/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.BaseInputControl;

public class InputFileControl
extends BaseInputControl {
    private final JTextField textField = new JTextField();
    private final JButton browseButton = new JButton();
    private File fileValue;

    public InputFileControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(new BoxLayout(this, 0));
        JButton browseButton = this.browseButton;
        browseButton.setAction(new BrowseAction());
        browseButton.setText("Browse");
        Dimension ps2 = this.textField.getPreferredSize();
        this.textField.setPreferredSize(new Dimension(128, ps2.height));
        this.textField.setEditable(false);
        this.add(this.textField);
        this.add(Box.createHorizontalStrut(4));
        this.add(browseButton);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setDisabled(boolean disabled) {
        this.browseButton.setEnabled(!disabled);
    }

    public void setValue(String value) {
    }

    private void setFileValue(File file) {
        this.fileValue = file;
        if (file == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(file.getAbsolutePath());
        }
    }

    public File getFileValue() {
        return this.fileValue;
    }

    public void resetInput() {
        this.setFileValue(null);
    }

    private class BrowseAction
    extends AbstractAction {
        private BrowseAction() {
        }

        public void actionPerformed(ActionEvent e10) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showOpenDialog(InputFileControl.this) == 0) {
                InputFileControl.this.setFileValue(chooser.getSelectedFile());
            } else {
                InputFileControl.this.setFileValue(null);
            }
        }
    }
}

