/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;

abstract class BaseRCollection
extends BaseBoundableRenderable
implements RCollection {
    public BaseRCollection(RenderableContainer container, ModelNode modelNode) {
        super(container, modelNode);
    }

    public void focus() {
        this.container.focus();
    }

    public void blur() {
        RCollection parent = this.parent;
        if (parent != null) {
            parent.focus();
        }
    }

    public void updateWidgetBounds(int guiX, int guiY) {
        Iterator i10 = this.getRenderables();
        if (i10 != null) {
            while (i10.hasNext()) {
                Object r10 = i10.next();
                if (!(r10 instanceof RCollection)) continue;
                RCollection rc2 = (RCollection)r10;
                rc2.updateWidgetBounds(guiX + rc2.getX(), guiY + rc2.getY());
            }
        }
    }

    private boolean checkStartSelection(Rectangle bounds, Point selectionPoint) {
        if (bounds.y > selectionPoint.y) {
            return true;
        }
        return selectionPoint.y >= bounds.y && selectionPoint.y < bounds.y + bounds.height && bounds.x > selectionPoint.x;
    }

    private boolean checkEndSelection(Rectangle bounds, Point selectionPoint) {
        if (bounds.y > selectionPoint.y) {
            return true;
        }
        return selectionPoint.y >= bounds.y && selectionPoint.y < bounds.y + bounds.height && selectionPoint.x < bounds.x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics g10, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Point checkPoint1 = null;
        Point checkPoint2 = null;
        if (!inSelection) {
            boolean isEnd;
            boolean isStart = startPoint.renderable == this;
            boolean bl2 = isEnd = endPoint.renderable == this;
            if (isStart && isEnd) {
                checkPoint1 = startPoint.getPoint();
                checkPoint2 = endPoint.getPoint();
            } else if (isStart) {
                checkPoint1 = startPoint.getPoint();
            } else if (isEnd) {
                checkPoint1 = endPoint.getPoint();
            }
        } else if (startPoint.renderable == this) {
            checkPoint1 = startPoint.getPoint();
        } else if (endPoint.renderable == this) {
            checkPoint1 = endPoint.getPoint();
        }
        Iterator i10 = this.getRenderables();
        if (i10 != null) {
            while (i10.hasNext()) {
                Object robj = i10.next();
                if (!(robj instanceof BoundableRenderable)) continue;
                BoundableRenderable renderable = (BoundableRenderable)robj;
                Rectangle bounds = renderable.getBounds();
                if (!inSelection) {
                    if (checkPoint1 != null && this.checkStartSelection(bounds, checkPoint1)) {
                        if (checkPoint2 != null) {
                            checkPoint1 = checkPoint2;
                            checkPoint2 = null;
                        } else {
                            checkPoint1 = null;
                        }
                        inSelection = true;
                    } else if (checkPoint2 != null && this.checkStartSelection(bounds, checkPoint2)) {
                        checkPoint1 = null;
                        checkPoint2 = null;
                        inSelection = true;
                    }
                } else if (inSelection && checkPoint1 != null && this.checkEndSelection(bounds, checkPoint1)) {
                    return false;
                }
                int offsetX = bounds.x;
                int offsetY = bounds.y;
                g10.translate(offsetX, offsetY);
                try {
                    boolean newInSelection = renderable.paintSelection(g10, inSelection, startPoint, endPoint);
                    if (inSelection && !newInSelection) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    inSelection = newInSelection;
                }
                finally {
                    g10.translate(-offsetX, -offsetY);
                }
            }
        }
        if (inSelection && checkPoint1 != null) {
            return false;
        }
        if (!(inSelection || checkPoint1 == null && checkPoint2 == null || checkPoint1 != null && checkPoint2 != null)) {
            return true;
        }
        return inSelection;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Point checkPoint1 = null;
        Point checkPoint2 = null;
        if (!inSelection) {
            boolean isEnd;
            boolean isStart = startPoint.renderable == this;
            boolean bl2 = isEnd = endPoint.renderable == this;
            if (isStart && isEnd) {
                checkPoint1 = startPoint.getPoint();
                checkPoint2 = endPoint.getPoint();
            } else if (isStart) {
                checkPoint1 = startPoint.getPoint();
            } else if (isEnd) {
                checkPoint1 = endPoint.getPoint();
            }
        } else if (startPoint.renderable == this) {
            checkPoint1 = startPoint.getPoint();
        } else if (endPoint.renderable == this) {
            checkPoint1 = endPoint.getPoint();
        }
        Iterator i10 = this.getRenderables();
        if (i10 != null) {
            while (i10.hasNext()) {
                Object robj = i10.next();
                if (!(robj instanceof BoundableRenderable)) continue;
                BoundableRenderable renderable = (BoundableRenderable)robj;
                if (!inSelection) {
                    Rectangle bounds = renderable.getBounds();
                    if (checkPoint1 != null && this.checkStartSelection(bounds, checkPoint1)) {
                        if (checkPoint2 != null) {
                            checkPoint1 = checkPoint2;
                            checkPoint2 = null;
                        } else {
                            checkPoint1 = null;
                        }
                        inSelection = true;
                    } else if (checkPoint2 != null && this.checkStartSelection(bounds, checkPoint2)) {
                        checkPoint1 = null;
                        checkPoint2 = null;
                        inSelection = true;
                    }
                } else if (inSelection && checkPoint1 != null && this.checkEndSelection(renderable.getBounds(), checkPoint1)) {
                    return false;
                }
                boolean newInSelection = renderable.extractSelectionText(buffer, inSelection, startPoint, endPoint);
                if (inSelection && !newInSelection) {
                    return false;
                }
                inSelection = newInSelection;
            }
        }
        if (inSelection && checkPoint1 != null) {
            return false;
        }
        if (!(inSelection || checkPoint1 == null && checkPoint2 == null || checkPoint1 != null && checkPoint2 != null)) {
            return true;
        }
        return inSelection;
    }

    public void invalidateLayoutDeep() {
        this.invalidateLayoutLocal();
        Iterator renderables = this.getRenderables();
        while (renderables.hasNext()) {
            Object r10 = renderables.next();
            if (!(r10 instanceof RCollection)) continue;
            ((RCollection)r10).invalidateLayoutDeep();
        }
    }
}

