/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.lobobrowser.html.HtmlParserContext;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.DOMImplementationImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.io.WritableLineReader;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private static final Logger logger = null;
    private EntityResolver resolver;
    private ErrorHandler errorHandler;
    private final UserAgentContext bcontext;
    private final HtmlRendererContext rcontext;
    private DOMImplementation domImplementation;

    public DocumentBuilderImpl(HtmlParserContext context) {
        this.rcontext = null;
        this.bcontext = context.getUserAgentContext();
    }

    public DocumentBuilderImpl(UserAgentContext context) {
        this.rcontext = null;
        this.bcontext = context;
    }

    public DocumentBuilderImpl(HtmlParserContext context, HtmlRendererContext rcontext) {
        this.rcontext = rcontext;
        this.bcontext = context.getUserAgentContext();
    }

    public DocumentBuilderImpl(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        this.rcontext = rcontext;
        this.bcontext = ucontext;
    }

    public Document parse(InputSource is2) throws SAXException, IOException {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.createDocument(is2);
        document.load();
        return document;
    }

    public Document createDocument(InputSource is2) throws SAXException, IOException {
        WritableLineReader wis;
        InputStream in2;
        String uri;
        String charset = is2.getEncoding();
        if (charset == null) {
            charset = "US-ASCII";
        }
        if ((uri = is2.getSystemId()) == null) {
            // empty if block
        }
        if ((in2 = is2.getByteStream()) != null) {
            wis = new WritableLineReader(new InputStreamReader(in2, charset));
        } else {
            Reader reader = is2.getCharacterStream();
            if (reader != null) {
                wis = new WritableLineReader(reader);
            } else {
                throw new IllegalArgumentException("InputSource has neither a byte stream nor a character stream");
            }
        }
        HTMLDocumentImpl document = new HTMLDocumentImpl(this.bcontext, this.rcontext, wis, uri);
        return document;
    }

    public boolean isNamespaceAware() {
        return false;
    }

    public boolean isValidating() {
        return false;
    }

    public void setEntityResolver(EntityResolver er2) {
        this.resolver = er2;
    }

    public void setErrorHandler(ErrorHandler eh2) {
        this.errorHandler = eh2;
    }

    public Document newDocument() {
        return new HTMLDocumentImpl(this.bcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMImplementation getDOMImplementation() {
        DocumentBuilderImpl documentBuilderImpl = this;
        synchronized (documentBuilderImpl) {
            if (this.domImplementation == null) {
                this.domImplementation = new DOMImplementationImpl(this.bcontext);
            }
            return this.domImplementation;
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }
}

