/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.BaseFontRenderState;
import org.lobobrowser.html.style.ColorRenderState;
import org.lobobrowser.html.style.FontNameRenderState;
import org.lobobrowser.html.style.FontSizeRenderState;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.html2.HTMLBaseFontElement;

public class HTMLBaseFontElementImpl
extends HTMLAbstractUIElement
implements HTMLBaseFontElement {
    public HTMLBaseFontElementImpl(String name) {
        super(name);
    }

    public String getColor() {
        return this.getAttribute("color");
    }

    public String getFace() {
        return this.getAttribute("face");
    }

    public void setColor(String color) {
        this.setAttribute("color", color);
    }

    public void setFace(String face) {
        this.setAttribute("face", face);
    }

    public int getSize() {
        try {
            return Integer.parseInt(this.getAttribute("size"));
        }
        catch (Exception thrown) {
            this.warn("getSize(): Unable to parse size attribute in " + this + ".", thrown);
            return 0;
        }
    }

    public void setSize(int size) {
        this.setAttribute("size", String.valueOf(size));
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        String face = this.getAttribute("face");
        String size = this.getAttribute("size");
        String color = this.getAttribute("color");
        if (face != null) {
            prevRenderState = new FontNameRenderState(prevRenderState, face);
        }
        if (size != null) {
            int fontNumber = HtmlValues.getFontNumberOldStyle(size, prevRenderState);
            float fontSize = HtmlValues.getFontSize(fontNumber);
            prevRenderState = new FontSizeRenderState(prevRenderState, fontSize);
            prevRenderState = new BaseFontRenderState(prevRenderState, fontNumber);
        }
        if (color != null) {
            prevRenderState = new ColorRenderState(prevRenderState, ColorFactory.getInstance().getColor(color));
        }
        return prevRenderState;
    }
}

