/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.util.BasicPrettyPrinter;
import flex.messaging.util.PrettyPrintable;
import flex.messaging.util.XMLUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ToStringPrettyPrinter
extends BasicPrettyPrinter {
    private IdentityHashMap knownObjects;
    private int knownObjectsCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prettify(Object o10) {
        try {
            this.knownObjects = new IdentityHashMap();
            this.knownObjectsCount = 0;
            String string = super.prettify(o10);
            Object var4_3 = null;
            this.knownObjects = null;
            this.knownObjectsCount = 0;
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.knownObjects = null;
            this.knownObjectsCount = 0;
            throw throwable;
        }
    }

    public Object copy() {
        return new ToStringPrettyPrinter();
    }

    protected void prettifyComplexType(Object o10) {
        if (!this.isKnownObject(o10)) {
            StringBuffer header = new StringBuffer();
            Class<?> c10 = o10.getClass();
            if (this.hasCustomToStringMethod(c10)) {
                this.trace.write(String.valueOf(o10));
            } else if (o10 instanceof Collection) {
                Collection col = (Collection)o10;
                header.append(c10.getName()).append(" (Collection size:").append(col.size()).append(")");
                this.trace.startArray(header.toString());
                Iterator it2 = col.iterator();
                int i10 = 0;
                while (it2.hasNext()) {
                    this.trace.arrayElement(i10);
                    this.internalPrettify(it2.next());
                    this.trace.newLine();
                    ++i10;
                }
                this.trace.endArray();
            } else if (c10.isArray()) {
                Class<?> componentType = c10.getComponentType();
                int count = Array.getLength(o10);
                header.append(componentType.getName()).append("[] (Array length:").append(count).append(")");
                this.trace.startArray(header.toString());
                for (int i11 = 0; i11 < count; ++i11) {
                    this.trace.arrayElement(i11);
                    this.internalPrettify(Array.get(o10, i11));
                    this.trace.newLine();
                }
                this.trace.endArray();
            } else if (o10 instanceof Document) {
                try {
                    String xml = XMLUtil.documentToString((Document)o10);
                    this.trace.write(xml);
                }
                catch (IOException ex2) {
                    this.trace.write("(Document not printable)");
                }
            } else {
                PropertyProxy proxy = PropertyProxyRegistry.getProxy(o10);
                if (o10 instanceof PrettyPrintable) {
                    PrettyPrintable pp2 = (PrettyPrintable)o10;
                    header.append(pp2.toStringHeader());
                } else {
                    header.append(c10.getName());
                    if (o10 instanceof Map) {
                        header.append(" (Map size:").append(((Map)o10).size()).append(")");
                    }
                }
                this.trace.startObject(header.toString());
                List propertyNames = proxy.getPropertyNames();
                if (propertyNames != null) {
                    for (String propName : propertyNames) {
                        this.trace.namedElement(propName);
                        Object value = null;
                        if (this.trace.nextElementExclude) {
                            this.trace.nextElementExclude = false;
                            value = "** [Value Suppressed] **";
                        } else {
                            String customToString;
                            if (o10 instanceof PrettyPrintable && (customToString = ((PrettyPrintable)o10).toStringCustomProperty(propName)) != null) {
                                value = customToString;
                            }
                            if (value == null) {
                                value = proxy.getValue(propName);
                            }
                        }
                        this.internalPrettify(value);
                        this.trace.newLine();
                    }
                }
                this.trace.endObject();
            }
        }
    }

    private boolean isKnownObject(Object o10) {
        Object ref = this.knownObjects.get(o10);
        if (ref != null) {
            try {
                int refNum = (Integer)ref;
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException classCastException) {}
        } else {
            this.rememberObject(o10);
        }
        return ref != null;
    }

    private void rememberObject(Object o10) {
        this.knownObjects.put(o10, new Integer(this.knownObjectsCount++));
    }
}

