/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

public class Hex {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] args) {
        boolean printData = false;
        int randomLimit = 500;
        for (int myCount = 0; myCount < 10000; ++myCount) {
            byte[] raw = new byte[(int)(Math.random() * (double)randomLimit)];
            for (int i10 = 0; i10 < raw.length; ++i10) {
                raw[i10] = i10 % 1024 < 256 ? (byte)(i10 % 1024) : (byte)((int)(Math.random() * 255.0) - 128);
            }
            Encoder encoder = new Encoder(100);
            encoder.encode(raw);
            String encoded = encoder.drain();
            Decoder decoder = new Decoder();
            decoder.decode(encoded);
            byte[] check = decoder.flush();
            String mesg = "Success!";
            if (check.length != raw.length) {
                mesg = "***** length mismatch!";
            } else {
                for (int i11 = 0; i11 < check.length; ++i11) {
                    if (check[i11] == raw[i11]) continue;
                    mesg = "***** data mismatch!";
                    break;
                }
            }
            if (mesg.indexOf("Success") == -1) {
                System.out.println(mesg + myCount);
                break;
            }
            if (!printData) continue;
            System.out.println("Decoded: " + new String(raw));
            System.out.println("Encoded: " + encoded);
            System.out.println("Decoded: " + new String(check));
        }
    }

    public static class Encoder {
        private StringBuffer output;

        public Encoder(int size) {
            this.output = new StringBuffer(size * 2);
        }

        private void encodeBlock(byte work) {
            this.output.append(digits[(work & 0xF0) >>> 4]);
            this.output.append(digits[work & 0xF]);
        }

        public void encode(byte[] data) {
            this.encode(data, 0, data.length);
        }

        public void encode(byte[] data, int offset, int length) {
            for (int plainIndex = offset; plainIndex < offset + length; ++plainIndex) {
                this.encodeBlock(data[plainIndex]);
            }
        }

        public String drain() {
            String r10 = this.output.toString();
            this.output.setLength(0);
            return r10;
        }

        public String flush() {
            return this.drain();
        }
    }

    public static class Decoder {
        private int filled = 0;
        private byte[] data;
        private int[] work = new int[]{0, 0};

        public Decoder() {
            this.data = new byte[256];
        }

        public void decode(String encoded) {
            int estimate = 1 + encoded.length() / 2;
            if (this.filled + estimate > this.data.length) {
                int length;
                for (length = this.data.length * 2; length < this.filled + estimate; length *= 2) {
                }
                byte[] newdata = new byte[length];
                System.arraycopy(this.data, 0, newdata, 0, this.filled);
                this.data = newdata;
            }
            for (int i10 = 0; i10 < encoded.length(); ++i10) {
                this.work[0] = Character.digit(encoded.charAt(i10), 16);
                this.work[1] = Character.digit(encoded.charAt(++i10), 16);
                this.data[this.filled++] = (byte)((this.work[0] << 4 | this.work[1]) & 0xFF);
            }
        }

        public byte[] drain() {
            byte[] r10 = new byte[this.filled];
            System.arraycopy(this.data, 0, r10, 0, this.filled);
            this.filled = 0;
            return r10;
        }

        public byte[] flush() throws IllegalStateException {
            return this.drain();
        }

        public void reset() {
            this.filled = 0;
        }
    }
}

