/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ExceptionUtil {
    public static String[] unwrapMethods = new String[]{"getRootCause", "getTargetException", "getTargetError", "getException", "getCausedByException", "getLinkedException"};

    public static Throwable wrappedException(Throwable t10) {
        return t10 instanceof InvocationTargetException ? ((InvocationTargetException)t10).getTargetException() : ExceptionUtil.getRootCauseWithReflection(t10);
    }

    public static Throwable baseException(Throwable t10) {
        Throwable wrapped = ExceptionUtil.wrappedException(t10);
        return wrapped != null ? ExceptionUtil.baseException(wrapped) : t10;
    }

    public static String toString(Throwable t10) {
        StringWriter strWrt = new StringWriter();
        t10.printStackTrace(new PrintWriter(strWrt));
        return strWrt.toString();
    }

    public static String getStackTraceUpTo(Throwable t10, String prefix) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t10), "\n\r");
        StringBuffer trace = new StringBuffer();
        boolean done = false;
        String lookingFor = "at " + prefix;
        while (!done && tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (token.indexOf(lookingFor) == -1) {
                trace.append(token);
            } else {
                done = true;
            }
            trace.append(StringUtils.NEWLINE);
        }
        return trace.toString();
    }

    public static String getStackTraceLines(Throwable t10, int numLines) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t10), "\n\r");
        StringBuffer trace = new StringBuffer();
        for (int i10 = 0; i10 < numLines; ++i10) {
            String token = tokens.nextToken();
            trace.append(token);
            trace.append(StringUtils.NEWLINE);
        }
        return trace.toString();
    }

    public static String getCallAt(Throwable t10, int nth) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t10), "\n\r");
        try {
            for (int i10 = 0; i10 <= nth; ++i10) {
                tokens.nextToken();
            }
            String token = tokens.nextToken();
            int index1 = token.indexOf(32);
            int index2 = token.indexOf(40);
            StringBuffer call = new StringBuffer();
            call.append(token.substring(index1 < 0 ? 0 : index1 + 1, index2 < 0 ? call.length() : index2));
            int index3 = token.indexOf(58, index2 < 0 ? 0 : index2);
            if (index3 >= 0) {
                int index4 = token.indexOf(41, index3);
                call.append(token.substring(index3, index4 < 0 ? token.length() : index4));
            }
            return call.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "unknown";
        }
    }

    public static String exceptionToString(Throwable t10) {
        StringWriter sw2 = new StringWriter();
        PrintWriter out = new PrintWriter(sw2);
        ExceptionUtil.printExceptionStack(t10, out, 0);
        return sw2.toString();
    }

    public static String exceptionFollowedByRootCausesToString(Throwable t10) {
        StringBuffer output = new StringBuffer();
        Throwable root = t10;
        while (root != null) {
            output.append(root == t10 ? (root instanceof Exception ? "  Exception: " : "  Error: ") : "  Root cause: ");
            output.append(ExceptionUtil.toString(root));
            Throwable cause = root.getCause();
            if (cause != (root = ExceptionUtil.wrappedException(root))) continue;
            break;
        }
        return output.toString();
    }

    protected static void printExceptionStack(Throwable th2, PrintWriter out, int depth) {
        boolean printStackDepth = depth > 0;
        Throwable wrappedException = ExceptionUtil.wrappedException(th2);
        if (wrappedException != null) {
            printStackDepth = true;
            ExceptionUtil.printExceptionStack(wrappedException, out, depth + 1);
        }
        if (printStackDepth) {
            out.write("[" + depth + "]");
        }
        th2.printStackTrace(out);
    }

    private static Throwable getRootCauseWithReflection(Throwable t10) {
        for (int i10 = 0; i10 < unwrapMethods.length; ++i10) {
            Method m10 = null;
            try {
                m10 = t10.getClass().getMethod(unwrapMethods[i10], null);
                return (Throwable)m10.invoke((Object)t10, (Object[])null);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

