/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.SecuritySettings;
import flex.messaging.security.LoginManager;
import flex.messaging.security.SecurityException;

public final class MessagingSecurityConstraintManager {
    public static final String SEND_SECURITY_CONSTRAINT = "send-security-constraint";
    public static final String SUBSCRIBE_SECURITY_CONSTRAINT = "subscribe-security-constraint";
    private static final int NO_SEC_CONSTRAINT = 10062;
    private LoginManager loginManager;
    private SecuritySettings securitySettings;
    private SecurityConstraint sendConstraint;
    private SecurityConstraint subscribeConstraint;

    public MessagingSecurityConstraintManager(MessageBroker broker) {
        this.loginManager = broker.getLoginManager();
        this.securitySettings = broker.getSecuritySettings();
    }

    public void setSendConstraint(String ref) {
        this.validateConstraint(ref);
        this.sendConstraint = this.securitySettings.getConstraint(ref);
    }

    public void setSubscribeConstraint(String ref) {
        this.validateConstraint(ref);
        this.subscribeConstraint = this.securitySettings.getConstraint(ref);
    }

    public void assertSendAuthorization() {
        this.checkConstraint(this.sendConstraint);
    }

    public void assertSubscribeAuthorization() {
        this.checkConstraint(this.subscribeConstraint);
    }

    public void createConstraints(ConfigMap serverSettings) {
        ConfigMap subscribe;
        ConfigMap send = serverSettings.getPropertyAsMap(SEND_SECURITY_CONSTRAINT, null);
        if (send != null) {
            String ref = send.getPropertyAsString("ref", null);
            this.createSendConstraint(ref);
        }
        if ((subscribe = serverSettings.getPropertyAsMap(SUBSCRIBE_SECURITY_CONSTRAINT, null)) != null) {
            String ref = subscribe.getPropertyAsString("ref", null);
            this.createSubscribeConstraint(ref);
        }
    }

    void createSendConstraint(String ref) {
        if (ref != null) {
            this.sendConstraint = this.securitySettings.getConstraint(ref);
        }
    }

    void createSubscribeConstraint(String ref) {
        if (ref != null) {
            this.subscribeConstraint = this.securitySettings.getConstraint(ref);
        }
    }

    private void checkConstraint(SecurityConstraint constraint) {
        if (constraint != null && !FlexContext.isMessageFromPeer()) {
            this.loginManager.checkConstraint(constraint);
        }
    }

    private void validateConstraint(String ref) {
        if (this.securitySettings.getConstraint(ref) == null) {
            SecurityException se2 = new SecurityException();
            se2.setMessage(10062, new Object[]{ref});
            throw se2;
        }
    }
}

