/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.config.ConfigurationException;
import java.util.Hashtable;

public class JMSSettings {
    private String acknowledgeMode = "auto_acknowledge";
    private String connectionFactory;
    private String connectionUsername;
    private String connectionPassword;
    private String deliveryMode = "default_delivery_mode";
    private String destinationJNDIName;
    private DeliverySettings deliverySettings = new DeliverySettings();
    private String destinationType = "topic";
    private boolean durableConsumers;
    private Hashtable initialContextEnvironment;
    private int maxProducers = 1;
    private int messagePriority = 4;
    private String messageType;
    private boolean preserveJMSHeaders = true;

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String mode) {
        if (mode == null) {
            this.acknowledgeMode = "auto_acknowledge";
            return;
        }
        if (!((mode = mode.toLowerCase()).equals("auto_acknowledge") || mode.equals("dups_ok_acknowledge") || mode.equals("client_acknowledge"))) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10808, new Object[]{mode});
            throw ce2;
        }
        this.acknowledgeMode = mode;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(String factory) {
        if (factory == null) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10804);
            throw ce2;
        }
        this.connectionFactory = factory;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public void setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(String mode) {
        if (mode == null) {
            this.deliveryMode = "default_delivery_mode";
            return;
        }
        if (!((mode = mode.toLowerCase()).equals("default_delivery_mode") || mode.equals("persistent") || mode.equals("non_persistent"))) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10809, new Object[]{mode});
            throw ce2;
        }
        this.deliveryMode = mode;
    }

    public DeliverySettings getDeliverySettings() {
        return this.deliverySettings;
    }

    public void setDeliverySettings(DeliverySettings deliverySettings) {
        this.deliverySettings = deliverySettings;
    }

    public String getDestinationJNDIName() {
        return this.destinationJNDIName;
    }

    public void setDestinationJNDIName(String name) {
        if (name == null) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10807);
            throw ce2;
        }
        this.destinationJNDIName = name;
    }

    public String getDestinationName() {
        return null;
    }

    public void setDestinationName(String name) {
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String type) {
        if (type == null) {
            this.destinationType = "topic";
            return;
        }
        if (!(type = type.toLowerCase()).equals("topic") && !type.equals("queue")) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10805);
            throw ce2;
        }
        this.destinationType = type;
    }

    public boolean useDurableConsumers() {
        return this.durableConsumers;
    }

    public void setDurableConsumers(boolean durable) {
        this.durableConsumers = durable;
    }

    public Hashtable getInitialContextEnvironment() {
        return this.initialContextEnvironment;
    }

    public void setInitialContextEnvironment(Hashtable env) {
        this.initialContextEnvironment = env;
    }

    public int getMaxProducers() {
        return this.maxProducers;
    }

    public void setMaxProducers(int value) {
        if (value < 1) {
            value = 1;
        }
        this.maxProducers = value;
    }

    public int getMessagePriority() {
        return this.messagePriority;
    }

    public void setMessagePriority(int priority) {
        this.messagePriority = priority;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String type) {
        if (type == null || !type.equals("javax.jms.TextMessage") && !type.equals("javax.jms.ObjectMessage") && !type.equals("javax.jms.MapMessage")) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10811, new Object[]{type});
            throw ce2;
        }
        this.messageType = type;
    }

    public boolean isPreserveJMSHeaders() {
        return this.preserveJMSHeaders;
    }

    public void setPreserveJMSHeaders(boolean preserveJMSHeaders) {
        this.preserveJMSHeaders = preserveJMSHeaders;
    }

    public boolean isTransactedSessions() {
        return false;
    }

    public void setTransactedSessions(boolean mode) {
    }

    public static class DeliverySettings {
        private String mode = "sync";
        private long syncReceiveIntervalMillis = 100L;
        private long syncReceiveWaitMillis = 0L;

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            if (mode == null) {
                mode = "sync";
                return;
            }
            if (!(mode = mode.toLowerCase()).equals("async") && !mode.equals("sync")) {
                ConfigurationException ce2 = new ConfigurationException();
                ce2.setMessage(10817, new Object[]{mode});
                throw ce2;
            }
            this.mode = mode;
        }

        public long getSyncReceiveIntervalMillis() {
            return this.syncReceiveIntervalMillis;
        }

        public void setSyncReceiveIntervalMillis(long syncReceiveIntervalMillis) {
            if (syncReceiveIntervalMillis < 1L) {
                syncReceiveIntervalMillis = 100L;
            }
            this.syncReceiveIntervalMillis = syncReceiveIntervalMillis;
        }

        public long getSyncReceiveWaitMillis() {
            return this.syncReceiveWaitMillis;
        }

        public void setSyncReceiveWaitMillis(long syncReceiveWaitMillis) {
            if (syncReceiveWaitMillis < -1L) {
                syncReceiveWaitMillis = 0L;
            }
            this.syncReceiveWaitMillis = syncReceiveWaitMillis;
        }
    }
}

