/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.cluster.RemoveNodeListener;
import flex.messaging.log.Log;
import flex.messaging.services.messaging.RemoteMessageClient;
import flex.messaging.services.messaging.SubscriptionManager;
import flex.messaging.util.StringUtils;
import java.util.List;

public class RemoteSubscriptionManager
extends SubscriptionManager
implements RemoveNodeListener {
    private Object syncLock = new Object();
    private static final Object initRemoteSubscriptionsLock = new Object();

    public RemoteSubscriptionManager(MessageDestination destination) {
        this(destination, false);
    }

    public RemoteSubscriptionManager(MessageDestination destination, boolean enableManagement) {
        super(destination, enableManagement);
    }

    public void setSessionTimeout(long sessionConfigValue) {
    }

    public long getSessionTimeout() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(String flexClientId, Object clientId, String selector, String subtopic) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.allSubscriptions.get(clientId) != null) {
                super.addSubscriber(clientId, selector, subtopic, null);
            } else if (Log.isDebug()) {
                Log.getLogger("Service.Message").debug("Ignoring new remote subscription for server: " + clientId + " whose subscription state we have not yet received.  selector: " + selector + " subtopic: " + subtopic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(String flexClientId, Object clientId, String selector, String subtopic, String endpoint) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.allSubscriptions.get(clientId) != null) {
                super.removeSubscriber(clientId, selector, subtopic, null);
            }
        }
    }

    protected void sendSubscriptionToPeer(boolean subscribe, String selector, String subtopic) {
    }

    protected MessageClient newMessageClient(Object clientId, String endpointId) {
        return new RemoteMessageClient(clientId, this.destination, endpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscriptionState(Object state, Object address) {
        MessageClient client = this.newMessageClient(address, null);
        if (Log.isDebug()) {
            Log.getLogger("Service.Message").debug("Received subscription state for destination: " + this.destination.getId() + " from server: " + address + StringUtils.NEWLINE + state);
        }
        Object object = this.syncLock;
        synchronized (object) {
            this.allSubscriptions.put(address, client);
            List list = (List)state;
            for (int i10 = 0; i10 < list.size(); i10 += 2) {
                this.addSubscriber(null, address, (String)list.get(i10), (String)list.get(i10 + 1));
            }
        }
        object = initRemoteSubscriptionsLock;
        synchronized (object) {
            initRemoteSubscriptionsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSubscriptions(Object addr) {
        if (this.getSubscriber(addr) == null) {
            Object object = initRemoteSubscriptionsLock;
            synchronized (object) {
                try {
                    if (Log.isDebug()) {
                        Log.getLogger("Service.Message").debug("Waiting for subscriptions from cluster node: " + addr + " for destination: " + this.destination.getId());
                    }
                    initRemoteSubscriptionsLock.wait(5000L);
                    if (Log.isDebug()) {
                        Log.getLogger("Service.Message").debug("Done waiting for subscriptions from cluster node: " + addr + " for destination: " + this.destination.getId());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.getSubscriber(addr) == null && Log.isWarn()) {
                Log.getLogger("Service.Message").warn("No response yet from request subscriptions request for server: " + addr + " for destination: " + this.destination.getId());
            }
        } else if (Log.isDebug()) {
            Log.getLogger("Service.Message").debug("Already have subscriptions from server: " + addr + " for destination: " + this.destination.getId());
        }
    }

    public void removeClusterNode(Object address) {
        MessageClient client;
        if (Log.isDebug()) {
            Log.getLogger("Service.Message").debug("Cluster node: " + address + " subscriptions being removed for destination:" + this.destination.getId() + " before: " + StringUtils.NEWLINE + this.getDebugSubscriptionState());
        }
        if ((client = this.getSubscriber(address)) != null) {
            client.invalidate();
        }
        if (Log.isDebug()) {
            Log.getLogger("Service.Message").debug("Cluster node: " + address + " subscriptions being removed for destination:" + this.destination.getId() + " after: " + StringUtils.NEWLINE + this.getDebugSubscriptionState());
        }
    }

    protected void monitorTimeout(MessageClient client) {
    }
}

