/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.management.runtime.messaging.services.RemotingServiceControl;
import flex.management.runtime.messaging.services.remoting.RemotingDestinationControl;
import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.messages.RemotingMessage;
import flex.messaging.services.AbstractService;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.remoting.RemotingDestination;
import flex.messaging.util.MethodMatcher;

public class RemotingService
extends AbstractService {
    public static final String LOG_CATEGORY = "Service.Remoting";
    private static final int UNKNOWN_DESTINATION = 10650;
    private MethodMatcher methodMatcher;
    private RemotingServiceControl controller;

    public RemotingService() {
        this(false);
    }

    public RemotingService(boolean enableManagement) {
        super(enableManagement);
    }

    public Destination createDestination(String id2) {
        RemotingDestination destination = new RemotingDestination();
        destination.setId(id2);
        destination.setManaged(this.isManaged());
        destination.setService(this);
        return destination;
    }

    public void addDestination(Destination destination) {
        RemotingDestination remotingDest = (RemotingDestination)destination;
        super.addDestination(remotingDest);
    }

    public MethodMatcher getMethodMatcher() {
        if (this.methodMatcher == null) {
            this.methodMatcher = new MethodMatcher();
        }
        return this.methodMatcher;
    }

    public Object serviceMessage(Message msg) {
        if (msg instanceof RemotingMessage) {
            RemotingDestinationControl destinationControl;
            RemotingMessage message = (RemotingMessage)msg;
            RemotingDestination destination = (RemotingDestination)this.getDestination(msg);
            RemotingDestinationControl remotingDestinationControl = destinationControl = destination.isManaged() ? (RemotingDestinationControl)destination.getControl() : null;
            if (destination != null) {
                ServiceAdapter adapter = destination.getAdapter();
                long startTime = 0L;
                if (destinationControl != null) {
                    startTime = System.currentTimeMillis();
                }
                try {
                    MessagePerformanceUtils.markServerPreAdapterTime(message);
                    Object result = adapter.invoke(message);
                    MessagePerformanceUtils.markServerPostAdapterTime(message);
                    if (Log.isDebug()) {
                        Log.getLogger(LOG_CATEGORY).debug("Adapter '{0}' called '{1}.{2}({3})'", new Object[]{adapter.getId(), message.getSource(), message.getOperation(), message.getParameters()});
                        Log.getLogger(LOG_CATEGORY).debug("Result: '{0}'", new Object[]{result});
                    }
                    if (destinationControl != null) {
                        destinationControl.incrementInvocationSuccessCount((int)(System.currentTimeMillis() - startTime));
                    }
                    return result;
                }
                catch (MessageException ex2) {
                    if (destinationControl != null) {
                        destinationControl.incrementInvocationFaultCount((int)(System.currentTimeMillis() - startTime));
                    }
                    throw ex2;
                }
                catch (Throwable t10) {
                    if (destinationControl != null) {
                        destinationControl.incrementInvocationFaultCount((int)(System.currentTimeMillis() - startTime));
                    }
                    throw new MessageException(t10);
                }
            }
            ServiceException e10 = new ServiceException();
            e10.setMessage(10650, new Object[]{msg.getDestination()});
            throw e10;
        }
        ServiceException e11 = new ServiceException();
        e11.setMessage(10454, new Object[]{"Remoting", "RemotingMessage"});
        throw e11;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupServiceControl(MessageBroker broker) {
        this.controller = new RemotingServiceControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }
}

