/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.util.ObjectTrace;

public class AmfTrace
extends ObjectTrace {
    public AmfTrace() {
        this.buffer = new StringBuffer(4096);
    }

    public void startRequest(String message) {
        this.m_indent = 0;
        this.buffer.append(message);
        ++this.m_indent;
    }

    public void startResponse(String message) {
        this.m_indent = 0;
        this.buffer.append(message);
        ++this.m_indent;
    }

    public void version(int version) {
        this.newLine();
        this.buffer.append("Version: ").append(version);
    }

    public void startHeader(String name, boolean mustUnderstand, int index) {
        this.newLine();
        this.buffer.append(this.indentString());
        this.buffer.append("(Header #").append(index).append(" name=").append(name);
        this.buffer.append(", mustUnderstand=").append(mustUnderstand).append(")");
        this.newLine();
        ++this.m_indent;
    }

    public void endHeader() {
        --this.m_indent;
    }

    public void startCommand(Object cmd2, int iCmd, Object trxId) {
        this.newLine();
        this.buffer.append(this.indentString());
        this.buffer.append("(Command method=").append(cmd2).append(" (").append(iCmd).append(")");
        this.buffer.append(" trxId=").append(trxId).append(")");
        this.newLine();
        ++this.m_indent;
    }

    public void endCommand() {
        --this.m_indent;
    }

    public void startMessage(String targetURI, String responseURI, int index) {
        this.newLine();
        this.buffer.append(this.indentString());
        this.buffer.append("(Message #").append(index).append(" targetURI=").append(targetURI);
        this.buffer.append(", responseURI=").append(responseURI).append(")");
        this.newLine();
        ++this.m_indent;
    }

    public void endMessage() {
        --this.m_indent;
    }

    private boolean isExcluded() {
        if (this.nextElementExclude) {
            this.nextElementExclude = false;
            this.buffer.append("** [Value Suppressed] **");
            this.newLine();
            return true;
        }
        return false;
    }

    public void write(Object o10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(String.valueOf(o10));
        this.newLine();
    }

    public void write(boolean b10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(b10);
        this.newLine();
    }

    public void write(double d10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(d10);
        this.newLine();
    }

    public void write(float f10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(f10);
        this.newLine();
    }

    public void write(int i10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(i10);
        this.newLine();
    }

    public void write(long l10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(l10);
        this.newLine();
    }

    public void write(short s10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(s10);
        this.newLine();
    }

    public void write(byte b10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append(b10);
        this.newLine();
    }

    public void writeNull() {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("null");
        this.newLine();
    }

    public void writeRef(int ref) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("(Ref #").append(ref).append(")");
        this.newLine();
    }

    public void writeString(String s10) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("\"").append(s10).append("\"");
        this.newLine();
    }

    public void writeStringRef(int ref) {
        if (this.isExcluded()) {
            return;
        }
        this.buffer.append(" (String Ref #").append(ref).append(")");
    }

    public void writeTraitsInfoRef(int ref) {
        if (this.isExcluded()) {
            return;
        }
        this.buffer.append(" (Traits Ref #").append(ref).append(")");
    }

    public void writeUndefined() {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("undefined");
        this.newLine();
    }

    public void startAMFArray(int ref) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("(Array #").append(ref).append(")").append(newLine);
        ++this.m_indent;
        ++this.m_nested;
    }

    public void startECMAArray(int ref) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("(ECMA Array #").append(ref).append(")").append(newLine);
        ++this.m_indent;
        ++this.m_nested;
    }

    public void startByteArray(int ref, int length) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("(Byte Array #").append(ref).append(", Length ").append(length).append(")").append(newLine);
    }

    public void endAMFArray() {
        --this.m_indent;
        --this.m_nested;
    }

    public void startExternalizableObject(String type, int ref) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        this.buffer.append("(Externalizable Object #").append(ref).append(" '").append(type).append("')").append(newLine);
        ++this.m_indent;
        ++this.m_nested;
        this.buffer.append(this.indentString());
    }

    public void startAMFObject(String type, int ref) {
        if (this.isExcluded()) {
            return;
        }
        if (this.m_nested <= 0) {
            this.buffer.append(this.indentString());
        }
        if (type != null && type.length() > 0) {
            this.buffer.append("(Typed Object #").append(ref).append(" '").append(type).append("')").append(newLine);
        } else {
            this.buffer.append("(Object #").append(ref).append(")").append(newLine);
        }
        ++this.m_indent;
        ++this.m_nested;
    }

    public void endAMFObject() {
        --this.m_indent;
        --this.m_nested;
    }
}

