/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.AmfTypes;
import flex.messaging.io.amf.TraitsInfo;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class Amf0Output
extends AbstractAmfOutput
implements AmfTypes {
    public static final byte[] OBJECT_END_MARKER = new byte[]{0, 0, 9};
    protected IdentityHashMap serializedObjects;
    protected int serializedObjectCount = 0;
    protected boolean avmPlus;
    protected Amf3Output avmPlusOutput;

    public Amf0Output(SerializationContext context) {
        super(context);
        context.supportDatesByReference = false;
        this.serializedObjects = new IdentityHashMap(64);
    }

    public void setAvmPlus(boolean a10) {
        this.avmPlus = a10;
    }

    public void reset() {
        super.reset();
        this.serializedObjects.clear();
        this.serializedObjectCount = 0;
        if (this.avmPlusOutput != null) {
            this.avmPlusOutput.reset();
        }
    }

    protected void createAMF3Output() {
        this.avmPlusOutput = new Amf3Output(this.context);
        this.avmPlusOutput.setOutputStream(this.out);
        this.avmPlusOutput.setDebugTrace(this.trace);
    }

    public void writeObject(Object o10) throws IOException {
        if (o10 == null) {
            this.writeAMFNull();
            return;
        }
        if (o10 instanceof String) {
            this.writeAMFString((String)o10);
        } else if (o10 instanceof Number) {
            if (!this.context.legacyBigNumbers && (o10 instanceof BigInteger || o10 instanceof BigDecimal)) {
                this.writeAMFString(o10.toString());
            } else {
                this.writeAMFDouble(((Number)o10).doubleValue());
            }
        } else if (o10 instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o10);
        } else if (o10 instanceof Character) {
            String s10 = o10.toString();
            this.writeAMFString(s10);
        } else if (o10 instanceof Date) {
            this.writeAMFDate((Date)o10);
        } else if (o10 instanceof Calendar) {
            this.writeAMFDate(((Calendar)o10).getTime());
        } else if (o10 instanceof Enum && PropertyProxyRegistry.getRegistry().getProxy(o10.getClass()) == null) {
            Enum enumValue = (Enum)o10;
            this.writeAMFString(enumValue.name());
        } else if (this.avmPlus) {
            if (this.avmPlusOutput == null) {
                this.createAMF3Output();
            }
            this.out.writeByte(17);
            this.avmPlusOutput.writeObject(o10);
        } else {
            Class<?> cls = o10.getClass();
            if (cls.isArray()) {
                this.writeAMFArray(o10, cls.getComponentType());
            } else if (o10 instanceof Map && this.context.legacyMap && !(o10 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o10);
            } else if (o10 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o10, null);
                } else {
                    this.writeArrayCollection((Collection)o10, null);
                }
            } else if (o10 instanceof Document) {
                this.out.write(15);
                String xml = this.documentToString(o10);
                if (this.isDebug) {
                    this.trace.write(xml);
                }
                this.writeUTF(xml, true, false);
            } else {
                if (o10 instanceof RowSet) {
                    o10 = new PagedRowSet((RowSet)o10, Integer.MAX_VALUE, false);
                } else if (o10 instanceof Throwable && this.context.legacyThrowable) {
                    o10 = new StatusInfoProxy((Throwable)o10);
                }
                this.writeCustomObject(o10);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo traits) throws IOException {
        String className = null;
        if (traits != null) {
            className = traits.getClassName();
        }
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.serializedObjectCount - 1);
        }
        if (className == null || className.length() == 0) {
            this.out.write(3);
        } else {
            this.out.write(16);
            this.out.writeUTF(className);
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.out.writeUTF(name);
        this.increaseNestObjectLevel();
        this.writeObject(value);
        this.decreaseNestObjectLevel();
    }

    public void writeObjectEnd() throws IOException {
        this.out.write(OBJECT_END_MARKER, 0, OBJECT_END_MARKER.length);
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    protected void writeAMFBoolean(boolean b10) throws IOException {
        if (this.isDebug) {
            this.trace.write(b10);
        }
        this.out.write(1);
        this.out.writeBoolean(b10);
    }

    protected void writeAMFDouble(double d10) throws IOException {
        if (this.isDebug) {
            this.trace.write(d10);
        }
        this.out.write(0);
        this.out.writeDouble(d10);
    }

    protected void writeAMFDate(Date d10) throws IOException {
        if (this.isDebug) {
            this.trace.write(d10);
        }
        this.out.write(11);
        this.out.writeDouble(d10.getTime());
        int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
        this.out.writeShort(nCurrentTimezoneOffset / 60000);
    }

    protected void writeAMFArray(Object o10, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o10);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o10);
        } else {
            this.writeObjectArray((Object[])o10, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        if (!this.serializeAsReference(col)) {
            ArrayCollection ac2;
            if (col instanceof ArrayCollection) {
                ac2 = (ArrayCollection)col;
            } else {
                ac2 = new ArrayCollection(col);
                if (desc != null) {
                    ac2.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac2);
            this.writePropertyProxy(proxy, ac2);
        }
    }

    protected void writeCustomObject(Object o10) throws IOException {
        PropertyProxy proxy = null;
        if (o10 instanceof PropertyProxy) {
            proxy = (PropertyProxy)o10;
            if ((o10 = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o10 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o10, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o10, proxy.getDescriptor());
                }
                return;
            }
            if (o10.getClass().isArray()) {
                this.writeObjectArray((Object[])o10, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o10 instanceof Map && !(o10 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o10);
                return;
            }
        }
        if (!this.serializeAsReference(o10)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o10);
            }
            this.writePropertyProxy(proxy, o10);
        }
    }

    protected void writePropertyProxy(PropertyProxy pp2, Object instance) throws IOException {
        Object newInst = pp2.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + pp2.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            pp2 = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        boolean externalizable = false;
        List propertyNames = pp2.getPropertyNames(instance);
        if (pp2 instanceof BeanProxy) {
            BeanProxy bp2 = (BeanProxy)pp2;
            Iterator it2 = propertyNames.iterator();
            while (it2.hasNext()) {
                String propName = (String)it2.next();
                if (!bp2.isWriteOnly(instance, propName)) continue;
                it2.remove();
            }
        }
        TraitsInfo ti2 = new TraitsInfo(pp2.getAlias(instance), pp2.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti2);
        if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = pp2.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writeMapAsECMAArray(Map m10) throws IOException {
        if (!this.serializeAsReference(m10)) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.serializedObjectCount - 1);
            }
            this.out.write(8);
            this.out.writeInt(0);
            for (Object key : m10.keySet()) {
                Object value = m10.get(key);
                this.writeObjectProperty(key.toString(), value);
            }
            this.writeObjectEnd();
        }
    }

    protected void writeAMFNull() throws IOException {
        if (this.isDebug) {
            this.trace.writeNull();
        }
        this.out.write(5);
    }

    protected void writeAMFString(String str) throws IOException {
        if (this.isDebug) {
            this.trace.writeString(str);
        }
        this.writeUTF(str, false, true);
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        if (!this.serializeAsReference(values)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.serializedObjectCount - 1);
            }
            this.out.write(10);
            this.out.writeInt(values.length);
            for (int i10 = 0; i10 < values.length; ++i10) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i10);
                }
                if (!((item = values[i10]) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    item = proxy;
                }
                this.increaseNestObjectLevel();
                this.writeObject(item);
                this.decreaseNestObjectLevel();
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeCollection(Collection c10, SerializationDescriptor descriptor) throws IOException {
        if (!this.serializeAsReference(c10)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.serializedObjectCount - 1);
            }
            this.out.write(10);
            this.out.writeInt(c10.size());
            Iterator it2 = c10.iterator();
            int i10 = 0;
            while (it2.hasNext()) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i10++);
                }
                if (!((item = it2.next()) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    item = proxy;
                }
                this.increaseNestObjectLevel();
                this.writeObject(item);
                this.decreaseNestObjectLevel();
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        block11: {
            Class<?> aType;
            block10: {
                aType = obj.getClass().getComponentType();
                if (!aType.equals(Character.TYPE)) break block10;
                char[] c10 = (char[])obj;
                this.writeCharArrayAsString(c10);
                break block11;
            }
            if (this.serializeAsReference(obj)) break block11;
            if (aType.equals(Boolean.TYPE)) {
                this.out.write(10);
                boolean[] b10 = (boolean[])obj;
                this.out.writeInt(b10.length);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.serializedObjectCount - 1);
                    for (int i10 = 0; i10 < b10.length; ++i10) {
                        this.trace.arrayElement(i10);
                        this.writeAMFBoolean(b10[i10]);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i11 = 0; i11 < b10.length; ++i11) {
                        this.writeAMFBoolean(b10[i11]);
                    }
                }
            } else {
                this.out.write(10);
                int length = Array.getLength(obj);
                this.out.writeInt(length);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.serializedObjectCount - 1);
                    for (int i12 = 0; i12 < length; ++i12) {
                        this.trace.arrayElement(i12);
                        double v10 = Array.getDouble(obj, i12);
                        this.writeAMFDouble(v10);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i13 = 0; i13 < length; ++i13) {
                        double v11 = Array.getDouble(obj, i13);
                        this.writeAMFDouble(v11);
                    }
                }
            }
        }
    }

    protected void writeCharArrayAsString(Character[] ca) throws IOException {
        int length = ca.length;
        char[] chars = new char[length];
        for (int i10 = 0; i10 < length; ++i10) {
            Character c10 = ca[i10];
            chars[i10] = c10 == null ? (char)'\u0000' : ca[i10].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca) throws IOException {
        this.writeAMFString(new String(ca));
    }

    protected void writeUTF(String str, boolean forceLong, boolean writeType) throws IOException {
        byte[] bytearr;
        char c10;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        char[] charr = this.getTempCharArray(strlen);
        str.getChars(0, strlen, charr, 0);
        for (int i10 = 0; i10 < strlen; ++i10) {
            c10 = charr[i10];
            if (c10 <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c10 > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        int type = forceLong ? 12 : (utflen <= 65535 ? 2 : 12);
        if (writeType) {
            bytearr = this.getTempByteArray(utflen + (type == 2 ? 3 : 5));
            bytearr[count++] = (byte)type;
        } else {
            bytearr = this.getTempByteArray(utflen + (type == 2 ? 2 : 4));
        }
        if (type == 12) {
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (int i11 = 0; i11 < strlen; ++i11) {
            c10 = charr[i11];
            if (c10 <= '\u007f') {
                bytearr[count++] = (byte)c10;
                continue;
            }
            if (c10 > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c10 >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c10 >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c10 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c10 >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c10 & 0x3F);
        }
        this.out.write(bytearr, 0, count);
    }

    protected void rememberObjectReference(Object obj) {
        this.serializedObjects.put(obj, new Integer(this.serializedObjectCount++));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean serializeAsReference(Object obj) throws IOException {
        ref = this.serializedObjects.get(obj);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.out.write(7);
                this.out.writeShort(refNum);
                if (!this.isDebug) ** GOTO lbl13
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference value is not an Integer");
            }
        } else {
            this.rememberObjectReference(obj);
        }
lbl13:
        // 3 sources

        return ref != null;
    }
}

