/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionMessageInput;
import flex.messaging.io.amf.AmfIO;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.XMLUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractAmfInput
extends AmfIO
implements ActionMessageInput {
    public static final int INITIAL_ARRAY_CAPACITY = 1024;
    public static final int DEFAULT_MAX_STRING_BYTES = 0x1900000;
    public static final String STRING_MAX_STRING_BYTES = "max-string-bytes";
    protected BeanProxy beanProxy = new BeanProxy();
    protected DataInputStream in = null;
    protected int maxStringBytes = 0x1900000;

    public AbstractAmfInput(SerializationContext context) {
        super(context);
        this.readMaxStringBytes();
    }

    public void setInputStream(InputStream in2) {
        this.in = new DataInputStream(in2);
    }

    protected Object stringToDocument(String xml) {
        if (xml != null && xml.indexOf(60) == -1) {
            return xml;
        }
        return XMLUtil.stringToDocument(xml, !this.context.legacyXMLNamespaces);
    }

    protected void checkUTFLength(int utflen) {
        if (utflen > this.maxStringBytes) {
            SerializationException ex2 = new SerializationException();
            ex2.setMessage(10314, new Object[]{utflen, this.maxStringBytes});
            throw ex2;
        }
    }

    protected Object createObjectInstance(Object[] params) {
        String className = (String)params[0];
        String aliasedClass = ClassAliasRegistry.getRegistry().getClassName(className);
        if (aliasedClass != null) {
            className = aliasedClass;
            params[0] = className;
        }
        Object object = null;
        PropertyProxy proxy = null;
        if (className != null && className.startsWith(">")) {
            object = this.createDefaultASObject(className);
        } else if (className != null && className.length() > 0 && (this.context.instantiateTypes || className.startsWith("flex."))) {
            Class desiredClass;
            block9: {
                desiredClass = null;
                try {
                    desiredClass = AbstractProxy.getClassFromClassName(className);
                }
                catch (MessageException me2) {
                    if (me2.getCode().startsWith("Server.ResourceUnavailable") && this.context.createASObjectForMissingType) break block9;
                    throw me2;
                }
            }
            if (desiredClass != null) {
                proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(desiredClass);
                object = proxy == null ? ClassUtil.createDefaultInstance(desiredClass, null, true) : proxy.createInstance(className);
            }
        }
        if (object == null) {
            object = this.createDefaultASObject(className);
        }
        if (proxy == null) {
            proxy = PropertyProxyRegistry.getProxyAndRegister(object);
        }
        params[1] = proxy;
        return object;
    }

    protected ASObject createDefaultASObject(String type) {
        ASObject object = (ASObject)ClassUtil.createDefaultInstance(ASObject.class, null, true);
        if (type != null && type.length() > 0) {
            object.setType(type);
        }
        return object;
    }

    protected void readMaxStringBytes() {
        String maxStringBytes = null;
        try {
            maxStringBytes = System.getProperty(STRING_MAX_STRING_BYTES);
        }
        catch (SecurityException se2) {
            // empty catch block
        }
        if (maxStringBytes == null) {
            return;
        }
        try {
            this.maxStringBytes = Integer.parseInt(maxStringBytes);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] bytes) throws IOException {
        return this.in.read(bytes);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.in.read(bytes, offset, length);
    }

    public long skip(long n10) throws IOException {
        return this.in.skip(n10);
    }

    public int skipBytes(int n10) throws IOException {
        return this.in.skipBytes(n10);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public void readFully(byte[] bytes) throws IOException {
        this.in.readFully(bytes);
    }

    public void readFully(byte[] bytes, int offset, int length) throws IOException {
        this.in.readFully(bytes, offset, length);
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

