/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.LocalizedException;
import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.DictionaryProxy;
import flex.messaging.io.MapProxy;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PageableRowSetProxy;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.ThrowableProxy;
import flex.messaging.io.amf.ASObject;
import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.RowSet;

public class PropertyProxyRegistry {
    private final Map<Class, PropertyProxy> classRegistry = new IdentityHashMap<Class, PropertyProxy>();
    private static final PropertyProxyRegistry registry = new PropertyProxyRegistry();

    public static PropertyProxyRegistry getRegistry() {
        return registry;
    }

    public static void release() {
        registry.clear();
    }

    private static void preRegister() {
        ThrowableProxy proxy = new ThrowableProxy();
        registry.register(MessageException.class, proxy);
        registry.register(LocalizedException.class, proxy);
        registry.register(Throwable.class, proxy);
        MapProxy mapProxy = new MapProxy();
        registry.register(ASObject.class, mapProxy);
        registry.register(HashMap.class, mapProxy);
        registry.register(AbstractMap.class, mapProxy);
        registry.register(Map.class, mapProxy);
    }

    public static PropertyProxy getProxyAndRegister(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c10 = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(c10);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
            PropertyProxyRegistry.getRegistry().register(c10, proxy);
        }
        return proxy;
    }

    public static PropertyProxy getProxy(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c10 = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxy(c10);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
        }
        proxy = (PropertyProxy)proxy.clone();
        proxy.setDefaultInstance(instance);
        return proxy;
    }

    private static PropertyProxy guessProxy(Object instance) {
        AbstractProxy proxy = instance instanceof Map ? new MapProxy() : (instance instanceof Throwable ? new ThrowableProxy() : (instance instanceof PageableRowSet || instance instanceof RowSet ? new PageableRowSetProxy() : (instance instanceof Dictionary ? new DictionaryProxy() : new BeanProxy())));
        return proxy;
    }

    public PropertyProxy getProxy(Class c10) {
        return this.getProxy(c10, true, false);
    }

    public PropertyProxy getProxyAndRegister(Class c10) {
        return this.getProxy(c10, true, true);
    }

    public PropertyProxy getProxy(Class c10, boolean searchHierarchy, boolean autoRegister) {
        Class<?> superclass;
        PropertyProxy proxy;
        if (c10 == null) {
            return null;
        }
        if (c10.isArray()) {
            c10 = c10.getComponentType();
        }
        if ((proxy = this.classRegistry.get(c10)) == null && searchHierarchy) {
            Class<?>[] interfaces = c10.getInterfaces();
            for (int i10 = 0; i10 < interfaces.length; ++i10) {
                Class<?> interfaceClass = interfaces[i10];
                proxy = this.classRegistry.get(interfaceClass);
                if (proxy != null && autoRegister) {
                    this.register(c10, proxy);
                    break;
                }
                proxy = this.getProxy(interfaceClass, searchHierarchy, autoRegister);
                if (proxy != null) break;
            }
        }
        if (proxy == null && searchHierarchy && (superclass = c10.getSuperclass()) != null && (proxy = this.getProxy(superclass, searchHierarchy, autoRegister)) != null && autoRegister) {
            this.register(c10, proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class c10, PropertyProxy proxy) {
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.put(c10, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class c10) {
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.remove(c10);
        }
    }

    static {
        PropertyProxyRegistry.preRegister();
    }
}

