/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;

public class ArrayCollection
extends ArrayList
implements Externalizable {
    private static final long serialVersionUID = 8037277879661457358L;
    private SerializationDescriptor descriptor = null;

    public ArrayCollection() {
    }

    public ArrayCollection(Collection c10) {
        super(c10);
    }

    public ArrayCollection(int initialCapacity) {
        super(initialCapacity);
    }

    public Object[] getSource() {
        return this.toArray();
    }

    public void setDescriptor(SerializationDescriptor desc) {
        this.descriptor = desc;
    }

    public void setSource(Object[] s10) {
        if (s10 != null) {
            if (this.size() > 0) {
                this.clear();
            }
            for (int i10 = 0; i10 < s10.length; ++i10) {
                this.add(s10[i10]);
            }
        } else {
            this.clear();
        }
    }

    public void setSource(Collection s10) {
        this.addAll(s10);
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        Object[] s10 = input.readObject();
        if (s10 instanceof Collection) {
            s10 = ((Collection)s10).toArray();
        }
        Object[] source = s10;
        this.setSource(source);
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        if (this.descriptor == null) {
            output.writeObject(this.getSource());
        } else {
            Object[] source = this.getSource();
            if (source == null) {
                output.writeObject(null);
            } else {
                for (int i10 = 0; i10 < source.length; ++i10) {
                    Object item = source[i10];
                    if (item == null) {
                        source[i10] = null;
                        continue;
                    }
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(this.descriptor);
                    proxy.setDefaultInstance(item);
                    source[i10] = proxy;
                }
                output.writeObject(source);
            }
        }
    }
}

