/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.StreamingHTTPEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BaseStreamingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amfx.AmfxOutput;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class StreamingHTTPEndpoint
extends BaseStreamingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.StreamingHTTP";

    public StreamingHTTPEndpoint() {
        this(false);
    }

    public StreamingHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = new SessionFilter();
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        batchFilter.setNext(sessionFilter);
        sessionFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    protected String getResponseContentType() {
        return "application/xml";
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected long getMessageSizeForPerformanceInfo(Message message) {
        DataOutputStream dataOutStream;
        block2: {
            AmfxOutput amfxOut = new AmfxOutput(this.serializationContext);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            dataOutStream = new DataOutputStream(outStream);
            amfxOut.setOutputStream(dataOutStream);
            try {
                amfxOut.writeObject(message);
            }
            catch (IOException e10) {
                if (!Log.isDebug()) break block2;
                this.log.debug("MPI exception while retrieving the size of the serialized message: " + e10.toString());
            }
        }
        return dataOutStream.size();
    }

    protected String getDeserializerClassName() {
        return "flex.messaging.io.amfx.AmfxMessageDeserializer";
    }

    protected String getSerializerClassName() {
        return "flex.messaging.io.amfx.AmfxMessageSerializer";
    }

    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new StreamingHTTPEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }

    protected void streamMessages(List messages, ServletOutputStream os2, HttpServletResponse response) throws IOException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        TypeMarshallingContext.setTypeMarshaller(this.getTypeMarshaller());
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            AmfxOutput amfxOut = new AmfxOutput(this.serializationContext);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DataOutputStream dataOutStream = new DataOutputStream(outStream);
            amfxOut.setOutputStream(dataOutStream);
            Message message = (Message)iter.next();
            if (this.isRecordMessageSizes() || this.isRecordMessageTimes()) {
                this.addPerformanceInfo(message);
            }
            if (Log.isDebug()) {
                this.log.debug("Endpoint with id '" + this.getId() + "' is streaming message: " + message);
            }
            amfxOut.writeObject(message);
            dataOutStream.flush();
            byte[] messageBytes = outStream.toByteArray();
            this.streamChunk(messageBytes, os2, response);
            if (!this.isManaged()) continue;
            ((StreamingHTTPEndpointControl)this.controller).incrementPushCount();
        }
        TypeMarshallingContext.setTypeMarshaller(null);
    }
}

