/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.util.PropertyStringResourceLoader;
import flex.messaging.util.ResourceLoader;
import flex.messaging.util.WatchedObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;

public class SystemSettings {
    private ResourceLoader resourceLoader = new PropertyStringResourceLoader();
    private Locale defaultLocale;
    private boolean enforceEndpointValidation = false;
    private boolean manageable = true;
    private boolean redeployEnabled = false;
    private int watchInterval = 20;
    private List watches;
    private List touches = new ArrayList();

    public SystemSettings() {
        this.watches = new ArrayList();
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
        this.resourceLoader.setDefaultLocale(this.defaultLocale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public boolean isManageable() {
        return this.manageable;
    }

    public void setManageable(String manageable) {
        if ((manageable = manageable.toLowerCase()).startsWith("f")) {
            this.manageable = false;
        }
    }

    public boolean isEnforceEndpointValidation() {
        return this.enforceEndpointValidation;
    }

    public void setEnforceEndpointValidation(String enforceEndpointValidation) {
        if (enforceEndpointValidation == null || enforceEndpointValidation.length() == 0) {
            return;
        }
        if (enforceEndpointValidation.toLowerCase().startsWith("t")) {
            this.enforceEndpointValidation = true;
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setRedeployEnabled(String enabled) {
        if ((enabled = enabled.toLowerCase()).startsWith("t")) {
            this.redeployEnabled = true;
        }
    }

    public boolean getRedeployEnabled() {
        return this.redeployEnabled;
    }

    public void setWatchInterval(String interval) {
        this.watchInterval = Integer.parseInt(interval);
    }

    public int getWatchInterval() {
        return this.watchInterval;
    }

    public void addWatchFile(String watch) {
        this.watches.add(watch);
    }

    public List getWatchFiles() {
        return this.watches;
    }

    public void addTouchFile(String touch) {
        this.touches.add(touch);
    }

    public List getTouchFiles() {
        return this.touches;
    }

    public void setPaths(ServletContext context) {
        if (this.redeployEnabled) {
            Logger logger;
            ArrayList<WatchedObject> resolvedWatches = new ArrayList<WatchedObject>();
            for (int i10 = 0; i10 < this.watches.size(); ++i10) {
                String path = (String)this.watches.get(i10);
                String resolvedPath = null;
                if (path.startsWith("{context.root}") || path.startsWith("{context-root}")) {
                    resolvedPath = context.getRealPath(path = path.substring(14));
                    if (resolvedPath != null) {
                        try {
                            resolvedWatches.add(new WatchedObject(resolvedPath));
                        }
                        catch (FileNotFoundException fnfe) {
                            logger = Log.getLogger("Configuration");
                            if (logger == null) continue;
                            logger.warn("The watch-file, " + path + ", could not be found and will be ignored.");
                        }
                        continue;
                    }
                    Logger logger2 = Log.getLogger("Configuration");
                    logger2.warn("The watch-file, " + path + ", could not be resolved to a path and will be ignored.");
                    continue;
                }
                try {
                    resolvedWatches.add(new WatchedObject(path));
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    logger = Log.getLogger("Configuration");
                    if (logger == null) continue;
                    logger.warn("The watch-file, " + path + ", could not be found and will be ignored.");
                }
            }
            this.watches = resolvedWatches;
            ArrayList<Object> resolvedTouches = new ArrayList<Object>();
            for (int i11 = 0; i11 < this.touches.size(); ++i11) {
                Logger logger3;
                String path = (String)this.touches.get(i11);
                String resolvedPath = null;
                if (path.startsWith("{context.root}") || path.startsWith("{context-root}")) {
                    resolvedPath = context.getRealPath(path = path.substring(14));
                    if (resolvedPath != null) {
                        File file = new File(resolvedPath);
                        if (!file.exists() || !file.isFile() && !file.isDirectory() || !file.isAbsolute()) {
                            logger3 = Log.getLogger("Configuration");
                            logger3.warn("The touch-file, " + path + ", could not be found and will be ignored.");
                            continue;
                        }
                        resolvedTouches.add(resolvedPath);
                        continue;
                    }
                    logger = Log.getLogger("Configuration");
                    logger.warn("The touch-file, " + path + ", could not be resolved to a path and will be ignored.");
                    continue;
                }
                try {
                    resolvedTouches.add(new WatchedObject(path));
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    logger3 = Log.getLogger("Configuration");
                    if (logger3 == null) continue;
                    logger3.warn("The touch-file, " + path + ", could not be found and will be ignored.");
                }
            }
            this.touches = resolvedTouches;
        }
    }

    public void clear() {
        this.resourceLoader = null;
        this.defaultLocale = null;
        this.watches = null;
        this.touches = null;
    }
}

