/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.AbstractConfigurationParser;
import flex.messaging.config.AdapterSettings;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FactorySettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.LoginCommandSettings;
import flex.messaging.config.MessageFilterSettings;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.SharedServerSettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.config.TargetSettings;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.config.ValidatorSettings;
import flex.messaging.util.LocaleUtils;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ServerConfigurationParser
extends AbstractConfigurationParser {
    private boolean verifyAdvancedMessagingSupport = false;
    private boolean advancedMessagingSupportRegistered = false;

    protected void parseTopLevelConfig(Document doc2) {
        Node root = this.selectSingleNode(doc2, "/services-config");
        if (root != null) {
            this.allowedChildElements(root, SERVICES_CONFIG_CHILDREN);
            this.securitySection(root);
            this.serversSection(root);
            this.channelsSection(root);
            this.services(root);
            this.clusters(root);
            this.logging(root);
            this.system(root);
            this.flexClient(root);
            this.factories(root);
            this.messageFilters(root);
            this.validators(root);
            if (this.verifyAdvancedMessagingSupport && !this.advancedMessagingSupportRegistered) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(11129);
                throw e10;
            }
        } else {
            ConfigurationException e11 = new ConfigurationException();
            e11.setMessage(10103, new Object[]{"services-config"});
            throw e11;
        }
    }

    private void clusters(Node root) {
        Node clusteringNode = this.selectSingleNode(root, "clusters");
        if (clusteringNode != null) {
            this.allowedAttributesOrElements(clusteringNode, CLUSTERING_CHILDREN);
            NodeList clusters = this.selectNodeList(clusteringNode, "cluster");
            for (int i10 = 0; i10 < clusters.getLength(); ++i10) {
                NodeList properties;
                String ulb2;
                String defaultValue;
                Node cluster = clusters.item(i10);
                this.requiredAttributesOrElements(cluster, CLUSTER_DEFINITION_CHILDREN);
                String clusterName = this.getAttributeOrChildElement(cluster, "id");
                if (!ServerConfigurationParser.isValidID(clusterName)) continue;
                String propsFileName = this.getAttributeOrChildElement(cluster, "properties");
                ClusterSettings clusterSettings = new ClusterSettings();
                clusterSettings.setClusterName(clusterName);
                clusterSettings.setPropsFileName(propsFileName);
                String className = this.getAttributeOrChildElement(cluster, "class");
                if (className != null && className.length() > 0) {
                    clusterSettings.setImplementationClass(className);
                }
                if ((defaultValue = this.getAttributeOrChildElement(cluster, "default")) != null && defaultValue.length() > 0) {
                    if (defaultValue.equalsIgnoreCase("true")) {
                        clusterSettings.setDefault(true);
                    } else if (!defaultValue.equalsIgnoreCase("false")) {
                        ConfigurationException e10 = new ConfigurationException();
                        e10.setMessage(10215, new Object[]{clusterName, defaultValue});
                        throw e10;
                    }
                }
                if ((ulb2 = this.getAttributeOrChildElement(cluster, "url-load-balancing")) != null && ulb2.length() > 0) {
                    if (ulb2.equalsIgnoreCase("false")) {
                        clusterSettings.setURLLoadBalancing(false);
                    } else if (!ulb2.equalsIgnoreCase("true")) {
                        ConfigurationException e11 = new ConfigurationException();
                        e11.setMessage(10216, new Object[]{clusterName, ulb2});
                        throw e11;
                    }
                }
                if ((properties = this.selectNodeList(cluster, "properties/*")).getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(cluster));
                    clusterSettings.addProperties(map);
                }
                ((MessagingConfiguration)this.config).addClusterSettings(clusterSettings);
            }
        }
    }

    private void securitySection(Node root) {
        Node security = this.selectSingleNode(root, "security");
        if (security != null) {
            int i10;
            this.allowedChildElements(security, SECURITY_CHILDREN);
            NodeList list = this.selectNodeList(security, "security-constraint");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                Node constraint = list.item(i10);
                this.securityConstraint(constraint, false);
            }
            list = this.selectNodeList(security, "login-command");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                Node login = list.item(i10);
                LoginCommandSettings loginCommandSettings = new LoginCommandSettings();
                this.requiredAttributesOrElements(login, LOGIN_COMMAND_REQ_CHILDREN);
                this.allowedAttributesOrElements(login, LOGIN_COMMAND_CHILDREN);
                String server = this.getAttributeOrChildElement(login, "server");
                if (server.length() == 0) {
                    ConfigurationException e10 = new ConfigurationException();
                    e10.setMessage(10105, new Object[]{"server", "login-command"});
                    throw e10;
                }
                loginCommandSettings.setServer(server);
                String loginClass = this.getAttributeOrChildElement(login, "class");
                if (loginClass.length() == 0) {
                    ConfigurationException e11 = new ConfigurationException();
                    e11.setMessage(10105, new Object[]{"class", "login-command"});
                    throw e11;
                }
                loginCommandSettings.setClassName(loginClass);
                boolean isPerClientAuth = Boolean.valueOf(this.getAttributeOrChildElement(login, "per-client-authentication"));
                loginCommandSettings.setPerClientAuthentication(isPerClientAuth);
                ((MessagingConfiguration)this.config).getSecuritySettings().addLoginCommandSettings(loginCommandSettings);
            }
        }
    }

    private SecurityConstraint securityConstraint(Node constraint, boolean inline) {
        SecurityConstraint sc2;
        this.allowedAttributesOrElements(constraint, SECURITY_CONSTRAINT_DEFINITION_CHILDREN);
        String ref = this.getAttributeOrChildElement(constraint, "ref");
        if (ref.length() > 0) {
            this.allowedAttributesOrElements(constraint, new String[]{"ref"});
            sc2 = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
            if (sc2 == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"security-constraint", ref});
                throw e10;
            }
        } else {
            String id2 = this.getAttributeOrChildElement(constraint, "id");
            if (inline) {
                sc2 = new SecurityConstraint("");
            } else if (ServerConfigurationParser.isValidID(id2)) {
                sc2 = new SecurityConstraint(id2);
                ((MessagingConfiguration)this.config).getSecuritySettings().addConstraint(sc2);
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10110, new Object[]{"security-constraint", id2});
                ex2.setDetails(10110);
                throw ex2;
            }
            String method = this.getAttributeOrChildElement(constraint, "auth-method");
            sc2.setMethod(method);
            Node rolesNode = this.selectSingleNode(constraint, "roles");
            if (rolesNode != null) {
                this.allowedChildElements(rolesNode, ROLES_CHILDREN);
                NodeList roles = this.selectNodeList(rolesNode, "role");
                for (int r10 = 0; r10 < roles.getLength(); ++r10) {
                    Node roleNode = roles.item(r10);
                    String role = this.evaluateExpression(roleNode, ".").toString().trim();
                    if (role.length() <= 0) continue;
                    sc2.addRole(role);
                }
            }
        }
        return sc2;
    }

    private void serversSection(Node root) {
        if (!(this.config instanceof MessagingConfiguration)) {
            return;
        }
        Node serversNode = this.selectSingleNode(root, "servers");
        if (serversNode != null) {
            this.allowedAttributesOrElements(serversNode, SERVERS_CHILDREN);
            NodeList servers = this.selectNodeList(serversNode, "server");
            for (int i10 = 0; i10 < servers.getLength(); ++i10) {
                Node server = servers.item(i10);
                this.serverDefinition(server);
            }
        }
    }

    private void serverDefinition(Node server) {
        this.requiredAttributesOrElements(server, SERVER_REQ_CHILDREN);
        this.allowedAttributesOrElements(server, SERVER_CHILDREN);
        String id2 = this.getAttributeOrChildElement(server, "id");
        if (ServerConfigurationParser.isValidID(id2)) {
            SharedServerSettings settings = new SharedServerSettings();
            settings.setId(id2);
            settings.setSourceFile(this.getSourceFileOf(server));
            String className = this.getAttributeOrChildElement(server, "class");
            if (className.length() > 0) {
                settings.setClassName(className);
                NodeList properties = this.selectNodeList(server, "properties/*");
                if (properties.getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(server));
                    settings.addProperties(map);
                }
                ((MessagingConfiguration)this.config).addSharedServerSettings(settings);
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10114, new Object[]{"server", id2});
                throw ex2;
            }
        }
    }

    private void channelsSection(Node root) {
        Node channelsNode = this.selectSingleNode(root, "channels");
        if (channelsNode != null) {
            this.allowedAttributesOrElements(channelsNode, CHANNELS_CHILDREN);
            NodeList channels = this.selectNodeList(channelsNode, "channel-definition");
            for (int i10 = 0; i10 < channels.getLength(); ++i10) {
                Node channel = channels.item(i10);
                this.channelDefinition(channel);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void channelDefinition(Node channel) {
        String ref;
        NodeList properties;
        Node server;
        boolean serverOnly;
        this.requiredAttributesOrElements(channel, CHANNEL_DEFINITION_REQ_CHILDREN);
        this.allowedAttributesOrElements(channel, CHANNEL_DEFINITION_CHILDREN);
        String id2 = this.getAttributeOrChildElement(channel, "id");
        if (!ServerConfigurationParser.isValidID(id2)) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10110, new Object[]{"channel-definition", id2});
            ex2.setDetails(10110);
            throw ex2;
        }
        if (this.config.getChannelSettings(id2) != null) {
            ConfigurationException e10 = new ConfigurationException();
            e10.setMessage(11127, new Object[]{id2});
            throw e10;
        }
        ChannelSettings channelSettings = new ChannelSettings(id2);
        channelSettings.setSourceFile(this.getSourceFileOf(channel));
        String clientType = this.getAttributeOrChildElement(channel, "class");
        clientType = clientType.length() > 0 ? clientType : null;
        String serverOnlyString = this.getAttributeOrChildElement(channel, "server-only");
        boolean bl2 = serverOnly = serverOnlyString.length() > 0 ? Boolean.valueOf(serverOnlyString) : false;
        if (clientType == null && !serverOnly) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(11139, new Object[]{id2});
            throw ce2;
        }
        if (clientType != null && serverOnly) {
            ConfigurationException ce3 = new ConfigurationException();
            ce3.setMessage(11140, new Object[]{id2});
            throw ce3;
        }
        if (serverOnly) {
            channelSettings.setServerOnly(true);
        } else {
            channelSettings.setClientType(clientType);
        }
        String remote = this.getAttributeOrChildElement(channel, "remote");
        channelSettings.setRemote(Boolean.valueOf(remote));
        Node endpoint = this.selectSingleNode(channel, "endpoint");
        if (endpoint != null) {
            this.allowedAttributesOrElements(endpoint, ENDPOINT_CHILDREN);
            String type = this.getAttributeOrChildElement(endpoint, "class");
            channelSettings.setEndpointType(type);
            String uri = this.getAttributeOrChildElement(endpoint, "url");
            if (uri == null || "".equals(uri)) {
                uri = this.getAttributeOrChildElement(endpoint, "uri");
            }
            channelSettings.setUri(uri);
            this.config.addChannelSettings(id2, channelSettings);
        }
        if ((server = this.selectSingleNode(channel, "server")) != null) {
            this.requiredAttributesOrElements(server, CHANNEL_DEFINITION_SERVER_REQ_CHILDREN);
            String serverId = this.getAttributeOrChildElement(server, "ref");
            channelSettings.setServerId(serverId);
        }
        if ((properties = this.selectNodeList(channel, "properties/*")).getLength() > 0) {
            boolean adaptiveFrequency;
            ConfigMap queueProcessorProperties;
            ConfigMap outboundQueueProcessor;
            ConfigMap map = this.properties(properties, this.getSourceFileOf(channel));
            channelSettings.addProperties(map);
            if (!this.verifyAdvancedMessagingSupport && (outboundQueueProcessor = map.getPropertyAsMap("flex-client-outbound-queue-processor", null)) != null && (queueProcessorProperties = outboundQueueProcessor.getPropertyAsMap("properties", null)) != null && (adaptiveFrequency = queueProcessorProperties.getPropertyAsBoolean("adaptive-frequency", false))) {
                this.verifyAdvancedMessagingSupport = true;
            }
        }
        if ((ref = this.evaluateExpression(channel, "@security-constraint").toString().trim()).length() <= 0) {
            Node security = this.selectSingleNode(channel, "security");
            if (security == null) return;
            this.allowedChildElements(security, EMBEDDED_SECURITY_CHILDREN);
            Node constraint = this.selectSingleNode(security, "security-constraint");
            if (constraint == null) return;
            SecurityConstraint sc2 = this.securityConstraint(constraint, true);
            channelSettings.setConstraint(sc2);
            return;
        }
        SecurityConstraint sc3 = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
        if (sc3 != null) {
            channelSettings.setConstraint(sc3);
            return;
        }
        ConfigurationException ex3 = new ConfigurationException();
        ex3.setMessage(10132, new Object[]{"security-constraint", ref, id2});
        throw ex3;
    }

    private void services(Node root) {
        Node servicesNode = this.selectSingleNode(root, "services");
        if (servicesNode != null) {
            Node service;
            int i10;
            this.allowedChildElements(servicesNode, SERVICES_CHILDREN);
            Node defaultChannels = this.selectSingleNode(servicesNode, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    Node chan = channels.item(c10);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan);
                }
            }
            NodeList services = this.selectNodeList(servicesNode, "service-include");
            for (i10 = 0; i10 < services.getLength(); ++i10) {
                service = services.item(i10);
                this.serviceInclude(service);
            }
            services = this.selectNodeList(servicesNode, "service");
            for (i10 = 0; i10 < services.getLength(); ++i10) {
                service = services.item(i10);
                this.service(service);
            }
        }
    }

    private void serviceInclude(Node serviceInclude) {
        this.requiredAttributesOrElements(serviceInclude, SERVICE_INCLUDE_CHILDREN);
        String src2 = this.getAttributeOrChildElement(serviceInclude, "file-path");
        if (src2.length() > 0) {
            Document doc2 = this.loadDocument(src2, this.fileResolver.getIncludedFile(src2));
            doc2.getDocumentElement().normalize();
            Node service = this.selectSingleNode(doc2, "/service");
            if (service != null) {
                this.service(service);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10112, new Object[]{"service"});
                throw ex2;
            }
        }
    }

    private void service(Node service) {
        this.requiredAttributesOrElements(service, SERVICE_REQ_CHILDREN);
        this.allowedAttributesOrElements(service, SERVICE_CHILDREN);
        String id2 = this.getAttributeOrChildElement(service, "id");
        if (ServerConfigurationParser.isValidID(id2)) {
            Node dest;
            int i10;
            Node adapters;
            Node defaultSecurityConstraint;
            Node defaultChannels;
            ServiceSettings serviceSettings = this.config.getServiceSettings(id2);
            if (serviceSettings != null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10113, new Object[]{id2});
                throw e10;
            }
            serviceSettings = new ServiceSettings(id2);
            serviceSettings.setSourceFile(this.getSourceFileOf(service));
            this.config.addServiceSettings(serviceSettings);
            String className = this.getAttributeOrChildElement(service, "class");
            if (className.length() > 0) {
                serviceSettings.setClassName(className);
                if (className.equals("flex.messaging.services.AdvancedMessagingSupport")) {
                    this.advancedMessagingSupportRegistered = true;
                }
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10114, new Object[]{"service", id2});
                throw ex2;
            }
            NodeList properties = this.selectNodeList(service, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(service));
                serviceSettings.addProperties(map);
            }
            if ((defaultChannels = this.selectSingleNode(service, "default-channels")) != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    Node chan = channels.item(c10);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan, serviceSettings);
                }
            } else if (this.config.getDefaultChannels().size() > 0) {
                for (String channelId : this.config.getDefaultChannels()) {
                    ChannelSettings channel = this.config.getChannelSettings(channelId);
                    serviceSettings.addDefaultChannel(channel);
                }
            }
            if ((defaultSecurityConstraint = this.selectSingleNode(service, "default-security-constraint")) != null) {
                this.requiredAttributesOrElements(defaultSecurityConstraint, new String[]{"ref"});
                this.allowedAttributesOrElements(defaultSecurityConstraint, new String[]{"ref"});
                String ref = this.getAttributeOrChildElement(defaultSecurityConstraint, "ref");
                if (ref.length() > 0) {
                    SecurityConstraint sc2 = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
                    if (sc2 == null) {
                        ConfigurationException e11 = new ConfigurationException();
                        e11.setMessage(10109, new Object[]{"security-constraint", ref});
                        throw e11;
                    }
                    serviceSettings.setConstraint(sc2);
                } else {
                    ConfigurationException ex3 = new ConfigurationException();
                    ex3.setMessage(11124, new Object[]{ref, id2});
                    throw ex3;
                }
            }
            if ((adapters = this.selectSingleNode(service, "adapters")) != null) {
                this.allowedChildElements(adapters, ADAPTERS_CHILDREN);
                NodeList serverAdapters = this.selectNodeList(adapters, "adapter-definition");
                for (int a10 = 0; a10 < serverAdapters.getLength(); ++a10) {
                    Node adapter = serverAdapters.item(a10);
                    this.adapterDefinition(adapter, serviceSettings);
                }
            }
            NodeList list = this.selectNodeList(service, "destination");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                dest = list.item(i10);
                this.destination(dest, serviceSettings);
            }
            list = this.selectNodeList(service, "destination-include");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                dest = list.item(i10);
                this.destinationInclude(dest, serviceSettings);
            }
        } else {
            ConfigurationException ex4 = new ConfigurationException();
            ex4.setMessage(10110, new Object[]{"service", id2});
            throw ex4;
        }
    }

    private void defaultChannel(Node chan) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"channel", ref});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10116, new Object[]{"MessageBroker"});
            throw ex2;
        }
        this.config.addDefaultChannel(channel.getId());
    }

    private void defaultChannel(Node chan, ServiceSettings serviceSettings) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"channel", ref});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10116, new Object[]{serviceSettings.getId()});
            throw ex2;
        }
        serviceSettings.addDefaultChannel(channel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adapterDefinition(Node adapter, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(adapter, ADAPTER_DEFINITION_REQ_CHILDREN);
        this.allowedChildElements(adapter, ADAPTER_DEFINITION_CHILDREN);
        String serviceId = serviceSettings.getId();
        String id2 = this.getAttributeOrChildElement(adapter, "id");
        if (!ServerConfigurationParser.isValidID(id2)) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10119, new Object[]{"adapter-definition", id2, serviceId});
            throw ex2;
        }
        AdapterSettings adapterSettings = new AdapterSettings(id2);
        adapterSettings.setSourceFile(this.getSourceFileOf(adapter));
        String className = this.getAttributeOrChildElement(adapter, "class");
        if (className.length() <= 0) {
            ConfigurationException ex3 = new ConfigurationException();
            ex3.setMessage(10114, new Object[]{"adapter-definition", id2});
            throw ex3;
        }
        adapterSettings.setClassName(className);
        boolean isDefault = Boolean.valueOf(this.getAttributeOrChildElement(adapter, "default"));
        if (isDefault) {
            adapterSettings.setDefault(isDefault);
            AdapterSettings defaultAdapter = serviceSettings.getDefaultAdapter();
            if (defaultAdapter != null) {
                ConfigurationException ex4 = new ConfigurationException();
                ex4.setMessage(10117, new Object[]{id2, serviceId, defaultAdapter.getId()});
                throw ex4;
            }
        }
        serviceSettings.addAdapterSettings(adapterSettings);
        NodeList properties = this.selectNodeList(adapter, "properties/*");
        if (properties.getLength() <= 0) return;
        ConfigMap map = this.properties(properties, this.getSourceFileOf(adapter));
        adapterSettings.addProperties(map);
    }

    private void destinationInclude(Node destInclude, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(destInclude, DESTINATION_INCLUDE_CHILDREN);
        String src2 = this.getAttributeOrChildElement(destInclude, "file-path");
        if (src2.length() > 0) {
            Document doc2 = this.loadDocument(src2, this.fileResolver.getIncludedFile(src2));
            doc2.getDocumentElement().normalize();
            Node destinationsNode = this.selectSingleNode(doc2, "destinations");
            if (destinationsNode != null) {
                this.allowedChildElements(destinationsNode, DESTINATIONS_CHILDREN);
                NodeList destinations = this.selectNodeList(destinationsNode, "destination");
                for (int a10 = 0; a10 < destinations.getLength(); ++a10) {
                    Node dest = destinations.item(a10);
                    this.destination(dest, serviceSettings);
                }
                this.fileResolver.popIncludedFile();
            } else {
                Node dest = this.selectSingleNode(doc2, "/destination");
                if (dest != null) {
                    this.destination(dest, serviceSettings);
                    this.fileResolver.popIncludedFile();
                } else {
                    ConfigurationException ex2 = new ConfigurationException();
                    ex2.setMessage(10118, new Object[]{"destinations", "destination"});
                    throw ex2;
                }
            }
        }
    }

    private void destination(Node dest, ServiceSettings serviceSettings) {
        DestinationSettings destinationSettings;
        this.requiredAttributesOrElements(dest, DESTINATION_REQ_CHILDREN);
        this.allowedAttributes(dest, DESTINATION_ATTR);
        this.allowedChildElements(dest, DESTINATION_CHILDREN);
        String serviceId = serviceSettings.getId();
        String id2 = this.getAttributeOrChildElement(dest, "id");
        if (ServerConfigurationParser.isValidID(id2)) {
            destinationSettings = (DestinationSettings)serviceSettings.getDestinationSettings().get(id2);
            if (destinationSettings != null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10122, new Object[]{id2, serviceId});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10119, new Object[]{"destination", id2, serviceId});
            throw ex2;
        }
        destinationSettings = new DestinationSettings(id2);
        destinationSettings.setSourceFile(this.getSourceFileOf(dest));
        serviceSettings.addDestinationSettings(destinationSettings);
        NodeList properties = this.selectNodeList(dest, "properties/*");
        if (properties.getLength() > 0) {
            ConfigMap networkSettings;
            ConfigMap map = this.properties(properties, this.getSourceFileOf(dest));
            destinationSettings.addProperties(map);
            if (!this.verifyAdvancedMessagingSupport && (networkSettings = map.getPropertyAsMap("network", null)) != null) {
                String reliable = networkSettings.getPropertyAsString("reliable", null);
                if (reliable != null && Boolean.valueOf(reliable).booleanValue()) {
                    this.verifyAdvancedMessagingSupport = true;
                } else {
                    String policy;
                    ConfigMap outbound;
                    String policy2;
                    ConfigMap inbound = networkSettings.getPropertyAsMap("throttle-inbound", null);
                    if (inbound != null && (policy2 = inbound.getPropertyAsString("policy", null)) != null && (ThrottleSettings.Policy.BUFFER.toString().equalsIgnoreCase(policy2) || ThrottleSettings.Policy.CONFLATE.toString().equalsIgnoreCase(policy2))) {
                        this.verifyAdvancedMessagingSupport = true;
                    }
                    if (!this.verifyAdvancedMessagingSupport && (outbound = networkSettings.getPropertyAsMap("throttle-outbound", null)) != null && (policy = outbound.getPropertyAsString("policy", null)) != null && (ThrottleSettings.Policy.BUFFER.toString().equalsIgnoreCase(policy) || ThrottleSettings.Policy.CONFLATE.toString().equalsIgnoreCase(policy))) {
                        this.verifyAdvancedMessagingSupport = true;
                    }
                }
            }
        }
        this.destinationChannels(dest, destinationSettings, serviceSettings);
        this.destinationSecurity(dest, destinationSettings, serviceSettings);
        this.destinationAdapter(dest, destinationSettings, serviceSettings);
    }

    private void destinationChannels(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String channelsList = this.evaluateExpression(dest, "@channels").toString().trim();
        if (channelsList.length() > 0) {
            StringTokenizer st2 = new StringTokenizer(channelsList, ",;:");
            while (st2.hasMoreTokens()) {
                String ref = st2.nextToken().trim();
                ChannelSettings channel = this.config.getChannelSettings(ref);
                if (channel != null) {
                    destinationSettings.addChannelSettings(channel);
                    continue;
                }
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10120, new Object[]{"channel", ref, destId});
                throw ex2;
            }
        } else {
            Node channelsNode = this.selectSingleNode(dest, "channels");
            if (channelsNode != null) {
                this.allowedChildElements(channelsNode, DESTINATION_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(channelsNode, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    ChannelSettings channel;
                    Node chan = channels.item(c10);
                    this.requiredAttributesOrElements(chan, DESTINATION_CHANNEL_REQ_CHILDREN);
                    String ref = this.getAttributeOrChildElement(chan, "ref");
                    if (ref.length() > 0) {
                        channel = this.config.getChannelSettings(ref);
                        if (channel == null) {
                            ConfigurationException ex3 = new ConfigurationException();
                            ex3.setMessage(10120, new Object[]{"channel", ref, destId});
                            throw ex3;
                        }
                    } else {
                        ConfigurationException ex4 = new ConfigurationException();
                        ex4.setMessage(10121, new Object[]{"channel", ref, destId});
                        throw ex4;
                    }
                    destinationSettings.addChannelSettings(channel);
                }
            } else {
                List defaultChannels = serviceSettings.getDefaultChannels();
                for (ChannelSettings channel : defaultChannels) {
                    destinationSettings.addChannelSettings(channel);
                }
            }
        }
        if (destinationSettings.getChannelSettings().size() <= 0) {
            ConfigurationException ex5 = new ConfigurationException();
            ex5.setMessage(10123, new Object[]{destId});
            throw ex5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void destinationSecurity(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String ref = this.evaluateExpression(dest, "@security-constraint").toString().trim();
        if (ref.length() > 0) {
            SecurityConstraint sc2 = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
            if (sc2 != null) {
                destinationSettings.setConstraint(sc2);
                return;
            }
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10120, new Object[]{"security-constraint", ref, destId});
            throw ex2;
        }
        Node security = this.selectSingleNode(dest, "security");
        if (security != null) {
            this.allowedChildElements(security, EMBEDDED_SECURITY_CHILDREN);
            Node constraint = this.selectSingleNode(security, "security-constraint");
            if (constraint == null) return;
            SecurityConstraint sc3 = this.securityConstraint(constraint, true);
            destinationSettings.setConstraint(sc3);
            return;
        }
        SecurityConstraint sc4 = serviceSettings.getConstraint();
        if (sc4 == null) return;
        destinationSettings.setConstraint(sc4);
    }

    private void destinationAdapter(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String ref = this.evaluateExpression(dest, "@adapter").toString().trim();
        if (ref.length() > 0) {
            this.adapterReference(ref, destinationSettings, serviceSettings);
        } else {
            Node adapter = this.selectSingleNode(dest, "adapter");
            if (adapter != null) {
                this.allowedAttributesOrElements(adapter, DESTINATION_ADAPTER_CHILDREN);
                ref = this.getAttributeOrChildElement(adapter, "ref");
                this.adapterReference(ref, destinationSettings, serviceSettings);
            } else {
                AdapterSettings adapterSettings = serviceSettings.getDefaultAdapter();
                if (adapterSettings != null) {
                    destinationSettings.setAdapterSettings(adapterSettings);
                }
            }
        }
        if (destinationSettings.getAdapterSettings() == null) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10127, new Object[]{destId});
            throw ex2;
        }
    }

    private void adapterReference(String ref, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        AdapterSettings adapterSettings;
        String destId = destinationSettings.getId();
        if (ref.length() > 0) {
            adapterSettings = serviceSettings.getAdapterSettings(ref);
            if (adapterSettings == null) {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10120, new Object[]{"adapter", ref, destId});
                throw ex2;
            }
        } else {
            ConfigurationException ex3 = new ConfigurationException();
            ex3.setMessage(10121, new Object[]{"adapter", ref, destId});
            throw ex3;
        }
        destinationSettings.setAdapterSettings(adapterSettings);
    }

    private void logging(Node root) {
        Node logging = this.selectSingleNode(root, "logging");
        if (logging != null) {
            this.allowedAttributesOrElements(logging, LOGGING_CHILDREN);
            LoggingSettings settings = new LoggingSettings();
            NodeList properties = this.selectNodeList(logging, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(logging));
                settings.addProperties(map);
            }
            NodeList targets = this.selectNodeList(logging, "target");
            for (int i10 = 0; i10 < targets.getLength(); ++i10) {
                Node filtersNode;
                Node targetNode = targets.item(i10);
                this.requiredAttributesOrElements(targetNode, TARGET_REQ_CHILDREN);
                this.allowedAttributesOrElements(targetNode, TARGET_CHILDREN);
                String className = this.getAttributeOrChildElement(targetNode, "class");
                if (className.length() <= 0) continue;
                TargetSettings targetSettings = new TargetSettings(className);
                String targetLevel = this.getAttributeOrChildElement(targetNode, "level");
                if (targetLevel.length() > 0) {
                    targetSettings.setLevel(targetLevel);
                }
                if ((filtersNode = this.selectSingleNode(targetNode, "filters")) != null) {
                    this.allowedChildElements(filtersNode, FILTERS_CHILDREN);
                    NodeList filters = this.selectNodeList(filtersNode, "pattern");
                    for (int f10 = 0; f10 < filters.getLength(); ++f10) {
                        Node pattern = filters.item(f10);
                        String filter = this.evaluateExpression(pattern, ".").toString().trim();
                        targetSettings.addFilter(filter);
                    }
                }
                if ((properties = this.selectNodeList(targetNode, "properties/*")).getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(targetNode));
                    targetSettings.addProperties(map);
                }
                settings.addTarget(targetSettings);
            }
            this.config.setLoggingSettings(settings);
        }
    }

    private void system(Node root) {
        Node system = this.selectSingleNode(root, "system");
        if (system != null) {
            this.allowedAttributesOrElements(system, SYSTEM_CHILDREN);
            SystemSettings settings = new SystemSettings();
            settings.setEnforceEndpointValidation(this.getAttributeOrChildElement(system, "enforce-endpoint-validation"));
            Node localeNode = this.selectSingleNode(system, "locale");
            if (localeNode != null) {
                this.allowedAttributesOrElements(localeNode, LOCALE_CHILDREN);
                String defaultLocaleString = this.getAttributeOrChildElement(localeNode, "default-locale");
                Locale defaultLocale = defaultLocaleString.length() > 0 ? LocaleUtils.buildLocale(defaultLocaleString) : LocaleUtils.buildLocale(null);
                settings.setDefaultLocale(defaultLocale);
            }
            settings.setManageable(this.getAttributeOrChildElement(system, "manageable"));
            Node redeployNode = this.selectSingleNode(system, "redeploy");
            if (redeployNode != null) {
                this.allowedAttributesOrElements(redeployNode, REDEPLOY_CHILDREN);
                String enabled = this.getAttributeOrChildElement(redeployNode, "enabled");
                settings.setRedeployEnabled(enabled);
                String interval = this.getAttributeOrChildElement(redeployNode, "watch-interval");
                if (interval.length() > 0) {
                    settings.setWatchInterval(interval);
                }
                NodeList watches = this.selectNodeList(redeployNode, "watch-file");
                for (int i10 = 0; i10 < watches.getLength(); ++i10) {
                    Node watchNode = watches.item(i10);
                    String watch = this.evaluateExpression(watchNode, ".").toString().trim();
                    if (watch.length() <= 0) continue;
                    settings.addWatchFile(watch);
                }
                NodeList touches = this.selectNodeList(redeployNode, "touch-file");
                for (int i11 = 0; i11 < touches.getLength(); ++i11) {
                    Node touchNode = touches.item(i11);
                    String touch = this.evaluateExpression(touchNode, ".").toString().trim();
                    if (touch.length() <= 0) continue;
                    settings.addTouchFile(touch);
                }
            }
            ((MessagingConfiguration)this.config).setSystemSettings(settings);
        } else {
            ((MessagingConfiguration)this.config).setSystemSettings(new SystemSettings());
        }
    }

    private void flexClient(Node root) {
        Node flexClient = this.selectSingleNode(root, "flex-client");
        if (flexClient != null) {
            this.allowedChildElements(flexClient, FLEX_CLIENT_CHILDREN);
            FlexClientSettings flexClientSettings = new FlexClientSettings();
            String timeout = this.getAttributeOrChildElement(flexClient, "timeout-minutes");
            if (timeout.length() > 0) {
                try {
                    long timeoutMinutes = Long.parseLong(timeout);
                    if (timeoutMinutes < 0L) {
                        ConfigurationException e10 = new ConfigurationException();
                        e10.setMessage(11123, new Object[]{timeout});
                        throw e10;
                    }
                    flexClientSettings.setTimeoutMinutes(timeoutMinutes);
                }
                catch (NumberFormatException nfe) {
                    ConfigurationException e11 = new ConfigurationException();
                    e11.setMessage(11123, new Object[]{timeout});
                    throw e11;
                }
            } else {
                flexClientSettings.setTimeoutMinutes(0L);
            }
            Node outboundQueueProcessor = this.selectSingleNode(flexClient, "flex-client-outbound-queue-processor");
            if (outboundQueueProcessor != null) {
                this.requiredAttributesOrElements(outboundQueueProcessor, FLEX_CLIENT_OUTBOUND_QUEUE_PROCESSOR_REQ_CHILDREN);
                String outboundQueueProcessClass = this.getAttributeOrChildElement(outboundQueueProcessor, "class");
                if (outboundQueueProcessClass.length() <= 0) {
                    ConfigurationException ex2 = new ConfigurationException();
                    ex2.setMessage(10114, new Object[]{"flex-client-outbound-queue-processor", ""});
                    throw ex2;
                }
                flexClientSettings.setFlexClientOutboundQueueProcessorClassName(outboundQueueProcessClass);
                NodeList properties = this.selectNodeList(outboundQueueProcessor, "properties/*");
                if (properties.getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(outboundQueueProcessor));
                    flexClientSettings.setFlexClientOutboundQueueProcessorProperties(map);
                    boolean adaptiveFrequency = map.getPropertyAsBoolean("adaptive-frequency", false);
                    if (adaptiveFrequency) {
                        this.verifyAdvancedMessagingSupport = true;
                    }
                }
            }
            ((MessagingConfiguration)this.config).setFlexClientSettings(flexClientSettings);
        }
    }

    private void factories(Node root) {
        Node factories = this.selectSingleNode(root, "factories");
        if (factories != null) {
            this.allowedAttributesOrElements(factories, FACTORIES_CHILDREN);
            NodeList factoryList = this.selectNodeList(factories, "factory");
            for (int i10 = 0; i10 < factoryList.getLength(); ++i10) {
                Node factory = factoryList.item(i10);
                this.factory(factory);
            }
        }
    }

    private void factory(Node factory) {
        FactorySettings factorySettings;
        this.requiredAttributesOrElements(factory, FACTORY_REQ_CHILDREN);
        String id2 = this.getAttributeOrChildElement(factory, "id");
        String className = this.getAttributeOrChildElement(factory, "class");
        if (ServerConfigurationParser.isValidID(id2)) {
            factorySettings = new FactorySettings(id2, className);
            NodeList properties = this.selectNodeList(factory, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(factory));
                factorySettings.addProperties(map);
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10110, new Object[]{"factory", id2});
            ex2.setDetails(10110);
            throw ex2;
        }
        ((MessagingConfiguration)this.config).addFactorySettings(id2, factorySettings);
    }

    private void messageFilters(Node root) {
        this.typedMessageFilters(root, "async-message-filters", ASYNC_MESSAGE_FILTERS_ELEMENT_CHILDREN);
        this.typedMessageFilters(root, "sync-message-filters", SYNC_MESSAGE_FILTERS_ELEMENT_CHILDREN);
    }

    private void typedMessageFilters(Node root, String filterTypeElement, String[] childrenElements) {
        Node messageFiltersNode = this.selectSingleNode(root, filterTypeElement);
        if (messageFiltersNode == null) {
            return;
        }
        this.allowedChildElements(messageFiltersNode, childrenElements);
        NodeList messageFilters = this.selectNodeList(messageFiltersNode, "filter");
        for (int i10 = 0; i10 < messageFilters.getLength(); ++i10) {
            Node messageFilter = messageFilters.item(i10);
            this.messageFilter(messageFilter, filterTypeElement);
        }
    }

    private void messageFilter(Node messageFilter, String filterType) {
        this.requiredAttributesOrElements(messageFilter, FILTER_REQ_CHILDREN);
        this.allowedAttributesOrElements(messageFilter, FILTER_CHILDREN);
        String id2 = this.getAttributeOrChildElement(messageFilter, "id");
        if (ServerConfigurationParser.isValidID(id2)) {
            String className = this.getAttributeOrChildElement(messageFilter, "class");
            if (className.length() > 0) {
                MessageFilterSettings messageFilterSettings = new MessageFilterSettings();
                messageFilterSettings.setId(id2);
                messageFilterSettings.setClassName(className);
                MessageFilterSettings.FilterType type = filterType.equals("async-message-filters") ? MessageFilterSettings.FilterType.ASYNC : MessageFilterSettings.FilterType.SYNC;
                messageFilterSettings.setFilterType(type);
                NodeList properties = this.selectNodeList(messageFilter, "properties/*");
                if (properties.getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(messageFilter));
                    messageFilterSettings.addProperties(map);
                }
                ((MessagingConfiguration)this.config).addMessageFilterSettings(messageFilterSettings);
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10114, new Object[]{"filter", id2});
                throw ex2;
            }
        }
    }

    private void validators(Node root) {
        Node validatorsNode = this.selectSingleNode(root, "validators");
        if (validatorsNode == null) {
            return;
        }
        this.allowedChildElements(validatorsNode, VALIDATORS_CHILDREN);
        NodeList validators = this.selectNodeList(validatorsNode, "validator");
        for (int i10 = 0; i10 < validators.getLength(); ++i10) {
            Node validator = validators.item(i10);
            this.validator(validator);
        }
    }

    private void validator(Node validator) {
        NodeList properties;
        this.requiredAttributesOrElements(validator, VALIDATOR_REQ_CHILDREN);
        this.allowedAttributesOrElements(validator, VALIDATOR_CHILDREN);
        ValidatorSettings validatorSettings = new ValidatorSettings();
        String className = this.getAttributeOrChildElement(validator, "class");
        if (className.length() <= 0) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10114, new Object[]{"validator", ""});
            throw ex2;
        }
        validatorSettings.setClassName(className);
        String type = this.getAttributeOrChildElement(validator, "type");
        if (type.length() > 0) {
            validatorSettings.setType(type);
        }
        if ((properties = this.selectNodeList(validator, "properties/*")).getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(validator));
            validatorSettings.addProperties(map);
        }
        ((MessagingConfiguration)this.config).addValidatorSettings(validatorSettings);
    }
}

