/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.PropertiesSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.util.StringUtils;

public class ChannelSettings
extends PropertiesSettings {
    protected String id;
    protected boolean remote;
    protected String serverId;
    private String sourceFile;
    protected SecurityConstraint constraint;
    protected String uri;
    protected int port;
    protected String endpointType;
    protected String clientType;
    protected boolean serverOnly;
    protected String parsedUri;
    protected boolean contextParsed;
    protected String parsedClientUri;
    protected boolean clientContextParsed;

    public ChannelSettings(String id2) {
        this.id = id2;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean value) {
        this.remote = value;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String value) {
        this.serverId = value;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String type) {
        this.clientType = type;
    }

    public boolean getServerOnly() {
        return this.serverOnly;
    }

    public void setServerOnly(boolean serverOnly) {
        this.serverOnly = serverOnly;
    }

    String getSourceFile() {
        return this.sourceFile;
    }

    void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public int getPort() {
        return this.port;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.port = ChannelSettings.parsePort(uri);
        this.port = this.port == -1 ? 0 : this.port;
        this.contextParsed = false;
        this.clientContextParsed = false;
    }

    public String getClientParsedUri(String contextPath) {
        if (!this.clientContextParsed) {
            ChannelSettings.parseClientUri(this, contextPath);
        }
        return this.parsedClientUri;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String type) {
        this.endpointType = type;
    }

    public SecurityConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(SecurityConstraint constraint) {
        this.constraint = constraint;
    }

    private static void parseClientUri(ChannelSettings cs2, String contextPath) {
        if (!cs2.clientContextParsed) {
            String channelEndpoint = cs2.getUri().trim();
            channelEndpoint = StringUtils.substitute(channelEndpoint, "{context-root}", "{context.root}");
            if (contextPath == null && channelEndpoint.indexOf("{context.root}") != -1) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(11120, new Object[]{cs2.getId()});
                throw e10;
            }
            if (contextPath != null && !contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            if (channelEndpoint.indexOf("/{context.root}") != -1) {
                if ("/".equals(contextPath) && !"/{context.root}".equals(channelEndpoint)) {
                    contextPath = "";
                }
                channelEndpoint = StringUtils.substitute(channelEndpoint, "/{context.root}", contextPath);
            } else {
                if ("/".equals(contextPath) && !"{context.root}".equals(channelEndpoint)) {
                    contextPath = "";
                }
                channelEndpoint = StringUtils.substitute(channelEndpoint, "{context.root}", contextPath);
            }
            cs2.parsedClientUri = channelEndpoint;
            cs2.clientContextParsed = true;
        }
    }

    public static String parseHost(String url) {
        int start = url.indexOf(":/");
        if (start == -1) {
            return "";
        }
        int end2 = url.indexOf(47, start += 3);
        String hostnameWithPort = end2 == -1 ? url.substring(start) : url.substring(start, end2);
        int delim = hostnameWithPort.indexOf(93);
        int n10 = delim = delim != -1 ? hostnameWithPort.indexOf(58, delim) : hostnameWithPort.indexOf(58);
        if (delim == -1) {
            return hostnameWithPort;
        }
        return hostnameWithPort.substring(0, delim);
    }

    public static int parsePort(String url) {
        int start = url.indexOf(":/");
        if (start == -1) {
            return 0;
        }
        int end2 = url.indexOf(47, start += 3);
        String snp = end2 == -1 ? url.substring(start) : url.substring(start, end2);
        int delim = snp.indexOf(93);
        int n10 = delim = delim > -1 ? snp.indexOf(58, delim) : snp.indexOf(58);
        if (delim == -1) {
            return 0;
        }
        int port = 0;
        try {
            int p10 = Integer.parseInt(snp.substring(delim + 1));
            port = p10 > 0 ? p10 : 0;
        }
        catch (Throwable t10) {
            port = -1;
        }
        return port;
    }

    public static String removeTokens(String url) {
        int nextSlash;
        String channelEndpoint = url.toLowerCase().trim();
        if ((channelEndpoint.startsWith("http://") || channelEndpoint.startsWith("https://") || channelEndpoint.startsWith("rtmp://") || channelEndpoint.startsWith("rtmps://")) && (nextSlash = channelEndpoint.indexOf(47, 8)) > 0 && nextSlash != channelEndpoint.length() - 1) {
            channelEndpoint = channelEndpoint.substring(nextSlash);
        }
        if ((channelEndpoint = StringUtils.substitute(channelEndpoint, "{context-root}", "{context.root}")).startsWith("{context.root}")) {
            channelEndpoint = channelEndpoint.substring("{context.root}".length());
        } else if (channelEndpoint.startsWith("/{context.root}")) {
            channelEndpoint = channelEndpoint.substring("/{context.root}".length());
        }
        if (channelEndpoint.endsWith("/")) {
            channelEndpoint = channelEndpoint.substring(0, channelEndpoint.length() - 1);
        }
        return channelEndpoint;
    }
}

