/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.messaging.MessageClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.MessageFrequency;
import flex.messaging.services.messaging.ThrottleManager;
import flex.messaging.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OutboundQueueThrottleManager {
    protected final Map<String, DestinationFrequency> destinationFrequencies = new HashMap<String, DestinationFrequency>();
    protected final FlexClientOutboundQueueProcessor processor;

    public OutboundQueueThrottleManager(FlexClientOutboundQueueProcessor processor) {
        this.processor = processor;
    }

    public boolean isDestinationRegistered(String destinationId) {
        return this.destinationFrequencies.containsKey(destinationId);
    }

    public void registerDestination(String destinationId, int outboundMaxClientFrequency, ThrottleSettings.Policy outboundPolicy) {
        DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
        if (frequency == null) {
            frequency = new DestinationFrequency(outboundMaxClientFrequency, outboundPolicy);
            this.destinationFrequencies.put(destinationId, frequency);
        }
    }

    public void unregisterDestination(String destinationId) {
        if (this.isDestinationRegistered(destinationId)) {
            this.destinationFrequencies.remove(destinationId);
        }
    }

    public boolean isSubscriptionRegistered(String destinationId, MessageClient.SubscriptionInfo si2) {
        if (this.isDestinationRegistered(destinationId)) {
            DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
            return frequency != null && frequency.isSubscriptionRegistered(si2);
        }
        return false;
    }

    public void registerSubscription(String destinationId, MessageClient.SubscriptionInfo si2) {
        DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
        frequency.registerSubscription(si2);
    }

    public void unregisterSubscription(String destinationId, MessageClient.SubscriptionInfo si2) {
        if (this.isSubscriptionRegistered(destinationId, si2)) {
            DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
            frequency.unregisterSubscription(si2);
            if (frequency.subscriptionMessageFrequencies.size() == 0) {
                this.unregisterDestination(destinationId);
            }
        }
    }

    public void unregisterAllSubscriptions(String destinationId) {
        if (this.isDestinationRegistered(destinationId)) {
            DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
            frequency.unregisterAllSubscriptions();
            if (frequency.subscriptionMessageFrequencies.size() == 0) {
                this.unregisterDestination(destinationId);
            }
        }
    }

    public ThrottleManager.ThrottleResult throttleOutgoingClientLevel(Message message) {
        String destinationId = message.getDestination();
        if (this.isDestinationRegistered(destinationId)) {
            DestinationFrequency frequency = this.destinationFrequencies.get(message.getDestination());
            int maxFrequency = frequency.getMaxFrequency(message);
            MessageFrequency messageFrequency = frequency.getMessageFrequency(message);
            if (messageFrequency != null) {
                ThrottleManager.ThrottleResult result = messageFrequency.checkLimit(maxFrequency, frequency.outboundPolicy);
                return result;
            }
        }
        return new ThrottleManager.ThrottleResult();
    }

    public void updateMessageFrequencyOutgoingClientLevel(Message message) {
        DestinationFrequency frequency;
        MessageFrequency messageFrequency;
        String destinationId = message.getDestination();
        if (this.isDestinationRegistered(destinationId) && (messageFrequency = (frequency = this.destinationFrequencies.get(message.getDestination())).getMessageFrequency(message)) != null) {
            messageFrequency.updateMessageFrequency();
        }
    }

    static class SubscriptionMessageFrequency {
        protected final MessageClient.SubscriptionInfo si;
        protected final MessageFrequency mf;

        public SubscriptionMessageFrequency(MessageClient.SubscriptionInfo si2, MessageFrequency mf2) {
            this.si = si2;
            this.mf = mf2;
        }
    }

    class DestinationFrequency {
        protected final int outboundMaxClientFrequency;
        protected final ThrottleSettings.Policy outboundPolicy;
        protected final List<SubscriptionMessageFrequency> subscriptionMessageFrequencies = new ArrayList<SubscriptionMessageFrequency>();

        DestinationFrequency(int outboundMaxClientFrequency, ThrottleSettings.Policy outboundPolicy) {
            this.outboundMaxClientFrequency = outboundMaxClientFrequency;
            this.outboundPolicy = outboundPolicy;
        }

        int getMaxFrequency(Message message) {
            return this.outboundMaxClientFrequency;
        }

        MessageFrequency getMessageFrequency(Message message) {
            String subtopic = (String)message.getHeader("DSSubtopic");
            String selector = (String)message.getHeader("DSSelector");
            MessageClient.SubscriptionInfo si2 = new MessageClient.SubscriptionInfo(selector, subtopic);
            if (this.isSubscriptionRegistered(si2)) {
                for (SubscriptionMessageFrequency frequency : this.subscriptionMessageFrequencies) {
                    if (!frequency.si.equals(si2)) continue;
                    return frequency.mf;
                }
            }
            return null;
        }

        boolean isSubscriptionRegistered(MessageClient.SubscriptionInfo si2) {
            if (this.subscriptionMessageFrequencies != null) {
                for (SubscriptionMessageFrequency info : this.subscriptionMessageFrequencies) {
                    if (!info.si.equals(si2)) continue;
                    return true;
                }
            }
            return false;
        }

        void registerSubscription(MessageClient.SubscriptionInfo si2) {
            SubscriptionMessageFrequency frequency = new SubscriptionMessageFrequency(si2, new MessageFrequency(this.outboundMaxClientFrequency));
            this.subscriptionMessageFrequencies.add(frequency);
            this.logMaxFrequencyDuringRegistration(this.outboundMaxClientFrequency, si2);
        }

        void logMaxFrequencyDuringRegistration(int maxFrequency, MessageClient.SubscriptionInfo si2) {
            if (Log.isDebug()) {
                Log.getLogger("Transport.Throttle").debug("Outbound queue throttle manager for FlexClient '" + OutboundQueueThrottleManager.this.processor.getFlexClient().getId() + "' is using '" + maxFrequency + "' as the throttling limit for its subscription: " + StringUtils.NEWLINE + si2);
            }
        }

        void unregisterSubscription(MessageClient.SubscriptionInfo si2) {
            if (this.isSubscriptionRegistered(si2)) {
                this.subscriptionMessageFrequencies.remove(si2);
                if (this.subscriptionMessageFrequencies.size() == 0) {
                    this.unregisterAllSubscriptions();
                }
            }
        }

        void unregisterAllSubscriptions() {
            this.subscriptionMessageFrequencies.clear();
        }
    }
}

