/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.client.FlexClientManagerControl;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.TimeoutManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;

public class FlexClientManager
extends ManageableComponent {
    public static final String TYPE = "FlexClientManager";
    private final MessageBroker broker;
    private FlexClientManagerControl controller;
    private final Map<String, FlexClient> flexClients = new ConcurrentHashMap<String, FlexClient>();
    private volatile TimeoutManager flexClientTimeoutManager;
    private volatile long flexClientTimeoutMillis;

    public FlexClientManager() {
        this(MessageBroker.getMessageBroker(null));
    }

    public FlexClientManager(MessageBroker broker) {
        this(broker.isManaged(), broker);
    }

    public FlexClientManager(boolean enableManagement, MessageBroker mbroker) {
        super(enableManagement);
        super.setId(TYPE);
        this.broker = mbroker != null ? mbroker : MessageBroker.getMessageBroker(null);
        FlexClientSettings flexClientSettings = this.broker.getFlexClientSettings();
        if (flexClientSettings != null && flexClientSettings.getTimeoutMinutes() != -1L) {
            this.setFlexClientTimeoutMillis(flexClientSettings.getTimeoutMinutes() * 60L * 1000L);
        }
        this.setParent(this.broker);
    }

    public String[] getClientIds() {
        String[] ids = new String[this.flexClients.size()];
        ArrayList<String> idList = new ArrayList<String>(this.flexClients.keySet());
        for (int i10 = 0; i10 < this.flexClients.size(); ++i10) {
            ids[i10] = idList.get(i10);
        }
        return ids;
    }

    public int getFlexClientCount() {
        return this.flexClients.size();
    }

    public long getFlexClientTimeoutMillis() {
        return this.flexClientTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlexClientTimeoutMillis(long value) {
        if (value < 1L) {
            value = 0L;
        }
        FlexClientManager flexClientManager = this;
        synchronized (flexClientManager) {
            this.flexClientTimeoutMillis = value;
        }
    }

    public MessageBroker getMessageBroker() {
        return this.broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexClient getFlexClient(String id2) {
        FlexClient flexClient = null;
        if (id2 != null && (flexClient = this.flexClients.get(id2)) != null) {
            if (flexClient.isValid() && !flexClient.invalidating) {
                flexClient.updateLastUse();
                return flexClient;
            }
            this.flexClients.remove(id2);
        }
        FlexClientManager flexClientManager = this;
        synchronized (flexClientManager) {
            if (id2 != null && (flexClient = this.flexClients.get(id2)) != null) {
                flexClient.updateLastUse();
                return flexClient;
            }
            flexClient = this.createFlexClient(id2);
            this.flexClients.put(flexClient.getId(), flexClient);
            if (this.flexClientTimeoutMillis > 0L) {
                this.flexClientTimeoutManager.scheduleTimeout(flexClient);
            }
            flexClient.notifyCreated();
            return flexClient;
        }
    }

    public FlexClientOutboundQueueProcessor createOutboundQueueProcessor(FlexClient flexClient, String endpointId) {
        FlexClientOutboundQueueProcessor processor = this.createCustomOutboundQueueProcessor(flexClient, endpointId);
        if (processor == null) {
            processor = this.createDefaultOutboundQueueProcessor(flexClient, endpointId);
        }
        if (processor == null) {
            processor = new FlexClientOutboundQueueProcessor();
            processor.setFlexClient(flexClient);
            processor.setEndpointId(endpointId);
        }
        return processor;
    }

    public void monitorAsyncPollTimeout(TimeoutAbstractObject asyncPollTimeout) {
        this.flexClientTimeoutManager.scheduleTimeout(asyncPollTimeout);
    }

    public void monitorScheduledFlush(TimeoutAbstractObject scheduledFlushTimeout) {
        this.flexClientTimeoutManager.scheduleTimeout(scheduledFlushTimeout);
    }

    public void start() {
        if (this.isManaged()) {
            this.controller = new FlexClientManagerControl(this.getParent().getControl(), this);
            this.setControl(this.controller);
            this.controller.register();
        }
        final String baseId = this.getId();
        this.flexClientTimeoutManager = new TimeoutManager(new ThreadFactory(){
            int counter = 1;

            public synchronized Thread newThread(Runnable runnable) {
                Thread t10 = new Thread(runnable);
                t10.setName(baseId + "-FlexClientTimeoutThread-" + this.counter++);
                return t10;
            }
        });
    }

    public void stop() {
        if (this.controller != null) {
            this.controller.unregister();
        }
        if (this.flexClientTimeoutManager != null) {
            this.flexClientTimeoutManager.shutdown();
        }
    }

    protected FlexClient createFlexClient(String id2) {
        return id2 == null ? new FlexClient(this) : new FlexClient(this, id2);
    }

    protected String getLogCategory() {
        return "Client.FlexClient";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFlexClient(FlexClient flexClient) {
        if (flexClient != null) {
            String id2;
            String string = id2 = flexClient.getId();
            synchronized (string) {
                FlexClient storedClient = this.flexClients.get(id2);
                if (storedClient == flexClient) {
                    this.flexClients.remove(id2);
                }
            }
        }
    }

    private FlexClientOutboundQueueProcessor createDefaultOutboundQueueProcessor(FlexClient flexClient, String endpointId) {
        String queueProcessorClassName;
        FlexClientOutboundQueueProcessor processor = null;
        FlexClientSettings flexClientSettings = this.broker.getFlexClientSettings();
        if (flexClientSettings != null && (queueProcessorClassName = flexClientSettings.getFlexClientOutboundQueueProcessorClassName()) != null) {
            try {
                Class queueProcessorClass = this.createClass(queueProcessorClassName);
                Object instance = ClassUtil.createDefaultInstance(queueProcessorClass, null);
                processor = (FlexClientOutboundQueueProcessor)instance;
                processor.setFlexClient(flexClient);
                processor.setEndpointId(endpointId);
                processor.initialize(flexClientSettings.getFlexClientOutboundQueueProcessorProperties());
            }
            catch (Throwable t10) {
                String message = "Failed to create MessageBroker's outbound queue processor for FlexClient with id '" + flexClient.getId() + "'.";
                if (Log.isWarn()) {
                    Log.getLogger("Client.FlexClient").warn(message, t10);
                }
                MessageException me2 = new MessageException(message, t10);
                throw me2;
            }
        }
        return processor;
    }

    private FlexClientOutboundQueueProcessor createCustomOutboundQueueProcessor(FlexClient flexClient, String endpointId) {
        FlexClientOutboundQueueProcessor processor;
        block4: {
            Class<?> processorClass;
            processor = null;
            Endpoint endpoint = this.broker.getEndpoint(endpointId);
            if (endpoint instanceof AbstractEndpoint && (processorClass = ((AbstractEndpoint)endpoint).getFlexClientOutboundQueueProcessorClass()) != null) {
                try {
                    Object instance = ClassUtil.createDefaultInstance(processorClass, null);
                    if (instance instanceof FlexClientOutboundQueueProcessor) {
                        processor = (FlexClientOutboundQueueProcessor)instance;
                        processor.setFlexClient(flexClient);
                        processor.setEndpointId(endpointId);
                        processor.initialize(((AbstractEndpoint)endpoint).getFlexClientOutboundQueueProcessorConfig());
                    }
                }
                catch (Throwable t10) {
                    if (!Log.isWarn()) break block4;
                    Log.getLogger("Client.FlexClient").warn("Failed to create custom outbound queue processor for FlexClient with id '" + flexClient.getId() + "'. Using MessageBroker's default queue processor.", t10);
                }
            }
        }
        return processor;
    }

    private Class createClass(String className) {
        Class c10 = ClassUtil.createClass(className, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
        return c10;
    }
}

