/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageClientListener;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.client.OutboundQueueThrottleManager;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.MessageService;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutAbstractObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class MessageClient
extends TimeoutAbstractObject
implements Serializable {
    public static final String MESSAGE_CLIENT_LOG_CATEGORY = "Client.MessageClient";
    static final long serialVersionUID = 3730240451524954453L;
    private static final CopyOnWriteArrayList<MessageClientListener> createdListeners = new CopyOnWriteArrayList();
    private volatile boolean clientChannelDisconnected;
    protected final Object clientId;
    protected final Destination destination;
    protected final String destinationId;
    private volatile transient CopyOnWriteArrayList destroyedListeners;
    private String endpointId;
    private final transient FlexClient flexClient;
    private transient FlexSession flexSession;
    private boolean invalidating;
    protected Object lock = new Object();
    private volatile boolean attemptingInvalidationClientNotification;
    private transient int numReferences;
    protected final Set subscriptions = new CopyOnWriteArraySet();
    protected boolean valid = true;
    private volatile boolean willTimeout;
    private volatile boolean registered = false;

    public static void addMessageClientCreatedListener(MessageClientListener listener) {
        if (listener != null) {
            createdListeners.addIfAbsent(listener);
        }
    }

    public static void removeMessageClientCreatedListener(MessageClientListener listener) {
        if (listener != null) {
            createdListeners.remove(listener);
        }
    }

    private static boolean equalStrings(String a10, String b10) {
        return a10 == b10 || a10 != null && a10.equals(b10);
    }

    static int compareStrings(String a10, String b10) {
        if (a10 == b10) {
            return 0;
        }
        if (a10 != null && b10 != null) {
            return a10.compareTo(b10);
        }
        if (a10 == null) {
            return -1;
        }
        return 1;
    }

    public MessageClient(Object clientId, Destination destination, String endpointId) {
        this(clientId, destination, endpointId, true);
    }

    public MessageClient(Object clientId, Destination destination, String endpointId, boolean useSession) {
        this.clientId = clientId;
        this.destination = destination;
        this.endpointId = endpointId;
        this.destinationId = destination.getId();
        this.updateLastUse();
        if (useSession) {
            this.flexSession = FlexContext.getFlexSession();
            this.flexSession.registerMessageClient(this);
            this.flexClient = FlexContext.getFlexClient();
            this.flexClient.registerMessageClient(this);
        } else {
            this.flexClient = null;
            this.flexSession = null;
            this.lock = new Object();
        }
        if (Log.isDebug()) {
            Log.getLogger(MESSAGE_CLIENT_LOG_CATEGORY).debug("MessageClient created with clientId '" + this.clientId + "' for destination '" + this.destinationId + "'.");
        }
    }

    public Object getClientId() {
        return this.clientId;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public FlexClient getFlexClient() {
        return this.flexClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexSession getFlexSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.flexSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubscriptionCount() {
        int count;
        Object object = this.lock;
        synchronized (object) {
            count = this.subscriptions != null ? this.subscriptions.size() : 0;
        }
        return count;
    }

    public boolean isAttemptingInvalidationClientNotification() {
        return this.attemptingInvalidationClientNotification;
    }

    public void setClientChannelDisconnected(boolean value) {
        this.clientChannelDisconnected = value;
    }

    public boolean isClientChannelDisconnected() {
        return this.clientChannelDisconnected;
    }

    public void setRegistered(boolean reg) {
        this.registered = reg;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageClientDestroyedListener(MessageClientListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.destroyedListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.destroyedListeners == null) {
                        this.destroyedListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.destroyedListeners.addIfAbsent(listener);
        }
    }

    public void removeMessageClientDestroyedListener(MessageClientListener listener) {
        if (listener != null && this.destroyedListeners != null) {
            this.destroyedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(String selector, String subtopic, int maxFrequency) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.incrementReferences();
            SubscriptionInfo si2 = new SubscriptionInfo(selector, subtopic, maxFrequency);
            this.subscriptions.add(si2);
            this.registerSubscriptionWithThrottleManager(si2);
        }
    }

    public void registerSubscriptionWithThrottleManager(SubscriptionInfo si2) {
        OutboundQueueThrottleManager throttleManager;
        ThrottleSettings ts2 = this.destination.getNetworkSettings().getThrottleSettings();
        if (ts2.getOutboundPolicy() != ThrottleSettings.Policy.NONE && (ts2.isOutboundClientThrottleEnabled() || si2.maxFrequency > 0)) {
            throttleManager = this.getThrottleManager(true);
            if (throttleManager != null && !throttleManager.isDestinationRegistered(this.destinationId)) {
                throttleManager.registerDestination(this.destinationId, ts2.getOutgoingClientFrequency(), ts2.getOutboundPolicy());
            }
        } else if (si2.maxFrequency > 0 && Log.isWarn()) {
            Log.getLogger(MESSAGE_CLIENT_LOG_CATEGORY).warn("MessageClient with clientId '" + this.clientId + "' for destination '" + this.destinationId + "' specified a maxFrequency value of '" + si2.maxFrequency + "' but the destination does not define a throttling policy. This value will be ignored.");
        }
        throttleManager = this.getThrottleManager(false);
        if (throttleManager != null && !throttleManager.isSubscriptionRegistered(this.destinationId, si2)) {
            throttleManager.registerSubscription(this.destinationId, si2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscription(String selector, String subtopic) {
        Object object = this.lock;
        synchronized (object) {
            SubscriptionInfo si2 = new SubscriptionInfo(selector, subtopic);
            if (this.subscriptions.remove(si2)) {
                this.unregisterSubscriptionWithThrottleManager(si2);
                return this.decrementReferences();
            }
            if (Log.isError()) {
                Log.getLogger("Service.Message").error("Error - unable to find subscription to remove for MessageClient: " + this.clientId + " selector: " + selector + " subtopic: " + subtopic);
            }
            return this.numReferences == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReferences() {
        Object object = this.lock;
        synchronized (object) {
            ++this.numReferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrementReferences() {
        Object object = this.lock;
        synchronized (object) {
            if (--this.numReferences == 0) {
                MessageDestination msgDestination;
                this.cancelTimeout();
                if (this.destination instanceof MessageDestination && (msgDestination = (MessageDestination)this.destination).getThrottleManager() != null) {
                    msgDestination.getThrottleManager().removeClientThrottleMark(this.clientId);
                }
                return true;
            }
            return false;
        }
    }

    public void notifyCreatedListeners() {
        if (!createdListeners.isEmpty()) {
            Iterator<MessageClientListener> iter = createdListeners.iterator();
            while (iter.hasNext()) {
                iter.next().messageClientCreated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEndpoint(String newEndpointId) {
        String oldEndpointId = null;
        FlexSession oldSession = null;
        FlexSession newSession = FlexContext.getFlexSession();
        Object object = this.lock;
        synchronized (object) {
            if (this.endpointId == null || newEndpointId == null || this.flexSession == null || newSession == null || this.endpointId.equals(newEndpointId) && this.flexSession.equals(newSession)) {
                return;
            }
            oldEndpointId = this.endpointId;
            this.endpointId = newEndpointId;
            oldSession = this.flexSession;
            this.flexSession = newSession;
        }
        if (this.flexClient != null) {
            this.flexClient.unregisterMessageClient(this);
        }
        if (oldSession != null) {
            oldSession.unregisterMessageClient(this);
        }
        if (this.flexSession != null) {
            this.flexSession.registerMessageClient(this);
        }
        if (this.flexClient != null) {
            this.flexClient.registerMessageClient(this);
        }
        if (Log.isDebug()) {
            String msg = "MessageClient with clientId '" + this.clientId + "' for destination '" + this.destinationId + "' has been reset as a result of a resubscribe.";
            if (oldEndpointId != null && !oldEndpointId.equals(newEndpointId)) {
                msg = msg + " Endpoint change [" + oldEndpointId + " -> " + newEndpointId + "]";
            }
            if (oldSession != null && newSession != null && oldSession != newSession) {
                msg = msg + " FlexSession change [" + oldSession.getClass().getName() + ":" + oldSession.getId() + " -> " + newSession.getClass().getName() + ":" + newSession.getId() + "]";
            }
            Log.getLogger(MESSAGE_CLIENT_LOG_CATEGORY).debug(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testMessage(Message message, MessageDestination destination) {
        String subtopic = (String)message.getHeader("DSSubtopic");
        Object object = this.lock;
        synchronized (object) {
            for (SubscriptionInfo si2 : this.subscriptions) {
                Subtopic messageSubtopic;
                String subtopicSeparator;
                Subtopic consumerSubtopic;
                String csel = si2.selector;
                String csub = si2.subtopic;
                if (subtopic == null && csub != null || subtopic != null && csub == null || subtopic != null && csub != null && !(consumerSubtopic = new Subtopic(csub, subtopicSeparator = destination.getServerSettings().getSubtopicSeparator())).matches(messageSubtopic = new Subtopic(subtopic, subtopicSeparator))) continue;
                if (csel == null) {
                    return true;
                }
                JMSSelector selector = new JMSSelector(csel);
                try {
                    if (!selector.match(message)) continue;
                    return true;
                }
                catch (JMSSelectorException jmse) {
                    if (Log.isWarn()) {
                        Log.getLogger("Message.Selector").warn("Error processing message selector: " + jmse.toString() + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE + "  selector: " + csel + StringUtils.NEWLINE);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean notifyClient) {
        TreeSet<Object> subscriberIds;
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid || this.invalidating) {
                return;
            }
            this.invalidating = true;
            this.cancelTimeout();
        }
        this.attemptingInvalidationClientNotification = notifyClient;
        if (notifyClient && this.flexClient != null && this.flexClient.isValid()) {
            CommandMessage msg = new CommandMessage();
            msg.setDestination(this.destination.getId());
            msg.setClientId(this.clientId);
            msg.setOperation(10);
            subscriberIds = new TreeSet<Object>();
            subscriberIds.add(this.clientId);
            try {
                if (this.destination instanceof MessageDestination) {
                    MessageDestination msgDestination = (MessageDestination)this.destination;
                    ((MessageService)msgDestination.getService()).pushMessageToClients(msgDestination, subscriberIds, msg, false);
                }
            }
            catch (MessageException ignore) {
                // empty catch block
            }
        }
        if (this.destroyedListeners != null && !this.destroyedListeners.isEmpty()) {
            Iterator iter = this.destroyedListeners.iterator();
            while (iter.hasNext()) {
                ((MessageClientListener)iter.next()).messageClientDestroyed(this);
            }
            this.destroyedListeners.clear();
        }
        ArrayList<CommandMessage> unsubMessages = new ArrayList<CommandMessage>();
        subscriberIds = this.lock;
        synchronized (subscriberIds) {
            for (SubscriptionInfo subInfo : this.subscriptions) {
                CommandMessage unsubMessage = new CommandMessage();
                unsubMessage.setDestination(this.destination.getId());
                unsubMessage.setClientId(this.clientId);
                unsubMessage.setOperation(1);
                unsubMessage.setHeader("DSSubscriptionInvalidated", Boolean.TRUE);
                unsubMessage.setHeader("DSSelector", subInfo.selector);
                unsubMessage.setHeader("DSSubtopic", subInfo.subtopic);
                unsubMessages.add(unsubMessage);
            }
        }
        Iterator iter = unsubMessages.iterator();
        while (iter.hasNext()) {
            try {
                this.destination.getService().serviceCommand((CommandMessage)iter.next());
            }
            catch (MessageException me2) {
                if (!Log.isDebug()) continue;
                Log.getLogger(MESSAGE_CLIENT_LOG_CATEGORY).debug("MessageClient: " + this.getClientId() + " issued an unsubscribe message during invalidation that was not processed but will continue with invalidation. Reason: " + ExceptionUtil.toString(me2));
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            int remainingSubscriptionCount = this.subscriptions.size();
            if (remainingSubscriptionCount > 0 && Log.isError()) {
                Log.getLogger(MESSAGE_CLIENT_LOG_CATEGORY).error("MessageClient: " + this.getClientId() + " failed to remove " + remainingSubscriptionCount + " subscription(s) during invalidation");
            }
        }
        if (this.registered && this.destination instanceof MessageDestination) {
            ((MessageDestination)this.destination).getSubscriptionManager().releaseMessageClient(this);
        }
        object2 = this.lock;
        synchronized (object2) {
            this.valid = false;
            this.invalidating = false;
        }
        if (Log.isDebug()) {
            Log.getLogger(MESSAGE_CLIENT_LOG_CATEGORY).debug("MessageClient with clientId '" + this.clientId + "' for destination '" + this.destinationId + "' has been invalidated.");
        }
    }

    public void invalidate(Message message) {
        if (message != null) {
            message.setDestination(this.destination.getId());
            message.setClientId(this.clientId);
            TreeSet<Object> subscriberIds = new TreeSet<Object>();
            subscriberIds.add(this.clientId);
            try {
                if (this.destination instanceof MessageDestination) {
                    MessageDestination msgDestination = (MessageDestination)this.destination;
                    ((MessageService)msgDestination.getService()).pushMessageToClients(msgDestination, subscriberIds, message, false);
                }
            }
            catch (MessageException messageException) {
                // empty catch block
            }
            this.invalidate(true);
        } else {
            this.invalidate();
        }
    }

    public boolean equals(Object o10) {
        MessageClient c10;
        return o10 instanceof MessageClient && (c10 = (MessageClient)o10) != null && c10.getClientId().equals(this.clientId);
    }

    public int hashCode() {
        return this.getClientId().hashCode();
    }

    public String toString() {
        return String.valueOf(this.clientId);
    }

    public long getTimeoutPeriod() {
        return this.destination instanceof MessageDestination ? ((MessageDestination)this.destination).getSubscriptionManager().getSubscriptionTimeoutMillis() : 0L;
    }

    public void timeout() {
        this.invalidate(true);
    }

    public boolean isTimingOut() {
        return this.willTimeout;
    }

    public void setTimingOut(boolean value) {
        this.willTimeout = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValid() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                throw new RuntimeException("MessageClient has been invalidated.");
            }
        }
    }

    private OutboundQueueThrottleManager getThrottleManager(boolean create) {
        FlexClientOutboundQueueProcessor processor;
        if (this.flexClient != null && (processor = this.flexClient.getOutboundQueueProcessor(this.endpointId)) != null) {
            return create ? processor.getOrCreateOutboundQueueThrottleManager() : processor.getOutboundQueueThrottleManager();
        }
        return null;
    }

    private void unregisterSubscriptionWithThrottleManager(SubscriptionInfo si2) {
        OutboundQueueThrottleManager throttleManager = this.getThrottleManager(false);
        if (throttleManager != null && throttleManager.isSubscriptionRegistered(this.destinationId, si2)) {
            throttleManager.unregisterSubscription(this.destinationId, si2);
        }
    }

    public static class SubscriptionInfo
    implements Comparable {
        public String selector;
        public String subtopic;
        public int maxFrequency;

        public SubscriptionInfo(String sel, String sub2) {
            this(sel, sub2, 0);
        }

        public SubscriptionInfo(String sel, String sub2, int maxFrequency) {
            this.selector = sel;
            this.subtopic = sub2;
            this.maxFrequency = maxFrequency;
        }

        public boolean equals(Object o10) {
            if (o10 instanceof SubscriptionInfo) {
                SubscriptionInfo other = (SubscriptionInfo)o10;
                return MessageClient.equalStrings(other.selector, this.selector) && MessageClient.equalStrings(other.subtopic, this.subtopic);
            }
            return false;
        }

        public int hashCode() {
            return (this.selector == null ? 0 : this.selector.hashCode()) + (this.subtopic == null ? 1 : this.subtopic.hashCode());
        }

        public int compareTo(Object o10) {
            SubscriptionInfo other = (SubscriptionInfo)o10;
            int result = MessageClient.compareStrings(other.selector, this.selector);
            if (result != 0) {
                return result;
            }
            result = MessageClient.compareStrings(other.subtopic, this.subtopic);
            if (result != 0) {
                return result;
            }
            return 0;
        }

        public String toString() {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("Subtopic: " + this.subtopic + StringUtils.NEWLINE);
            sb2.append("Selector: " + this.selector + StringUtils.NEWLINE);
            if (this.maxFrequency > 0) {
                sb2.append("maxFrequency: " + this.maxFrequency);
            }
            return sb2.toString();
        }
    }
}

