/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;

public class BooleanEncodedValue
extends EncodedValue {
    public static final BooleanEncodedValue TrueValue = new BooleanEncodedValue(true);
    public static final BooleanEncodedValue FalseValue = new BooleanEncodedValue(false);
    public final boolean value;

    private BooleanEncodedValue(boolean value) {
        this.value = value;
    }

    protected static BooleanEncodedValue getBooleanEncodedValue(byte valueArg) {
        if (valueArg == 0) {
            return FalseValue;
        }
        if (valueArg == 1) {
            return TrueValue;
        }
        throw new RuntimeException("valueArg must be either 0 or 1");
    }

    public void writeValue(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate("value_type=" + ValueType.VALUE_BOOLEAN.name() + ",value=" + Boolean.toString(this.value));
        }
        out.writeByte(ValueType.VALUE_BOOLEAN.value | (this.value ? 1 : 0) << 5);
    }

    public int placeValue(int offset) {
        return offset + 1;
    }

    protected int compareValue(EncodedValue o) {
        BooleanEncodedValue other = (BooleanEncodedValue)o;
        if (this.value == other.value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public ValueType getValueType() {
        return ValueType.VALUE_BOOLEAN;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }
}

