/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction35ms
extends Instruction
implements FiveRegisterInstruction,
OdexedInvokeVirtual {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private byte regA;
    private byte regD;
    private byte regE;
    private byte regF;
    private byte regG;
    private short methodIndex;

    private Instruction35ms(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regCount = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regD = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 4]);
        this.regE = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 4]);
        this.regF = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 5]);
        this.regG = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 5]);
        this.methodIndex = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regCount << 4 | this.regA);
        out.writeShort(this.methodIndex);
        out.writeByte(this.regE << 4 | this.regD);
        out.writeByte(this.regG << 4 | this.regF);
    }

    public Format getFormat() {
        return Format.Format35ms;
    }

    public byte getRegCount() {
        return this.regCount;
    }

    public byte getRegisterA() {
        return this.regA;
    }

    public byte getRegisterD() {
        return this.regD;
    }

    public byte getRegisterE() {
        return this.regE;
    }

    public byte getRegisterF() {
        return this.regF;
    }

    public byte getRegisterG() {
        return this.regG;
    }

    public int getMethodIndex() {
        return this.methodIndex & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction35ms(opcode, buffer, bufferIndex);
        }
    }
}

