/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.res.util.ExtFile;
import brut.androlib.src.DebugInjector;
import brut.androlib.src.DexFileBuilder;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class SmaliBuilder {
    private final ExtFile mSmaliDir;
    private final File mDexFile;
    private final boolean mDebug;
    private DexFileBuilder mDexBuilder;
    private static final Logger LOGGER = Logger.getLogger(SmaliBuilder.class.getName());

    public static void build(ExtFile smaliDir, File dexFile, boolean debug) throws AndrolibException {
        new SmaliBuilder(smaliDir, dexFile, debug).build();
    }

    private SmaliBuilder(ExtFile smaliDir, File dexFile, boolean debug) {
        this.mSmaliDir = smaliDir;
        this.mDexFile = dexFile;
        this.mDebug = debug;
    }

    private void build() throws AndrolibException {
        try {
            this.mDexBuilder = new DexFileBuilder();
            for (String fileName : this.mSmaliDir.getDirectory().getFiles(true)) {
                this.buildFile(fileName);
            }
            this.mDexBuilder.writeTo(this.mDexFile);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildFile(String fileName) throws AndrolibException, IOException {
        File inFile = new File(this.mSmaliDir, fileName);
        FileInputStream inStream = new FileInputStream(inFile);
        if (fileName.endsWith(".smali")) {
            this.mDexBuilder.addSmaliFile(inFile);
            return;
        }
        if (!fileName.endsWith(".java")) {
            LOGGER.warning("Unknown file type, ignoring: " + inFile);
            return;
        }
        StringBuilder out = new StringBuilder();
        List lines = IOUtils.readLines(inStream);
        if (!this.mDebug) {
            String[] linesArray = lines.toArray(new String[0]);
            for (int i = 2; i < linesArray.length - 2; ++i) {
                out.append(linesArray[i]).append('\n');
            }
        } else {
            lines.remove(lines.size() - 1);
            lines.remove(lines.size() - 1);
            ListIterator<String> it = lines.listIterator(2);
            out.append(".source \"").append(inFile.getName()).append("\"\n");
            while (it.hasNext()) {
                String line = ((String)it.next()).trim();
                if (line.isEmpty() || line.charAt(0) == '#' || line.startsWith(".source")) continue;
                if (line.startsWith(".method ")) {
                    it.previous();
                    DebugInjector.inject(it, out);
                    continue;
                }
                out.append(line).append('\n');
            }
        }
        this.mDexBuilder.addSmaliFile(IOUtils.toInputStream(out.toString()), fileName);
    }
}

