/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.androlib.res.util.ExtXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.XmlSerializerWrapper;

public class XmlPullStreamDecoder
implements ResStreamDecoder {
    private final XmlPullParser mParser;
    private final ExtXmlSerializer mSerial;

    public XmlPullStreamDecoder(XmlPullParser parser, ExtXmlSerializer serializer) {
        this.mParser = parser;
        this.mSerial = serializer;
    }

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            XmlPullWrapperFactory factory = XmlPullWrapperFactory.newInstance();
            XmlPullParserWrapper par = factory.newPullParserWrapper(this.mParser);
            XmlSerializerWrapper ser = factory.newSerializerWrapper(this.mSerial);
            par.setInput(in, null);
            ser.setOutput(out, null);
            while (par.nextToken() != 1) {
                ser.event(par);
            }
            this.mSerial.newLine();
            ser.flush();
        }
        catch (XmlPullParserException ex) {
            throw new AndrolibException("Could not decode XML", ex);
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode XML", ex);
        }
    }
}

