/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.err.InFileNotFoundException;
import brut.androlib.err.OutDirExistsException;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.util.OS;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ApkDecoder {
    private final Androlib mAndrolib;
    private ExtFile mApkFile;
    private File mOutDir;
    private ResTable mResTable;
    private short mDecodeSources = 1;
    private short mDecodeResources = (short)257;
    private boolean mDebug = false;
    private boolean mForceDelete = false;
    private String mFrameTag;
    private boolean mKeepBrokenResources = false;

    public ApkDecoder() {
        this(new Androlib());
    }

    public ApkDecoder(Androlib androlib) {
        this.mAndrolib = androlib;
    }

    public void setApkFile(File apkFile) {
        this.mApkFile = new ExtFile(apkFile);
        this.mResTable = null;
    }

    public void setOutDir(File outDir) throws AndrolibException {
        this.mOutDir = outDir;
    }

    public void decode() throws AndrolibException {
        File outDir = this.getOutDir();
        if (!this.mForceDelete && outDir.exists()) {
            throw new OutDirExistsException();
        }
        if (!this.mApkFile.isFile() || !this.mApkFile.canRead()) {
            throw new InFileNotFoundException();
        }
        try {
            OS.rmdir(outDir);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
        outDir.mkdirs();
        if (this.hasSources()) {
            switch (this.mDecodeSources) {
                case 0: {
                    this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, this.mDebug);
                    break;
                }
                case 1: {
                    this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, this.mDebug);
                    break;
                }
                case 2: {
                    this.mAndrolib.decodeSourcesJava(this.mApkFile, outDir, this.mDebug);
                }
            }
        }
        if (this.hasResources()) {
            switch (this.mDecodeResources) {
                case 256: {
                    this.mAndrolib.decodeResourcesRaw(this.mApkFile, outDir);
                    break;
                }
                case 257: {
                    this.mAndrolib.decodeResourcesFull(this.mApkFile, outDir, this.getResTable());
                }
            }
        }
        this.mAndrolib.decodeRawFiles(this.mApkFile, outDir);
        this.writeMetaFile();
    }

    public void setDecodeSources(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new AndrolibException("Invalid decode sources mode: " + mode);
        }
        this.mDecodeSources = mode;
    }

    public void setDecodeResources(short mode) throws AndrolibException {
        if (mode != 256 && mode != 257) {
            throw new AndrolibException("Invalid decode resources mode");
        }
        this.mDecodeResources = mode;
    }

    public void setDebugMode(boolean debug) {
        this.mDebug = debug;
    }

    public void setForceDelete(boolean forceDelete) {
        this.mForceDelete = forceDelete;
    }

    public void setFrameworkTag(String tag) throws AndrolibException {
        this.mFrameTag = tag;
        if (this.mResTable != null) {
            this.getResTable().setFrameTag(tag);
        }
    }

    public void setKeepBrokenResources(boolean keepBrokenResources) {
        this.mKeepBrokenResources = keepBrokenResources;
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            if (!this.hasResources()) {
                throw new AndrolibException("Apk doesn't containt resources.arsc file");
            }
            AndrolibResources.sKeepBroken = this.mKeepBrokenResources;
            this.mResTable = this.mAndrolib.getResTable(this.mApkFile);
            this.mResTable.setFrameTag(this.mFrameTag);
        }
        return this.mResTable;
    }

    public boolean hasSources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private File getOutDir() throws AndrolibException {
        if (this.mOutDir == null) {
            throw new AndrolibException("Out dir not set");
        }
        return this.mOutDir;
    }

    private void writeMetaFile() throws AndrolibException {
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        meta.put("version", Androlib.getVersion());
        meta.put("apkFileName", this.mApkFile.getName());
        if (this.hasResources()) {
            meta.put("isFrameworkApk", this.mAndrolib.isFrameworkApk(this.getResTable()));
            this.putUsesFramework(meta);
        }
        this.mAndrolib.writeMetaFile(this.mOutDir, meta);
    }

    private void putUsesFramework(Map<String, Object> meta) throws AndrolibException {
        Set<ResPackage> pkgs = this.getResTable().listFramePackages();
        if (pkgs.isEmpty()) {
            return;
        }
        Object[] ids = new Integer[pkgs.size()];
        int i = 0;
        for (ResPackage pkg : pkgs) {
            ids[i++] = pkg.getId();
        }
        Arrays.sort(ids);
        LinkedHashMap<String, Object> uses = new LinkedHashMap<String, Object>();
        uses.put("ids", ids);
        if (this.mFrameTag != null) {
            uses.put("tag", this.mFrameTag);
        }
        meta.put("usesFramework", uses);
    }
}

