/*
 * Decompiled with CFR 0.152.
 */
package com.saikoa.dexguard.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Mojo(name="help", requiresProject=false, threadSafe=true)
public class HelpMojo
extends AbstractMojo {
    @Parameter(property="detail", defaultValue="false")
    private boolean detail;
    @Parameter(property="goal")
    private String goal;
    @Parameter(property="lineLength", defaultValue="80")
    private int lineLength;
    @Parameter(property="indentSize", defaultValue="2")
    private int indentSize;

    private Document a() {
        this.getLog().debug((CharSequence)"load plugin-help.xml: /META-INF/maven/plugin.xml");
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            return document;
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MojoExecutionException(parserConfigurationException.getMessage(), (Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new MojoExecutionException(sAXException.getMessage(), (Exception)sAXException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
                }
            }
        }
    }

    public void execute() {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        Iterator iterator = this.a();
        StringBuilder stringBuilder = new StringBuilder();
        iterator = HelpMojo.b((Node)((Object)iterator), "plugin");
        String string = HelpMojo.a((Node)((Object)iterator), "name");
        Object object = HelpMojo.a((Node)((Object)iterator), "version");
        String string2 = HelpMojo.a((Node)((Object)iterator), "groupId") + ":" + HelpMojo.a((Node)((Object)iterator), "artifactId") + ":" + (String)object;
        if (HelpMojo.a(string) && !string.contains(string2)) {
            this.a(stringBuilder, string + " " + (String)object, 0);
        } else if (HelpMojo.a(string)) {
            this.a(stringBuilder, string, 0);
        } else {
            this.a(stringBuilder, string2, 0);
        }
        this.a(stringBuilder, HelpMojo.a((Node)((Object)iterator), "description"), 1);
        this.a(stringBuilder, "", 0);
        string = HelpMojo.a((Node)((Object)iterator), "goalPrefix");
        iterator = HelpMojo.c(HelpMojo.b((Node)((Object)iterator), "mojos"), "mojo");
        if (this.goal == null || this.goal.length() <= 0) {
            this.a(stringBuilder, "This plugin has " + iterator.size() + (iterator.size() > 1 ? " goals:" : " goal:"), 0);
            this.a(stringBuilder, "", 0);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = (Node)iterator.next();
            this.a(stringBuilder, string, (Element)object);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)stringBuilder.toString());
        }
    }

    private static boolean a(String string) {
        return string != null && string.length() > 0;
    }

    private static String a(Node node, String string) {
        return HelpMojo.b(node, string).getTextContent();
    }

    private static Node b(Node object, String string) {
        if ((object = HelpMojo.c((Node)object, string)).isEmpty()) {
            throw new MojoExecutionException("Could not find " + string + " in plugin-help.xml");
        }
        if (object.size() > 1) {
            throw new MojoExecutionException("Multiple " + string + " in plugin-help.xml");
        }
        return (Node)object.get(0);
    }

    private static ArrayList c(Node object, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        object = object.getChildNodes();
        for (int i2 = 0; i2 < object.getLength(); ++i2) {
            Node node = object.item(i2);
            if (!string.equals(node.getNodeName())) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private static Node d(Node object, String string) {
        if ((object = HelpMojo.c((Node)object, string)).isEmpty()) {
            return null;
        }
        if (object.size() > 1) {
            throw new MojoExecutionException("Multiple " + string + "in plugin-help.xml");
        }
        return (Node)object.get(0);
    }

    private void a(StringBuilder stringBuilder, String iterator, Element object) {
        CharSequence charSequence = HelpMojo.a((Node)object, "goal");
        Node node = HelpMojo.d((Node)object, "configuration");
        Object object2 = HelpMojo.d((Node)object, "description");
        if (this.goal == null || this.goal.length() <= 0 || charSequence.equals(this.goal)) {
            this.a(stringBuilder, (String)((Object)iterator) + ":" + charSequence, 0);
            iterator = HelpMojo.d((Node)object, "deprecated");
            if (iterator != null && HelpMojo.a(iterator.getTextContent())) {
                this.a(stringBuilder, "Deprecated. " + iterator.getTextContent(), 1);
                if (this.detail && object2 != null) {
                    this.a(stringBuilder, "", 0);
                    this.a(stringBuilder, object2.getTextContent(), 1);
                }
            } else if (object2 != null) {
                this.a(stringBuilder, object2.getTextContent(), 1);
            }
            this.a(stringBuilder, "", 0);
            if (this.detail) {
                iterator = HelpMojo.c(HelpMojo.b((Node)object, "parameters"), "parameter");
                this.a(stringBuilder, "Available parameters:", 1);
                this.a(stringBuilder, "", 0);
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object = (Node)iterator.next();
                    Node node2 = node;
                    object2 = object;
                    charSequence = stringBuilder;
                    object = this;
                    Object object3 = HelpMojo.a((Node)object2, "name");
                    String string = HelpMojo.a((Node)object2, "description");
                    node2 = (Element)HelpMojo.d(node2, (String)object3);
                    String string2 = "";
                    if (node2 != null && node2.hasAttribute("default-value")) {
                        string2 = " (Default: " + node2.getAttribute("default-value") + ")";
                    }
                    super.a((StringBuilder)charSequence, (String)object3 + string2, 2);
                    object3 = HelpMojo.d((Node)object2, "deprecated");
                    if (object3 != null && HelpMojo.a(object3.getTextContent())) {
                        super.a((StringBuilder)charSequence, "Deprecated. " + object3.getTextContent(), 3);
                        super.a((StringBuilder)charSequence, "", 0);
                    }
                    super.a((StringBuilder)charSequence, string, 3);
                    if ("true".equals(HelpMojo.a((Node)object2, "required"))) {
                        super.a((StringBuilder)charSequence, "Required: Yes", 3);
                    }
                    if (node2 != null && HelpMojo.a(node2.getTextContent())) {
                        object2 = node2.getTextContent();
                        object2 = object2 != null && ((String)object2).startsWith("${") && ((String)object2).endsWith("}") && !((String)object2).substring(2).contains("${") ? ((String)object2).substring(2, ((String)object2).length() - 1) : null;
                        super.a((StringBuilder)charSequence, "User property: " + (String)object2, 3);
                    }
                    super.a((StringBuilder)charSequence, "", 0);
                }
            }
        }
    }

    private static String a(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void a(StringBuilder stringBuilder, String object, int n2) {
        int n3 = this.lineLength;
        int n4 = this.indentSize;
        ArrayList arrayList = new ArrayList();
        String string3 = HelpMojo.a("\t", n2);
        for (String string2 : ((String)object).split("(\r\n)|(\r)|(\n)")) {
            HelpMojo.a(arrayList, string3 + string2, n4, n3);
        }
        for (String string3 : arrayList) {
            stringBuilder.append(string3).append('\n');
        }
    }

    private static void a(ArrayList arrayList, String stringArray, int n2, int n3) {
        int n4;
        String[] stringArray2 = stringArray;
        int n5 = 0;
        for (n4 = 0; n4 < stringArray2.length() && stringArray2.charAt(n4) == '\t'; ++n4) {
            ++n5;
        }
        for (n4 = n5 + 1; n4 <= n5 + 4 && n4 < stringArray2.length(); ++n4) {
            if (stringArray2.charAt(n4) != '\t') continue;
            ++n5;
            break;
        }
        int n6 = n5;
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string : stringArray.split(" +")) {
            if (stringBuilder.length() > 0) {
                if (stringBuilder.length() + string.length() >= n3) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    stringBuilder.append(HelpMojo.a(" ", n6 * n2));
                } else {
                    stringBuilder.append(' ');
                }
            }
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\t') {
                    stringBuilder.append(HelpMojo.a(" ", n2 - stringBuilder.length() % n2));
                    continue;
                }
                if (c2 == '\u00a0') {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(c2);
            }
        }
        arrayList.add(stringBuilder.toString());
    }
}

