/******************************************************************************
** $Id: opcua_complextypeparser.c 21885 2007-05-22 13:17:24Z jmayer $
**
** Copyright (C) 2006-2007 ascolab GmbH. All Rights Reserved.
** Web: http://www.ascolab.com
** 
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
** 
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
** 
** Project: OpcUa Wireshark Plugin
**
** Description: OpcUa Complex Type Parser
**
** This file was autogenerated on 8.5.2007 18:53:26.
** DON'T MODIFY THIS FILE!
**
******************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include "opcua_complextypeparser.h"
#include "opcua_enumparser.h"
#include "opcua_simpletypes.h"
#include "opcua_hfindeces.h"


gint ett_opcua_ReferenceNode = -1;
void parseReferenceNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReferenceNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReferenceNode);

  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsInverse);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ServerIndex);
  parseExpandedNodeId(subtree, tvb, pOffset, "TargetId");
}

gint ett_opcua_Node = -1;
void parseNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : Node", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_Node);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseInt32(subtree, tvb, pOffset, hf_opcua_NodeClass);
  parseQualifiedName(subtree, tvb, pOffset, "BrowseName");
  parseLocalizedText(subtree, tvb, pOffset, "DisplayName");
  parseLocalizedText(subtree, tvb, pOffset, "Description");
  parseArrayComplex(subtree, tvb, pOffset, "References", parseReferenceNode);
}

gint ett_opcua_ObjectNode = -1;
void parseObjectNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ObjectNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ObjectNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseByte(subtree, tvb, pOffset, hf_opcua_EventNotifier);
}

gint ett_opcua_ObjectTypeNode = -1;
void parseObjectTypeNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ObjectTypeNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ObjectTypeNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
}

gint ett_opcua_VariableNode = -1;
void parseVariableNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : VariableNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_VariableNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseVariant(subtree, tvb, pOffset, "Value");
  parseNodeId(subtree, tvb, pOffset, "DataType");
  parseInt32(subtree, tvb, pOffset, hf_opcua_ArraySize);
  parseByte(subtree, tvb, pOffset, hf_opcua_AccessLevel);
  parseByte(subtree, tvb, pOffset, hf_opcua_UserAccessLevel);
  parseInt32(subtree, tvb, pOffset, hf_opcua_MinimumSamplingInterval);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_Historizing);
}

gint ett_opcua_VariableTypeNode = -1;
void parseVariableTypeNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : VariableTypeNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_VariableTypeNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseVariant(subtree, tvb, pOffset, "Value");
  parseNodeId(subtree, tvb, pOffset, "DataType");
  parseInt32(subtree, tvb, pOffset, hf_opcua_ArraySize);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
}

gint ett_opcua_ReferenceTypeNode = -1;
void parseReferenceTypeNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReferenceTypeNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReferenceTypeNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_Symmetric);
  parseLocalizedText(subtree, tvb, pOffset, "InverseName");
}

gint ett_opcua_MethodNode = -1;
void parseMethodNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MethodNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MethodNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_Executable);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_UserExecutable);
}

gint ett_opcua_ViewNode = -1;
void parseViewNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ViewNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ViewNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ContainsNoLoops);
  parseByte(subtree, tvb, pOffset, hf_opcua_EventNotifier);
}

gint ett_opcua_DataTypeNode = -1;
void parseDataTypeNode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DataTypeNode", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DataTypeNode);
  /* parse base class members */ 
  parseNode(subtree, tvb, pOffset, "[Node]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
}

gint ett_opcua_UriTableEntry = -1;
void parseUriTableEntry(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : UriTableEntry", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_UriTableEntry);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_Index);
  parseString(subtree, tvb, pOffset, hf_opcua_Uri);
}

gint ett_opcua_NodeSet = -1;
void parseNodeSet(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : NodeSet", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_NodeSet);

  parseArrayComplex(subtree, tvb, pOffset, "NamespaceUris", parseUriTableEntry);
  parseArrayComplex(subtree, tvb, pOffset, "ServerUris", parseUriTableEntry);
  parseArrayComplex(subtree, tvb, pOffset, "Nodes", parseExtensionObject);
}

gint ett_opcua_Argument = -1;
void parseArgument(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : Argument", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_Argument);

  parseString(subtree, tvb, pOffset, hf_opcua_Name);
  parseNodeId(subtree, tvb, pOffset, "DataType");
  parseInt32(subtree, tvb, pOffset, hf_opcua_ArraySize);
  parseLocalizedText(subtree, tvb, pOffset, "Description");
}

gint ett_opcua_Status = -1;
void parseStatus(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : Status", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_Status);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseDiagnosticInfo(subtree, tvb, pOffset, "DiagnosticInfo");
}

gint ett_opcua_BaseEvent = -1;
void parseBaseEvent(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BaseEvent", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BaseEvent);

  parseByteString(subtree, tvb, pOffset, hf_opcua_EventId);
  parseNodeId(subtree, tvb, pOffset, "EventType");
  parseNodeId(subtree, tvb, pOffset, "SourceNode");
  parseString(subtree, tvb, pOffset, hf_opcua_SourceName);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_Time);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_ReceiveTime);
  parseLocalizedText(subtree, tvb, pOffset, "Message");
  parseUInt16(subtree, tvb, pOffset, hf_opcua_Severity);
}

gint ett_opcua_SecurityPolicy = -1;
void parseSecurityPolicy(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SecurityPolicy", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SecurityPolicy);

  parseString(subtree, tvb, pOffset, hf_opcua_Uri);
  parseString(subtree, tvb, pOffset, hf_opcua_Digest);
  parseString(subtree, tvb, pOffset, hf_opcua_SymmetricSignature);
  parseString(subtree, tvb, pOffset, hf_opcua_SymmetricKeyWrap);
  parseString(subtree, tvb, pOffset, hf_opcua_SymmetricEncryption);
  parseInt32(subtree, tvb, pOffset, hf_opcua_SymmetricKeyLength);
  parseString(subtree, tvb, pOffset, hf_opcua_AsymmetricSignature);
  parseString(subtree, tvb, pOffset, hf_opcua_AsymmetricKeyWrap);
  parseString(subtree, tvb, pOffset, hf_opcua_AsymmetricEncryption);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MinimumAsymmetricKeyLength);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaximumAsymmetricKeyLength);
  parseString(subtree, tvb, pOffset, hf_opcua_DerivedKey);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_DerivedEncryptionKeyLength);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_DerivedSignatureKeyLength);
}

gint ett_opcua_UserTokenPolicy = -1;
void parseUserTokenPolicy(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : UserTokenPolicy", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_UserTokenPolicy);

  parseUserTokenType(subtree, tvb, pOffset);
  parseString(subtree, tvb, pOffset, hf_opcua_IssuerType);
  parseString(subtree, tvb, pOffset, hf_opcua_IssuerUrl);
}

gint ett_opcua_ServerDescription = -1;
void parseServerDescription(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ServerDescription", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ServerDescription);

  parseServerDescriptionType(subtree, tvb, pOffset);
  parseString(subtree, tvb, pOffset, hf_opcua_ServerUri);
  parseLocalizedText(subtree, tvb, pOffset, "ServerName");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_DiscoveryUrls, parseString);
}

gint ett_opcua_EndpointDescription = -1;
void parseEndpointDescription(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EndpointDescription", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EndpointDescription);

  parseServerDescription(subtree, tvb, pOffset, "Server");
  parseString(subtree, tvb, pOffset, hf_opcua_EndpointUrl);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ServerCertificate);
  parseMessageSecurityMode(subtree, tvb, pOffset);
  parseString(subtree, tvb, pOffset, hf_opcua_SecurityPolicyUri);
  parseArrayComplex(subtree, tvb, pOffset, "UserIdentityTokens", parseUserTokenPolicy);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SupportedProfiles, parseString);
}

gint ett_opcua_EndpointConfiguration = -1;
void parseEndpointConfiguration(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EndpointConfiguration", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EndpointConfiguration);

  parseInt32(subtree, tvb, pOffset, hf_opcua_SendTimeout);
  parseInt32(subtree, tvb, pOffset, hf_opcua_OperationTimeout);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_UseBinaryEncoding);
  parseInt32(subtree, tvb, pOffset, hf_opcua_MaxMessageSize);
  parseInt32(subtree, tvb, pOffset, hf_opcua_MaxArrayLength);
  parseInt32(subtree, tvb, pOffset, hf_opcua_MaxStringLength);
}

gint ett_opcua_UserIdentityToken = -1;
void parseUserIdentityToken(proto_tree *tree, tvbuff_t *tvb, gint *pOffset _U_, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : UserIdentityToken", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_UserIdentityToken);
  subtree = 0; 
}

gint ett_opcua_UserNameIdentityToken = -1;
void parseUserNameIdentityToken(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : UserNameIdentityToken", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_UserNameIdentityToken);
  /* parse base class members */ 
  parseUserIdentityToken(subtree, tvb, pOffset, "[UserIdentityToken]");
  /* parse additional members */
  parseString(subtree, tvb, pOffset, hf_opcua_UserName);
  parseString(subtree, tvb, pOffset, hf_opcua_Password);
  parseString(subtree, tvb, pOffset, hf_opcua_HashAlgorithm);
}

gint ett_opcua_X509IdentityToken = -1;
void parseX509IdentityToken(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : X509IdentityToken", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_X509IdentityToken);
  /* parse base class members */ 
  parseUserIdentityToken(subtree, tvb, pOffset, "[UserIdentityToken]");
  /* parse additional members */
  parseByteString(subtree, tvb, pOffset, hf_opcua_CertificateData);
}

gint ett_opcua_WssIdentityToken = -1;
void parseWssIdentityToken(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : WssIdentityToken", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_WssIdentityToken);
  /* parse base class members */ 
  parseUserIdentityToken(subtree, tvb, pOffset, "[UserIdentityToken]");
  /* parse additional members */
  parseXmlElement(subtree, tvb, pOffset, hf_opcua_TokenData);
}

gint ett_opcua_SupportedProfile = -1;
void parseSupportedProfile(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SupportedProfile", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SupportedProfile);

  parseString(subtree, tvb, pOffset, hf_opcua_ProfileUri);
  parseString(subtree, tvb, pOffset, hf_opcua_ProfileName);
  parseComplianceLevel(subtree, tvb, pOffset);
}

gint ett_opcua_BuildInfo = -1;
void parseBuildInfo(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BuildInfo", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BuildInfo);

  parseString(subtree, tvb, pOffset, hf_opcua_ApplicationUri);
  parseString(subtree, tvb, pOffset, hf_opcua_ManufacturerName);
  parseString(subtree, tvb, pOffset, hf_opcua_ApplicationName);
  parseString(subtree, tvb, pOffset, hf_opcua_SoftwareVersion);
  parseString(subtree, tvb, pOffset, hf_opcua_BuildNumber);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_BuildDate);
}

gint ett_opcua_SoftwareCertificate = -1;
void parseSoftwareCertificate(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SoftwareCertificate", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SoftwareCertificate);

  parseBuildInfo(subtree, tvb, pOffset, "ServerInfo");
  parseString(subtree, tvb, pOffset, hf_opcua_IssuedBy);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_IssuedDate);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_ExpirationDate);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ApplicationCertificate);
  parseString(subtree, tvb, pOffset, hf_opcua_IssuerCertificateThumbprint);
  parseString(subtree, tvb, pOffset, hf_opcua_IssuerSignatureAlgorithm);
  parseArrayComplex(subtree, tvb, pOffset, "SupportedProfiles", parseSupportedProfile);
}

gint ett_opcua_SignedSoftwareCertificate = -1;
void parseSignedSoftwareCertificate(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SignedSoftwareCertificate", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SignedSoftwareCertificate);

  parseByteString(subtree, tvb, pOffset, hf_opcua_CertificateData);
  parseByteString(subtree, tvb, pOffset, hf_opcua_IssuerSignature);
}

gint ett_opcua_NodeAttributes = -1;
void parseNodeAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : NodeAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_NodeAttributes);

  parseLocalizedText(subtree, tvb, pOffset, "DisplayName");
  parseLocalizedText(subtree, tvb, pOffset, "Description");
}

gint ett_opcua_ObjectAttributes = -1;
void parseObjectAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ObjectAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ObjectAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseByte(subtree, tvb, pOffset, hf_opcua_EventNotifier);
}

gint ett_opcua_ObjectTypeAttributes = -1;
void parseObjectTypeAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ObjectTypeAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ObjectTypeAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
}

gint ett_opcua_VariableAttributes = -1;
void parseVariableAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : VariableAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_VariableAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseVariant(subtree, tvb, pOffset, "Value");
  parseNodeId(subtree, tvb, pOffset, "DataType");
  parseInt32(subtree, tvb, pOffset, hf_opcua_ArraySize);
  parseByte(subtree, tvb, pOffset, hf_opcua_AccessLevel);
  parseByte(subtree, tvb, pOffset, hf_opcua_UserAccessLevel);
  parseInt32(subtree, tvb, pOffset, hf_opcua_MinimumSamplingInterval);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_Historizing);
}

gint ett_opcua_VariableTypeAttributes = -1;
void parseVariableTypeAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : VariableTypeAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_VariableTypeAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseVariant(subtree, tvb, pOffset, "Value");
  parseNodeId(subtree, tvb, pOffset, "DataType");
  parseInt32(subtree, tvb, pOffset, hf_opcua_ArraySize);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
}

gint ett_opcua_ReferenceTypeAttributes = -1;
void parseReferenceTypeAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReferenceTypeAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReferenceTypeAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsAbstract);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_Symmetric);
  parseLocalizedText(subtree, tvb, pOffset, "InverseName");
}

gint ett_opcua_MethodAttributes = -1;
void parseMethodAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MethodAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MethodAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_Executable);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_UserExecutable);
}

gint ett_opcua_ViewAttributes = -1;
void parseViewAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ViewAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ViewAttributes);
  /* parse base class members */ 
  parseNodeAttributes(subtree, tvb, pOffset, "[NodeAttributes]");
  /* parse additional members */
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ContainsNoLoops);
  parseByte(subtree, tvb, pOffset, hf_opcua_EventNotifier);
}

gint ett_opcua_AddNodesItem = -1;
void parseAddNodesItem(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : AddNodesItem", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddNodesItem);

  parseExpandedNodeId(subtree, tvb, pOffset, "ParentNodeId");
  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseExpandedNodeId(subtree, tvb, pOffset, "RequestedNewNodeId");
  parseQualifiedName(subtree, tvb, pOffset, "BrowseName");
  parseInt32(subtree, tvb, pOffset, hf_opcua_NodeClass);
  parseExtensionObject(subtree, tvb, pOffset, "NodeAttributes");
  parseExpandedNodeId(subtree, tvb, pOffset, "TypeDefinition");
}

gint ett_opcua_AddReferencesItem = -1;
void parseAddReferencesItem(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : AddReferencesItem", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddReferencesItem);

  parseNodeId(subtree, tvb, pOffset, "SourceNodeId");
  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsForward);
  parseString(subtree, tvb, pOffset, hf_opcua_TargetServerUri);
  parseExpandedNodeId(subtree, tvb, pOffset, "TargetNodeId");
  parseInt32(subtree, tvb, pOffset, hf_opcua_TargetNodeClass);
}

gint ett_opcua_DeleteNodesItem = -1;
void parseDeleteNodesItem(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DeleteNodesItem", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteNodesItem);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_DeleteTargetReferences);
}

gint ett_opcua_DeleteReferencesItem = -1;
void parseDeleteReferencesItem(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DeleteReferencesItem", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteReferencesItem);

  parseNodeId(subtree, tvb, pOffset, "SourceNodeId");
  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsForward);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ServerIndex);
  parseExpandedNodeId(subtree, tvb, pOffset, "TargetNodeId");
}

gint ett_opcua_RedundantServerDataType = -1;
void parseRedundantServerDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : RedundantServerDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RedundantServerDataType);

  parseString(subtree, tvb, pOffset, hf_opcua_ServerId);
  parseSByte(subtree, tvb, pOffset, hf_opcua_ServiceLevel);
  parseServerState(subtree, tvb, pOffset);
}

gint ett_opcua_SamplingRateDiagnosticsDataType = -1;
void parseSamplingRateDiagnosticsDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SamplingRateDiagnosticsDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SamplingRateDiagnosticsDataType);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SamplingRate);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SamplingErrorCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SampledMonitoredItemsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxSampledMonitoredItemsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_DisabledMonitoredItemsSamplingCount);
}

gint ett_opcua_ServerDiagnosticsSummaryDataType = -1;
void parseServerDiagnosticsSummaryDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ServerDiagnosticsSummaryDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ServerDiagnosticsSummaryDataType);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_ServerViewCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentSessionCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CumulatedSessionCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SecurityRejectedSessionCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RejectSessionCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionTimeoutCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionAbortCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SamplingRateCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_PublishingRateCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentSubscriptionCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CumulatedSubscriptionCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SecurityRejectedRequestsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RejectedRequestsCount);
}

gint ett_opcua_ServerStatusDataType = -1;
void parseServerStatusDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ServerStatusDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ServerStatusDataType);

  parseDateTime(subtree, tvb, pOffset, hf_opcua_StartTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_CurrentTime);
  parseServerState(subtree, tvb, pOffset);
  parseBuildInfo(subtree, tvb, pOffset, "BuildInfo");
}

gint ett_opcua_ServiceCounterDataType = -1;
void parseServiceCounterDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ServiceCounterDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ServiceCounterDataType);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_TotalCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_UnauthorizedCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ErrorCount);
}

gint ett_opcua_SessionDiagnosticsDataType = -1;
void parseSessionDiagnosticsDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SessionDiagnosticsDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SessionDiagnosticsDataType);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionId);
  parseString(subtree, tvb, pOffset, hf_opcua_ClientName);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_LocaleIds, parseString);
  parseInt32(subtree, tvb, pOffset, hf_opcua_ActualSessionTimeout);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_ClientConnectionTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_ClientLastContactTime);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentSubscriptionsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentMonitoredItemsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentPublishRequestsInQueue);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentPublishTimerExpirations);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_KeepAliveCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_CurrentRepublishRequestsInQueue);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxRepublishRequestsInQueue);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RepublishCounter);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_PublishingCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_PublishingQueueOverflowCount);
  parseServiceCounterDataType(subtree, tvb, pOffset, "ReadCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "HistoryReadCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "WriteCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "HistoryUpdateCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "CallCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "CreateMonitoredItemsCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "ModifyMonitoredItemsCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "SetMonitoringModeCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "SetTriggeringCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "DeleteMonitoredItemsCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "CreateSubscriptionCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "ModifySubscriptionCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "SetPublishingModeCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "PublishCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "RepublishCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "TransferSubscriptionCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "DeleteSubscriptionsCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "AddNodesCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "AddReferencesCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "DeleteNodesCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "DeleteReferencesCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "BrowseCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "BrowseNextCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "TranslateBrowsePathsToNodeIdsCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "QueryFirstCount");
  parseServiceCounterDataType(subtree, tvb, pOffset, "QueryNextCount");
}

gint ett_opcua_SessionSecurityDiagnosticsDataType = -1;
void parseSessionSecurityDiagnosticsDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SessionSecurityDiagnosticsDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SessionSecurityDiagnosticsDataType);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionId);
  parseString(subtree, tvb, pOffset, hf_opcua_ClientUserIdOfSession);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ClientUserIdHistory, parseString);
  parseString(subtree, tvb, pOffset, hf_opcua_AuthenticationMechanism);
  parseString(subtree, tvb, pOffset, hf_opcua_Encoding);
  parseString(subtree, tvb, pOffset, hf_opcua_TransportProtocol);
  parseString(subtree, tvb, pOffset, hf_opcua_SecurityPolicy);
}

gint ett_opcua_SubscriptionDiagnosticsDataType = -1;
void parseSubscriptionDiagnosticsDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SubscriptionDiagnosticsDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SubscriptionDiagnosticsDataType);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_PublishingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MaxKeepAliveCount);
  parseByte(subtree, tvb, pOffset, hf_opcua_Priority);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_PublishingEnabled);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ModifyCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_EnableCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_DisableCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RepublishRequestCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RepublishMessageRequestCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RepublishMessageCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TransferRequestCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TransferredToAltClientCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_TransferredToSameClientCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_PublishRequestCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_DataChangeNotificationsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_EventNotificationsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_NotificationsCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_LateStateCount);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_KeepAliveStateCount);
}

gint ett_opcua_Range = -1;
void parseRange(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : Range", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_Range);

  parseDouble(subtree, tvb, pOffset, hf_opcua_Low);
  parseDouble(subtree, tvb, pOffset, hf_opcua_High);
}

gint ett_opcua_EUInformation = -1;
void parseEUInformation(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EUInformation", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EUInformation);

  parseString(subtree, tvb, pOffset, hf_opcua_NamespaceUri);
  parseInt32(subtree, tvb, pOffset, hf_opcua_UnitId);
  parseLocalizedText(subtree, tvb, pOffset, "DisplayName");
  parseLocalizedText(subtree, tvb, pOffset, "Description");
}

gint ett_opcua_Annotation = -1;
void parseAnnotation(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : Annotation", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_Annotation);

  parseString(subtree, tvb, pOffset, hf_opcua_Message);
  parseString(subtree, tvb, pOffset, hf_opcua_UserName);
  parseExtensionObject(subtree, tvb, pOffset, "UserIdentity");
  parseDateTime(subtree, tvb, pOffset, hf_opcua_AnnotationTime);
}

gint ett_opcua_BaseStructureDataType = -1;
void parseBaseStructureDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BaseStructureDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BaseStructureDataType);

  parseInt32(subtree, tvb, pOffset, hf_opcua_Id);
  parseString(subtree, tvb, pOffset, hf_opcua_Name);
}

gint ett_opcua_DerivedStructureDataType = -1;
void parseDerivedStructureDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DerivedStructureDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DerivedStructureDataType);
  /* parse base class members */ 
  parseBaseStructureDataType(subtree, tvb, pOffset, "[BaseStructureDataType]");
  /* parse additional members */
  parseString(subtree, tvb, pOffset, hf_opcua_Description);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_Timestamp);
}

gint ett_opcua_ScalarValuesDataType = -1;
void parseScalarValuesDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ScalarValuesDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ScalarValuesDataType);

  parseBoolean(subtree, tvb, pOffset, hf_opcua_Boolean);
  parseSByte(subtree, tvb, pOffset, hf_opcua_SByte);
  parseByte(subtree, tvb, pOffset, hf_opcua_Byte);
  parseInt16(subtree, tvb, pOffset, hf_opcua_Int16);
  parseUInt16(subtree, tvb, pOffset, hf_opcua_UInt16);
  parseInt32(subtree, tvb, pOffset, hf_opcua_Int32);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_UInt32);
  parseInt64(subtree, tvb, pOffset, hf_opcua_Int64);
  parseUInt64(subtree, tvb, pOffset, hf_opcua_UInt64);
  parseFloat(subtree, tvb, pOffset, hf_opcua_Float);
  parseDouble(subtree, tvb, pOffset, hf_opcua_Double);
  parseString(subtree, tvb, pOffset, hf_opcua_String);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_DateTime);
  parseGuid(subtree, tvb, pOffset, hf_opcua_Guid);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ByteString);
  parseXmlElement(subtree, tvb, pOffset, hf_opcua_XmlElement);
  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseExpandedNodeId(subtree, tvb, pOffset, "ExpandedNodeId");
  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseDiagnosticInfo(subtree, tvb, pOffset, "DiagnosticInfo");
  parseQualifiedName(subtree, tvb, pOffset, "QualifiedName");
  parseLocalizedText(subtree, tvb, pOffset, "LocalizedText");
  parseExtensionObject(subtree, tvb, pOffset, "ExtensionObject");
  parseDataValue(subtree, tvb, pOffset, "DataValue");
  parseVariant(subtree, tvb, pOffset, "Variant");
  parseBaseStructureDataType(subtree, tvb, pOffset, "Structure");
  parseColorsDataType(subtree, tvb, pOffset);
}

gint ett_opcua_ArrayValuesDataType = -1;
void parseArrayValuesDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ArrayValuesDataType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ArrayValuesDataType);

  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Boolean, parseBoolean);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SByte, parseSByte);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Int16, parseInt16);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_UInt16, parseUInt16);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Int32, parseInt32);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_UInt32, parseUInt32);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Int64, parseInt64);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_UInt64, parseUInt64);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Float, parseFloat);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Double, parseDouble);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_String, parseString);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_DateTime, parseDateTime);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Guid, parseGuid);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ByteString, parseByteString);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_XmlElement, parseXmlElement);
  parseArrayComplex(subtree, tvb, pOffset, "NodeId", parseNodeId);
  parseArrayComplex(subtree, tvb, pOffset, "ExpandedNodeId", parseExpandedNodeId);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_StatusCode, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfo", parseDiagnosticInfo);
  parseArrayComplex(subtree, tvb, pOffset, "QualifiedName", parseQualifiedName);
  parseArrayComplex(subtree, tvb, pOffset, "LocalizedText", parseLocalizedText);
  parseArrayComplex(subtree, tvb, pOffset, "ExtensionObject", parseExtensionObject);
  parseArrayComplex(subtree, tvb, pOffset, "DataValue", parseDataValue);
  parseArrayComplex(subtree, tvb, pOffset, "Variant", parseVariant);
  parseArrayComplex(subtree, tvb, pOffset, "Structure", parseBaseStructureDataType);
  parseArrayEnum(subtree, tvb, pOffset, parseColorsDataType);
}

gint ett_opcua_RequestHeader = -1;
void parseRequestHeader(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : RequestHeader", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RequestHeader);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionId);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_Timestamp);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ReturnDiagnostics);
  parseString(subtree, tvb, pOffset, hf_opcua_AuditLogEntryId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_TimeoutHint);
  parseExtensionObject(subtree, tvb, pOffset, "AdditionalHeaders");
}

gint ett_opcua_ResponseHeader = -1;
void parseResponseHeader(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ResponseHeader", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ResponseHeader);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SessionId);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_Timestamp);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RequestId);
  parseStatusCode(subtree, tvb, pOffset, hf_opcua_ServiceResult);
  parseDiagnosticInfo(subtree, tvb, pOffset, "ServiceDiagnostics");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_StringTable, parseString);
  parseExtensionObject(subtree, tvb, pOffset, "AdditionalHeaders");
}

gint ett_opcua_ServiceFault = -1;
void parseServiceFault(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ServiceFault", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ServiceFault);

  parseResponseHeader(subtree, tvb, pOffset, "ResponseHeader");
}

gint ett_opcua_ComplexTestType = -1;
void parseComplexTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ComplexTestType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ComplexTestType);

  parseDateTime(subtree, tvb, pOffset, hf_opcua_Value1);
  parseArrayEnum(subtree, tvb, pOffset, parseEnumeratedTestType);
}

gint ett_opcua_BaseTestType = -1;
void parseBaseTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BaseTestType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BaseTestType);

  parseDateTime(subtree, tvb, pOffset, hf_opcua_Value1);
}

gint ett_opcua_DerivedTestType = -1;
void parseDerivedTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DerivedTestType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DerivedTestType);
  /* parse base class members */ 
  parseBaseTestType(subtree, tvb, pOffset, "[BaseTestType]");
  /* parse additional members */
  parseDateTime(subtree, tvb, pOffset, hf_opcua_Value2);
}

gint ett_opcua_ScalarTestType = -1;
void parseScalarTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ScalarTestType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ScalarTestType);

  parseBoolean(subtree, tvb, pOffset, hf_opcua_Boolean);
  parseSByte(subtree, tvb, pOffset, hf_opcua_SByte);
  parseByte(subtree, tvb, pOffset, hf_opcua_Byte);
  parseInt16(subtree, tvb, pOffset, hf_opcua_Int16);
  parseUInt16(subtree, tvb, pOffset, hf_opcua_UInt16);
  parseInt32(subtree, tvb, pOffset, hf_opcua_Int32);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_UInt32);
  parseInt64(subtree, tvb, pOffset, hf_opcua_Int64);
  parseUInt64(subtree, tvb, pOffset, hf_opcua_UInt64);
  parseFloat(subtree, tvb, pOffset, hf_opcua_Float);
  parseDouble(subtree, tvb, pOffset, hf_opcua_Double);
  parseString(subtree, tvb, pOffset, hf_opcua_String);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_DateTime);
  parseGuid(subtree, tvb, pOffset, hf_opcua_Guid);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ByteString);
  parseXmlElement(subtree, tvb, pOffset, hf_opcua_XmlElement);
  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseExpandedNodeId(subtree, tvb, pOffset, "ExpandedNodeId");
  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseDiagnosticInfo(subtree, tvb, pOffset, "DiagnosticInfo");
  parseQualifiedName(subtree, tvb, pOffset, "QualifiedName");
  parseLocalizedText(subtree, tvb, pOffset, "LocalizedText");
  parseExtensionObject(subtree, tvb, pOffset, "ExtensionObject");
  parseDataValue(subtree, tvb, pOffset, "DataValue");
  parseVariant(subtree, tvb, pOffset, "Variant");
  parseComplexTestType(subtree, tvb, pOffset, "ComplexValue");
  parseEnumeratedTestType(subtree, tvb, pOffset);
}

gint ett_opcua_ArrayTestType = -1;
void parseArrayTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ArrayTestType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ArrayTestType);

  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Booleans, parseBoolean);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SBytes, parseSByte);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Int16s, parseInt16);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_UInt16s, parseUInt16);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Int32s, parseInt32);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_UInt32s, parseUInt32);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Int64s, parseInt64);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_UInt64s, parseUInt64);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Floats, parseFloat);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Doubles, parseDouble);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Strings, parseString);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_DateTimes, parseDateTime);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_Guids, parseGuid);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ByteStrings, parseByteString);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_XmlElements, parseXmlElement);
  parseArrayComplex(subtree, tvb, pOffset, "NodeIds", parseNodeId);
  parseArrayComplex(subtree, tvb, pOffset, "ExpandedNodeIds", parseExpandedNodeId);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_StatusCodes, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
  parseArrayComplex(subtree, tvb, pOffset, "QualifiedNames", parseQualifiedName);
  parseArrayComplex(subtree, tvb, pOffset, "LocalizedTexts", parseLocalizedText);
  parseArrayComplex(subtree, tvb, pOffset, "ExtensionObjects", parseExtensionObject);
  parseArrayComplex(subtree, tvb, pOffset, "DataValues", parseDataValue);
  parseArrayComplex(subtree, tvb, pOffset, "Variants", parseVariant);
  parseArrayComplex(subtree, tvb, pOffset, "ComplexValues", parseComplexTestType);
  parseArrayEnum(subtree, tvb, pOffset, parseEnumeratedTestType);
}

gint ett_opcua_CompositeTestType = -1;
void parseCompositeTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : CompositeTestType", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CompositeTestType);

  parseScalarTestType(subtree, tvb, pOffset, "Input1");
  parseArrayTestType(subtree, tvb, pOffset, "Input2");
}

gint ett_opcua_RegisteredServer = -1;
void parseRegisteredServer(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : RegisteredServer", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_RegisteredServer);

  parseServerDescriptionType(subtree, tvb, pOffset);
  parseString(subtree, tvb, pOffset, hf_opcua_ServerUri);
  parseArrayComplex(subtree, tvb, pOffset, "ServerNames", parseLocalizedText);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_DiscoveryUrls, parseString);
  parseString(subtree, tvb, pOffset, hf_opcua_SemaphoreFilePath);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsOnline);
}

gint ett_opcua_ChannelSecurityToken = -1;
void parseChannelSecurityToken(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ChannelSecurityToken", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ChannelSecurityToken);

  parseGuid(subtree, tvb, pOffset, hf_opcua_ChannelId);
  parseString(subtree, tvb, pOffset, hf_opcua_TokenId);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_CreatedAt);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RevisedLifetime);
}

gint ett_opcua_SignatureData = -1;
void parseSignatureData(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SignatureData", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SignatureData);

  parseString(subtree, tvb, pOffset, hf_opcua_Algorithm);
  parseByteString(subtree, tvb, pOffset, hf_opcua_Signature);
}

gint ett_opcua_AddNodesResult = -1;
void parseAddNodesResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : AddNodesResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AddNodesResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseNodeId(subtree, tvb, pOffset, "AddedNodeId");
}

gint ett_opcua_BrowsePropertiesPropertyResult = -1;
void parseBrowsePropertiesPropertyResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BrowsePropertiesPropertyResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowsePropertiesPropertyResult);

  parseQualifiedName(subtree, tvb, pOffset, "PropertyName");
  parseLocalizedText(subtree, tvb, pOffset, "PropertyDisplayName");
  parseNodeId(subtree, tvb, pOffset, "PropertyNodeId");
  parseStatusCode(subtree, tvb, pOffset, hf_opcua_PropertyStatusCode);
}

gint ett_opcua_BrowsePropertiesResult = -1;
void parseBrowsePropertiesResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BrowsePropertiesResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowsePropertiesResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "PropertyResults", parseBrowsePropertiesPropertyResult);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_ReferenceDescription = -1;
void parseReferenceDescription(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReferenceDescription", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReferenceDescription);

  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsForward);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_ServerIndex);
  parseExpandedNodeId(subtree, tvb, pOffset, "NodeId");
  parseQualifiedName(subtree, tvb, pOffset, "BrowseName");
  parseLocalizedText(subtree, tvb, pOffset, "DisplayName");
  parseInt32(subtree, tvb, pOffset, hf_opcua_NodeClass);
  parseExpandedNodeId(subtree, tvb, pOffset, "TypeDefinition");
}

gint ett_opcua_ViewDescription = -1;
void parseViewDescription(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ViewDescription", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ViewDescription);

  parseNodeId(subtree, tvb, pOffset, "ViewId");
  parseDateTime(subtree, tvb, pOffset, hf_opcua_Timestamp);
  parseInt32(subtree, tvb, pOffset, hf_opcua_ViewVersion);
}

gint ett_opcua_BrowsePath = -1;
void parseBrowsePath(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : BrowsePath", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_BrowsePath);

  parseNodeId(subtree, tvb, pOffset, "StartingNode");
  parseString(subtree, tvb, pOffset, hf_opcua_RelativePath);
}

gint ett_opcua_TranslateBrowsePathResult = -1;
void parseTranslateBrowsePathResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : TranslateBrowsePathResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TranslateBrowsePathResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "MatchingNodeIds", parseNodeId);
}

gint ett_opcua_AttributeDescription = -1;
void parseAttributeDescription(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : AttributeDescription", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AttributeDescription);

  parseString(subtree, tvb, pOffset, hf_opcua_RelativePath);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_AttributeId);
  parseString(subtree, tvb, pOffset, hf_opcua_IndexRange);
}

gint ett_opcua_NodeTypeDescription = -1;
void parseNodeTypeDescription(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : NodeTypeDescription", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_NodeTypeDescription);

  parseNodeId(subtree, tvb, pOffset, "TypeDefinitionNode");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IncludeSubTypes);
  parseArrayComplex(subtree, tvb, pOffset, "AttributesToReturn", parseAttributeDescription);
}

gint ett_opcua_QueryDataSet = -1;
void parseQueryDataSet(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : QueryDataSet", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryDataSet);

  parseExpandedNodeId(subtree, tvb, pOffset, "NodeId");
  parseNodeId(subtree, tvb, pOffset, "TypeDefinitionNodeId");
  parseArrayComplex(subtree, tvb, pOffset, "Values", parseVariant);
}

gint ett_opcua_NodeReference = -1;
void parseNodeReference(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : NodeReference", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_NodeReference);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseNodeId(subtree, tvb, pOffset, "ReferenceTypeId");
  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsForward);
  parseArrayComplex(subtree, tvb, pOffset, "ReferencedNodeIds", parseNodeId);
}

gint ett_opcua_ContentFilterElement = -1;
void parseContentFilterElement(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ContentFilterElement", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ContentFilterElement);

  parseFilterOperator(subtree, tvb, pOffset);
  parseArrayComplex(subtree, tvb, pOffset, "FilterOperands", parseExtensionObject);
}

gint ett_opcua_ContentFilter = -1;
void parseContentFilter(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ContentFilter", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ContentFilter);

  parseArrayComplex(subtree, tvb, pOffset, "Elements", parseContentFilterElement);
}

gint ett_opcua_FilterOperand = -1;
void parseFilterOperand(proto_tree *tree, tvbuff_t *tvb, gint *pOffset _U_, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : FilterOperand", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_FilterOperand);
  subtree = 0; 
}

gint ett_opcua_ElementOperand = -1;
void parseElementOperand(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ElementOperand", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ElementOperand);
  /* parse base class members */ 
  parseFilterOperand(subtree, tvb, pOffset, "[FilterOperand]");
  /* parse additional members */
  parseUInt32(subtree, tvb, pOffset, hf_opcua_Index);
}

gint ett_opcua_LiteralOperand = -1;
void parseLiteralOperand(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : LiteralOperand", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_LiteralOperand);
  /* parse base class members */ 
  parseFilterOperand(subtree, tvb, pOffset, "[FilterOperand]");
  /* parse additional members */
  parseVariant(subtree, tvb, pOffset, "Value");
}

gint ett_opcua_AttributeOperand = -1;
void parseAttributeOperand(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : AttributeOperand", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_AttributeOperand);
  /* parse base class members */ 
  parseFilterOperand(subtree, tvb, pOffset, "[FilterOperand]");
  /* parse additional members */
  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseString(subtree, tvb, pOffset, hf_opcua_Alias);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_AttributeId);
  parseString(subtree, tvb, pOffset, hf_opcua_IndexRange);
}

gint ett_opcua_PropertyOperand = -1;
void parsePropertyOperand(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : PropertyOperand", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_PropertyOperand);
  /* parse base class members */ 
  parseFilterOperand(subtree, tvb, pOffset, "[FilterOperand]");
  /* parse additional members */
  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseString(subtree, tvb, pOffset, hf_opcua_Alias);
  parseQualifiedName(subtree, tvb, pOffset, "Property");
  parseString(subtree, tvb, pOffset, hf_opcua_IndexRange);
}

gint ett_opcua_ContentFilterResult = -1;
void parseContentFilterResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ContentFilterResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ContentFilterResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_Result);
  parseDiagnosticInfo(subtree, tvb, pOffset, "DiagnosticInfo");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_IndexOfInvalidElement);
}

gint ett_opcua_QueryResult = -1;
void parseQueryResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : QueryResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_QueryResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_AttributeStatusCodes, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "AttributeDiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_ReadValueId = -1;
void parseReadValueId(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReadValueId", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadValueId);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_AttributeId);
  parseString(subtree, tvb, pOffset, hf_opcua_IndexRange);
  parseQualifiedName(subtree, tvb, pOffset, "Encoding");
}

gint ett_opcua_HistoryReadValueId = -1;
void parseHistoryReadValueId(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : HistoryReadValueId", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryReadValueId);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseQualifiedName(subtree, tvb, pOffset, "Encoding");
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
}

gint ett_opcua_HistoryReadResult = -1;
void parseHistoryReadResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : HistoryReadResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryReadResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseByteString(subtree, tvb, pOffset, hf_opcua_ContinuationPoint);
  parseExtensionObject(subtree, tvb, pOffset, "HistoryData");
}

gint ett_opcua_MonitoringFilter = -1;
void parseMonitoringFilter(proto_tree *tree, tvbuff_t *tvb, gint *pOffset _U_, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoringFilter", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoringFilter);
  subtree = 0; 
}

gint ett_opcua_EventFilter = -1;
void parseEventFilter(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EventFilter", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EventFilter);
  /* parse base class members */ 
  parseMonitoringFilter(subtree, tvb, pOffset, "[MonitoringFilter]");
  /* parse additional members */
  parseArrayComplex(subtree, tvb, pOffset, "SelectClauses", parseNodeId);
  parseContentFilter(subtree, tvb, pOffset, "WhereClause");
}

gint ett_opcua_ReadEventDetails = -1;
void parseReadEventDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReadEventDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadEventDetails);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_NumValuesPerNode);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_StartTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_EndTime);
  parseEventFilter(subtree, tvb, pOffset, "Filter");
}

gint ett_opcua_ReadRawModifiedDetails = -1;
void parseReadRawModifiedDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReadRawModifiedDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadRawModifiedDetails);

  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsReadModified);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_StartTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_EndTime);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_NumValuesPerNode);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_ReturnBounds);
}

gint ett_opcua_ReadProcessedDetails = -1;
void parseReadProcessedDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReadProcessedDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadProcessedDetails);

  parseDateTime(subtree, tvb, pOffset, hf_opcua_StartTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_EndTime);
  parseInt32(subtree, tvb, pOffset, hf_opcua_ResampleInterval);
  parseNodeId(subtree, tvb, pOffset, "AggregateType");
}

gint ett_opcua_ReadAtTimeDetails = -1;
void parseReadAtTimeDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : ReadAtTimeDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_ReadAtTimeDetails);

  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ReqTimes, parseDateTime);
}

gint ett_opcua_HistoryData = -1;
void parseHistoryData(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : HistoryData", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryData);

  parseArrayComplex(subtree, tvb, pOffset, "DataValues", parseDataValue);
}

gint ett_opcua_EventFieldList = -1;
void parseEventFieldList(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EventFieldList", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EventFieldList);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_ClientHandle);
  parseArrayComplex(subtree, tvb, pOffset, "EventFields", parseVariant);
}

gint ett_opcua_EventNotification = -1;
void parseEventNotification(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EventNotification", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EventNotification);

  parseArrayComplex(subtree, tvb, pOffset, "Events", parseEventFieldList);
}

gint ett_opcua_HistoryEvent = -1;
void parseHistoryEvent(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : HistoryEvent", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryEvent);

  parseArrayComplex(subtree, tvb, pOffset, "Notifications", parseEventNotification);
}

gint ett_opcua_WriteValue = -1;
void parseWriteValue(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : WriteValue", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_WriteValue);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_AttributeId);
  parseString(subtree, tvb, pOffset, hf_opcua_IndexRange);
  parseDataValue(subtree, tvb, pOffset, "Value");
}

gint ett_opcua_InsertReplaceDetails = -1;
void parseInsertReplaceDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : InsertReplaceDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_InsertReplaceDetails);

  parseBoolean(subtree, tvb, pOffset, hf_opcua_PerformInsert);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_PerformReplace);
  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseHistoryData(subtree, tvb, pOffset, "UpdateValue");
}

gint ett_opcua_InsertEventDetails = -1;
void parseInsertEventDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : InsertEventDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_InsertEventDetails);

  parseHistoryEvent(subtree, tvb, pOffset, "HistoryEvent");
}

gint ett_opcua_DeleteRawModifiedDetails = -1;
void parseDeleteRawModifiedDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DeleteRawModifiedDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteRawModifiedDetails);

  parseBoolean(subtree, tvb, pOffset, hf_opcua_IsDeleteModified);
  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseDateTime(subtree, tvb, pOffset, hf_opcua_StartTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_EndTime);
}

gint ett_opcua_DeleteAtTimeDetails = -1;
void parseDeleteAtTimeDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DeleteAtTimeDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteAtTimeDetails);

  parseNodeId(subtree, tvb, pOffset, "NodeId");
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_ReqTimes, parseDateTime);
}

gint ett_opcua_DeleteEventDetails = -1;
void parseDeleteEventDetails(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DeleteEventDetails", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DeleteEventDetails);

  parseEventFilter(subtree, tvb, pOffset, "EventFilter");
  parseDateTime(subtree, tvb, pOffset, hf_opcua_StartTime);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_EndTime);
}

gint ett_opcua_HistoryUpdateResult = -1;
void parseHistoryUpdateResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : HistoryUpdateResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_HistoryUpdateResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_OperationResult, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_CallRequestItem = -1;
void parseCallRequestItem(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : CallRequestItem", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CallRequestItem);

  parseNodeId(subtree, tvb, pOffset, "ObjectId");
  parseNodeId(subtree, tvb, pOffset, "MethodId");
  parseArrayComplex(subtree, tvb, pOffset, "InputArguments", parseVariant);
}

gint ett_opcua_CallResultItem = -1;
void parseCallResultItem(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : CallResultItem", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_CallResultItem);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_InputArgumentResults, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "InputArgumentDiagnosticInfos", parseDiagnosticInfo);
  parseArrayComplex(subtree, tvb, pOffset, "OutputArguments", parseVariant);
}

gint ett_opcua_DataChangeFilter = -1;
void parseDataChangeFilter(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DataChangeFilter", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DataChangeFilter);
  /* parse base class members */ 
  parseMonitoringFilter(subtree, tvb, pOffset, "[MonitoringFilter]");
  /* parse additional members */
  parseDataChangeTrigger(subtree, tvb, pOffset);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_DeadbandType);
  parseDouble(subtree, tvb, pOffset, hf_opcua_DeadbandValue);
}

gint ett_opcua_MonitoringFilterResult = -1;
void parseMonitoringFilterResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset _U_, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoringFilterResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoringFilterResult);
  subtree = 0; 
}

gint ett_opcua_EventFilterResult = -1;
void parseEventFilterResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : EventFilterResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_EventFilterResult);
  /* parse base class members */ 
  parseMonitoringFilterResult(subtree, tvb, pOffset, "[MonitoringFilterResult]");
  /* parse additional members */
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_SelectClauseResults, parseStatusCode);
  parseArrayComplex(subtree, tvb, pOffset, "SelectClauseDiagnosticInfos", parseDiagnosticInfo);
  parseContentFilterResult(subtree, tvb, pOffset, "WhereClauseResult");
}

gint ett_opcua_MonitoringAttributes = -1;
void parseMonitoringAttributes(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoringAttributes", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoringAttributes);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_ClientHandle);
  parseInt32(subtree, tvb, pOffset, hf_opcua_SamplingInterval);
  parseExtensionObject(subtree, tvb, pOffset, "Filter");
  parseUInt32(subtree, tvb, pOffset, hf_opcua_QueueSize);
  parseBoolean(subtree, tvb, pOffset, hf_opcua_DiscardOldest);
}

gint ett_opcua_MonitoredItemCreateRequest = -1;
void parseMonitoredItemCreateRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoredItemCreateRequest", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoredItemCreateRequest);

  parseReadValueId(subtree, tvb, pOffset, "ItemToMonitor");
  parseMonitoringMode(subtree, tvb, pOffset);
  parseMonitoringAttributes(subtree, tvb, pOffset, "RequestedAttributes");
}

gint ett_opcua_MonitoredItemCreateResult = -1;
void parseMonitoredItemCreateResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoredItemCreateResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoredItemCreateResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_MonitoredItemId);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RevisedSamplingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedQueueSize);
  parseExtensionObject(subtree, tvb, pOffset, "FilterResult");
}

gint ett_opcua_MonitoredItemModifyRequest = -1;
void parseMonitoredItemModifyRequest(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoredItemModifyRequest", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoredItemModifyRequest);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_MonitorItemId);
  parseMonitoringAttributes(subtree, tvb, pOffset, "RequestedAttributes");
}

gint ett_opcua_MonitoredItemModifyResult = -1;
void parseMonitoredItemModifyResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoredItemModifyResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoredItemModifyResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseInt32(subtree, tvb, pOffset, hf_opcua_RevisedSamplingInterval);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_RevisedQueueSize);
  parseExtensionObject(subtree, tvb, pOffset, "FilterResult");
}

gint ett_opcua_SubscriptionAcknowledgement = -1;
void parseSubscriptionAcknowledgement(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : SubscriptionAcknowledgement", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_SubscriptionAcknowledgement);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pOffset, hf_opcua_SequenceNumber);
}

gint ett_opcua_NotificationMessage = -1;
void parseNotificationMessage(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : NotificationMessage", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_NotificationMessage);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_SequenceNumber);
  parseDateTime(subtree, tvb, pOffset, hf_opcua_PublishTime);
  parseArrayComplex(subtree, tvb, pOffset, "NotificationData", parseExtensionObject);
}

gint ett_opcua_MonitoredItemNotification = -1;
void parseMonitoredItemNotification(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : MonitoredItemNotification", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_MonitoredItemNotification);

  parseUInt32(subtree, tvb, pOffset, hf_opcua_ClientHandle);
  parseDataValue(subtree, tvb, pOffset, "Value");
}

gint ett_opcua_DataChangeNotification = -1;
void parseDataChangeNotification(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : DataChangeNotification", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_DataChangeNotification);

  parseArrayComplex(subtree, tvb, pOffset, "MonitoredItems", parseMonitoredItemNotification);
  parseArrayComplex(subtree, tvb, pOffset, "DiagnosticInfos", parseDiagnosticInfo);
}

gint ett_opcua_TransferResult = -1;
void parseTransferResult(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, char *szFieldName)
{
  proto_item *ti = proto_tree_add_text(tree, tvb, 0, -1, "%s : TransferResult", szFieldName);
  proto_tree *subtree = proto_item_add_subtree(ti, ett_opcua_TransferResult);

  parseStatusCode(subtree, tvb, pOffset, hf_opcua_StatusCode);
  parseArraySimple(subtree, tvb, pOffset, hf_opcua_AvailableSequenceNumbersRanges, parseString);
}

/** Setup protocol subtree array */
static gint *ett[] =
{
  &ett_opcua_ReferenceNode,
  &ett_opcua_Node,
  &ett_opcua_ObjectNode,
  &ett_opcua_ObjectTypeNode,
  &ett_opcua_VariableNode,
  &ett_opcua_VariableTypeNode,
  &ett_opcua_ReferenceTypeNode,
  &ett_opcua_MethodNode,
  &ett_opcua_ViewNode,
  &ett_opcua_DataTypeNode,
  &ett_opcua_UriTableEntry,
  &ett_opcua_NodeSet,
  &ett_opcua_Argument,
  &ett_opcua_Status,
  &ett_opcua_BaseEvent,
  &ett_opcua_SecurityPolicy,
  &ett_opcua_UserTokenPolicy,
  &ett_opcua_ServerDescription,
  &ett_opcua_EndpointDescription,
  &ett_opcua_EndpointConfiguration,
  &ett_opcua_UserIdentityToken,
  &ett_opcua_UserNameIdentityToken,
  &ett_opcua_X509IdentityToken,
  &ett_opcua_WssIdentityToken,
  &ett_opcua_SupportedProfile,
  &ett_opcua_BuildInfo,
  &ett_opcua_SoftwareCertificate,
  &ett_opcua_SignedSoftwareCertificate,
  &ett_opcua_NodeAttributes,
  &ett_opcua_ObjectAttributes,
  &ett_opcua_ObjectTypeAttributes,
  &ett_opcua_VariableAttributes,
  &ett_opcua_VariableTypeAttributes,
  &ett_opcua_ReferenceTypeAttributes,
  &ett_opcua_MethodAttributes,
  &ett_opcua_ViewAttributes,
  &ett_opcua_AddNodesItem,
  &ett_opcua_AddReferencesItem,
  &ett_opcua_DeleteNodesItem,
  &ett_opcua_DeleteReferencesItem,
  &ett_opcua_RedundantServerDataType,
  &ett_opcua_SamplingRateDiagnosticsDataType,
  &ett_opcua_ServerDiagnosticsSummaryDataType,
  &ett_opcua_ServerStatusDataType,
  &ett_opcua_ServiceCounterDataType,
  &ett_opcua_SessionDiagnosticsDataType,
  &ett_opcua_SessionSecurityDiagnosticsDataType,
  &ett_opcua_SubscriptionDiagnosticsDataType,
  &ett_opcua_Range,
  &ett_opcua_EUInformation,
  &ett_opcua_Annotation,
  &ett_opcua_BaseStructureDataType,
  &ett_opcua_DerivedStructureDataType,
  &ett_opcua_ScalarValuesDataType,
  &ett_opcua_ArrayValuesDataType,
  &ett_opcua_RequestHeader,
  &ett_opcua_ResponseHeader,
  &ett_opcua_ServiceFault,
  &ett_opcua_ComplexTestType,
  &ett_opcua_BaseTestType,
  &ett_opcua_DerivedTestType,
  &ett_opcua_ScalarTestType,
  &ett_opcua_ArrayTestType,
  &ett_opcua_CompositeTestType,
  &ett_opcua_RegisteredServer,
  &ett_opcua_ChannelSecurityToken,
  &ett_opcua_SignatureData,
  &ett_opcua_AddNodesResult,
  &ett_opcua_BrowsePropertiesPropertyResult,
  &ett_opcua_BrowsePropertiesResult,
  &ett_opcua_ReferenceDescription,
  &ett_opcua_ViewDescription,
  &ett_opcua_BrowsePath,
  &ett_opcua_TranslateBrowsePathResult,
  &ett_opcua_AttributeDescription,
  &ett_opcua_NodeTypeDescription,
  &ett_opcua_QueryDataSet,
  &ett_opcua_NodeReference,
  &ett_opcua_ContentFilterElement,
  &ett_opcua_ContentFilter,
  &ett_opcua_FilterOperand,
  &ett_opcua_ElementOperand,
  &ett_opcua_LiteralOperand,
  &ett_opcua_AttributeOperand,
  &ett_opcua_PropertyOperand,
  &ett_opcua_ContentFilterResult,
  &ett_opcua_QueryResult,
  &ett_opcua_ReadValueId,
  &ett_opcua_HistoryReadValueId,
  &ett_opcua_HistoryReadResult,
  &ett_opcua_MonitoringFilter,
  &ett_opcua_EventFilter,
  &ett_opcua_ReadEventDetails,
  &ett_opcua_ReadRawModifiedDetails,
  &ett_opcua_ReadProcessedDetails,
  &ett_opcua_ReadAtTimeDetails,
  &ett_opcua_HistoryData,
  &ett_opcua_EventFieldList,
  &ett_opcua_EventNotification,
  &ett_opcua_HistoryEvent,
  &ett_opcua_WriteValue,
  &ett_opcua_InsertReplaceDetails,
  &ett_opcua_InsertEventDetails,
  &ett_opcua_DeleteRawModifiedDetails,
  &ett_opcua_DeleteAtTimeDetails,
  &ett_opcua_DeleteEventDetails,
  &ett_opcua_HistoryUpdateResult,
  &ett_opcua_CallRequestItem,
  &ett_opcua_CallResultItem,
  &ett_opcua_DataChangeFilter,
  &ett_opcua_MonitoringFilterResult,
  &ett_opcua_EventFilterResult,
  &ett_opcua_MonitoringAttributes,
  &ett_opcua_MonitoredItemCreateRequest,
  &ett_opcua_MonitoredItemCreateResult,
  &ett_opcua_MonitoredItemModifyRequest,
  &ett_opcua_MonitoredItemModifyResult,
  &ett_opcua_SubscriptionAcknowledgement,
  &ett_opcua_NotificationMessage,
  &ett_opcua_MonitoredItemNotification,
  &ett_opcua_DataChangeNotification,
  &ett_opcua_TransferResult,
};

void registerComplexTypes(void)
{
  proto_register_subtree_array(ett, array_length(ett));
}


