/* packet-ndps.h
 * Routines for NetWare's NDPS
 * Greg Morris <gmorris@novell.com>
 *
 * Copyright (c) Novell, Inc. 2002-2003
 *
 * $Id: packet-ndps.h 18196 2006-05-21 04:49:01Z sahlberg $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#define NDPS_HEADER_LEN 16

#define TCP_PORT_PA                     0x0d44 /* NDPS Printer Agent */
#define TCP_PORT_BROKER                 0x0bc6 /* NDPS Broker */
#define TCP_PORT_SRS                    0x0bca /* NDPS Service Registry Service */
#define TCP_PORT_ENS                    0x0bc8 /* NDPS Event Notification Service */
#define TCP_PORT_RMS                    0x0bcb /* NDPS Remote Management Service */
#define TCP_PORT_NOTIFY_LISTENER        0x0bc9 /* NDPS Notify Listener */


/*
 * The following value strings are definitions of NDPS
 * Object ID's defined by Novell. Third parties are able 
 * to define their own undocumented OID's. These cannot be 
 * listed and the NDPS dissector will list these as unknown.
 */

static const value_string object_ids_7[] = { /* 0607 (LENGTH 7)*/
    /* These values are 0x060728CF3F+(defined number)*/
	{ 0x00000001,		"Unknown Object ID" },
	{ 0x01000006,		"ID-VC" },
	{ 0x0,			NULL },
};

static const value_string object_ids_8[] = { /* 0608 (LENGTH 8)*/ 
    /* These values are 0x28CF3F01+(defined number)*/
	{ 0x00000600,		"STATE" },
	{ 0x00000601,		"AVAILABILITY" },
	{ 0x00000602,		"GENERIC" },
	{ 0x0000060A,		"PRINT QUALITY" },
	{ 0x0000060B,		"FONT FIDELITY" },
	{ 0x0000060C,		"MEDIUM FIDELITY" },
	{ 0x00000610,		"CONTENT ORIENTATION" },
	{ 0x00000612,		"JOB STATE" },
	{ 0x00000613,		"REASONS" },
	{ 0x00000614,		"JOB SCHEDULING" },
	{ 0x00000615,		"JOB VALIDATE" },
	{ 0x00000616,		"DOCUMENT TYPE" },
	{ 0x00000617,		"DOCUMENT STATE" },
	{ 0x00000619,		"CONFIDENTIALITY POLICY" },
	{ 0x0000061A,		"INTEGRITY POLICY" },
	{ 0x0000061B,		"SECURITY LABEL" },
	{ 0x0000061C,		"SECURITY POLICY" },
	{ 0x0000061D,		"PRINTER RESOLUTION" },
	{ 0x0000061E,		"PRINTER STATE" },
	{ 0x00000621,		"PRINTER OUTPUT_BIN" },
	{ 0x00000622,		"INPUT TRAY" },
	{ 0x00000624,		"CHECKPOINT FORMATS" },
	{ 0x00000629,		"DISTINGUISHED NAME SYNTAX" },
	{ 0x00000632,		"MEDIUM" },
	{ 0x00000634,		"MEDIUM TYPE" },
	{ 0x00000635,		"MEDIUM SIZE" },
	{ 0x00000636,		"MEDIUM COLOR" },
	{ 0x00000637,		"MEDIUM TOOTH" },
	{ 0x00000638,		"MEDIUM GRAIN" },
	{ 0x00000641,		"RESOURCE" },
	{ 0x00000642,		"RESOURCE TYPE" },
	{ 0x0000064B,		"TRANSFER METHOD" },
	{ 0x0000064C,		"TRANSFER METHOD TYPE" },
	{ 0x0000064D,		"DOCUMENT REFERENCE TYPE" },
	{ 0x00000650,		"DELIVERY METHOD" },
	{ 0x00000654,		"AUXILARY PACKAGE" },
	{ 0x00000655,		"AUXILARY SHEET" },
	{ 0x0000065A,		"FINISHING" },
	{ 0x0000065B,		"STITCHING" },
	{ 0x0000065C,		"BINDING" },
	{ 0x0000065D,		"STITCHING TYPE" },
	{ 0x0000065E,		"BINDING TYPE" },
	{ 0x0000065F,		"BINDING COLOR" },
	{ 0x00000660,		"PERFORATION TYPE" },
	{ 0x00000661,		"PERFORATION" },
	{ 0x00000662,		"TRIMMING" },
	{ 0x00000663,		"PUNCHING" },
	{ 0x00000664,		"IMPOSITION" },
	{ 0x00000665,		"PLEX" },
	{ 0x00000666,		"LOGICAL PAGE ORIGIN" },
	{ 0x00000669,		"SCHEDULER" },
	{ 0x0000066E,		"SLITTING" },
	{ 0x0000066F,		"COVERS" },
	{ 0x00000670,		"COVER NAME" },
	{ 0x00000671,		"FOLDING" },
	{ 0x00000673,		"OUTPUT" },
	{ 0x00000678,		"EVENT CLASS" },
	{ 0x00000679,		"EVENT ABORTED" },
	{ 0x0000067A,		"EVENT ERROR" },
	{ 0x0000067B,		"EVENT WARNING" },
	{ 0x0000067C,		"EVENT REPORT" },
	{ 0x0,			NULL },
};

static const value_string object_ids_9[] = { /* 060928 (LENGTH 9)*/
    /* These values are 0xCF3F0100+(defined number)*/
	{ 0x00060001,		"READY" },
	{ 0x00060002,		"ON REQUEST" },
	{ 0x00060003,		"UNAVAILABLE" },
	{ 0x00060004,		"UNKNOWN" },
	{ 0x00060005,		"BUSY" },
	{ 0x00060006,		"INITIALIZING" },
	{ 0x00060007,		"TERMINATING" },
	{ 0x00060101,		"HIGH AVAILABILITY" },
	{ 0x00060102,		"NORMAL AVAILABILITY" },
	{ 0x00060103,		"LOW AVAILABILITY" },
	{ 0x00060106,		"UNKNOWN AVAILABILITY" },
	{ 0x00060200,		"GENERIC NONE" },
	{ 0x00060A00,		"DRAFT PRINT QUALITY" },
	{ 0x00060A01,		"NORMAL PRINT QUALITY" },
	{ 0x00060A02,		"HIGH PRINT QUALITY" },
	{ 0x00060C00,		"MEDIUM FIDELITY SIZE" },
	{ 0x00060C01,		"MEDIUM FIDELITY COLOR" },
	{ 0x00060C02,		"MEDIUM FIDELITY TOOTH" },
	{ 0x00060C03,		"MEDIUM FIDELITY GRAIN" },
	{ 0x00060C04,		"MEDIUM FIDELITY WEIGHT" },
	{ 0x00060C05,		"MEDIUM FIDELITY ARA" },
	{ 0x00061000,		"CONTENT ORIENTATION PORTRAIT" },
	{ 0x00061001,		"CONTENT ORIENTATION LANDSCAPE" },
	{ 0x00061003,		"CONTENT ORIENTATION REVERSE PORTRAIT" },
	{ 0x00061004,		"CONTENT ORIENTATION REVERSE LANDSCAPE" },
	{ 0x00061200,		"JOB STATE UNKNOWN" },
	{ 0x00061201,		"JOB STATE PRE PROCESSING" },
	{ 0x00061204,		"JOB STATE PENDING" },
	{ 0x00061205,		"JOB STATE PROCESSING" },
	{ 0x00061206,		"JOB STATE INTERRUPTED" },
	{ 0x00061209,		"JOB STATE RETAINED" },
	{ 0x0006120A,		"JOB STATE HELD" },
	{ 0x0006120B,		"JOB STATE PAUSED" },
	{ 0x0006120E,		"JOB STATE CANCELLED" },
	{ 0x0006120F,		"JOB STATE COMPLETED" },
	{ 0x00061210,		"JOB STATE PRINTING" },
	{ 0x00061301,		"REASONS DOCUMENTS NEEDED" },
	{ 0x00061302,		"REASONS JOB HOLD SET" },
	{ 0x00061303,		"REASONS JOB PRINTED AFTER SPECIFIED" },
	{ 0x00061304,		"REASONS REQESTED RESPONSE NOT READY" },
	{ 0x00061305,		"REASONS SUCCESSFULLY COMPLETE" },
	{ 0x00061306,		"REASONS COMPLETED WITH WARNING" },
	{ 0x00061307,		"REASONS COMPLETED WITH ERROR" },
	{ 0x00061308,		"REASONS CANCELED BY USER" },
	{ 0x00061309,		"REASONS CANCELED BY OPERATOR" },
	{ 0x0006130A,		"REASONS ABORTED BY SYSTEM" },
	{ 0x00061400,		"JOB SCHEDULED AFTER COMPLETED" },
	{ 0x00061401,		"JOB SCHEDULED BEFORE COMPLETED" },
	{ 0x00061402,		"JOB SCHEDULING EITHER" },
	{ 0x00061500,		"JOB VALIDATE AND PRINT" },
	{ 0x00061501,		"JOB VALIDATE SUBMIT ONLY" },
	{ 0x00061600,		"DOCUMENT TYPE IS PRINTABLE" },
	{ 0x00061601,		"DOCUMENT TYPE IS FONT" },
	{ 0x00061603,		"DOCUMENT TYPE IS OTHER RESOURCE" },
	{ 0x00061700,		"DOCUMENT STATE TRANSFER PENDING" },
	{ 0x00061701,		"DOCUMENT STATE PENDING" },
	{ 0x00061702,		"DOCUMENT STATE PROCESSING" },
	{ 0x00061703,		"DOCUMENT STATE COMPLETED" },
	{ 0x00061704,		"DOCUMENT STATE PRINTING" },
	{ 0x00061B00,		"SECURITY LABEL SHEET TOP" },
	{ 0x00061B01,		"SECURITY LABEL NO SHEET TOP" },
	{ 0x00061B02,		"SECURITY LABEL SHEET BOTTOM" },
	{ 0x00061B03,		"SECURITY LABEL NO SHEET BOTTOM" },
	{ 0x00061B04,		"SECURITY LABEL JOB START SHEET" },
	{ 0x00061B05,		"SECURITY LABEL JOB END SHEET" },
	{ 0x00061C00,		"SECURITY POLICY DISCLOSE" },
	{ 0x00061D00,		"PRINTER RESOLUTION LOWEST" },
	{ 0x00061D01,		"PRINTER RESOLUTION MEDIUM" },
	{ 0x00061D02,		"PRINTER RESOLUTION HIGHEST" },
	{ 0x00061E00,		"PRINTER STATE UNKNOWN" },
	{ 0x00061E01,		"PRINTER STATE IDLE" },
	{ 0x00061E02,		"PRINTER STATE PRINTING" },
	{ 0x00061E03,		"PRINTER STATE NEEDS ATTENTION" },
	{ 0x00061E04,		"PRINTER STATE PAUSED" },
	{ 0x00061E05,		"PRINTER STATE SHUTDOWN" },
	{ 0x00061E06,		"PRINTER STATE JOB START WAIT" },
	{ 0x00061E07,		"PRINTER STATE JOB END WAIT" },
	{ 0x00061E08,		"PRINTER STATE NEEDS KEY OPERATOR" },
	{ 0x00061E09,		"PRINTER STATE JOB PASSWORD WAIT" },
	{ 0x00061E0A,		"PRINTER STATE TIMED OUT" },
	{ 0x00061E0B,		"PRINTER STATE CONNECTING" },
	{ 0x00062100,		"OUTPUT BIN TOP" },
	{ 0x00062101,		"OUTPUT BIN MIDDLE" },
	{ 0x00062102,		"OUTPUT BIN BOTTOM" },
	{ 0x00062103,		"OUTPUT BIN SIDE" },
	{ 0x00062104,		"OUTPUT BIN FACE UP" },
	{ 0x00062105,		"OUTPUT BIN LEFT" },
	{ 0x00062106,		"OUTPUT BIN RIGHT" },
	{ 0x00062107,		"OUTPUT BIN LARGE" },
	{ 0x00062108,		"OUTPUT BIN PRIVATE" },
	{ 0x00062109,		"OUTPUT BIN FACE DOWN" },
	{ 0x0006210A,		"OUTPUT BIN COLLATOR" },
	{ 0x00062200,		"INPUT TRAY TOP" },
	{ 0x00062201,		"INPUT TRAY MIDDLE" },
	{ 0x00062202,		"INPUT TRAY BOTTOM" },
	{ 0x00062203,		"INPUT TRAY ENVELOPE" },
	{ 0x00062204,		"INPUT TRAY MANUAL" },
	{ 0x00062205,		"INPUT TRAY LARGE CAPACITY" },
	{ 0x00062206,		"INPUT TRAY MAIN" },
	{ 0x00062207,		"INPUT TRAY SIDE" },
	{ 0x00062400,		"CHEKPOINT FORMAT NO CONTEXT" },
	{ 0x00062900,		"DISTINGUISHED NAME SYNTAX AUTOMATIC" },
	{ 0x00062901,		"DISTINGUISHED NAME SYNTAX X.500" },
	{ 0x00062902,		"DISTINGUISHED NAME SYNTAX XFN" },
	{ 0x00062903,		"DISTINGUISHED NAME SYNTAX DCE" },
	{ 0x00062904,		"DISTINGUISHED NAME SYNTAX CDS" },
	{ 0x00062905,		"DISTINGUISHED NAME SYNTAX NIS" },
	{ 0x00062906,		"DISTINGUISHED NAME SYNTAX DNS" },
	{ 0x00062907,		"DISTINGUISHED NAME SYNTAX DEC NS" },
	{ 0x00062908,		"DISTINGUISHED NAME SYNTAX INTERNET MAIL" },
	{ 0x00062909,		"DISTINGUISHED NAME SYNTAX XNS" },
	{ 0x00062914,		"DISTINGUISHED NAME SYNTAX POSIX" },
	{ 0x00062915,		"DISTINGUISHED NAME SYNTAX UNIX" },
	{ 0x00062916,		"DISTINGUISHED NAME SYNTAX OS2" },
	{ 0x00062917,		"DISTINGUISHED NAME SYNTAX PC DOS" },
	{ 0x00062918,		"DISTINGUISHED NAME SYNTAX NT" },
	{ 0x00062919,		"DISTINGUISHED NAME SYNTAX MVS" },
	{ 0x0006291A,		"DISTINGUISHED NAME SYNTAX VM" },
	{ 0x0006291B,		"DISTINGUISHED NAME SYNTAX OS400" },
	{ 0x0006291C,		"DISTINGUISHED NAME SYNTAX VMS" },
	{ 0x00063200,		"MEDIUM ISO A4 WHITE" },
	{ 0x00063201,		"MEDIUM ISO A4 COLORED" },
	{ 0x00063202,		"MEDIUM ISO A4 TRANSPARENT" },
	{ 0x0006320A,		"MEDIUM ISO A3 WHITE" },
	{ 0x0006320B,		"MEDIUM ISO A3 COLORED" },
	{ 0x00063214,		"MEDIUM ISO A5 WHITE" },
	{ 0x00063215,		"MEDIUM ISO A5 COLORED" },
	{ 0x0006321E,		"MEDIUM ISO B4 WHITE" },
	{ 0x0006321F,		"MEDIUM ISO B4 COLORED" },
	{ 0x00063228,		"MEDIUM ISO B5 WHITE" },
	{ 0x00063229,		"MEDIUM ISO B5 COLORED" },
	{ 0x00063232,		"MEDIUM NORTH AMERICA LETTER WHITE" },
	{ 0x00063233,		"MEDIUM NORTH AMERICA LETTER COLOR" },
	{ 0x00063234,		"MEDIUM NORTH AMERICA LETTER TRANSPARENT" },
	{ 0x0006323C,		"MEDIUM NORTH AMERICA LEGAL WHITE" },
	{ 0x0006323D,		"MEDIUM NORTH AMERICA LEGAL COLORED" },
	{ 0x00063249,		"MEDIUM ISO B5 ENVELOPE" },
	{ 0x00063253,		"MEDIUM ISO B4 ENVELOPE" },
	{ 0x00063258,		"MEDIUM ISO C3 ENVELOPE" },
	{ 0x0006325D,		"MEDIUM ISO C4 ENVELOPE" },
	{ 0x00063267,		"MEDIUM ISO C5 ENVELOPE" },
	{ 0x0006326C,		"MEDIUM ISO C6 ENVELOPE" },
	{ 0x00063271,		"MEDIUM ISO DESIGN LONG ENVELOPE" },
	{ 0x0006327B,		"MEDIUM NORTH AMERICA 10X13 ENVELOPE" },
	{ 0x00063400,		"MEDIUM TYPE STATIONERY" },
	{ 0x00063401,		"MEDIUM TYPE TRANSPARENCY" },
	{ 0x00063402,		"MEDIUM TYPE ENVELOPE" },
	{ 0x00063403,		"MEDIUM TYPE ENVELOPE PLAIN" },
	{ 0x00063404,		"MEDIUM TYPE CONTINUOUS LONG" },
	{ 0x00063405,		"MEDIUM TYPE CONTINUOUS SHORT" },
	{ 0x00063406,		"MEDIUM TYPE TABULATED STOCK" },
	{ 0x00063407,		"MEDIUM TYPE MULTI-PART FORMS" },
	{ 0x00063408,		"MEDIUM TYPE LABELS" },
	{ 0x00063409,		"MEDIUM TYPE ENVELOPE WITH WINDOW" },
	{ 0x0006340A,		"MEDIUM TYPE MULTI-LAYER" },
	{ 0x00063500,		"MEDIUM SIZE NORTH AMERICA LETTER" },
	{ 0x00063501,		"MEDIUM SIZE NORTH AMERICA LEGAL" },
	{ 0x00063502,		"MEDIUM SIZE NORTH AMERICA 10X13 ENVELOPE" },
	{ 0x00063503,		"MEDIUM SIZE NORTH AMERICA 9X12 ENVELOPE" },
	{ 0x00063504,		"MEDIUM SIZE NORTH AMERICA NUMBER 10 ENVELOPE" },
	{ 0x00063505,		"MEDIUM SIZE NORTH AMERICA 7X9 ENVELOPE" },
	{ 0x00063506,		"MEDIUM SIZE NORTH AMERICA 9X11 ENVELOPE" },
	{ 0x00063507,		"MEDIUM SIZE NORTH AMERICA 10X14 ENVELOPE" },
	{ 0x00063508,		"MEDIUM SIZE NORTH AMERICA NUMBER 9 ENVELOPE" },
	{ 0x00063509,		"MEDIUM SIZE NORTH AMERICA 6X9 ENVELOPE" },
	{ 0x0006350A,		"MEDIUM SIZE NORTH AMERICA 10X15 ENVELOPE" },
	{ 0x0006350B,		"MEDIUM SIZE A" },
	{ 0x0006350C,		"MEDIUM SIZE B" },
	{ 0x0006350D,		"MEDIUM SIZE C" },
	{ 0x0006350E,		"MEDIUM SIZE D" },
	{ 0x0006350F,		"MEDIUM SIZE E" },
	{ 0x00063510,		"MEDIUM SIZE MONARCH ENVELOPE" },
	{ 0x00063514,		"MEDIUM SIZE ISO A0" },
	{ 0x00063515,		"MEDIUM SIZE ISO A1" },
	{ 0x00063516,		"MEDIUM SIZE ISO A2" },
	{ 0x00063517,		"MEDIUM SIZE ISO A3" },
	{ 0x00063518,		"MEDIUM SIZE ISO A4" },
	{ 0x00063519,		"MEDIUM SIZE ISO A5" },
	{ 0x0006351A,		"MEDIUM SIZE ISO A6" },
	{ 0x0006351B,		"MEDIUM SIZE ISO A7" },
	{ 0x0006351C,		"MEDIUM SIZE ISO A8" },
	{ 0x0006351D,		"MEDIUM SIZE ISO A9" },
	{ 0x0006351E,		"MEDIUM SIZE ISO A10" },
	{ 0x00063528,		"MEDIUM SIZE ISO B0" },
	{ 0x00063529,		"MEDIUM SIZE ISO B1" },
	{ 0x0006352A,		"MEDIUM SIZE ISO B2" },
	{ 0x0006352B,		"MEDIUM SIZE ISO B3" },
	{ 0x0006352C,		"MEDIUM SIZE ISO B4" },
	{ 0x0006352D,		"MEDIUM SIZE ISO B5" },
	{ 0x0006352E,		"MEDIUM SIZE ISO B6" },
	{ 0x0006352F,		"MEDIUM SIZE ISO B7" },
	{ 0x00063530,		"MEDIUM SIZE ISO B8" },
	{ 0x00063531,		"MEDIUM SIZE ISO B9" },
	{ 0x00063532,		"MEDIUM SIZE ISO B10" },
	{ 0x0006353F,		"MEDIUM SIZE ISO C3" },
	{ 0x00063540,		"MEDIUM SIZE ISO C4" },
	{ 0x00063541,		"MEDIUM SIZE ISO C5" },
	{ 0x00063542,		"MEDIUM SIZE ISO C6" },
	{ 0x00063543,		"MEDIUM SIZE ISO DESIGNATED LANGUAGE" },
	{ 0x00063550,		"MEDIUM SIZE JIS B0" },
	{ 0x00063551,		"MEDIUM SIZE JIS B1" },
	{ 0x00063552,		"MEDIUM SIZE JIS B2" },
	{ 0x00063553,		"MEDIUM SIZE JIS B3" },
	{ 0x00063554,		"MEDIUM SIZE JIS B4" },
	{ 0x00063555,		"MEDIUM SIZE JIS B5" },
	{ 0x00063556,		"MEDIUM SIZE JIS B6" },
	{ 0x00063557,		"MEDIUM SIZE JIS B7" },
	{ 0x00063558,		"MEDIUM SIZE JIS B8" },
	{ 0x00063559,		"MEDIUM SIZE JIS B9" },
	{ 0x0006355A,		"MEDIUM SIZE JIS B10" },
	{ 0x00063564,		"MEDIUM SIZE EXECUTIVE" },
	{ 0x00063565,		"MEDIUM SIZE FOLIO" },
	{ 0x00063566,		"MEDIUM SIZE INVOICE" },
	{ 0x00063567,		"MEDIUM SIZE LEDGER" },
	{ 0x00063568,		"MEDIUM SIZE QUARTO" },
	{ 0x00063600,		"MEDIUM COLOR WHITE" },
	{ 0x00063601,		"MEDIUM COLOR PINK" },
	{ 0x00063602,		"MEDIUM COLOR YELLOW" },
	{ 0x00063603,		"MEDIUM COLOR BUFF" },
	{ 0x00063604,		"MEDIUM COLOR GOLDENROD" },
	{ 0x00063605,		"MEDIUM COLOR BLUE" },
	{ 0x00063606,		"MEDIUM COLOR GREEN" },
	{ 0x00063607,		"MEDIUM COLOR CLEAR" },
	{ 0x00063701,		"MEDIUM TOOTH FINE" },
	{ 0x00063702,		"MEDIUM TOOTH COARSE" },
	{ 0x00063801,		"MEDIUM GRAIN LONG" },
	{ 0x00063802,		"MEDIUM GRAIN SHORT" },
	{ 0x00064100,		"RESOURCE TYPE" },
	{ 0x00064B00,		"TRANSFER METHOD WITH REQUEST" },
	{ 0x00064B01,		"TRANSFER METHOD REFERENCE DATA" },
	{ 0x00064B02,		"TRANSFER METHOD FTAM BY CLIENT" },
	{ 0x00064B03,		"TRANSFER METHOD FTAM BY SERVER" },
	{ 0x00064C00,		"TRANSFER METHOD TYPE PUSH" },
	{ 0x00064C01,		"TRANSFER METHOD TYPE PULL" },
	{ 0x00064C02,		"TRANSFER METHOD TYPE IMMEDIATE" },
	{ 0x00064D00,		"DOCUMENT REFERENCE TYPE IMMEDIATE " },
	{ 0x00065000,		"DELIVERY METHOD PICK UP" },
	{ 0x00065001,		"DELIVERY METHOD SECURE PICK UP" },
	{ 0x00065002,		"DELIVERY METHOD OFFICE MAIL" },
	{ 0x00065003,		"DELIVERY METHOD POSTAL MAIL" },
	{ 0x00065004,		"DELIVERY METHOD NOTIFICATION SERVICE" },
	{ 0x00065005,		"DELIVERY METHOD ELECTRONIC MAIL" },
	{ 0x00065006,		"DELIVERY METHOD FILE" },
	{ 0x00065008,		"DELIVERY METHOD WITH JOB RESULTS" },
	{ 0x00065009,		"DELIVERY METHOD PRINTED MATERIAL MAIL" },
	{ 0x0006500A,		"DELIVERY METHOD BULK MAIL" },
	{ 0x0006500B,		"DELIVERY METHOD XPRS MAIL" },
	{ 0x0006500C,		"DELIVERY METHOD BUDGET XPRS MAIL" },
	{ 0x0006500D,		"DELIVERY METHOD DOCUMENT FILE" },
	{ 0x0006500E,		"DELIVERY METHOD FILE ADDRESSED TO" },
	{ 0x0006500F,		"DELIVERY METHOD NONE" },
	{ 0x00065400,		"AUXILARY PACKAGE JOB SEPARATORS" },
	{ 0x00065401,		"AUXILARY PACKAGE JOB SET START" },
	{ 0x00065402,		"AUXILARY PACKAGE JOB SET END" },
	{ 0x00065403,		"AUXILARY PACKAGE JOB SET WRAP" },
	{ 0x00065404,		"AUXILARY PACKAGE JOB SET START COPY SEPARATORS" },
	{ 0x00065405,		"AUXILARY PACKAGE JOB SET END COPY SEPARATORS" },
	{ 0x00065406,		"AUXILARY PACKAGE JOB SET WRAP COPY SEPARATORS" },
	{ 0x00065407,		"AUXILARY PACKAGE JOB COPY START" },
	{ 0x00065408,		"AUXILARY PACKAGE JOB COPY END" },
	{ 0x00065409,		"AUXILARY PACKAGE JOB COPY WRAP" },
	{ 0x00065414,		"AUXILARY PACKAGE DOCUMENT SEPARATORS" },
	{ 0x00065415,		"AUXILARY PACKAGE DOCUMENT SET START" },
	{ 0x00065416,		"AUXILARY PACKAGE DOCUMENT SET END" },
	{ 0x00065417,		"AUXILARY PACKAGE DOCUMENT SET WRAP" },
	{ 0x00065418,		"AUXILARY PACKAGE DOCUMENT SET START COPY SEPARATOR" },
	{ 0x00065419,		"AUXILARY PACKAGE DOCUMENT SET END COPY SEPARATOR" },
	{ 0x0006541A,		"AUXILARY PACKAGE DOCUMENT SET WRAP COPY SEPARATOR" },
	{ 0x0006541B,		"AUXILARY PACKAGE DOCUMENT COPY START" },
	{ 0x0006541C,		"AUXILARY PACKAGE DOCUMENT COPY END" },
	{ 0x0006541D,		"AUXILARY PACKAGE DOCUMENT COPY WRAP" },
	{ 0x0006550A,		"AUXILARY JOB SET START" },
	{ 0x0006550B,		"AUXILARY JOB SET SEPARATOR" },
	{ 0x0006550C,		"AUXILARY JOB SET END" },
	{ 0x0006550D,		"AUXILARY JOB COPY START" },
	{ 0x0006550E,		"AUXILARY JOB COPY SEPARATOR" },
	{ 0x0006550F,		"AUXILARY JOB COPY END" },
	{ 0x0006551E,		"AUXILARY DOCUMENT SET START" },
	{ 0x0006551F,		"AUXILARY DOCUMENT SET SEPARATOR" },
	{ 0x00065520,		"AUXILARY DOCUMENT SET END" },
	{ 0x00065521,		"AUXILARY DOCUMENT COPY START" },
	{ 0x00065522,		"AUXILARY DOCUMENT COPY SEPARATOR" },
	{ 0x00065523,		"AUXILARY DOCUMENT COPY END" },
	{ 0x00065A00,		"FINISHING STAPLE" },
	{ 0x00065A01,		"FINISHING STAPLE TOP LEFT" },
	{ 0x00065A02,		"FINISHING STAPLE BOTTOM LEFT" },
	{ 0x00065A03,		"FINISHING STAPLE TOP RIGHT" },
	{ 0x00065A04,		"FINISHING STAPLE BOTTOM RIGHT" },
	{ 0x00065A05,		"FINISHING SADDLE STITCH" },
	{ 0x00065A06,		"FINISHING EDGE STITCH" },
	{ 0x00065A07,		"FINISHING PUNCH" },
	{ 0x00065A08,		"FINISHING COVER" },
	{ 0x00065A09,		"FINISHING BIND" },
	{ 0x00065B00,		"STITCHING DEFAULT" },
	{ 0x00065B01,		"STITCHING STAPLE" },
	{ 0x00065B02,		"STITCHING STAPLE TOP LEFT" },
	{ 0x00065B03,		"STITCHING STAPLE BOTTOM LEFT" },
	{ 0x00065B04,		"STITCHING STAPLE TOP RIGHT" },
	{ 0x00065B05,		"STITCHING STAPLE BOTTOM RIGHT" },
	{ 0x00065B06,		"STITCHING SADDLE STITCH" },
	{ 0x00065B07,		"STITCHING EDGE STITCH" },
	{ 0x00065B08,		"STITCHING EDGE RIGHT" },
	{ 0x00065B09,		"STITCHING EDGE TOP" },
	{ 0x00065C00,		"BINDING DEFAULT" },
	{ 0x00065D00,		"STITCHING TYPE DEFAULT" },
	{ 0x00065D03,		"STITCHING TYPE STAPLE" },
	{ 0x00065D04,		"STITCHING TYPE EDGE" },
	{ 0x00065D05,		"STITCHING TYPE SADDLE" },
	{ 0x00065E00,		"BINDING TYPE DEFAULT" },
	{ 0x00065E01,		"BINDING TYPE TAPE" },
	{ 0x00065E02,		"BINDING TYPE PLASTIC" },
	{ 0x00065E03,		"BINDING TYPE VELO" },
	{ 0x00065E04,		"BINDING TYPE PERFECT" },
	{ 0x00065E05,		"BINDING TYPE SPIRAL" },
	{ 0x00065F00,		"BINDING COLOR DEFAULT" },
	{ 0x00065F01,		"BINDING COLOR BLACK" },
	{ 0x00065F02,		"BINDING COLOR BLUE" },
	{ 0x00065F03,		"BINDING COLOR GRAY" },
	{ 0x00065F04,		"BINDING COLOR BROWN" },
	{ 0x00066000,		"PERFORATION TYPE DEFAULT" },
	{ 0x00066100,		"PERFORATION DEFAULT" },
	{ 0x00066200,		"TRIMMING DEFAULT" },
	{ 0x00066300,		"PUNCHING DEFAULT" },
	{ 0x00066403,		"IMPOSITION SIMPLE 2 UP" },
	{ 0x00066404,		"IMPOSITION SIMPLE 4 UP" },
	{ 0x00066500,		"PLEX SIMPLEX" },
	{ 0x00066501,		"PLEX DUPLEX" },
	{ 0x00066502,		"PLEX TUMBLE" },
	{ 0x00066600,		"LOGICAL PAGE ORIGIN LOWER LEFT" },
	{ 0x00066601,		"LOGICAL PAGE ORIGIN LOWER RIGHT" },
	{ 0x00066602,		"LOGICAL PAGE ORIGIN UPPER RIGHT" },
	{ 0x00066603,		"LOGICAL PAGE ORIGIN UPPER_LEFT" },
	{ 0x00066900,		"SCHEDULER FIFO" },
	{ 0x00066901,		"SCHEDULER SHORT JOB FIRST" },
	{ 0x00066E00,		"SLITTING DEFAULT" },
	{ 0x00066F00,		"COVERS DEFAULT" },
	{ 0x00067000,		"COVER NAME DEFAULT" },
	{ 0x00067100,		"FOLDING DEFAULT" },
	{ 0x00067300,		"OUTPUT PAGE COLLATE" },
	{ 0x00067301,		"OUTPUT NO PAGE COLLATE" },
	{ 0x00067304,		"OUTPUT DECOLLATE" },
	{ 0x00067305,		"OUTPUT NO DECOLLATE" },
	{ 0x00067306,		"OUTPUT BURST" },
	{ 0x00067307,		"OUTPUT NO BURST" },
	{ 0x0006730A,		"OUTPUT STACKING DEFAULT" },
	{ 0x00067800,		"EVENT CLASS ABORTED" },
	{ 0x00067801,		"EVENT CLASS ERROR" },
	{ 0x00067802,		"EVENT CLASS WARNING" },
	{ 0x00067803,		"EVENT CLASS REPORT" },
	{ 0x00067804,		"EVENT CLASS STATE CHANGE" },
	{ 0x00067900,		"EVENT JOB ABORTED BY SERVER " },
	{ 0x00067901,		"EVENT JOB CANCELED BY OPERATOR" },
	{ 0x00067902,		"EVENT JOB CANCELED BY USER" },
	{ 0x00067903,		"EVENT DOCUMENT ABORTED BY SERVER " },
	{ 0x00067904,		"EVENT DOCUMENT CANCELED BY OPERATOR" },
	{ 0x00067905,		"EVENT DOCUMENT CANCELED BY USER" },
	{ 0x00067A03,		"EVENT ERROR DEADLINE" },
	{ 0x00067A04,		"EVENT ERROR DISCARD TIME" },
	{ 0x00067A05,		"EVENT ERROR PRINTER SHUTDOWN" },
	{ 0x00067A06,		"EVENT ERROR NO RESOURCES" },
	{ 0x00067A07,		"EVENT ERROR UNRECOGNIZED RESOURCE" },
	{ 0x00067A08,		"EVENT ERROR NO DOCUMENT" },
	{ 0x00067A09,		"EVENT ERROR JOB SUBMIT INCOMPLETE" },
	{ 0x00067A0A,		"EVENT ERROR PAGE SELECT" },
	{ 0x00067A0B,		"EVENT ERROR DOCUMENT CONTENT" },
	{ 0x00067A63,		"EVENT ERROR OTHER" },
	{ 0x00067B00,		"EVENT WARNING RESOURCE NEEDS ATTENTION" },
	{ 0x00067B01,		"EVENT WARNING RESOURCE NEEDS OPERATOR" },
	{ 0x00067B02,		"EVENT WARNING PRINTER SHUTDOWN" },
	{ 0x00067B03,		"EVENT WARNING JOB MODIFIED" },
	{ 0x00067B04,		"EVENT WARNING ALMOST DEADLINE" },
	{ 0x00067B05,		"EVENT WARNING ALMOST DISCARDED" },
	{ 0x00067B06,		"EVENT WARNING CRITERIA EXCEEDED" },
	{ 0x00067B07,		"EVENT WARNING DUPLICATE ATTRIBUTE IGNORED" },
	{ 0x00067B08,		"EVENT WARNING JOB PAUSED" },
	{ 0x00067B09,		"EVENT WARNING JOB INTERRUPTED" },
	{ 0x00067B0A,		"EVENT WARNING ATTRIBUTE IGNORED" },
	{ 0x00067B63,		"EVENT WARNING OTHER" },
	{ 0x00067C00,		"EVENT REPORT JOB COMPLETED" },
	{ 0x00067C01,		"EVENT REPORT CHECKPOINT TAKEN" },
	{ 0x00067C02,		"EVENT REPORT RESOURCE MESSAGE" },
	{ 0x00067C03,		"EVENT REPORT JOB DISCARDED" },
	{ 0x00067C04,		"EVENT REPORT FILE TRANSFERRED" },
	{ 0x00067C05,		"EVENT REPORT JOB PROMOTED" },
	{ 0x00067C06,		"EVENT REPORT JOB RESUMED" },
	{ 0x00067C07,		"EVENT REPORT PROCESS STARTED" },
	{ 0x00067C08,		"EVENT REPORT PRINT STARTED" },
	{ 0x00068149,		"CHARACTER_REPERTOIRE" },
	{ 0x0006814A,		"CHARACTER_MAPPING" },
	{ 0x0,			NULL },
};

static const value_string object_ids_10[] = { 
    /* These values are 0x3F010000+(defined number)*/
	{ 0x06328105,		"MEDIUM NORTH AMERICA 9X12 ENVELOPE" },
	{ 0x06328106,		"MEDIUM MONARCH ENVELOPE" },
	{ 0x0632810F,		"MEDIUM NORTH AMERICA NUMBER 10 ENVELOPE" },
	{ 0x06328110,		"MEDIUM NORTH AMERICA 7X9 ENVELOPE" },
	{ 0x06328111,		"MEDIUM NORTH AMERICA 9X11 ENVELOPE" },
	{ 0x06328112,		"MEDIUM NORTH AMERICA 10X14 ENVELOPE" },
	{ 0x06328113,		"MEDIUM NORTH AMERICA NUMBER 9 ENVELOPE" },
	{ 0x06328114,		"MEDIUM NORTH AMERICA 6X9 ENVELOPE" },
	{ 0x06328115,		"MEDIUM NORTH AMERICA 10X15 ENVELOPE" },
	{ 0x06328116,		"MEDIUM JIS B4 WHITE" },
	{ 0x06328117,		"MEDIUM JIS B4 COLORED" },
	{ 0x06328120,		"MEDIUM JIS B5 WHITE" },
	{ 0x06328121,		"MEDIUM JIS B5 COLORED" },
	{ 0x0632812A,		"MEDIUM EXECUTIVE" },
	{ 0x0632812B,		"MEDIUM FOLIO" },
	{ 0x0632812C,		"MEDIUM INVOICE" },
	{ 0x0632812D,		"MEDIUM LEDGER" },
	{ 0x0632812E,		"MEDIUM QUARTO" },
	{ 0x06328148,		"MEDIUM ISO A0 WHITE" },
	{ 0x06328149,		"MEDIUM ISO A1 WHITE" },
	{ 0x0632814A,		"MEDIUM ISO A2 WHITE" },
	{ 0x0632814E,		"MEDIUM ISO A6 WHITE" },
	{ 0x0632814F,		"MEDIUM ISO A7 WHITE" },
	{ 0x06328150,		"MEDIUM ISO A8 WHITE" },
	{ 0x06328151,		"MEDIUM ISO A9 WHITE" },
	{ 0x06328152,		"MEDIUM ISO A10 WHITE" },
	{ 0x0632815C,		"MEDIUM ISO B0 WHITE" },
	{ 0x0632815D,		"MEDIUM ISO B1 WHITE" },
	{ 0x0632815E,		"MEDIUM ISO B2 WHITE" },
	{ 0x0632815F,		"MEDIUM ISO B3 WHITE" },
	{ 0x06328162,		"MEDIUM ISO B6 WHITE" },
	{ 0x06328163,		"MEDIUM ISO B7 WHITE" },
	{ 0x06328164,		"MEDIUM ISO B8 WHITE" },
	{ 0x06328165,		"MEDIUM ISO B9 WHITE" },
	{ 0x06328166,		"MEDIUM ISO B10 WHITE" },
	{ 0x06328170,		"MEDIUM JIS B0 WHITE" },
	{ 0x06328171,		"MEDIUM JIS B1 WHITE" },
	{ 0x06328172,		"MEDIUM JIS B2 WHITE" },
	{ 0x06328173,		"MEDIUM JIS B3 WHITE" },
	{ 0x06328176,		"MEDIUM JIS B6 WHITE" },
	{ 0x06328177,		"MEDIUM JIS B7 WHITE" },
	{ 0x06328178,		"MEDIUM JIS B8 WHITE" },
	{ 0x06328179,		"MEDIUM JIS B9 WHITE" },
	{ 0x0632817A,		"MEDIUM JIS B10 WHITE" },
	{ 0x06328204,		"MEDIUM A" },
	{ 0x06328205,		"MEDIUM B" },
	{ 0x06328206,		"MEDIUM C" },
	{ 0x06328207,		"MEDIUM D" },
	{ 0x06328208,		"MEDIUM E" },
	{ 0x06328768,		"MEDIUM DEFAULT" },
    /* These values are 0x480186F8+(defined number)*/
	{ 0x37010400,		"NDPS OBJECT CLASS" },
	{ 0x37010401,		"NDPS VALUE CLASS" },
	{ 0x37010402,		"NDPS NDS TOP" },
	{ 0x0,			NULL },
};

static const value_string object_ids_11[] = { 
    /* These values are 0x0186F837+(defined number)*/
	{ 0x01040000,		"(Novell) Object Class GENERIC" },
	{ 0x01040001,		"(Novell) Object Class JOB" },
	{ 0x01040002,		"(Novell) Object Class DOCUMENT" },
	{ 0x01040003,		"(Novell) Object Class PRINTER" },
	{ 0x01040004,		"(Novell) Object Class MEDIUM" },
	{ 0x01040005,		"(Novell) Object Class FONT" },
	{ 0x01040006,		"(Novell) Object Class TRANSFER METHOD" },
	{ 0x01040007,		"(Novell) Object Class DELIVERY METHOD" },
	{ 0x01040008,		"(Novell) Object Class AUXILIARY SHEET" },
	{ 0x01040009,		"(Novell) Object Class FINISHING" },
	{ 0x0104000B,		"(Novell) Object Class IMPOSITION" },
	{ 0x0104000C,		"(Novell) Object Class SCHEDULER" },
	{ 0x0104000E,		"(Novell) Object Class RESOURCE" },
	{ 0x0104000F,		"(Novell) Object Class INPUT" },
	{ 0x01040010,		"(Novell) Object Class OUTPUT" },
	{ 0x01040011,		"(Novell) Object Class AUXILIARY SHEET PACKAGE" },
	{ 0x01040012,		"(Novell) Object Class MANAGER" },
	{ 0x01040013,		"(Novell) Object Class JOB DEFAULTS" },
	{ 0x01040014,		"(Novell) Object Class DOCUMENT DEFAULTS" },
	{ 0x01040015,		"(Novell) Object Class JOB LIMITS" },
	{ 0x01040016,		"(Novell) Object Class DOCUMENT LIMITS" },
	{ 0x01040017,		"(Novell) Object Class ABSTRACT EVENT" },
	{ 0x01040018,		"(Novell) Object Class RETAINED JOB" },
	{ 0x01040019,		"(Novell) Object Class MARKER" },
	{ 0x0104001A,		"(Novell) Object Class MEDIA PATH" },
	{ 0x0104001B,		"(Novell) Object Class CHANNEL" },
	{ 0x0104001C,		"(Novell) Object Class INTERPRETER" },
	{ 0x0104001D,		"(Novell) Object Class NOTIFICATION METHOD" },
	{ 0x0104001E,		"(Novell) Object Class MARKER SUPPLIES" },
	{ 0x0104001F,		"(Novell) Object Class MARKER COLORANT" },
	{ 0x01040020,		"(Novell) Object Class COVER" },
	{ 0x01040021,		"(Novell) Object Class LIGHT" },
	{ 0x01040022,		"(Novell) Object Class BUFFER" },
	{ 0x01040023,		"(Novell) Object Class RESOURCE CONTEXT" },
	{ 0x01040024,		"(Novell) Object Class ACCOUNTING" },
	{ 0x01040025,		"(Novell) Object Class FINISHER DEVICE" },
	{ 0x01040026,		"(Novell) Object Class FINISHER SUPPLY" },
	{ 0x01040027,		"(Novell) Object Class PRINTER POOL" },
	{ 0x01040100,		"(Novell) Value Class PRINTER STATE" },
	{ 0x01040101,		"(Novell) Value Class TRANSFER METHOD" },
	{ 0x01040102,		"(Novell) Value Class SCHEDULER" },
	{ 0x01040103,		"(Novell) Value Class DISTINGUISHED NAME SYNTAX" },
	{ 0x01040104,		"(Novell) Value Class DEVICE CONTROL" },
	{ 0x01040105,		"(Novell) Value Class PRINTER OUTPUT BIN" },
	{ 0x01040106,		"(Novell) Value Class INPUT TRAY" },
	{ 0x01040107,		"(Novell) Value Class MEDIUM" },
	{ 0x01040108,		"(Novell) Value Class MEDIUM TYPE" },
	{ 0x01040109,		"(Novell) Value Class MANAGER STATE" },
	{ 0x0104010A,		"(Novell) Value Class NOTIFICATION METHOD" },
	{ 0x0104010B,		"(Novell) Value Class REASONS" },
	{ 0x0104010C,		"(Novell) Value Class DEVICE STATE" },
	{ 0x01040203,		"(Novell) Object Class NDS ORGANIZATION" },
	{ 0x01040204,		"(Novell) Object Class NDS ORGANIZATIONAL UNIT" },
	{ 0x01040205,		"(Novell) Object Class NDS GROUP" },
	{ 0x01040206,		"(Novell) Object Class NDS USER" },
	{ 0x0,			NULL },
};

static const value_string object_ids_12[] = { /* 060C60 864801 (LENGTH 12)*/
    /* These values are 0x86F83701+(defined number)*/
	{ 0x04000000,		"(Novell) Object Class GENERIC DPA" },
	{ 0x04000001,		"(Novell) Object Class GENERIC MIB" },
	{ 0x04000002,		"(Novell) Object Class GENERIC DPS" },
	{ 0x04000003,		"(Novell) Object Class GENERIC VENDOR" },
	{ 0x04000100,		"(Novell) Object Class JOB DPA" },
	{ 0x04000101,		"(Novell) Object Class JOB MIB" },
	{ 0x04000102,		"(Novell) Object Class JOB DPS" },
	{ 0x04000103,		"(Novell) Object Class JOB VENDOR" },
	{ 0x04000200,		"(Novell) Object Class DOCUMENT DPA" },
	{ 0x04000201,		"(Novell) Object Class DOCUMENT MIB" },
	{ 0x04000202,		"(Novell) Object Class DOCUMENT DPS" },
	{ 0x04000203,		"(Novell) Object Class DOCUMENT VENDOR" },
	{ 0x04000300,		"(Novell) Object Class PRINTER DPA" },
	{ 0x04000301,		"(Novell) Object Class PRINTER MIB" },
	{ 0x04000302,		"(Novell) Object Class PRINTER DPS" },
	{ 0x04000303,		"(Novell) Object Class PRINTER HISTORY" },
	{ 0x04000304,		"(Novell) Object Class PRINTER VENDOR" },
	{ 0x04000400,		"(Novell) Object Class MEDIUM DPA" },
	{ 0x04000401,		"(Novell) Object Class MEDIUM MIB" },
	{ 0x04000402,		"(Novell) Object Class MEDIUM DPS" },
	{ 0x04000403,		"(Novell) Object Class MEDIUM VENDOR" },
	{ 0x04000500,		"(Novell) Object Class FONT DPA" },
	{ 0x04000501,		"(Novell) Object Class FONT MIB" },
	{ 0x04000502,		"(Novell) Object Class FONT DPS" },
	{ 0x04000503,		"(Novell) Object Class FONT VENDOR" },
	{ 0x04000600,		"(Novell) Object Class TRANSFER METHOD DPA" },
	{ 0x04000601,		"(Novell) Object Class TRANSFER METHOD MIB" },
	{ 0x04000602,		"(Novell) Object Class TRANSFER METHOD DPS" },
	{ 0x04000603,		"(Novell) Object Class TRANSFER METHOD VENDOR" },
	{ 0x04000700,		"(Novell) Object Class DELIVERY METHOD DPA" },
	{ 0x04000701,		"(Novell) Object Class DELIVERY METHOD MIB" },
	{ 0x04000702,		"(Novell) Object Class DELIVERY METHOD DPS" },
	{ 0x04000703,		"(Novell) Object Class DELIVERY METHOD VENDOR" },
	{ 0x04000800,		"(Novell) Object Class AUXILIARY SHEET DPA" },
	{ 0x04000801,		"(Novell) Object Class AUXILIARY SHEET MIB" },
	{ 0x04000802,		"(Novell) Object Class AUXILIARY SHEET DPS" },
	{ 0x04000803,		"(Novell) Object Class AUXILIARY SHEET VENDOR" },
	{ 0x04000900,		"(Novell) Object Class FINISHING DPA" },
	{ 0x04000901,		"(Novell) Object Class FINISHING MIB" },
	{ 0x04000902,		"(Novell) Object Class FINISHING DPS" },
	{ 0x04000903,		"(Novell) Object Class FINISHING VENDOR" },
	{ 0x04000B00,		"(Novell) Object Class IMPOSITION DPA" },
	{ 0x04000B01,		"(Novell) Object Class IMPOSITION MIB" },
	{ 0x04000B02,		"(Novell) Object Class IMPOSITION DPS" },
	{ 0x04000B03,		"(Novell) Object Class IMPOSITION VENDOR" },
	{ 0x04000C00,		"(Novell) Object Class SCHEDULER DPA" },
	{ 0x04000C01,		"(Novell) Object Class SCHEDULER MIB" },
	{ 0x04000C02,		"(Novell) Object Class SCHEDULER DPS" },
	{ 0x04000C03,		"(Novell) Object Class SCHEDULER VENDOR" },
	{ 0x04000E00,		"(Novell) Object Class RESOURCE DPA" },
	{ 0x04000E01,		"(Novell) Object Class RESOURCE MIB" },
	{ 0x04000E02,		"(Novell) Object Class RESOURCE DPS" },
	{ 0x04000E03,		"(Novell) Object Class RESOURCE VENDOR" },
	{ 0x04000F00,		"(Novell) Object Class INPUT DPA" },
	{ 0x04000F01,		"(Novell) Object Class INPUT MIB" },
	{ 0x04000F02,		"(Novell) Object Class INPUT DPS" },
	{ 0x04000F03,		"(Novell) Object Class INPUT VENDOR" },
	{ 0x04001000,		"(Novell) Object Class OUTPUT DPA" },
	{ 0x04001001,		"(Novell) Object Class OUTPUT MIB" },
	{ 0x04001002,		"(Novell) Object Class OUTPUT DPS" },
	{ 0x04001003,		"(Novell) Object Class OUTPUT VENDOR" },
	{ 0x04001100,		"(Novell) Object Class AUXILIARY SHEET PKG DPA" },
	{ 0x04001101,		"(Novell) Object Class AUXILIARY SHEET PKG MIB" },
	{ 0x04001102,		"(Novell) Object Class AUXILIARY SHEET PKG DPS" },
	{ 0x04001103,		"(Novell) Object Class AUXILIARY SHEET PKG VENDOR" },
	{ 0x04001200,		"(Novell) Object Class MANAGER DPA" },
	{ 0x04001201,		"(Novell) Object Class MANAGER MIB" },
	{ 0x04001202,		"(Novell) Object Class MANAGER DPS" },
	{ 0x04001203,		"(Novell) Object Class MANAGER VENDOR" },
	{ 0x04001300,		"(Novell) Object Class JOB DEFAULTS DPA" },
	{ 0x04001301,		"(Novell) Object Class JOB DEFAULTS MIB" },
	{ 0x04001302,		"(Novell) Object Class JOB DEFAULTS DPS" },
	{ 0x04001303,		"(Novell) Object Class JOB DEFAULTS VENDOR" },
	{ 0x04001400,		"(Novell) Object Class DOCUMENT DEFAULTS DPA" },
	{ 0x04001401,		"(Novell) Object Class DOCUMENT DEFAULTS MIB" },
	{ 0x04001402,		"(Novell) Object Class DOCUMENT DEFAULTS DPS" },
	{ 0x04001403,		"(Novell) Object Class DOCUMENT DEFAULTS VENDOR" },
	{ 0x04001500,		"(Novell) Object Class JOB LIMITS DPA" },
	{ 0x04001501,		"(Novell) Object Class JOB LIMITS MIB" },
	{ 0x04001502,		"(Novell) Object Class JOB LIMITS DPS" },
	{ 0x04001503,		"(Novell) Object Class JOB LIMITS VENDOR" },
	{ 0x04001600,		"(Novell) Object Class DOCUMENT LIMITS DPA" },
	{ 0x04001601,		"(Novell) Object Class DOCUMENT LIMITS MIB" },
	{ 0x04001602,		"(Novell) Object Class DOCUMENT LIMITS DPS" },
	{ 0x04001603,		"(Novell) Object Class DOCUMENT LIMITS VENDOR" },
	{ 0x04001700,		"(Novell) Object Class ABSTRACT EVENT DPA" },
	{ 0x04001701,		"(Novell) Object Class ABSTRACT EVENT MIB" },
	{ 0x04001702,		"(Novell) Object Class ABSTRACT EVENT DPS" },
	{ 0x04001703,		"(Novell) Object Class ABSTRACT EVENT VENDOR" },
	{ 0x04001900,		"(Novell) Object Class MARKER DPA" },
	{ 0x04001901,		"(Novell) Object Class MARKER MIB" },
	{ 0x04001902,		"(Novell) Object Class MARKER DPS" },
	{ 0x04001903,		"(Novell) Object Class MARKER VENDOR" },
	{ 0x04001A00,		"(Novell) Object Class MEDIA PATH DPA" },
	{ 0x04001A01,		"(Novell) Object Class MEDIA PATH MIB" },
	{ 0x04001A02,		"(Novell) Object Class MEDIA PATH DPS" },
	{ 0x04001A03,		"(Novell) Object Class MEDIA PATH VENDOR" },
	{ 0x04001B00,		"(Novell) Object Class CHANNEL DPA" },
	{ 0x04001B01,		"(Novell) Object Class CHANNEL MIB" },
	{ 0x04001B02,		"(Novell) Object Class CHANNEL DPS" },
	{ 0x04001B03,		"(Novell) Object Class CHANNEL VENDOR" },
	{ 0x04001C00,		"(Novell) Object Class INTERP DPA" },
	{ 0x04001C01,		"(Novell) Object Class INTERP MIB" },
	{ 0x04001C02,		"(Novell) Object Class INTERP DPS" },
	{ 0x04001C03,		"(Novell) Object Class INTERP VENDOR" },
	{ 0x04001D00,		"(Novell) Object Class NOTIFICATION METHOD DPA" },
	{ 0x04001D01,		"(Novell) Object Class NOTIFICATION METHOD MIB" },
	{ 0x04001D02,		"(Novell) Object Class NOTIFICATION METHOD DPS" },
	{ 0x04001D03,		"(Novell) Object Class NOTIFICATION METHOD VENDOR" },
	{ 0x04001E00,		"(Novell) Object Class MARKER SUPPLIES DPA" },
	{ 0x04001E01,		"(Novell) Object Class MARKER SUPPLIES MIB" },
	{ 0x04001E02,		"(Novell) Object Class MARKER SUPPLIES DPS" },
	{ 0x04001E03,		"(Novell) Object Class MARKER SUPPLIES VENDOR" },
	{ 0x04001F00,		"(Novell) Object Class MARKER COLORANT DPA" },
	{ 0x04001F01,		"(Novell) Object Class MARKER COLORANT MIB" },
	{ 0x04001F02,		"(Novell) Object Class MARKER COLORANT DPS" },
	{ 0x04001F03,		"(Novell) Object Class MARKER COLORANT VENDOR" },
	{ 0x04002000,		"(Novell) Object Class COVER DPA" },
	{ 0x04002001,		"(Novell) Object Class COVER MIB" },
	{ 0x04002002,		"(Novell) Object Class COVER DPS" },
	{ 0x04002003,		"(Novell) Object Class COVER VENDOR" },
	{ 0x04002100,		"(Novell) Object Class LIGHT DPA" },
	{ 0x04002101,		"(Novell) Object Class LIGHT MIB" },
	{ 0x04002102,		"(Novell) Object Class LIGHT DPS" },
	{ 0x04002103,		"(Novell) Object Class LIGHT VENDOR" },
	{ 0x04002200,		"(Novell) Object Class BUFFER DPA" },
	{ 0x04002201,		"(Novell) Object Class BUFFER MIB" },
	{ 0x04002202,		"(Novell) Object Class BUFFER DPS" },
	{ 0x04002203,		"(Novell) Object Class BUFFER VENDOR" },
	{ 0x04002300,		"(Novell) Object Class RESOURCE CONTEXT DPA" },
	{ 0x04002301,		"(Novell) Object Class RESOURCE CONTEXT MIB" },
	{ 0x04002302,		"(Novell) Object Class RESOURCE CONTEXT DPS" },
	{ 0x04002303,		"(Novell) Object Class RESOURCE CONTEXT VENDOR" },
	{ 0x04002500,		"(Novell) Object Class FINISHER DEVICE DPA" },
	{ 0x04002501,		"(Novell) Object Class FINISHER DEVICE MIB" },
	{ 0x04002502,		"(Novell) Object Class FINISHER DEVICE DPS" },
	{ 0x04002503,		"(Novell) Object Class FINISHER DEVICE VENDOR" },
	{ 0x04002600,		"(Novell) Object Class FINISHER SUPPLY DPA" },
	{ 0x04002601,		"(Novell) Object Class FINISHER SUPPLY MIB" },
	{ 0x04002602,		"(Novell) Object Class FINISHER SUPPLY DPS" },
	{ 0x04002603,		"(Novell) Object Class FINISHER SUPPLY VENDOR" },
	{ 0x04002700,		"(Novell) Object Class PRINTER POOL DPA" },
	{ 0x04002701,		"(Novell) Object Class PRINTER POOL MIB" },
	{ 0x04002702,		"(Novell) Object Class PRINTER POOL DPS" },
	{ 0x04002703,		"(Novell) Object Class PRINTER POOL VENDOR" },
	{ 0x04010000,		"(Novell) Value PRINTER STATE NOT CONNECTED" },
	{ 0x04010001,		"(Novell) Value PRINTER STATE STOPPED" },
	{ 0x04010002,		"(Novell) Value PRINTER STATE ACTIVE" },
	{ 0x04010003,		"(Novell) Value PRINTER STATE PAUSED NOT CONNECTED" },
	{ 0x04010004,		"(Novell) Value PRINTER STATE PRINTER STOPPED" },
	{ 0x04010100,		"(Novell) Value TRANSFER METHOD NDPS DATA" },
	{ 0x04010200,		"(Novell) Value SCHEDULER MEDIA" },
	{ 0x04010201,		"(Novell) Value SCHEDULER OPERATOR" },
	{ 0x04010202,		"(Novell) Value SCHEDULER CURRENT MEDIUM" },
	{ 0x04010300,		"(Novell) Value DISTINGUISHED NAME SYNTAX NDS" },
	{ 0x04010400,		"(Novell) Value DEVICE CONTROL PAUSE INPUT" },
	{ 0x04010401,		"(Novell) Value DEVICE CONTROL RESUME INPUT" },
	{ 0x04010402,		"(Novell) Value DEVICE CONTROL PAUSE OUTPUT" },
	{ 0x04010403,		"(Novell) Value DEVICE CONTROL RESUME OUTPUT" },
	{ 0x04010404,		"(Novell) Value DEVICE CONTROL RESET" },
	{ 0x04010405,		"(Novell) Value DEVICE CONTROL FORM FEED" },
	{ 0x04010406,		"(Novell) Value DEVICE CONTROL CONTINUE" },
	{ 0x04010407,		"(Novell) Value DEVICE CONTROL REFRESH INFORMATION" },
	{ 0x04010500,		"(Novell) Value OUTPUT BIN MAIN" },
	{ 0x04010501,		"(Novell) Value OUTPUT BIN MAIL BOX 1" },
	{ 0x04010502,		"(Novell) Value OUTPUT BIN MAIL BOX 2" },
	{ 0x04010503,		"(Novell) Value OUTPUT BIN MAIL BOX 3" },
	{ 0x04010504,		"(Novell) Value OUTPUT BIN MAIL BOX 4" },
	{ 0x04010505,		"(Novell) Value OUTPUT BIN MAIL BOX 5" },
	{ 0x04010506,		"(Novell) Value OUTPUT BIN MAIL BOX 6" },
	{ 0x04010507,		"(Novell) Value OUTPUT BIN MAIL BOX 7" },
	{ 0x04010508,		"(Novell) Value OUTPUT BIN MAIL BOX 8" },
	{ 0x04010509,		"(Novell) Value OUTPUT BIN MAIL BOX 9" },
	{ 0x0401050A,		"(Novell) Value OUTPUT BIN MAIL BOX 10" },
	{ 0x0401050B,		"(Novell) Value OUTPUT BIN MAIL BOX 11" },
	{ 0x0401050C,		"(Novell) Value OUTPUT BIN MAIL BOX 12" },
	{ 0x0401050D,		"(Novell) Value OUTPUT BIN MAIL BOX 13" },
	{ 0x0401050E,		"(Novell) Value OUTPUT BIN MAIL BOX 14" },
	{ 0x0401050F,		"(Novell) Value OUTPUT BIN MAIL BOX 15" },
	{ 0x04010600,		"(Novell) Value INPUT TRAY FRONT" },
	{ 0x04010601,		"(Novell) Value INPUT TRAY BACK" },
	{ 0x04010602,		"(Novell) Value INPUT TRAY MULTI PURPOSE" },
	{ 0x04010603,		"(Novell) Value INPUT TRAY SECONDARY" },
	{ 0x04010604,		"(Novell) Value INPUT TRAY 1" },
	{ 0x04010605,		"(Novell) Value INPUT TRAY 2" },
	{ 0x04010606,		"(Novell) Value INPUT TRAY 3" },
	{ 0x04010607,		"(Novell) Value INPUT TRAY 4" },
	{ 0x04010608,		"(Novell) Value INPUT TRAY 5" },
	{ 0x04010609,		"(Novell) Value INPUT TRAY 6" },
	{ 0x0401060A,		"(Novell) Value INPUT TRAY 7" },
	{ 0x0401060B,		"(Novell) Value INPUT TRAY 8" },
	{ 0x0401060C,		"(Novell) Value INPUT TRAY 9" },
	{ 0x0401060D,		"(Novell) Value INPUT TRAY 10" },
	{ 0x04010700,		"(Novell) Value MEDIUM 8X10" },
	{ 0x04010701,		"(Novell) Value MEDIUM SPFOLIO" },
	{ 0x04010702,		"(Novell) Value MEDIUM FOOLSCAP" },
	{ 0x04010800,		"(Novell) Value MEDIUM TYPE STANDARD" },
	{ 0x04010801,		"(Novell) Value MEDIUM TYPE CARD STOCK" },
	{ 0x04010802,		"(Novell) Value MEDIUM TYPE BOND" },
	{ 0x04010803,		"(Novell) Value MEDIUM TYPE LETTERHEAD" },
	{ 0x04010804,		"(Novell) Value MEDIUM TYPE GLOSSY" },
	{ 0x04010805,		"(Novell) Value MEDIUM TYPE CLAY BASED" },
	{ 0x04010806,		"(Novell) Value MEDIUM TYPE SPECIAL" },
	{ 0x04010900,		"(Novell) Value MSTATE INITIALIZING" },
	{ 0x04010901,		"(Novell) Value MSTATE ACTIVE" },
	{ 0x04010902,		"(Novell) Value MSTATE TERMINATING" },
	{ 0x04010903,		"(Novell) Value MSTATE DOWN" },
	{ 0x04010A00,		"NOTIFY METHOD ID POP UP" },
	{ 0x04010A01,		"NOTIFY METHOD ID SPX PROGRAM" },
	{ 0x04010A02,		"NOTIFY METHOD ID TIRPC PROGRAM" },
	{ 0x04010A03,		"NOTIFY METHOD ID LOG FILE" },
	{ 0x04010A04,		"NOTIFY METHOD ID MHS EMAIL" },
	{ 0x04010A05,		"NOTIFY METHOD ID GROUPWISE EMAIL" },
	{ 0x04010A06,		"NOTIFY METHOD ID WINSOCK PROGRAM" },
	{ 0x04010A07,		"NOTIFY METHOD ID PROGRAM" },
	{ 0x04010A08,		"NOTIFY METHOD ID DIRECT POP UP" },
	{ 0x04010A09,		"NOTIFY METHOD ID SMTP EMAIL" },
	{ 0x04010A0A,		"NOTIFY METHOD ID INDP" },
	{ 0x04010B00,		"(Novell) Value  REASONS OPER HOLD SET" },
	{ 0x04010B01,		"(Novell) Value  REASONS JOB START TIMEOUT" },
	{ 0x04010B02,		"(Novell) Value  REASONS JOB ACCOUNTING HOLD" },
	{ 0x04010C00,		"(Novell) Value  DEVICE PRINTER NORMAL" },
	{ 0x04010C01,		"(Novell) Value  DEVICE PRINTER BUSY" },
	{ 0x04010C02,		"(Novell) Value  DEVICE PRINTER NON CRITICAL" },
	{ 0x04010C03,		"(Novell) Value  DEVICE PRINTER CRITICAL" },
	{ 0x04010C04,		"(Novell) Value  DEVICE PRINTER UNAVAILABLE" },
	{ 0x04010C05,		"(Novell) Value  DEVICE PRINTER MOV OFF" },
	{ 0x04010C06,		"(Novell) Value  DEVICE PRINTER OFFLINE" },
	{ 0x04010C07,		"(Novell) Value  DEVICE PRINTER MOV ON" },
	{ 0x04010C08,		"(Novell) Value  DEVICE PRINTER STANDBY" },
	{ 0x04020100,		"(Novell) Object Class NDS MANAGER" },
	{ 0x04020101,		"(Novell) Object Class NDS BROKER" },
	{ 0x04020200,		"(Novell) Object Class NDS PRINTER" },
	{ 0x04020301,		"(Novell) Attribute NDS DEFAULT C A P" },
	{ 0x04020302,		"(Novell) Attribute NDS DEFAULT P A P" },
	{ 0x04020303,		"(Novell) Attribute NDS INSTALL C A P" },
	{ 0x04020304,		"(Novell) Attribute NDS INSTALL P A P" },
	{ 0x04020305,		"(Novell) Attribute NDS INSTALL T S" },
	{ 0x04020306,		"(Novell) Attribute NDS INSTALL F F" },
	{ 0x04020307,		"(Novell) Attribute NDS INSTALL FS" },
	{ 0x04020601,		"(Novell) Attribute NDS GROUP MEMBERSHIP" },
	{ 0x0,			NULL },
};

static const value_string object_ids_13[] = { /* 060D6086 480186 (LENGTH 13)*/
    /* These values are 0xF8370104+(defined number)*/
	{ 0x00000000,		"(Novell) Attribute OBJECT CLASS" },
	{ 0x00000001,		"(Novell) Attribute DESCRIPTOR" },
	{ 0x00000002,		"(Novell) Attribute DESCRIPTIVE NAME" },
	{ 0x00000004,		"(Novell) Attribute STATE" },
	{ 0x00000005,		"(Novell) Attribute MESSAGE" },
	{ 0x00000006,		"(Novell) Attribute AVAILABILITY" },
	{ 0x00000007,		"(Novell) Attribute LIST OF MANAGERS" },
	{ 0x00000008,		"(Novell) Attribute JOB ATTRIBUTES SUPPORTED" },
	{ 0x00000009,		"(Novell) Attribute DOCUMENT ATTRIBUTES SUPPORTED" },
	{ 0x0000000A,		"(Novell) Attribute LOGGING PROFILE" },
	{ 0x0000000C,		"(Novell) Attribute ASSOCIATED SERVER" },
	{ 0x00000200,		"(Novell) Attribute NOTIFICATION PROFILE" },
	{ 0x00000201,		"(Novell) Attribute ERROR CODE" },
	{ 0x00000202,		"(Novell) Attribute IPP USER NAME" },
	{ 0x00000203,		"(Novell) Attribute NATURAL LANGUAGE" },
	{ 0x00000204,		"(Novell) Attribute CHARACTER SET" },
	{ 0x00000205,		"(Novell) Attribute FINISHING PROCESS" },
	{ 0x00000206,		"(Novell) Attribute CLIENT ADDRESS" },
	{ 0x00000207,		"(Novell) Attribute XRI SUPPORTED" },
	{ 0x00000208,		"(Novell) Attribute SOURCE ADDRESS" },
	{ 0x00010001,		"(Novell) Attribute JOB NAME" },
	{ 0x00010002,		"(Novell) Attribute JOB ORIGINATOR" },
	{ 0x00010003,		"(Novell) Attribute JOB OWNER" },
	{ 0x00010004,		"(Novell) Attribute JOB COMMENT" },
	{ 0x00010007,		"(Novell) Attribute JOB CLIENT ID" },
	{ 0x00010008,		"(Novell) Attribute JOB NON COMPULSARY ATTRIBUTES" },
	{ 0x0001000F,		"(Novell) Attribute RESULTS PROFILE" },
	{ 0x00010010,		"(Novell) Attribute JOB FINISHING" },
	{ 0x00010016,		"(Novell) Attribute JOB ABORT CRITERIA" },
	{ 0x00010017,		"(Novell) Attribute JOB WARNING CRITERIA" },
	{ 0x00010018,		"(Novell) Attribute DOCUMENT ABORT CRITERIA" },
	{ 0x0001001E,		"(Novell) Attribute JOB START WAIT" },
	{ 0x0001001F,		"(Novell) Attribute JOB END WAIT" },
	{ 0x00010020,		"(Novell) Attribute JOB HOLD" },
	{ 0x00010021,		"(Novell) Attribute JOB PASSWORD" },
	{ 0x00010022,		"(Novell) Attribute JOB PRINT AFTER" },
	{ 0x00010023,		"(Novell) Attribute JOB PRIORITY" },
	{ 0x00010024,		"(Novell) Attribute JOB DEADLINE TIME" },
	{ 0x00010025,		"(Novell) Attribute JOB DISCARD TIME" },
	{ 0x00010026,		"(Novell) Attribute JOB RETENTION PERIOD" },
	{ 0x00010027,		"(Novell) Attribute JOB MSG TO OPERATOR" },
	{ 0x00010028,		"(Novell) Attribute JOB SCHEDULING" },
	{ 0x00010029,		"(Novell) Attribute JOB VALIDATE" },
	{ 0x0001002B,		"(Novell) Attribute PRINTER NAME REQUESTED" },
	{ 0x0001002C,		"(Novell) Attribute PRINTER LOCATIONS REQUESTED" },
	{ 0x0001002D,		"(Novell) Attribute PRINTER MODELS REQUESTED" },
	{ 0x0001002F,		"(Novell) Attribute PRINTER SPEED RANGE REQUESTED" },
	{ 0x00010078,		"(Novell) Attribute USER NAME" },
	{ 0x00010200,		"(Novell) Attribute JOB FORM FEED REQUESTED" },
	{ 0x00010201,		"(Novell) Attribute JOB BANNER REQUESTED" },
	{ 0x00010202,		"(Novell) Attribute JOB OPERATOR HOLD" },
	{ 0x00010203,		"(Novell) Attribute JOB PRINTER OBJECT ID" },
	{ 0x00010204,		"(Novell) Attribute JOB ID" },
	{ 0x00010205,		"(Novell) Attribute JOB START MESSAGE" },
	{ 0x00010206,		"(Novell) Attribute JOB END MESSAGE" },
	{ 0x00010207,		"(Novell) Attribute ACCOUNTING INFORMATION" },
	{ 0x00010208,		"(Novell) Attribute ESTIMATED COMPLETION TIME" },
	{ 0x00010209,		"(Novell) Attribute ASSIGNED PORTS STATES" },
	{ 0x0001020A,		"(Novell) Attribute PRINTER TYPES REQUESTED" },
	{ 0x0001020B,		"(Novell) Attribute JOB CONTROL LANGUAGE" },
	{ 0x0001020C,		"(Novell) Attribute JOB COPIES OCTETS" },
	{ 0x0001020D,		"(Novell) Attribute JOB COST" },
	{ 0x0001020E,		"(Novell) Attribute JOB HOLD UNTIL" },
	{ 0x0001020F,		"(Novell) Attribute IPP JOB NAME" },
	{ 0x00010210,		"(Novell) Attribute AUDITING JOB PDL" },
	{ 0x00020000,		"(Novell) Attribute DEFAULT CHARACTER SET" },
	{ 0x00020001,		"(Novell) Attribute DEFAULT CHARACTER MAPPING" },
	{ 0x00020002,		"(Novell) Attribute DEFAULT FONT" },
	{ 0x00020003,		"(Novell) Attribute DEFAULT CHARACTER REPERTOIR" },
	{ 0x00020006,		"(Novell) Attribute DEFAULT RESOURCES" },
	{ 0x00020007,		"(Novell) Attribute DEFAULT PRINTER RESOLUTION" },
	{ 0x00020008,		"(Novell) Attribute DEFAULT RESOLUTIONS USED" },
	{ 0x0002000C,		"(Novell) Attribute NEW LINE OPTION" },
	{ 0x0002000D,		"(Novell) Attribute CARRIAGE CONTROL TYPE" },
	{ 0x0002000E,		"(Novell) Attribute TABLE REFERENCE CHARACTER" },
	{ 0x0002000F,		"(Novell) Attribute SHIFT OUT SHIFT IN" },
	{ 0x00020014,		"(Novell) Attribute DOCUMENT STATE" },
	{ 0x00020015,		"(Novell) Attribute COPIES COMPLETED" },
	{ 0x00020032,		"(Novell) Attribute FONT SUBSTITUTION" },
	{ 0x00020033,		"(Novell) Attribute MEDIUM SUBSTITUTION" },
	{ 0x0002003B,		"(Novell) Attribute MEDIUM FIDELITY" },
	{ 0x0002003D,		"(Novell) Attribute SIDES" },
	{ 0x0002003E,		"(Novell) Attribute PAGE SELECT" },
	{ 0x0002003F,		"(Novell) Attribute PAGE MEDIA SELECT" },
	{ 0x00020040,		"(Novell) Attribute COPY COUNT" },
	{ 0x00020044,		"(Novell) Attribute RESET PRINTER" },
	{ 0x00020045,		"(Novell) Attribute BINDING EDGE" },
	{ 0x00020046,		"(Novell) Attribute BINDING EDGE IMAGE SHIFT" },
	{ 0x00020047,		"(Novell) Attribute NUMBER UP" },
	{ 0x00020048,		"(Novell) Attribute PLEX" },
	{ 0x00020049,		"(Novell) Attribute X IMAGE SHIFT" },
	{ 0x0002004A,		"(Novell) Attribute Y IMAGE SHIFT" },
	{ 0x00020050,		"(Novell) Attribute TRANSFER METHOD" },
	{ 0x00020052,		"(Novell) Attribute DOCUMENT SEQUENCE NUMBER" },
	{ 0x00020053,		"(Novell) Attribute DOCUMENT CONTENT" },
	{ 0x00020054,		"(Novell) Attribute FILE REFERENCE" },
	{ 0x00020055,		"(Novell) Attribute DOCUMENT TYPE" },
	{ 0x00020057,		"(Novell) Attribute RESOURCE CONTEXT" },
	{ 0x00020058,		"(Novell) Attribute NON COMPULSORY ATTRIBUTES" },
	{ 0x00020059,		"(Novell) Attribute DOCUMENT FILE NAME" },
	{ 0x0002005A,		"(Novell) Attribute DOCUMENT NAME" },
	{ 0x0002005B,		"(Novell) Attribute DOCUMENT AUTHORS" },
	{ 0x0002005C,		"(Novell) Attribute DOCUMENT COMMENT" },
	{ 0x0002005D,		"(Novell) Attribute DOCUMENT REVISION DATE" },
	{ 0x0002005F,		"(Novell) Attribute PAGE ORDER RECEIVED" },
	{ 0x00020061,		"(Novell) Attribute PAGE SIZE" },
	{ 0x00020062,		"(Novell) Attribute CONTENT ORIENTATION" },
	{ 0x00020064,		"(Novell) Attribute CHARACTER SETS USED" },
	{ 0x00020065,		"(Novell) Attribute CHARACTER MAPPINGS USED" },
	{ 0x00020066,		"(Novell) Attribute FONTS USED" },
	{ 0x00020067,		"(Novell) Attribute CHARACTER REPERTOIRES USED" },
	{ 0x00020068,		"(Novell) Attribute MEDIA USED" },
	{ 0x0002006A,		"(Novell) Attribute OCTET COUNT" },
	{ 0x0002006B,		"(Novell) Attribute PAGE COUNT" },
	{ 0x0002006C,		"(Novell) Attribute GLYPH COUNT" },
	{ 0x0002006D,		"(Novell) Attribute FONT COUNT" },
	{ 0x0002006E,		"(Novell) Attribute FONT CHANGE COUNT" },
	{ 0x0002006F,		"(Novell) Attribute MAXIMUM FONTS PER PAGE" },
	{ 0x00020070,		"(Novell) Attribute PERCENT GRAPHICS" },
	{ 0x00020071,		"(Novell) Attribute PERCENT IMAGES" },
	{ 0x00020073,		"(Novell) Attribute PRESENT DIRECTORIES USED" },
	{ 0x00020076,		"(Novell) Attribute RESOURCES USED" },
	{ 0x00020201,		"(Novell) Attribute FINISHING" },
	{ 0x00020202,		"(Novell) Attribute OUTPUT METHOD" },
	{ 0x00020203,		"(Novell) Attribute PRINT QUALITY" },
	{ 0x00020204,		"(Novell) Attribute DEFAULT MEDIUM" },
	{ 0x00020205,		"(Novell) Attribute DEFAULT INPUT TRAY" },
	{ 0x00020206,		"(Novell) Attribute INPUT TRAYS USED" },
	{ 0x00020207,		"(Novell) Attribute INPUT TRAY SELECT" },
	{ 0x00020208,		"(Novell) Attribute DOCUMENT PDL" },
	{ 0x00030002,		"(Novell) Attribute PRINTER LOCATIONS" },
	{ 0x00030003,		"(Novell) Attribute PRINTER MODEL" },
	{ 0x00030005,		"(Novell) Attribute PRINTER REALIZATION" },
	{ 0x00030015,		"(Novell) Attribute MEDIA SUPPORTED" },
	{ 0x00030016,		"(Novell) Attribute MEDIA READY" },
	{ 0x0003001B,		"(Novell) Attribute FINISHINGS SUPPORTED" },
	{ 0x0003001C,		"(Novell) Attribute FINISHINGS READY" },
	{ 0x00030027,		"(Novell) Attribute PRINT QUALITIES SUPPORTED" },
	{ 0x00030028,		"(Novell) Attribute PRINT QUALITIES READY" },
	{ 0x00030032,		"(Novell) Attribute CHARACTER SETS SUPPORTED" },
	{ 0x00030033,		"(Novell) Attribute CHARACTER SETS READY" },
	{ 0x00030035,		"(Novell) Attribute CHARACTER MAPPINGS SUPPORTED" },
	{ 0x00030036,		"(Novell) Attribute CHARACTER MAPPINGS READY" },
	{ 0x00030038,		"(Novell) Attribute CHARACTER REPRTIOR SUPPORTED" },
	{ 0x00030039,		"(Novell) Attribute CHARACTER REPRTIOR READY" },
	{ 0x0003003F,		"(Novell) Attribute PAGE SELECT SUPPORTED" },
	{ 0x00030049,		"(Novell) Attribute CONTENT ORIENTS SUPPORTED" },
	{ 0x0003004E,		"(Novell) Attribute SHEET COUNT" },
	{ 0x00030051,		"(Novell) Attribute PRESENT DIRECTORIES SUPPORTED" },
	{ 0x00030056,		"(Novell) Attribute PRINTER RESOURCE CONTEXT" },
	{ 0x00030058,		"(Novell) Attribute MEDIUM FIDEL SUPPORTED" },
	{ 0x0003005A,		"(Novell) Attribute PRINTER CONFIGURATION LEVEL RANGE" },
	{ 0x0003005B,		"(Novell) Attribute PRINTER CONFIGURATION CATEGORY SETS" },
	{ 0x0003005C,		"(Novell) Attribute PRINTER CONFIGURATION POLICY" },
	{ 0x0003005D,		"(Novell) Attribute PRINTER INTG LEVEL RANGE" },
	{ 0x0003005E,		"(Novell) Attribute PRINTER INTG CATEGORY SETS" },
	{ 0x0003005F,		"(Novell) Attribute PRINTER INTG POLICY" },
	{ 0x00030060,		"(Novell) Attribute PRINTER SECURITY LABEL POLICY" },
	{ 0x00030067,		"(Novell) Attribute NEW LINE OPTIONS SUPPORTED" },
	{ 0x00030068,		"(Novell) Attribute CC TYPES SUPPORTED" },
	{ 0x0003006A,		"(Novell) Attribute SHIFT OUT SHIFT IN SUPPORTED" },
	{ 0x0003006B,		"(Novell) Attribute INPUT TRAYS MEDIUM" },
	{ 0x00030200,		"(Novell) Attribute PRINTER ID" },
	{ 0x00030201,		"(Novell) Attribute PRINTER STATE REASONS" },
	{ 0x00030202,		"(Novell) Attribute PREVIOUS PRINTER STATE" },
	{ 0x00030203,		"(Novell) Attribute JOB POOL" },
	{ 0x00030204,		"(Novell) Attribute PDS EXECUTE AND PARAMETERS" },
	{ 0x00030205,		"(Novell) Attribute PRINT HANDLER EXECUTE AND PARAMETERS" },
	{ 0x00030206,		"(Novell) Attribute PDS STATE" },
	{ 0x00030209,		"(Novell) Attribute SCHEDULERS SUPPORTED" },
	{ 0x0003020A,		"(Novell) Attribute SCHEDULER READY" },
	{ 0x0003020B,		"(Novell) Attribute PRINTER DATA POOL SIZE LIMIT" },
	{ 0x0003020C,		"(Novell) Attribute PRINTER RETAINED SIZE LIMIT" },
	{ 0x0003020E,		"(Novell) Attribute PRINTER MANAGER NAME" },
	{ 0x0003020F,		"(Novell) Attribute PRINTER VOLUME SIZE" },
	{ 0x00030210,		"(Novell) Attribute PRINTER VOLUME FREE SPACE" },
	{ 0x00030211,		"(Novell) Attribute PRINTER SHEET COUNT SINCE SERVICE" },
	{ 0x00030212,		"(Novell) Attribute PRINTER JOB COUNT SINCE SERVICE" },
	{ 0x00030213,		"(Novell) Attribute PRINTER CURRENT RESOURCE SERVICE" },
	{ 0x00030214,		"(Novell) Attribute PRINTER CURRENT NOTIFICATION SERVICE" },
	{ 0x00030215,		"(Novell) Attribute PRINTER MANUFACTURER" },
	{ 0x00030216,		"(Novell) Attribute PRINTER INITIALIZATION STRING" },
	{ 0x00030217,		"(Novell) Attribute PRINTER RESET STRING" },
	{ 0x00030218,		"(Novell) Attribute COLOR SUPPORTED" },
	{ 0x0003021A,		"(Novell) Attribute PRINTER CONTROL SNAP FSPEC" },
	{ 0x0003021B,		"(Novell) Attribute PRINTER PDS CONFIGURATION SNAP FSPEC " },
	{ 0x0003021C,		"(Novell) Attribute PRINTER PRINT HANDLER CONFIGURATION SNAP FSPEC" },
	{ 0x0003021D,		"(Novell) Attribute PRINTER RESOURCE PRINTER ID" },
	{ 0x0003021E,		"(Novell) Attribute PRINTER JOBS SCHEDULED" },
	{ 0x0003021F,		"(Novell) Attribute PRINTER JOBS ACTIVE" },
	{ 0x00030220,		"(Novell) Attribute PRINTER DATA POOL TOTAL KB" },
	{ 0x00030221,		"(Novell) Attribute PRINTER DATA POOL RETEN KB" },
	{ 0x00030222,		"(Novell) Attribute PRINTER PDS IDENTIFICATION" },
	{ 0x00030223,		"(Novell) Attribute PRINTER DEVICE ID" },
	{ 0x00030224,		"(Novell) Attribute PRINTER BANNERS SUPPORTED" },
	{ 0x00030226,		"(Novell) Attribute PRINTER PRIMARY NOTIFY SERVICE" },
	{ 0x00030227,		"(Novell) Attribute PRINTER PRIMARY RESOURCE SERVICE" },
	{ 0x00030228,		"(Novell) Attribute PRINTER NEEDS ATTENTION TIME" },
	{ 0x00030229,		"(Novell) Attribute PRINTER NEEDS OP ATTENTION TIME" },
	{ 0x0003022A,		"(Novell) Attribute PDLS SUPPORTED" },
	{ 0x0003022B,		"(Novell) Attribute PRINTER MAXIMUM SPEED UNIT" },
	{ 0x0003022C,		"(Novell) Attribute PRINTER MAXIMUM SPEED" },
	{ 0x0003022D,		"(Novell) Attribute PRINTER TRANSFER METHOD SUPPORTED" },
	{ 0x0003022E,		"(Novell) Attribute PDS ADDITIONAL PARAMETERS" },
	{ 0x0003022F,		"(Novell) Attribute PRINT HANDLER ADDITIONAL PARAMETERS" },
	{ 0x00030230,		"(Novell) Attribute PRINTER MAXIMUM RESOLUTION" },
	{ 0x00030231,		"(Novell) Attribute PRINTER JOB WAIT TIMEOUT" },
	{ 0x00030232,		"(Novell) Attribute PRINTER STATE SEVERITY" },
	{ 0x00030233,		"(Novell) Attribute PRINTER AGENT NAME" },
	{ 0x00030234,		"(Novell) Attribute PRINTER STATE" },
	{ 0x00030235,		"(Novell) Attribute FONTS SUPPORTED" },
	{ 0x00030236,		"(Novell) Attribute FONTS READY" },
	{ 0x0003023B,		"(Novell) Attribute SIDES SUPPORTED" },
	{ 0x0003023C,		"(Novell) Attribute SIDES READY" },
	{ 0x0003023D,		"(Novell) Attribute PRINTER RESOLUTIONS SUPPORTED" },
	{ 0x0003023E,		"(Novell) Attribute PRINTER ASSOCIATED PRINTS" },
	{ 0x0003023F,		"(Novell) Attribute PRINTERS READY" },
	{ 0x00030240,		"(Novell) Attribute DEFAULT INPUT DEVICE" },
	{ 0x00030241,		"(Novell) Attribute CONTROL LANGUAGE FAMILY" },
	{ 0x00030242,		"(Novell) Attribute DEVICE STATE" },
	{ 0x00030243,		"(Novell) Attribute PRINTER NAME ALIASES" },
	{ 0x00030244,		"(Novell) Attribute PRINTER MEMORY SIZE" },
	{ 0x00030245,		"(Novell) Attribute PRINTER TYPES" },
	{ 0x00030246,		"(Novell) Attribute PRINTER JOB COMPLETION EVALUATION ATTRIBUTES" },
	{ 0x00030247,		"(Novell) Attribute PREVIOUS PA NAMES" },
	{ 0x00030248,		"(Novell) Attribute PRINTER OBJECT QUEUES" },
	{ 0x00030249,		"(Novell) Attribute PRINTER OPERATIONS SUPPORTED" },
	{ 0x0003024A,		"(Novell) Attribute PRINTER JOB ACCOUNTING ATTRIBUTES" },
	{ 0x0003024B,		"(Novell) Attribute ACCOUNTING EXECUTE AND PARAMETERS" },
	{ 0x0003024C,		"(Novell) Attribute PRINTER SECURITY LEVEL" },
	{ 0x0003024D,		"(Novell) Attribute PRINTER STARTUP TIME" },
	{ 0x0003024E,		"(Novell) Attribute IPP ENABLED" },
	{ 0x0003024F,		"(Novell) Attribute LPR ENABLED" },
	{ 0x00030250,		"(Novell) Attribute MULTIPLE DOCUMENTS SUPPORTED" },
	{ 0x00030251,		"(Novell) Attribute LPR ACCESS FILTER" },
	{ 0x00030252,		"(Novell) Attribute LPR CONFIGURED TIME" },
	{ 0x00030253,		"(Novell) Attribute LPR HOST NAME" },
	{ 0x00030254,		"(Novell) Attribute PRINTER AGENT ADDRESS" },
	{ 0x00030255,		"(Novell) Attribute URI SUPPORTED" },
	{ 0x00030256,		"(Novell) Attribute PRINTER PRF RESOURCE SERVICES" },
	{ 0x00030257,		"(Novell) Attribute PRINTER MAXIMUM SPEED COLOR" },
	{ 0x00030258,		"(Novell) Attribute LAST JOB NUMBER" },
	{ 0x00030259,		"(Novell) Attribute DEVICE URI" },
	{ 0x0003025A,		"(Novell) Attribute DEVICE ADDRESS" },
	{ 0x0003025B,		"(Novell) Attribute LPR DATA FILTER" },
	{ 0x0003025C,		"(Novell) Attribute IPP SECURITY CONFIGURED" },
	{ 0x0003025D,		"(Novell) Attribute INITIAL PROFILE ID" },
	{ 0x0003025E,		"(Novell) Attribute PRINTER XRI" },
	{ 0x0003025F,		"(Novell) Attribute MESSAGE FROM ADMIN" },
	{ 0x00030260,		"(Novell) Attribute PRINTER CURRENT NOTIFICATION SERVICE ADDRESS" },
	{ 0x00030261,		"(Novell) Attribute PRINTER CURRENT RSRC SERVICE ADDRESS" },
	{ 0x00030262,		"(Novell) Attribute LAST JOB COMPLETE TIME" },
	{ 0x00030263,		"(Novell) Attribute PRINTER ENERGY STATE" },
	{ 0x00030264,		"(Novell) Attribute PRINTER AUDITING LEVEL" },
	{ 0x00030265,		"(Novell) Attribute PRINTER PAGE COUNT" },
	{ 0x00040000,		"(Novell) Attribute MEDIUM IDENTIFIER" },
	{ 0x00040003,		"(Novell) Attribute MEDIUM TYPE" },
	{ 0x00040004,		"(Novell) Attribute MEDIUM SIZE" },
	{ 0x00040005,		"(Novell) Attribute MEDIUM DIMENSIONS" },
	{ 0x00040006,		"(Novell) Attribute MEDIUM COLOR" },
	{ 0x00040007,		"(Novell) Attribute MEDIUM TOOTH" },
	{ 0x00040008,		"(Novell) Attribute MEDIUM GRAIN" },
	{ 0x00040009,		"(Novell) Attribute MEDIUM SIDES" },
	{ 0x0004000A,		"(Novell) Attribute MEDIUM WEIGHT" },
	{ 0x0004000B,		"(Novell) Attribute MEDIUM ASSURE REP AREA" },
	{ 0x0004000C,		"(Novell) Attribute MEDIUM ASSOCIATED MEDIA" },
	{ 0x0004000D,		"(Novell) Attribute MEDIUM REALIZATION" },
	{ 0x0004000F,		"(Novell) Attribute MEDIUM FORM PARTS" },
	{ 0x00040014,		"(Novell) Attribute MEDIUM HOLES COUNT" },
	{ 0x00040015,		"(Novell) Attribute MEDIUM HOLES REFERENCE EDGE" },
	{ 0x00040016,		"(Novell) Attribute MEDIUM HOLES AXIS OFF" },
	{ 0x00040017,		"(Novell) Attribute MEDIUM HOLES LOCATIONS" },
	{ 0x00040018,		"(Novell) Attribute MEDIUM HOLES DIAMETER" },
	{ 0x00050000,		"(Novell) Attribute FONT IDENTIFIER" },
	{ 0x00060000,		"(Novell) Attribute TRANSFER METHOD ID" },
	{ 0x00060001,		"(Novell) Attribute TRANSFER METHOD TYPE" },
	{ 0x00060002,		"(Novell) Attribute DOCUMENT REFERENCE TYPE" },
	{ 0x00070000,		"(Novell) Attribute DELIVERY METHOD ID" },
	{ 0x00080000,		"(Novell) Attribute AUXILIARY SHEET ID" },
	{ 0x00080001,		"(Novell) Attribute AUXILIARY SHEET MEDIUM" },
	{ 0x00090000,		"(Novell) Attribute FINISHING IDENTIFIER" },
	{ 0x00090001,		"(Novell) Attribute FINISHING ASSOCIATED FINISHINGS " },
	{ 0x00090002,		"(Novell) Attribute FINISHING REALIZATION" },
	{ 0x00090003,		"(Novell) Attribute FINISHING SPECIFICATION" },
	{ 0x000B0000,		"(Novell) Attribute IMPOSITION IDENTIFIER" },
	{ 0x000B0007,		"(Novell) Attribute LOGICAL PAGE ORIGIN" },
	{ 0x000B0008,		"(Novell) Attribute LOGICAL PAGE X OFFSET" },
	{ 0x000B0009,		"(Novell) Attribute LOGICAL PAGE Y OFFSET" },
	{ 0x000B000A,		"(Novell) Attribute LOGICAL PAGE SCALING" },
	{ 0x000B000C,		"(Novell) Attribute IMPOSITION NOT UP" },
	{ 0x000C0200,		"(Novell) Attribute SCHEDULER ID" },
	{ 0x000C0201,		"(Novell) Attribute SCHEDULER EXECUTE NAME" },
	{ 0x000C0202,		"(Novell) Attribute SCHEDULER EXECUTE PARAMETERS" },
	{ 0x000E0000,		"(Novell) Attribute RESOURCE NAME" },
	{ 0x000E0001,		"(Novell) Attribute RESOURCE TYPE" },
	{ 0x000F0200,		"(Novell) Attribute INPUT ID" },
	{ 0x000F0201,		"(Novell) Attribute INPUT LOCATION" },
	{ 0x000F0202,		"(Novell) Attribute INPUT CURRENT MEDIUM" },
	{ 0x00100200,		"(Novell) Attribute OUTPUT ID" },
	{ 0x00100201,		"(Novell) Attribute OUTPUT LOCATION" },
	{ 0x00100202,		"(Novell) Attribute OUTPUT PAGE GROUPING" },
	{ 0x00110000,		"(Novell) Attribute AUXILIARY SHEET PACKAGE ID" },
	{ 0x00110001,		"(Novell) Attribute START SHEET OF SET" },
	{ 0x00110002,		"(Novell) Attribute SEPARATOR SHEET OF SET" },
	{ 0x00110003,		"(Novell) Attribute END SHEET OF SET" },
	{ 0x00110004,		"(Novell) Attribute START SHEET OF COPY" },
	{ 0x00110005,		"(Novell) Attribute SEPERATOR SHEET OF COPY" },
	{ 0x00110006,		"(Novell) Attribute END SHEET OF COPY" },
	{ 0x00120200,		"(Novell) Attribute MANAGER NAME" },
	{ 0x00120201,		"(Novell) Attribute MANAGER STATE" },
	{ 0x00120202,		"(Novell) Attribute MANAGER DNS NAME" },
	{ 0x00120203,		"(Novell) Attribute IPP PORTS SUPPORTED" },
	{ 0x00120204,		"(Novell) Attribute MANAGER VERSION" },
	{ 0x00130200,		"(Novell) Attribute JOB DEFAULTS ID" },
	{ 0x00140200,		"(Novell) Attribute DOCUMENT DEFAULTS ID" },
	{ 0x00150200,		"(Novell) Attribute JOB LIMITS ID" },
	{ 0x00160200,		"(Novell) Attribute DOCUMENT LIMITS ID" },
	{ 0x00170200,		"(Novell) Attribute ABSTRACT EVENT ID" },
	{ 0x00170201,		"(Novell) Attribute ALERT OTHER" },
	{ 0x00170202,		"(Novell) Attribute ALERT UNKNOWN" },
	{ 0x00170203,		"(Novell) Attribute ALERT COVER OPEN" },
	{ 0x00170204,		"(Novell) Attribute ALERT COVER CLOSED" },
	{ 0x00170205,		"(Novell) Attribute ALERT INTERLOCK OPEN" },
	{ 0x00170206,		"(Novell) Attribute ALERT INTERLOCK CLOSED" },
	{ 0x00170207,		"(Novell) Attribute ALERT CONFIGURATION CHANGE" },
	{ 0x00170208,		"(Novell) Attribute ALERT JAM" },
	{ 0x00170209,		"(Novell) Attribute ALERT JAM CLEAR" },
	{ 0x0017020A,		"(Novell) Attribute ALERT SUBUNIT LIFE ALARM" },
	{ 0x0017020B,		"(Novell) Attribute ALERT SUBUNIT LIFE OVER" },
	{ 0x0017020C,		"(Novell) Attribute ALERT SUBUNIT ALARM EMPTY" },
	{ 0x0017020D,		"(Novell) Attribute ALERT SUBUNIT EMPTY" },
	{ 0x0017020E,		"(Novell) Attribute ALERT SUBUNIT ALARM FULL" },
	{ 0x0017020F,		"(Novell) Attribute ALERT SUBUNIT FULL" },
	{ 0x00170210,		"(Novell) Attribute ALERT SUBUNIT NEAR LIMIT" },
	{ 0x00170211,		"(Novell) Attribute ALERT SUBUNIT AT LIMIT" },
	{ 0x00170212,		"(Novell) Attribute ALERT SUBUNIT OPENED" },
	{ 0x00170213,		"(Novell) Attribute ALERT SUBUNIT CLOSED" },
	{ 0x00170214,		"(Novell) Attribute ALERT SUBUNIT TURN ON" },
	{ 0x00170215,		"(Novell) Attribute ALERT SUBUNIT TURN OFF" },
	{ 0x00170216,		"(Novell) Attribute ALERT SUBUNIT OFFLINE" },
	{ 0x00170217,		"(Novell) Attribute ALERT SUBUNIT POWER SAVE" },
	{ 0x00170218,		"(Novell) Attribute ALERT SUBUNIT WARM UP" },
	{ 0x00170219,		"(Novell) Attribute ALERT SUBUNIT ADDED" },
	{ 0x0017021A,		"(Novell) Attribute ALERT SUBUNIT REMOVED" },
	{ 0x0017021B,		"(Novell) Attribute ALERT SUBUNIT RESOURCE ADD" },
	{ 0x0017021C,		"(Novell) Attribute ALERT SUBUNIT RESOURCE REMOVED" },
	{ 0x0017021D,		"(Novell) Attribute ALERT SUBUNIT REC FAIL" },
	{ 0x0017021E,		"(Novell) Attribute ALERT SUBUNIT UNR FAIL" },
	{ 0x0017021F,		"(Novell) Attribute ALERT SUBUNIT R S ERR" },
	{ 0x00170220,		"(Novell) Attribute ALERT SUBUNIT UR S ERR" },
	{ 0x00170221,		"(Novell) Attribute ALERT SUBUNIT MTR FAIL" },
	{ 0x00170222,		"(Novell) Attribute ALERT SUBUNIT MEMORY EXHAUSTED" },
	{ 0x00170223,		"(Novell) Attribute ALERT SUBUNIT UNDER TEMPERATURE" },
	{ 0x00170224,		"(Novell) Attribute ALERT SUBUNIT OVER TEMPERATURE" },
	{ 0x00170225,		"(Novell) Attribute ALERT SUBUNIT TIME FAIL" },
	{ 0x00170226,		"(Novell) Attribute ALERT SUBUNIT THERMAL FAILURE" },
	{ 0x00170264,		"(Novell) Attribute ALERT JOB START WAIT" },
	{ 0x00170265,		"(Novell) Attribute ALERT JOB END WAIT" },
	{ 0x00170267,		"(Novell) Attribute ALERT JOB HELD USER" },
	{ 0x00170268,		"(Novell) Attribute ALERT JOB USER HOLD REMOVE" },
	{ 0x00170269,		"(Novell) Attribute ALERT JOB HELD OPERATORE" },
	{ 0x0017026A,		"(Novell) Attribute ALERT JOB OPERATOR HOLD REMOVE" },
	{ 0x0017026B,		"(Novell) Attribute ALERT JOB CREATED" },
	{ 0x0017026C,		"(Novell) Attribute ALERT JOB REORDERED" },
	{ 0x0017026D,		"(Novell) Attribute ALERT JOB COMPLETE BRIEF" },
	{ 0x0017026E,		"(Novell) Attribute ALERT JOB STATE CHANGED" },
	{ 0x0017026F,		"(Novell) Attribute ALERT JOB CONFIGURATION CHANGED" },
	{ 0x00170270,		"(Novell) Attribute ALERT JOB PROGRESS" },
	{ 0x00190200,		"(Novell) Attribute MARKER ID" },
	{ 0x001A0200,		"(Novell) Attribute MEDIA PATH ID" },
	{ 0x001B0200,		"(Novell) Attribute CHANNEL ID" },
	{ 0x001C0200,		"(Novell) Attribute INTERPRETER ID" },
	{ 0x001C0201,		"(Novell) Attribute PRTINTERPFEEDRES" },
	{ 0x001C0202,		"(Novell) Attribute PRTINTERPXFEEDRES" },
	{ 0x001E0200,		"(Novell) Attribute MARKER SUPPLIES ID" },
	{ 0x001F0200,		"(Novell) Attribute MARKER COLORANT ID" },
	{ 0x00200200,		"(Novell) Attribute COVER ID" },
	{ 0x00210200,		"(Novell) Attribute LIGHT ID" },
	{ 0x00220200,		"(Novell) Attribute BUFFER ID" },
	{ 0x00250200,		"(Novell) Attribute FINISHER DEVICE ID" },
	{ 0x00260200,		"(Novell) Attribute FINISHER SUPPLY ID" },
	{ 0x00260201,		"(Novell) Attribute FINISHER SUPPLY DEVICE ID" },
	{ 0x00270200,		"(Novell) Attribute PRINTER POOL ID" },
	{ 0x00270201,		"(Novell) Attribute PRINTER POOL NAME" },
	{ 0x00270202,		"(Novell) Attribute POOL LAST JOB NUMBER" },
	{ 0x00270203,		"(Novell) Attribute PRINTER POOL PA NAME" },
	{ 0x02008100,		"(Novell) Attribute NDS COMMON NAME" },
	{ 0x02008101,		"(Novell) Attribute NDS DESCRIPTION" },
	{ 0x02008102,		"(Novell) Attribute NDS LOCALITY NAME" },
	{ 0x02008103,		"(Novell) Attribute NDS NETWORK ADDRESS" },
	{ 0x02008104,		"(Novell) Attribute NDS ORGANIZATION" },
	{ 0x02008105,		"(Novell) Attribute NDS ORGANIZATIONAL UNIT" },
	{ 0x02008106,		"(Novell) Attribute NDS SEE ALSO" },
	{ 0x02008107,		"(Novell) Attribute NDS CLASS NAME" },
	{ 0x02008108,		"(Novell) Attribute NDS GUID" },
	{ 0x02010000,		"(Novell) Attribute NDS PRINTER TO PA ID MAPS" },
	{ 0x02010001,		"(Novell) Attribute NDS DATAPOOL LOCATIONS" },
	{ 0x02010002,		"(Novell) Attribute NDS DB VOLUME NAME" },
	{ 0x02010003,		"(Novell) Attribute NDS MANAGER STATUS" },
	{ 0x02010004,		"(Novell) Attribute NDS DATABASE DIRECTORY PATH" },
	{ 0x02010100,		"(Novell) Attribute NDS DELIVERY METHODS INSTALLED" },
	{ 0x02010101,		"(Novell) Attribute NDS MHS SEND DIRECTORY PATH" },
	{ 0x02010102,		"(Novell) Attribute NDS MHS SEND DIRECTORY VOLUME" },
	{ 0x02010103,		"(Novell) Attribute NDS NOTIFY SERVICE ENABLED" },
	{ 0x02010104,		"(Novell) Attribute NDS REGISTERED ADVERTISING NAME" },
	{ 0x02010105,		"(Novell) Attribute NDS REGISTERED SERVICE ENABLED" },
	{ 0x02010106,		"(Novell) Attribute NDS RESOURCE MANAGEMENT SERVICE ENABLED" },
	{ 0x02010107,		"(Novell) Attribute NDS RESOURCE MANAGER DATABASE PATH" },
	{ 0x02010108,		"(Novell) Attribute NDS RESOURCE MANAGER DATABASE VOLUME" },
	{ 0x02010109,		"(Novell) Attribute NDS NOTIFY NETWORK ADDRESS" },
	{ 0x0201010A,		"(Novell) Attribute NDS REGISTERED NETWORK ADDRESS" },
	{ 0x0201010B,		"(Novell) Attribute NDS RESOURCE NETWORK ADDRESS" },
	{ 0x0201010C,		"(Novell) Attribute NDS GROUPWISE APIGW DIRECTORY PATH" },
	{ 0x0201010D,		"(Novell) Attribute NDS GROUPWISE APIGW DIRECTORY VOLUME" },
	{ 0x0201010E,		"(Novell) Attribute NDS NOTIFY NETWORK ADDRESS" },
	{ 0x0201010F,		"(Novell) Attribute NDS REGISTERED NETWORK ADDRESS" },
	{ 0x02010110,		"(Novell) Attribute NDS RESOURCE NETWORK ADDRESS" },
	{ 0x02010111,		"(Novell) Attribute NDS SMTP SERVER" },
	{ 0x02018300,		"(Novell) Attribute NDS ACCOUNT BALANCE" },
	{ 0x02018301,		"(Novell) Attribute NDS ALLOW UNLIMITED" },
	{ 0x02018302,		"(Novell) Attribute NDS FULL NAME" },
	{ 0x02018303,		"(Novell) Attribute NDS HOST DEVICE" },
	{ 0x02018304,		"(Novell) Attribute NDS MINIMUM ACCOUNT BALANCE" },
	{ 0x02018305,		"(Novell) Attribute NDS RESOURCE" },
	{ 0x02018306,		"(Novell) Attribute NDS STATUS" },
	{ 0x02018307,		"(Novell) Attribute NDS VERSION" },
	{ 0x02020000,		"(Novell) Attribute NDS OPERATOR ROLE" },
	{ 0x02020001,		"(Novell) Attribute NDS USER ROLE" },
	{ 0x02020002,		"(Novell) Attribute NDS MANAGER ROLE" },
	{ 0x02020003,		"(Novell) Attribute NDS PRINTER STATUS" },
	{ 0x0202000A,		"(Novell) Attribute NDS CLIENT INSTALL CANDIDATE" },
	{ 0x02020015,		"(Novell) Attribute NDS NOTIFY CONSUMERS" },
	{ 0x0202001A,		"(Novell) Attribute NDS PRINTER QUEUE LIST" },
	{ 0x0202001E,		"(Novell) Attribute NDS DATAPOOL LOCATION" },
	{ 0x0202001F,		"(Novell) Attribute NDS PRINTER SIBLINGS" },
	{ 0x02020021,		"(Novell) Attribute NDS ACCOUNTANT ROLE" },
	{ 0x02020022,		"(Novell) Attribute NDS IPP URI" },
	{ 0x02020023,		"(Novell) Attribute NDS IPP SECURITY SCHEME" },
	{ 0x02028200,		"(Novell) Attribute NDS OWNER" },
	{ 0x02028201,		"(Novell) Attribute NDS SERIAL NUMBER" },
	{ 0x0,			NULL },
};

static const value_string object_ids_14[] = { /* 060E6086 480186F8 (LENGTH 14)*/
    /* These values are 0x37010400+(defined number)*/
	{ 0x01008102,		"(Novell) Attribute JOB PRIVACY LEVEL" },
	{ 0x01008103,		"(Novell) Attribute JOB PRIVACY CATEGORY" },
	{ 0x01008104,		"(Novell) Attribute JOB PRIVACY POLICY" },
	{ 0x01008105,		"(Novell) Attribute JOB SECURITY INTEGRITY LEVEL" },
	{ 0x01008106,		"(Novell) Attribute JOB SECURITY INTEGRITY CATAGORY" },
	{ 0x01008107,		"(Novell) Attribute JOB SECURITY INTEGRITY POLICY" },
	{ 0x01008108,		"(Novell) Attribute JOB SECURITY LABEL" },
	{ 0x01008148,		"(Novell) Attribute CURRENT JOB STATE" },
	{ 0x01008149,		"(Novell) Attribute PREVIOUS JOB STATE" },
	{ 0x0100814A,		"(Novell) Attribute PRINTERS ASSIGNED" },
	{ 0x0100814C,		"(Novell) Attribute SUBMISSION TIME" },
	{ 0x0100814D,		"(Novell) Attribute MODIFICATION TIME" },
	{ 0x0100814E,		"(Novell) Attribute STARTED PRINTING TIME" },
	{ 0x0100814F,		"(Novell) Attribute JOB COPIES COMPLETED" },
	{ 0x01008150,		"(Novell) Attribute PAGES COMPLETED" },
	{ 0x01008151,		"(Novell) Attribute OCTETS COMPLETED" },
	{ 0x01008154,		"(Novell) Attribute INTERVENING JOBS" },
	{ 0x01008155,		"(Novell) Attribute PRINT CHECKPOINT" },
	{ 0x01008156,		"(Novell) Attribute NEW JOB IDENTIFIER" },
	{ 0x01008157,		"(Novell) Attribute ON REQUEST RESOURCES REQUESTED" },
	{ 0x01008158,		"(Novell) Attribute JOB MESSAGE FROM ADMIN" },
	{ 0x01008159,		"(Novell) Attribute LAST JOB EVENTS" },
	{ 0x0100815A,		"(Novell) Attribute NAME OF LAST ACCESSOR" },
	{ 0x0100815D,		"(Novell) Attribute ERROR COUNT" },
	{ 0x0100815E,		"(Novell) Attribute WARNING COUNT" },
	{ 0x0100815F,		"(Novell) Attribute PROCESSING TIME" },
	{ 0x01008160,		"(Novell) Attribute JOB SUBMIT COMPLETE" },
	{ 0x01008161,		"(Novell) Attribute COMPLETION TIME" },
	{ 0x01008162,		"(Novell) Attribute NUMBER OF DOCUMENTS" },
	{ 0x01008163,		"(Novell) Attribute IGNORED ATTRIBUTES" },
	{ 0x01008164,		"(Novell) Attribute JOB STATE REASONS" },
	{ 0x01008165,		"(Novell) Attribute TOTAL JOB OCTETS" },
	{ 0x01008166,		"(Novell) Attribute FINISH INCLUDE JOB SHEETS" },
	{ 0x01008167,		"(Novell) Attribute FINISH INCLUDE DOCUMENT SHEETS" },
	{ 0x01008168,		"(Novell) Attribute JOB SHEETS" },
	{ 0x01008169,		"(Novell) Attribute DOCUMENT SHEETS" },
	{ 0x0100816B,		"(Novell) Attribute IMPRESSIONS COMPLETED" },
	{ 0x0100816C,		"(Novell) Attribute MEDIA SHEETS COMPLETED" },
	{ 0x0100816D,		"(Novell) Attribute JOB PAGE COUNT" },
	{ 0x0100816E,		"(Novell) Attribute JOB IMPRESSION COUNT" },
	{ 0x0100816F,		"(Novell) Attribute JOB MEDIA SHEET COUNT" },
	{ 0x01008170,		"(Novell) Attribute JOB ID ON PRINTER" },
	{ 0x01008171,		"(Novell) Attribute JOB ID ON CLIENT" },
	{ 0x02008172,		"(Novell) Attribute PRESENTATION DIRECTION" },
	{ 0x02008173,		"(Novell) Attribute CONTENT ORIENTS USED" },
	{ 0x02008174,		"(Novell) Attribute CURRENT PAGE ORDER" },
	{ 0x0300810C,		"(Novell) Attribute JOB FINISHINGS SUPPORTED" },
	{ 0x0300810D,		"(Novell) Attribute JOB FINISHINGS READY" },
	{ 0x0300814A,		"(Novell) Attribute NUMBERS UP SUPPORTED" },
	{ 0x0300814C,		"(Novell) Attribute X IMAGE SHIFT RANG SUPPORTED" },
	{ 0x0300814E,		"(Novell) Attribute Y IMAGE SHIFT RANG SUPPORTED" },
	{ 0x03008158,		"(Novell) Attribute RESOURCES SUPPORTED" },
	{ 0x0300815B,		"(Novell) Attribute PRINTER TIMEOUT PERIOD" },
	{ 0x0300815F,		"(Novell) Attribute RESOURCES READY" },
	{ 0x03008163,		"(Novell) Attribute JOB ABORT CRITERIA SUPPORTED" },
	{ 0x03008164,		"(Novell) Attribute JOB WARNING CRITERIA SUPPORTED" },
	{ 0x03008165,		"(Novell) Attribute DOCUMENT ABORT CRITERIA SUPPORTED" },
	{ 0x03008166,		"(Novell) Attribute BINDING EDGES SUPPORTED" },
	{ 0x03008167,		"(Novell) Attribute EDGE IMAGE SHIFT MAXIMUM SUPPORTED" },
	{ 0x03008168,		"(Novell) Attribute JOB SHEETS SUPPORTED" },
	{ 0x03008169,		"(Novell) Attribute JOB SHEETS READY" },
	{ 0x0300816A,		"(Novell) Attribute DOCUMENT SHEETS SUPPORTED" },
	{ 0x0300816B,		"(Novell) Attribute DOCUMENT SHEETS READY" },
	{ 0x0300816C,		"(Novell) Attribute FINISH INCLUDED DOCUMENT SHEET SUPPORTED" },
	{ 0x0300816D,		"(Novell) Attribute FINISH INCLUDED JOB SHEET SUPPORTED" },
	{ 0x03008170,		"(Novell) Attribute JOB SIZE RANGE SUPPORTED" },
	{ 0x03008171,		"(Novell) Attribute JOB SIZE RANGE READY" },
	{ 0x03008172,		"(Novell) Attribute CHECKPOINT FORMATS SUPPORTED" },
	{ 0x03008173,		"(Novell) Attribute ARE FOREIGN JOBS VISABLE" },
	{ 0x03008174,		"(Novell) Attribute PRINTER ENABLED" },
	{ 0x03030202,		"(Novell) Attribute HARDWARE MEMORY SIZE" },
	{ 0x17028148,		"(Novell) Attribute ALERT PA CREATED" },
	{ 0x17028149,		"(Novell) Attribute ALERT PA DELETED" },
	{ 0x1702814A,		"(Novell) Attribute ALERT PRINT QUEUE CONNECTION LOST" },
	{ 0x1702814B,		"(Novell) Attribute ALERT NOTIFY SERVICE ERROR" },
	{ 0x1702814C,		"(Novell) Attribute ALERT RMS ERROR" },
	{ 0x1702814D,		"(Novell) Attribute ALERT SRS ERROR" },
	{ 0x1702814E,		"(Novell) Attribute ALERT IPP PORT NOT AVAILABLE" },
	{ 0x1702814F,		"(Novell) Attribute ALERT DNS NAME PROBLEM" },
	{ 0x17028150,		"(Novell) Attribute ALERT CANT PING PRINTER" },
	{ 0x17028151,		"(Novell) Attribute ALERT LPR COMMUNICATION FAILED" },
	{ 0x17028152,		"(Novell) Attribute ALERT SNMP COMMUNICATION FAILED" },
	{ 0x1702822C,		"(Novell) Attribute ALERT PRINTER OFF LINE" },
	{ 0x1702822D,		"(Novell) Attribute ALERT PRINTER ON LINE" },
	{ 0x1702822E,		"(Novell) Attribute ALERT PRINTER READY" },
	{ 0x17028375,		"(Novell) Attribute ALERT DOOR OPEN" },
	{ 0x17028376,		"(Novell) Attribute ALERT DOOR CLOSED" },
	{ 0x17028377,		"(Novell) Attribute ALERT POWER UP" },
	{ 0x17028378,		"(Novell) Attribute ALERT POWER DOWN" },
	{ 0x17028379,		"(Novell) Attribute ALERT PRINTER NMS RESET" },
	{ 0x1702837A,		"(Novell) Attribute ALERT PRINTER MANUAL RESET" },
	{ 0x1702837B,		"(Novell) Attribute ALERT PRINTER READY TO PRINT" },
	{ 0x17028621,		"(Novell) Attribute ALERT INPUT TRAY MISSING" },
	{ 0x17028622,		"(Novell) Attribute ALERT INPUT SIZE CHANGE" },
	{ 0x17028623,		"(Novell) Attribute ALERT INPUT WEIGHT CHANGE" },
	{ 0x17028624,		"(Novell) Attribute ALERT INPUT TYPE CHANGE" },
	{ 0x17028625,		"(Novell) Attribute ALERT INPUT COLOR CHANGE" },
	{ 0x17028626,		"(Novell) Attribute ALERT INPUT PARTS CHANGE" },
	{ 0x17028627,		"(Novell) Attribute ALERT INPUT SUPPLY LOW" },
	{ 0x17028628,		"(Novell) Attribute ALERT INPUT SUPPLY EMPTY" },
	{ 0x17028629,		"(Novell) Attribute ALERT INPUT MEDIA CHANGE REQUEST" },
	{ 0x1702862A,		"(Novell) Attribute ALERT INPUT MANUAL INPUT REQUEST" },
	{ 0x1702862B,		"(Novell) Attribute ALERT INPUT TRAY POSITION FAILED" },
	{ 0x1702862C,		"(Novell) Attribute ALERT INPUT TRAY ELV FAILED" },
	{ 0x1702862D,		"(Novell) Attribute ALERT INPUT CANT FEED SIZE" },
	{ 0x17028705,		"(Novell) Attribute ALERT OUTPUT TRAY MISSING" },
	{ 0x17028706,		"(Novell) Attribute ALERT OUTPUT TRAY ALMOST" },
	{ 0x17028707,		"(Novell) Attribute ALERT OUTPUT TRAY FULL" },
	{ 0x17028708,		"(Novell) Attribute ALERT OUTPUT TRAY OTHER" },
	{ 0x17028709,		"(Novell) Attribute ALERT OUTPUT TRAY OK" },
	{ 0x1702870A,		"(Novell) Attribute ALERT OUTPUT TRAY EMPTIED" },
	{ 0x17028769,		"(Novell) Attribute ALERT FUSER LO TEMP" },
	{ 0x1702876A,		"(Novell) Attribute ALERT FUSER HI TEMP" },
	{ 0x1702876B,		"(Novell) Attribute ALERT FUSER OK TEMP" },
	{ 0x1702876C,		"(Novell) Attribute ALERT FUSER THERMAL FAILURE" },
	{ 0x1702876D,		"(Novell) Attribute ALERT ADJUSTING PRINTER QUALITY" },
	{ 0x1702884D,		"(Novell) Attribute ALERT TONER EMPTY" },
	{ 0x1702884E,		"(Novell) Attribute ALERT INK EMPTY" },
	{ 0x1702884F,		"(Novell) Attribute ALERT RIBBON EMPTY" },
	{ 0x17028850,		"(Novell) Attribute ALERT TONER ALMOST" },
	{ 0x17028851,		"(Novell) Attribute ALERT INK ALMOST" },
	{ 0x17028852,		"(Novell) Attribute ALERT RIBBON ALMOST" },
	{ 0x17028853,		"(Novell) Attribute ALERT WASTE TONER ALMOST" },
	{ 0x17028854,		"(Novell) Attribute ALERT WASTE INK ALMOST" },
	{ 0x17028855,		"(Novell) Attribute ALERT WASTE TONER FULL" },
	{ 0x17028856,		"(Novell) Attribute ALERT WASTE INK FULL" },
	{ 0x17028857,		"(Novell) Attribute ALERT OPC LIFE ALMOST" },
	{ 0x17028858,		"(Novell) Attribute ALERT OPC LIFE OVER" },
	{ 0x17028859,		"(Novell) Attribute ALERT DEVELOPER ALMOST" },
	{ 0x1702885A,		"(Novell) Attribute ALERT DEVELOPER EMPTY" },
	{ 0x1702885B,		"(Novell) Attribute ALERT TONER CARTRIDGE MISSING" },
	{ 0x17028A15,		"(Novell) Attribute ALERT MEDIA TRAY MISSING" },
	{ 0x17028A16,		"(Novell) Attribute ALERT MEDIA TRAY ALMOST" },
	{ 0x17028A17,		"(Novell) Attribute ALERT MEDIA TRAY FULL" },
	{ 0x17028B5D,		"(Novell) Attribute ALERT INTERP MEMORY INCREASED" },
	{ 0x17028B5E,		"(Novell) Attribute ALERT INTERP MEMORY DECREASED" },
	{ 0x17028B5F,		"(Novell) Attribute ALERT INTERP CARTRIDGE ADD" },
	{ 0x17028B60,		"(Novell) Attribute ALERT INTERP CARTRIDGE DELETE" },
	{ 0x17028B61,		"(Novell) Attribute ALERT INTERP RESOURCE ADD" },
	{ 0x17028B62,		"(Novell) Attribute ALERT INTERP RESOURCE DELETE" },
	{ 0x17028B63,		"(Novell) Attribute ALERT INTERP RESOURCE UN" },
	{ 0x17028B65,		"(Novell) Attribute ALERT INTERP COMPLEX PAGE" },
	{ 0x17028C40,		"(Novell) Attribute ALERT WARMING UP" },
	{ 0x17028C41,		"(Novell) Attribute ALERT WARMED UP" },
	{ 0x17028C42,		"(Novell) Attribute ALERT INPUT JAM" },
	{ 0x17028C44,		"(Novell) Attribute ALERT INPUT SUPPLY NONE" },
	{ 0x17028C46,		"(Novell) Attribute ALERT TIME OUT" },
	{ 0x17028C47,		"(Novell) Attribute ALERT MANUAL FEED WAIT" },
	{ 0x17028C48,		"(Novell) Attribute ALERT PAPER LENGTH" },
	{ 0x17028C49,		"(Novell) Attribute ALERT OUTPUT JAM" },
	{ 0x17028C4B,		"(Novell) Attribute ALERT MANUAL FEED" },
	{ 0x17028C4C,		"(Novell) Attribute ALERT STORAGE" },
	{ 0x17028C4D,		"(Novell) Attribute ALERT ENGINE" },
	{ 0x17028C4E,		"(Novell) Attribute ALERT INTERP OTHER" },
	{ 0x17028C4F,		"(Novell) Attribute ALERT IO ERROR" },
	{ 0x17028C50,		"(Novell) Attribute ALERT VIDEO" },
	{ 0x17028C51,		"(Novell) Attribute ALERT MOTOR OTHER" },
	{ 0x17028C52,		"(Novell) Attribute ALERT TEMPERATURE OTHER" },
	{ 0x17028C53,		"(Novell) Attribute ALERT RECORDER OTHER" },
	{ 0x17028C54,		"(Novell) Attribute ALERT KNIFE OTHER" },
	{ 0x17028C55,		"(Novell) Attribute ALERT CASSETTE OTHER" },
	{ 0x17028C56,		"(Novell) Attribute ALERT PRINTER OTHER" },
	{ 0x17028C57,		"(Novell) Attribute ALERT BATTERY LOW" },
	{ 0x17028C58,		"(Novell) Attribute ALERT SELF TEST" },
	{ 0x17028C59,		"(Novell) Attribute ALERT ADJUST PRINTER QUALITY" },
	{ 0x17028C5A,		"(Novell) Attribute ALERT QUALITY ADJUSTED" },
	{ 0x17028C5D,		"(Novell) Attribute ALERT INPUT TRAY OTHER" },
	{ 0x17028C5E,		"(Novell) Attribute ALERT INPUT TRAY OK" },
	{ 0x17028C5F,		"(Novell) Attribute ALERT MEDIA CHANGE" },
	{ 0x17028C60,		"(Novell) Attribute ALERT INPUT MEDIA EMPTY" },
	{ 0x17028C61,		"(Novell) Attribute ALERT INPUT MEDIA OK" },
	{ 0x17028C62,		"(Novell) Attribute ALERT MANUAL FEED COMPLETE" },
	{ 0x17028C63,		"(Novell) Attribute ALERT CHANGE MEDIA REQUEST" },
	{ 0x17028C64,		"(Novell) Attribute ALERT CHANGE MEDIA COMPLETE" },
	{ 0x17028C65,		"(Novell) Attribute ALERT TONER OTHER" },
	{ 0x17028C66,		"(Novell) Attribute ALERT TONER OK" },
	{ 0x17028C67,		"(Novell) Attribute ALERT INK OTHER" },
	{ 0x17028C68,		"(Novell) Attribute ALERT INK OK" },
	{ 0x17028C69,		"(Novell) Attribute ALERT RIBBON OTHER" },
	{ 0x17028C6A,		"(Novell) Attribute ALERT RIBBON OK" },
	{ 0x17028C6B,		"(Novell) Attribute ALERT OPC OK" },
	{ 0x17028C6D,		"(Novell) Attribute ALERT DEVICE OTHER" },
	{ 0x17028C6E,		"(Novell) Attribute ALERT DEVICE OK" },
	{ 0x17028C6F,		"(Novell) Attribute ALERT CARTRIDGE ALMOST" },
	{ 0x17028C70,		"(Novell) Attribute ALERT CARTRIDGE REPLACE" },
	{ 0x17028C71,		"(Novell) Attribute ALERT CARTRIDGE OTHER" },
	{ 0x17028C72,		"(Novell) Attribute ALERT CARTRIDGE OK" },
	{ 0x17028C73,		"(Novell) Attribute ALERT FUSER ALMOST" },
	{ 0x17028C74,		"(Novell) Attribute ALERT FUSER REPLACE" },
	{ 0x17028C75,		"(Novell) Attribute ALERT FUSER OTHER" },
	{ 0x17028C76,		"(Novell) Attribute ALERT FUSER OK" },
	{ 0x17028C77,		"(Novell) Attribute ALERT WIPER ALMOST" },
	{ 0x17028C78,		"(Novell) Attribute ALERT WIPER REPLACE" },
	{ 0x17028C79,		"(Novell) Attribute ALERT WIPER OTHER" },
	{ 0x17028C7A,		"(Novell) Attribute ALERT WIPER OK" },
	{ 0x17028C7B,		"(Novell) Attribute ALERT WASTE ALMOST" },
	{ 0x17028C7C,		"(Novell) Attribute ALERT WASTE REPLACE" },
	{ 0x17028C7D,		"(Novell) Attribute ALERT WASTE OTHER" },
	{ 0x17028C7E,		"(Novell) Attribute ALERT WASTE PACKAGE OK" },
	{ 0x17028C7F,		"(Novell) Attribute ALERT OIL ALMOST" },
	{ 0x17028D00,		"(Novell) Attribute ALERT OIL REPLACE" },
	{ 0x17028D01,		"(Novell) Attribute ALERT OIL OTHER" },
	{ 0x17028D02,		"(Novell) Attribute ALERT OIL OK" },
	{ 0x17028D03,		"(Novell) Attribute ALERT BELT NEAR EOL" },
	{ 0x17028D04,		"(Novell) Attribute ALERT BELT REPLACE" },
	{ 0x17028D05,		"(Novell) Attribute ALERT BELT OTHER" },
	{ 0x17028D06,		"(Novell) Attribute ALERT BELT OK" },
	{ 0x17028D07,		"(Novell) Attribute ALERT STORAGE HIGH WATER" },
	{ 0x17028D08,		"(Novell) Attribute ALERT STORAGE ERROR" },
	{ 0x17028D09,		"(Novell) Attribute ALERT STORAGE OTHER" },
	{ 0x17028D0A,		"(Novell) Attribute ALERT STORAGE OK" },
	{ 0x17028D0B,		"(Novell) Attribute ALERT ENGINE OK" },
	{ 0x17028D0C,		"(Novell) Attribute ALERT INTERP OK" },
	{ 0x17028D0D,		"(Novell) Attribute ALERT IO OK" },
	{ 0x17028D0E,		"(Novell) Attribute ALERT VIDEO OK" },
	{ 0x17028D0F,		"(Novell) Attribute ALERT MOTOR OK" },
	{ 0x17028D10,		"(Novell) Attribute ALERT TEMPERATURE OK" },
	{ 0x17028D11,		"(Novell) Attribute ALERT RECORDER OK" },
	{ 0x17028D12,		"(Novell) Attribute ALERT KNIFE OK" },
	{ 0x17028D13,		"(Novell) Attribute ALERT CASSETTE OK" },
	{ 0x17028D14,		"(Novell) Attribute ALERT PRINTER OK" },
	{ 0x17028D15,		"(Novell) Attribute ALERT BATTERY OK " },
	{ 0x17028D16,		"(Novell) Attribute ALERT BATTERY OTHER" },
	{ 0x17028D17,		"(Novell) Attribute ALERT MAINTENANCE CHECK" },
	{ 0x17028D18,		"(Novell) Attribute ALERT JOB START" },
	{ 0x17028D19,		"(Novell) Attribute ALERT JOB END" },
	{ 0x17028D1A,		"(Novell) Attribute ALERT JOB SEND NEXT" },
	{ 0x17028D1B,		"(Novell) Attribute ALERT POWERSAVER ENTER" },
	{ 0x17028D1C,		"(Novell) Attribute ALERT POWERSAVER EXIT" },
	{ 0x17028D1D,		"(Novell) Attribute ALERT COMMUNICATIONS ERROR" },
	{ 0x17028D1E,		"(Novell) Attribute ALERT COMMUNICATIONS OK" },
	{ 0x17028D1F,		"(Novell) Attribute ALERT DRY INK LOW" },
	{ 0x17028D20,		"(Novell) Attribute ALERT DRY INK EMPTY" },
	{ 0x17028D21,		"(Novell) Attribute ALERT DRY INK OK" },
	{ 0x17028D22,		"(Novell) Attribute ALERT DRY INK OTHER" },
	{ 0x17028D23,		"(Novell) Attribute ALERT INPUT TRAY FAIL" },
	{ 0x17028D24,		"(Novell) Attribute ALERT OUTPUT TRAY FAIL" },
	{ 0x17028D25,		"(Novell) Attribute ALERT UNRECOVERABLE ERROR" },
	{ 0x17028D26,		"(Novell) Attribute ALERT BYPASS OPEN" },
	{ 0x17028D27,		"(Novell) Attribute ALERT BYPASS CLOSED" },
	{ 0x17028D28,		"(Novell) Attribute ALERT BYPASS MISSING" },
	{ 0x17028D29,		"(Novell) Attribute ALERT BYPASS OK" },
	{ 0x17028D2B,		"(Novell) Attribute ALERT PHOTOREC MISSING" },
	{ 0x17028D2C,		"(Novell) Attribute ALERT PHOTOREC OK" },
	{ 0x17028D2D,		"(Novell) Attribute ALERT PHOTOREC NEAR EOL" },
	{ 0x17028D2E,		"(Novell) Attribute ALERT PHOTOREC EOL" },
	{ 0x17028D2F,		"(Novell) Attribute ALERT PHOTOREC OTHER" },
	{ 0x17028D30,		"(Novell) Attribute ALERT PHOTOCON MISSING" },
	{ 0x17028D31,		"(Novell) Attribute ALERT PHOTOCON OK" },
	{ 0x17028D32,		"(Novell) Attribute ALERT PHOTOCON NEAR EOL" },
	{ 0x17028D33,		"(Novell) Attribute ALERT PHOTOCON EOL" },
	{ 0x17028D34,		"(Novell) Attribute ALERT PHOTOCON OTHER" },
	{ 0x17028D35,		"(Novell) Attribute ALERT DEVELOPER CARTRIDGE MISSING" },
	{ 0x17028D36,		"(Novell) Attribute ALERT DEVELOPER CARTRIDGE OK" },
	{ 0x17028D37,		"(Novell) Attribute ALERT DEVICE CARTRIDGE NEAR EOL" },
	{ 0x17028D38,		"(Novell) Attribute ALERT DEVELOPER CARTRIDGE OTHER" },
	{ 0x17028D39,		"(Novell) Attribute ALERT NOT READY" },
	{ 0x17028D3A,		"(Novell) Attribute ALERT TEST PRINT" },
	{ 0x17028D3B,		"(Novell) Attribute ALERT TEST COMPLETE" },
	{ 0x17028D3C,		"(Novell) Attribute ALERT MEMORY LOW WATER" },
	{ 0x17028D3D,		"(Novell) Attribute ALERT MEMORY OK" },
	{ 0x17028D3E,		"(Novell) Attribute ALERT ROS FAULT" },
	{ 0x17028D3F,		"(Novell) Attribute ALERT ROS OK" },
	{ 0x17028D40,		"(Novell) Attribute ALERT DUPLEX FAULT" },
	{ 0x17028D41,		"(Novell) Attribute ALERT DUPLEX OK" },
	{ 0x17028D42,		"(Novell) Attribute ALERT LASER FAULT" },
	{ 0x17028D43,		"(Novell) Attribute ALERT LASER OK" },
	{ 0x17028D44,		"(Novell) Attribute ALERT IMAGER FAULT" },
	{ 0x17028D45,		"(Novell) Attribute ALERT IMAGER OK" },
	{ 0x17028D46,		"(Novell) Attribute ALERT DEVELOPER CARTRIDGE EOL" },
	{ 0x17028D47,		"(Novell) Attribute ALERT STAPLER EMPTY" },
	{ 0x17028D48,		"(Novell) Attribute ALERT STAPLER OK" },
	{ 0x17028D49,		"(Novell) Attribute ALERT STAPLER PIN JAM" },
	{ 0x17028D4A,		"(Novell) Attribute ALERT STAPLER PIN OK" },
	{ 0x17028D4B,		"(Novell) Attribute ALERT PUNCH JAM" },
	{ 0x17028D4C,		"(Novell) Attribute ALERT PUNCH OTHER" },
	{ 0x17028D4D,		"(Novell) Attribute ALERT PUNCH OK" },
	{ 0x17028D4E,		"(Novell) Attribute ALERT PUNCH WASTE NEAR" },
	{ 0x17028D4F,		"(Novell) Attribute ALERT PUNCH WASTE FULL" },
	{ 0x17028D50,		"(Novell) Attribute ALERT PUNCH WASTE OK" },
	{ 0x17028D51,		"(Novell) Attribute ALERT WASTE NEAR FULL" },
	{ 0x17028D52,		"(Novell) Attribute ALERT WASTE FULL" },
	{ 0x17028D53,		"(Novell) Attribute ALERT WASTE OK" },
	{ 0x17028D54,		"(Novell) Attribute ALERT WAX LOW" },
	{ 0x17028D55,		"(Novell) Attribute ALERT WAX EMPTY" },
	{ 0x17028D56,		"(Novell) Attribute ALERT WAX OK" },
	{ 0x17028D57,		"(Novell) Attribute ALERT PAGE CLEARED" },
	{ 0x17028D58,		"(Novell) Attribute ALERT PAGE PUNT" },
	{ 0x17028D59,		"(Novell) Attribute ALERT RIBBON JAM" },
	{ 0x17028D5A,		"(Novell) Attribute ALERT PRINTER RELEASE LEVER NOT ENGAGED" },
	{ 0x17028D5B,		"(Novell) Attribute ALERT PRINTER RELEASE LEVER ENGAGED" },
	{ 0x17028D5C,		"(Novell) Attribute ALERT DUPLEX NOT SUPPORTED" },
	{ 0x17028D5D,		"(Novell) Attribute ALERT PAPER ORIENTATION WRONG" },
	{ 0x17028D5E,		"(Novell) Attribute ALERT STAPLER OPEN" },
	{ 0x17028D5F,		"(Novell) Attribute ALERT STAPLER OTHER" },
	{ 0x17028E08,		"(Novell) Attribute ALERT PRINT HANDLER NOT CONNECTED" },
	{ 0x17028E09,		"(Novell) Attribute ALERT PRINT HANDLER OTHER ERROR" },
	{ 0x17028E0A,		"(Novell) Attribute ALERT JOB START TIMEOUT" },
	{ 0x17028E0B,		"(Novell) Attribute ALERT JOB END TIMEOUT" },
	{ 0x17028E0C,		"(Novell) Attribute ALERT PDS PRINT HANDLER OTHER" },
	{ 0x17028E0D,		"(Novell) Attribute ALERT PRINT HANDLER VOLUME NOT MOUNTED" },
	{ 0x17028E0E,		"(Novell) Attribute ALERT PRINT HANDLER VOLUME FULL" },
	{ 0x17028E0F,		"(Novell) Attribute ALERT ACCOUNTING SERVICE ERROR" },
	{ 0x17028E10,		"(Novell) Attribute ALERT DEVICE PAUSED" },
	{ 0x17028E11,		"(Novell) Attribute ALERT DEVICE INPUT PAUSED" },
	{ 0x17028E12,		"(Novell) Attribute ALERT DEVICE SHUTDOWN" },
	{ 0x17028E13,		"(Novell) Attribute ALERT GATEWAY WITHOUT CONFIGURATION FILE" },
	{ 0x17028E14,		"(Novell) Attribute ALERT PRINTER STATE CHANGED" },
	{ 0x17028E15,		"(Novell) Attribute ALERT PRINTER STOPPED" },
	{ 0x0,			NULL },  
};

static const value_string object_ids_15[] = { /* 060F6086 480186F837 (LENGTH 15)*/
    /* These values are 0x01040003+(defined number)*/
	{ 0x01050101,		"(Novell) Attribute PRINTER GENERAL CONFIGURATION CHANGES" },
	{ 0x01050102,		"(Novell) Attribute PRINTER GENERAL CURRENT LOCAL" },
	{ 0x01050103,		"(Novell) Attribute PRINTER GENERAL RESET" },
	{ 0x01050104,		"(Novell) Attribute PRINTER GENERAL CURRENT OPERATION" },
	{ 0x01050105,		"(Novell) Attribute PRINTER GENERAL SERVICE PERSON" },
	{ 0x01050106,		"(Novell) Attribute PRINTER INPUT DEFAULT INDEX" },
	{ 0x01050107,		"(Novell) Attribute PRINTER OUTPUT DEFAULT INDEX" },
	{ 0x01050108,		"(Novell) Attribute PRINTER MARKER DEFAULT INDEX" },
	{ 0x01050109,		"(Novell) Attribute PRINTER MEDIA PATH DEFAULT INDEX" },
	{ 0x0105010A,		"(Novell) Attribute PRINTER CONSOLE LOCALIZATION" },
	{ 0x0105010B,		"(Novell) Attribute PRINTER CONTINUOUS NUMBER DISPLAY LINES" },
	{ 0x0105010C,		"(Novell) Attribute PRINTER CONTINUOUS NUMBER DISPLAY CHARACTERS" },
	{ 0x0105010D,		"(Novell) Attribute PRINTER CONSOLE DISABLE" },
	{ 0x01050201,		"(Novell) Attribute PRINTER STORAGE REFERENCE SEQUENCE NUMBER" },
	{ 0x01050202,		"(Novell) Attribute PRINTER STORAGE REFERENCES INDEX" },
	{ 0x01050301,		"(Novell) Attribute PRINTER DEVICE REFERENCE SEQUENCE NUMBER" },
	{ 0x01050302,		"(Novell) Attribute PRINTER DEVICE REFERENCE INDEX" },
	{ 0x01070101,		"(Novell) Attribute PRINTER LOCALIZATION INDEX" },
	{ 0x01070102,		"(Novell) Attribute PRINTER LOCAL LANGUAGE" },
	{ 0x01070103,		"(Novell) Attribute PRINTER LOCALIZATION COUNTRY" },
	{ 0x01070104,		"(Novell) Attribute PRINTER LOCAL CHARACTER SET" },
	{ 0x03030204,		"(Novell) Attribute HARDWARE DEVICE ID" },
	{ 0x03030205,		"(Novell) Attribute HARDWARE DEVICE STATUS" },
	{ 0x03030501,		"(Novell) Attribute HARDWARE PRINTER STATUS" },
	{ 0x03030502,		"(Novell) Attribute HARDWARE PRINTER DETECTED ERROR STATE" },
	{ 0x03030604,		"(Novell) Attribute HARDWARE DISK STORAGE CAPACITY" },
    /* These values are 0x0104000F+(defined number)*/
	{ 0x01080201,		"(Novell) Attribute PRINTER INPUT INDEX" },
	{ 0x01080202,		"(Novell) Attribute PRINTER INPUT TYPE" },
	{ 0x01080203,		"(Novell) Attribute PRINTER INPUT DIMINSION UNIT" },
	{ 0x01080204,		"(Novell) Attribute PRINTER INPUT MEDIA DIMINSION FEED DDEC" },
	{ 0x01080205,		"(Novell) Attribute PRINTER INPUT MEDIA DIMINSION XFEEDDDEC" },
	{ 0x01080206,		"(Novell) Attribute PRINTER INPUT MEDIA DIMINSION FEEDDCHO" },
	{ 0x01080207,		"(Novell) Attribute PRINTER INPUT MEDIA DIMINSION XFEEDDCHO" },
	{ 0x01080208,		"(Novell) Attribute PRINTER INPUT CAPACITY UNIT" },
	{ 0x01080209,		"(Novell) Attribute PRINTER INPUT MAXIMUM CAPACITY" },
	{ 0x0108020A,		"(Novell) Attribute PRINTER INPUT CURRENT LEVEL" },
	{ 0x0108020B,		"(Novell) Attribute PRINTER INPUT STATUS" },
	{ 0x0108020C,		"(Novell) Attribute PRINTER INPUT MEDIA NAME" },
	{ 0x0108020D,		"(Novell) Attribute PRINTER INPUT NAME" },
	{ 0x0108020E,		"(Novell) Attribute PRINTER INPUT VENDOR NAME" },
	{ 0x0108020F,		"(Novell) Attribute PRINTER INPUT MODEL" },
	{ 0x01080210,		"(Novell) Attribute PRINTER INPUT VERSION" },
	{ 0x01080211,		"(Novell) Attribute PRINTER INPUT SERIAL NUMBER" },
	{ 0x01080212,		"(Novell) Attribute PRINTER INPUT DESCRIPTION" },
	{ 0x01080213,		"(Novell) Attribute PRINTER INPUT SECURITY" },
    /* These values are 0x01040010+(defined number)*/
	{ 0x01090201,		"(Novell) Attribute PRINTER OUTPUT INDEX" },
	{ 0x01090202,		"(Novell) Attribute PRINTER OUTPUT TYPE" },
	{ 0x01090203,		"(Novell) Attribute PRINTER OUTPUT CAPACITY UNIT" },
	{ 0x01090204,		"(Novell) Attribute PRINTER OUTPUT MAXIMUM CAPACITY" },
	{ 0x01090205,		"(Novell) Attribute PRINTER OUTPUT REMAINING CAPACITY" },
	{ 0x01090206,		"(Novell) Attribute PRINTER OUTPUT STATUS" },
	{ 0x01090207,		"(Novell) Attribute PRINTER OUTPUT NAME" },
	{ 0x01090208,		"(Novell) Attribute PRINTER OUTPUT VENDOR NAME" },
	{ 0x01090209,		"(Novell) Attribute PRINTER OUTPUT MODEL" },
	{ 0x0109020A,		"(Novell) Attribute PRINTER OUTPUT VERSION" },
	{ 0x0109020B,		"(Novell) Attribute PRINTER OUTPUT SERIAL NUMBER" },
	{ 0x0109020C,		"(Novell) Attribute PRINTER OUTPUT DESCRIPTION" },
	{ 0x0109020D,		"(Novell) Attribute PRINTER OUTPUT SECURITY" },
	{ 0x0109020E,		"(Novell) Attribute PRINTER OUTPUT DIMINSION UNIT" },
	{ 0x0109020F,		"(Novell) Attribute PRINTER OUTPUT MAXIMUM DIMINSION FEED DIRECTION" },
	{ 0x01090210,		"(Novell) Attribute PRINTER OUTPUT MAXIMUM DIMINSION TRANSFER FEED DIRECTION" },
	{ 0x01090211,		"(Novell) Attribute PRINTER OUTPUT MINIMUM DIMINSION FEED DIRECTION" },
	{ 0x01090212,		"(Novell) Attribute PRINTER OUTPUT MINIMUM DIMINSION TRANSFER FEED DIRECTION" },
	{ 0x01090213,		"(Novell) Attribute PRINTER OUTPUT STACK INGORE DER" },
	{ 0x01090214,		"(Novell) Attribute PRINTER OUTPUT PAGE DELIVORY ENTRY" },
	{ 0x01090215,		"(Novell) Attribute PRINTER OUTPUT BURSTING" },
	{ 0x01090216,		"(Novell) Attribute PRINTER OUTPUT DECOLLATING" },
	{ 0x01090217,		"(Novell) Attribute PRINTER OUTPUT PAGE COLLATED" },
	{ 0x01090218,		"(Novell) Attribute PRINTER OUTPUT OFFSET STACKING" },
    /* These values are 0x01040017+(defined number)*/
	{ 0x02819C29,		"(Novell) Attribute ALERT SUBUNIT MISSING" },
	{ 0x02819C2A,		"(Novell) Attribute ALERT SUBUNIT OK" },
	{ 0x0281A328,		"(Novell) Attribute ALERT OUTPUT TRAY MBX SELECTED" },
	{ 0x0281A40B,		"(Novell) Attribute ALERT FUSER TIME FAILED" },
    /* These values are 0x01040019+(defined number)*/
	{ 0x01000201,		"(Novell) Attribute PRINTER MARKER INDEX" },
	{ 0x01000202,		"(Novell) Attribute PRINTER MARKER MARK TECH" },
	{ 0x01000203,		"(Novell) Attribute PRINTER MARKER COUNT UNIT" },
	{ 0x01000204,		"(Novell) Attribute PRINTER MARKER LIFE COUNT" },
	{ 0x01000205,		"(Novell) Attribute PRINTER MARKER POWER ON COUNT" },
	{ 0x01000206,		"(Novell) Attribute PRINTER MARKER PROCESS COLORS" },
	{ 0x01000207,		"(Novell) Attribute PRINTER MARKER SPOT COLORANTS" },
	{ 0x01000208,		"(Novell) Attribute PRINTER MARKER ADD UNIT" },
	{ 0x01000209,		"(Novell) Attribute PRINTER MARKER ADD RFEEDDIR" },
	{ 0x0100020A,		"(Novell) Attribute PRINTER MARKER ADDRXFEEDDIR" },
	{ 0x0100020B,		"(Novell) Attribute PRINTER MARKER NORTH MARGIN" },
	{ 0x0100020C,		"(Novell) Attribute PRINTER MARKER SOUTH MARGIN" },
	{ 0x0100020D,		"(Novell) Attribute PRINTER MARKER WEST MARGIN" },
	{ 0x0100020E,		"(Novell) Attribute PRINTER MARKER EAST MARGIN" },
	{ 0x0100020F,		"(Novell) Attribute PRINTER MARKER STATUS" },
    /* These values are 0x0104001A+(defined number)*/
	{ 0x010D0401,		"(Novell) Attribute PRINTER MEDIA PATH INDEX" },
	{ 0x010D0402,		"(Novell) Attribute PRINTER MEDIA PATH MAXIMUM SPEED UNIT" },
	{ 0x010D0403,		"(Novell) Attribute PRINTER MEDIA PATH SIZE UNIT" },
	{ 0x010D0404,		"(Novell) Attribute PRINTER MEDIA PATH MAXIMUM SPEED" },
	{ 0x010D0405,		"(Novell) Attribute PRINTER MEDIA PATH MAXIMUM FEED DIRECTION" },
	{ 0x010D0406,		"(Novell) Attribute PRINTER MEDIA PATH MAXIMUM TRANSFER FEED DIRECTION" },
	{ 0x010D0407,		"(Novell) Attribute PRINTER MEDIA PATH MINIMUM FEED DIRECTION" },
	{ 0x010D0408,		"(Novell) Attribute PRINTER MEDIA PATH MINIMUM TRANSFER FEED DIRECTION" },
	{ 0x010D0409,		"(Novell) Attribute PRINTER MEDIA PATH TYPE" },
	{ 0x010D040A,		"(Novell) Attribute PRINTER MEDIA PATH DESCRIPTION" },
	{ 0x010D040B,		"(Novell) Attribute PRINTER MEDIA PATH STATUS" },
    /* These values are 0x0104001B+(defined number)*/
	{ 0x010E0101,		"(Novell) Attribute PRINTER CHANNEL INDEX" },
	{ 0x010E0102,		"(Novell) Attribute PRINTER CHANNEL TYPE" },
	{ 0x010E0103,		"(Novell) Attribute PRINTER CHANNEL PROTOVERS" },
	{ 0x010E0104,		"(Novell) Attribute PRINTER CHANNEL CURRENT JCL INDEX" },
	{ 0x010E0105,		"(Novell) Attribute PRINTER CHANNEL DEFAULT PDL INDEX" },
	{ 0x010E0106,		"(Novell) Attribute PRINTER CHANNEL STATE" },
	{ 0x010E0107,		"(Novell) Attribute PRINTER CHANNEL IF INDEX" },
	{ 0x010E0108,		"(Novell) Attribute PRINTER CHANNEL STATUS" },
    /* These values are 0x0104001C+(defined number)*/
	{ 0x010F0101,		"(Novell) Attribute PRINTER INTERPRETER INDEX" },
	{ 0x010F0102,		"(Novell) Attribute PRINTER INTERPRETER LANGUAGE FAM" },
	{ 0x010F0103,		"(Novell) Attribute PRINTER INTERPRETER LANGUAGE LEVEL" },
	{ 0x010F0104,		"(Novell) Attribute PRINTER INTERPRETER LANGUAGE VERSION" },
	{ 0x010F0105,		"(Novell) Attribute PRINTER INTERPRETER DESCRIPTION" },
	{ 0x010F0106,		"(Novell) Attribute PRINTER INTERPRETER VERSION" },
	{ 0x010F0107,		"(Novell) Attribute PRINTER INTERPRETER DEFAULT ORIENTATION" },
	{ 0x010F0108,		"(Novell) Attribute PRINTER INTERPRETER FEED ADDRESS" },
	{ 0x010F0109,		"(Novell) Attribute PRINTER INTERPRETER TRANSFER FEED ADDRESS" },
	{ 0x010F010A,		"(Novell) Attribute PRINTER INTERPRETER DEFAULT CHARACTERS IN" },
	{ 0x010F010B,		"(Novell) Attribute PRINTER INTERPRETER DEFAULT CHARACTERS OUT" },
	{ 0x010F010C,		"(Novell) Attribute PRINTER INTERPRETER TWO WAY" },
    /* These values are 0x0104001E+(defined number)*/
	{ 0x01000101,		"(Novell) Attribute PRINTER MARKER SUPPLIES INDEX" },
	{ 0x01000102,		"(Novell) Attribute PRINTER MARKER SUPPLIES MARKER INDEX" },
	{ 0x01000103,		"(Novell) Attribute PRINTER MARKER SUPPLIES COLOR INDEX" },
	{ 0x01000104,		"(Novell) Attribute PRINTER MARKER SUPPLIES CLASS" },
	{ 0x01000105,		"(Novell) Attribute PRINTER MARKER SUPPLIES TYPE" },
	{ 0x01000106,		"(Novell) Attribute PRINTER MARKER SUPPLIES DESCRIPTION" },
	{ 0x01000107,		"(Novell) Attribute PRINTER MARKER SUPPLIES SUPPLY UNIT" },
	{ 0x01000108,		"(Novell) Attribute PRINTER MARKER SUPPLIES MAXIMUM CAPACITY" },
	{ 0x01000109,		"(Novell) Attribute PRINTER MARKER SUPPLIES LEVEL" },
    /* These values are 0x0104001F+(defined number)*/
	{ 0x01000101,		"(Novell) Attribute PRINTER MARKER COLORANT INDEX" },
	{ 0x01000102,		"(Novell) Attribute PRINTER MARKER COLORANT MARKER INDEX" },
	{ 0x01000103,		"(Novell) Attribute PRINTER MARKER COLORANT ROLE" },
	{ 0x01000104,		"(Novell) Attribute PRINTER MARKER COLORANT VALUE" },
	{ 0x01000105,		"(Novell) Attribute PRINTER MARKER COLORANT TONE" },
    /* These values are 0x01040020+(defined number)*/
	{ 0x01000101,		"(Novell) Attribute PRINTER COVER INDEX" },
	{ 0x01000102,		"(Novell) Attribute PRINTER COVER DESCRIPTION" },
	{ 0x01000103,		"(Novell) Attribute PRINTER COVER STATUS" },
    /* These values are 0x01040021+(defined number)*/
	{ 0x01000601,		"(Novell) Attribute PRINTER CONSOLE LIGHT INDEX" },
	{ 0x01000602,		"(Novell) Attribute PRINTER CONSOLE ON TIME" },
	{ 0x01000603,		"(Novell) Attribute PRINTER CONSOLE OFF TIME" },
	{ 0x01000604,		"(Novell) Attribute PRINTER CONSOLE COLOR" },
	{ 0x01000605,		"(Novell) Attribute PRINTER CONSOLE DESCRIPTION" },
    /* These values are 0x01040022+(defined number)*/
	{ 0x01000501,		"(Novell) Attribute PRINTER CONSOLE DISPLAY BUFFER INDEX" },
	{ 0x01000502,		"(Novell) Attribute PRINTER CONSOLE DISPLAY BUFFER TEXT" },
    /* These values are 0x01040025+(defined number)*/
	{ 0x011E0101,		"(Novell) Attribute FINISH DEVICE INDEX" },
	{ 0x011E0102,		"(Novell) Attribute FINISH DEVICE TYPE" },
	{ 0x011E0103,		"(Novell) Attribute FINISH DEVICE PRESENT ON OFF" },
	{ 0x011E0104,		"(Novell) Attribute FINISH DEVICE CAPACITY UNIT" },
	{ 0x011E0105,		"(Novell) Attribute FINISH DEVICE MAXIMUM CAPACITY" },
	{ 0x011E0106,		"(Novell) Attribute FINISH DEVICE CURRENT CAPACITY" },
	{ 0x011E0107,		"(Novell) Attribute FINISH DEVICE ASSOCIATED MEDIA PATH" },
	{ 0x011E0108,		"(Novell) Attribute FINISH DEVICE ASSOCIATED OUTPUTS" },
	{ 0x011E0109,		"(Novell) Attribute FINISH DEVICE STATUS" },
	{ 0x011E010A,		"(Novell) Attribute FINISH DEVICE DESCRIPTION" },
	{ 0x01210101,		"(Novell) Attribute FINISH DEVICE OTHER" },
	{ 0x01210103,		"(Novell) Attribute FINISH DEVICE NAME" },
	{ 0x01210104,		"(Novell) Attribute FINISH DEVICE VENDOR NAME" },
	{ 0x01210105,		"(Novell) Attribute FINISH DEVICE MODEL" },
	{ 0x01210106,		"(Novell) Attribute FINISH DEVICE VERSION" },
	{ 0x01210107,		"(Novell) Attribute FINISH DEVICE SERIAL NUMBER" },
	{ 0x01210108,		"(Novell) Attribute FINISH DEVICE MAXIMUM SHEETS" },
	{ 0x01210109,		"(Novell) Attribute FINISH PROCESS OFFSET UNITS" },
	{ 0x0121010A,		"(Novell) Attribute FINISH REFERENCE EDGE" },
	{ 0x0121010B,		"(Novell) Attribute FINISH AXIS OFFSET" },
	{ 0x0121010C,		"(Novell) Attribute FINISH JOG EDGE" },
	{ 0x0121010D,		"(Novell) Attribute FINISH HEAD LOCATION" },
	{ 0x0121010E,		"(Novell) Attribute FINISH OPERATOR RESTRICTIONS" },
	{ 0x0121010F,		"(Novell) Attribute FINISH NUMBER OF POSITIONS" },
	{ 0x01210110,		"(Novell) Attribute FINISH NAMED CONFIGURATION" },
	{ 0x01210111,		"(Novell) Attribute FINISH MEDIA TYPE RESTRICT" },
	{ 0x01210112,		"(Novell) Attribute FINISH PRINTER INPUT TRAY SUPPORT" },
	{ 0x01210113,		"(Novell) Attribute FINISH PREVIOUS FINISH IN GOP" },
	{ 0x01210114,		"(Novell) Attribute FINISH NEXT FINISH IN GOP" },
	{ 0x0121011E,		"(Novell) Attribute STITCHING TYPE" },
	{ 0x0121011F,		"(Novell) Attribute STITCHING DIRECTION" },
	{ 0x01210120,		"(Novell) Attribute STITCHING ANGLE" },
	{ 0x01210128,		"(Novell) Attribute FOLDING TYPE" },
	{ 0x01210132,		"(Novell) Attribute BINDING TYPE" },
	{ 0x01210150,		"(Novell) Attribute PUNCH HOLE TYPE" },
	{ 0x01210151,		"(Novell) Attribute PUNCH HOLE SIZE LONG DIMENSION" },
	{ 0x01210152,		"(Novell) Attribute PUNCH HOLE SIZE SHORT DIMENSION" },
	{ 0x01210153,		"(Novell) Attribute PUNCH PATTERN" },
	{ 0x01210164,		"(Novell) Attribute SLITTING TYPE" },
    /* These values are 0x01040026+(defined number)*/
	{ 0x011F0101,		"(Novell) Attribute FINISH SUPPLY INDEX" },
	{ 0x011F0102,		"(Novell) Attribute FINISH SUPPLY DEVICE INDEX" },
	{ 0x011F0103,		"(Novell) Attribute FINISH SUPPLY CLASS" },
	{ 0x011F0104,		"(Novell) Attribute FINISH SUPPLY TYPE" },
	{ 0x011F0105,		"(Novell) Attribute FINISH SUPPLY DESCRIPTION" },
	{ 0x011F0106,		"(Novell) Attribute FINISH SUPPLY UNIT" },
	{ 0x011F0107,		"(Novell) Attribute FINISH SUPPLY MAXIMUM CAPACITY" },
	{ 0x011F0108,		"(Novell) Attribute FINISH SUPPLY CURRENT LEVEL" },
	{ 0x011F0109,		"(Novell) Attribute FINISH SUPPLY COLOR NAME" },
	{ 0x0,			NULL },
};

static const value_string  object_ids_16[] = { /* 06106086 480186F83701 (LENGTH 16)*/
    /* These values are 0x04002501+(defined number)*/
	{ 0x21018102,		"(Novell) Attribute WRAPPING TYPE" },
	{ 0x21018120,		"(Novell) Attribute STACK OUTPUT TYPE" },
	{ 0x21018121,		"(Novell) Attribute STACK OFFSET" },
	{ 0x21018122,		"(Novell) Attribute STACK ROTATION" },
	{ 0x0,			NULL },
};
