/*******************************************************************************
* nativeadmin.h:
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: nativeadmin.h,v 1.1 2001/10/06 21:23:37 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _NATIVEADMIN_H_
#define _NATIVEADMIN_H_


//------------------------------------------------------------------------------
// Native admin module definitions
//------------------------------------------------------------------------------
#define INIT_PHASE              1
#define LOGIN_PHASE             2
#define COMMAND_PHASE           4


//------------------------------------------------------------------------------
// E_NativeAdmin class
//------------------------------------------------------------------------------
class E_NativeAdmin : public E_Exception
{
 public:
  E_NativeAdmin(const C_String& strMsg);
  E_NativeAdmin(const C_String& strMsg, const E_Exception& e);
};


//------------------------------------------------------------------------------
// C_NativeAdminSession class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_NativeAdminSession : public C_AdminSession
{
public:
  C_NativeAdminSession(C_Socket* pConnection, void* pAdmin);

  // Data processing
  void ProcessData();
  // Event management
  void SendEvent(const C_Event& cEvent);

  C_String m_strPeerName;

protected:
  virtual void OnInit();
  virtual void OnClose();

  void HandleMessage();
  
private:
  // Connection to the peer
  C_Socket* m_pConnection;
  C_Stream<C_Socket> m_cStream;

  // Session status
  int m_iPhase;

  // Internal data
  C_String m_strMessage;
};



//------------------------------------------------------------------------------
// C_NativeAdmin class
//------------------------------------------------------------------------------
class C_NativeAdmin : protected C_ConnectionsHandler<C_NativeAdminSession>, 
                      protected C_Thread
{
public:
  C_NativeAdmin(handle hLog, C_Admin* pAdmin);

  void PropagateEvent(const C_Event& cEvent);

  int Init();
  int Run();
  int Stop();
  int Destroy();

protected:
  void InitWork();
  void DoWork();
  void StopWork();
  void CleanWork();

private:
  // Helpers
  handle m_hLog;
  C_Admin* m_pAdmin;

  // Event fifo
  C_Vector<C_Event> m_cEvents;
  C_Mutex m_cEventsLock;
};



#else
#error "Multiple inclusions of nativeadmin.h"
#endif

