#import "AppController.h"
#import "GoomFXView.h"
#include "goom_core.h"

#import <OpenGL/GL.h>

@implementation AppController

- (AppController *)init
{
    self = [super init];

    if (self)
    {
    }

    return self;
}

-(void)awakeFromNib
{
    PluginInfo * goomInfos;
    int i;
    
    goomInfos = [myGoom infos];
    
    for (i=0; i < goomInfos->nbParams; i++)
    {
        NSTabViewItem * item = [[[NSTabViewItem alloc] initWithIdentifier:nil] autorelease];
        [item setLabel:[NSString stringWithCString:goomInfos->params[i].name]];
        [item setView:[[[GoomFXView alloc] initWithFrame:[TabView contentRect] andFX:goomInfos->params[i]] autorelease]];
        [TabView addTabViewItem:item];
        
        // Create and load textures for the first time
        [GLView loadTextures:GL_TRUE];
    }
}

@end
