/////////////////////////////////////////////////////////////////////////////
//
// wmp9_goomEvents.cpp : Implementation of CWmp9_goom events
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "wmp9_goom.h"

void CWmp9_goom::OpenStateChange( long NewState )
{
    switch (NewState)
    {
    case wmposUndefined:
        break;
	case wmposPlaylistChanging:
        break;
	case wmposPlaylistLocating:
        break;
	case wmposPlaylistConnecting:
        break;
	case wmposPlaylistLoading:
        break;
	case wmposPlaylistOpening:
        break;
	case wmposPlaylistOpenNoMedia:
        break;
	case wmposPlaylistChanged:
        break;
	case wmposMediaChanging:
        break;
	case wmposMediaLocating:
        break;
	case wmposMediaConnecting:
        break;
	case wmposMediaLoading:
        break;
	case wmposMediaOpening:
        break;
	case wmposMediaOpen:
        break;
	case wmposBeginCodecAcquisition:
        break;
	case wmposEndCodecAcquisition:
        break;
	case wmposBeginLicenseAcquisition:
        break;
	case wmposEndLicenseAcquisition:
        break;
	case wmposBeginIndividualization:
        break;
	case wmposEndIndividualization:
        break;
	case wmposMediaWaiting:
        break;
	case wmposOpeningUnknownURL:
        break;
    default:
        break;
    }
}

void CWmp9_goom::PlayStateChange( long NewState )
{
    switch (NewState)
    {
    case wmppsUndefined:
        break;
	case wmppsStopped:
        break;
	case wmppsPaused:
        break;
	case wmppsPlaying:
        break;
	case wmppsScanForward:
        break;
	case wmppsScanReverse:
        break;
	case wmppsBuffering:
        break;
	case wmppsWaiting:
        break;
	case wmppsMediaEnded:
        break;
	case wmppsTransitioning:
        break;
	case wmppsReady:
        break;
	case wmppsReconnecting:
        break;
	case wmppsLast:
        break;
    default:
        break;
    }
}

void CWmp9_goom::AudioLanguageChange( long LangID )
{
}

void CWmp9_goom::StatusChange()
{
}

void CWmp9_goom::ScriptCommand( BSTR scType, BSTR Param )
{
}

void CWmp9_goom::NewStream()
{
}

void CWmp9_goom::Disconnect( long Result )
{
}

void CWmp9_goom::Buffering( VARIANT_BOOL Start )
{
}

void CWmp9_goom::Error()
{
    CComPtr<IWMPError>      spError;
    CComPtr<IWMPErrorItem>  spErrorItem;
    HRESULT                 dwError = S_OK;
    HRESULT                 hr = S_OK;

    if (m_spCore)
    {
        hr = m_spCore->get_error(&spError);

        if (SUCCEEDED(hr))
        {
            hr = spError->get_item(0, &spErrorItem);
        }

        if (SUCCEEDED(hr))
        {
            hr = spErrorItem->get_errorCode( (long *) &dwError );
        }
    }
}

void CWmp9_goom::Warning( long WarningType, long Param, BSTR Description )
{
}

void CWmp9_goom::EndOfStream( long Result )
{
}

void CWmp9_goom::PositionChange( double oldPosition, double newPosition)
{
}

void CWmp9_goom::MarkerHit( long MarkerNum )
{
}

void CWmp9_goom::DurationUnitChange( long NewDurationUnit )
{
}

void CWmp9_goom::CdromMediaChange( long CdromNum )
{
}

void CWmp9_goom::PlaylistChange( IDispatch * Playlist, WMPPlaylistChangeEventType change )
{
    switch (change)
    {
    case wmplcUnknown:
        break;
	case wmplcClear:
        break;
	case wmplcInfoChange:
        break;
	case wmplcMove:
        break;
	case wmplcDelete:
        break;
	case wmplcInsert:
        break;
	case wmplcAppend:
        break;
	case wmplcPrivate:
        break;
	case wmplcNameChange:
        break;
	case wmplcMorph:
        break;
	case wmplcSort:
        break;
	case wmplcLast:
        break;
    default:
        break;
    }
}

void CWmp9_goom::CurrentPlaylistChange( WMPPlaylistChangeEventType change )
{
    switch (change)
    {
    case wmplcUnknown:
        break;
	case wmplcClear:
        break;
	case wmplcInfoChange:
        break;
	case wmplcMove:
        break;
	case wmplcDelete:
        break;
	case wmplcInsert:
        break;
	case wmplcAppend:
        break;
	case wmplcPrivate:
        break;
	case wmplcNameChange:
        break;
	case wmplcMorph:
        break;
	case wmplcSort:
        break;
	case wmplcLast:
        break;
    default:
        break;
    }
}

void CWmp9_goom::CurrentPlaylistItemAvailable( BSTR bstrItemName )
{
}

void CWmp9_goom::MediaChange( IDispatch * Item )
{
}

void CWmp9_goom::CurrentMediaItemAvailable( BSTR bstrItemName )
{
}

void CWmp9_goom::CurrentItemChange( IDispatch *pdispMedia)
{
}

void CWmp9_goom::MediaCollectionChange()
{
}

void CWmp9_goom::MediaCollectionAttributeStringAdded( BSTR bstrAttribName,  BSTR bstrAttribVal )
{
}

void CWmp9_goom::MediaCollectionAttributeStringRemoved( BSTR bstrAttribName,  BSTR bstrAttribVal )
{
}

void CWmp9_goom::MediaCollectionAttributeStringChanged( BSTR bstrAttribName, BSTR bstrOldAttribVal, BSTR bstrNewAttribVal)
{
}

void CWmp9_goom::PlaylistCollectionChange()
{
}

void CWmp9_goom::PlaylistCollectionPlaylistAdded( BSTR bstrPlaylistName)
{
}

void CWmp9_goom::PlaylistCollectionPlaylistRemoved( BSTR bstrPlaylistName)
{
}

void CWmp9_goom::PlaylistCollectionPlaylistSetAsDeleted( BSTR bstrPlaylistName, VARIANT_BOOL varfIsDeleted)
{
}

void CWmp9_goom::ModeChange( BSTR ModeName, VARIANT_BOOL NewValue)
{
}

void CWmp9_goom::MediaError( IDispatch * pMediaObject)
{
}

void CWmp9_goom::OpenPlaylistSwitch( IDispatch *pItem )
{
}

void CWmp9_goom::DomainChange( BSTR strDomain)
{
}

void CWmp9_goom::SwitchedToPlayerApplication()
{
}

void CWmp9_goom::SwitchedToControl()
{
}

void CWmp9_goom::PlayerDockedStateChange()
{
}

void CWmp9_goom::PlayerReconnect()
{
}

void CWmp9_goom::Click( short nButton, short nShiftState, long fX, long fY )
{
}

void CWmp9_goom::DoubleClick( short nButton, short nShiftState, long fX, long fY )
{
}

void CWmp9_goom::KeyDown( short nKeyCode, short nShiftState )
{
}

void CWmp9_goom::KeyPress( short nKeyAscii )
{
}

void CWmp9_goom::KeyUp( short nKeyCode, short nShiftState )
{
}

void CWmp9_goom::MouseDown( short nButton, short nShiftState, long fX, long fY )
{
}

void CWmp9_goom::MouseMove( short nButton, short nShiftState, long fX, long fY )
{
}

void CWmp9_goom::MouseUp( short nButton, short nShiftState, long fX, long fY )
{
}
