/////////////////////////////////////////////////////////////////////////////
//
// wmp9_goom.cpp : Implementation of CWmp9_goom
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <comutil.h>
#include <commctrl.h>
#include <stdio.h>
#include "wmp9_goom.h"
#include "ThreadRender.h"
#include "CPropertyDialog.h"
#include "..\tinyptc.h"
extern "C" {
#include "..\..\plugin_info.h"
void  __stdcall goom_init (unsigned int resx, unsigned int, int cinemascope);
void  __stdcall goom_set_resolution (unsigned int resx, unsigned int resy, int cinemascope);
unsigned int *  __stdcall goom_update ( short data[2][512], int forceMode, float fps,
											char *songTitle, char *message);
void   __stdcall  goom_close ();
PluginInfo*  __stdcall  goom_get_plugin ();
}
#include "..\frame_rate_tester.h"

#pragma comment(lib,"..\\libgoommmx.a")

extern "C" {
	int ptc_gl_open(char *, int, int);
	int ptc_gl_set_hwnd(void *);
	int ptc_gl_close();
	int ptc_gl_update(void *);
	void ReSizeGLScene(int,int);
	int ptc_set_parent(HWND, HINSTANCE);
}

/////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::CWmp9_goom
// Constructor

#define GOOM_BITMAP_WIDTH 320
#define GOOM_BITMAP_HEIGHT 240

int goom_ref_cnt = 0;
int goom_width = 320;
int goom_height = 240;
int win_width = 320;
int win_height = 240;
HWND win_wnd = NULL;
bool win_gl = false;
PluginInfo* renderplug = NULL;
int win_ok = 0;
#define ENCORE_NUL_LOCK (32*60)
static int encore_nul = 0;
static int msg_pos = 0;
extern "C" int msg_rotate_ogl;
extern "C" char * __stdcall readme();
extern "C" float zshift;
#define VERSION "2k4"
static char *msg_tab[] = {
	"What a GOOM! version " VERSION
	"\n\n\n\n\n\n\n\n"
	"an iOS sotfware production.\n"
	"\n\n\n"
	"http://ios.free.fr",
	"", // will be replaced by readme()
	"copyright (c)2000-2004, by jeko"
};
static int encore_frame_ogl[] = { /* Note the times are off by one because msg_pos is incremented */
	32*15,						/* drawglgoom is called */
	32*20,
	32*35
};
static char *err_message = NULL;

static ThreadRender *thr = NULL;

#include "Regsettings.h"

RegSettings::RegSettings(PluginInfo *p1)
{
	showfps = true;
	showtitle = true;
	surface_gl = false;
	zsval = -5.0f;
	plug=p1;
	fpslim=5;
	Read();
}
RegSettings::~RegSettings()
{
}
void RegSettings::Write()
{
	HKEY hKey; DWORD disp;
	LONG res = RegCreateKeyEx(HKEY_CURRENT_USER,"Software\\Goom\\WMP9",0,NULL,0,KEY_WRITE,NULL,&hKey,&disp);
	if (res!=ERROR_SUCCESS) return;
	RegSetValueEx(hKey,"showfps",0,REG_BINARY,(LPBYTE)&showfps,sizeof(showfps));
	RegSetValueEx(hKey,"showtitle",0,REG_BINARY,(LPBYTE)&showtitle,sizeof(showtitle));
	RegSetValueEx(hKey,"surface_gl",0,REG_BINARY,(LPBYTE)&surface_gl,sizeof(surface_gl));
	RegSetValueEx(hKey,"zsval",0,REG_BINARY,(LPBYTE)&zsval,sizeof(zsval));
	RegSetValueEx(hKey,"fpslim",0,REG_BINARY,(LPBYTE)&fpslim,sizeof(fpslim));
	RegCloseKey(hKey);
	int i;
	for (i = 0; i < plug->nbParams; i++) {
		WriteSection(&plug->params[i]);
	}
}
void RegSettings::Read()
{
	DWORD cbData;
	HKEY hKey;
	LONG res = RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Goom\\WMP9",0,KEY_READ,&hKey);
	if (res!=ERROR_SUCCESS) return;
	cbData=sizeof(showfps);RegQueryValueEx(hKey,"showfps",0,NULL,(LPBYTE)&showfps,&cbData);
	cbData=sizeof(showtitle);RegQueryValueEx(hKey,"showtitle",0,NULL,(LPBYTE)&showtitle,&cbData);
	cbData=sizeof(surface_gl);RegQueryValueEx(hKey,"surface_gl",0,NULL,(LPBYTE)&surface_gl,&cbData);
	cbData=sizeof(zsval);RegQueryValueEx(hKey,"zsval",0,NULL,(LPBYTE)&zsval,&cbData);
	cbData=sizeof(fpslim);RegQueryValueEx(hKey,"fpslim",0,NULL,(LPBYTE)&fpslim,&cbData);
	RegCloseKey(hKey);
	int i;
	for (i = 0; i < plug->nbParams; i++) {
		ReadSection(&plug->params[i]);
	}
}
extern "C" void set_str_param_value(PluginParam *p, const char *str);
extern "C" void set_list_param_value(PluginParam *p, const char *str);
void RegSettings::ReadSection(PluginParameters *params)
{
	int i;
	DWORD cbData;
	HKEY hKey;
	char *keystr;
	int l = strlen("Software\\Goom\\WMP9\\") + strlen(params->name);
	keystr = new char[l+1];
	if (keystr == NULL) return;
	sprintf(keystr,"Software\\Goom\\WMP9\\");
	strcat(keystr,params->name);
	LONG res = RegOpenKeyEx(HKEY_CURRENT_USER,keystr,0,KEY_READ,&hKey);
	delete[] keystr;
	if (res!=ERROR_SUCCESS) return;
	for (i = 0; i < params->nbParams; i++) {
		if (params->params[i] == 0) continue;
		PluginParam *p = params->params[i];
		switch(p->type) {
		case (PARAM_INTVAL):
			{
				int v;
				cbData=sizeof(v);RegQueryValueEx(hKey,p->name,0,NULL,(LPBYTE)&v,&cbData);
				IVAL(*p)=v;
			}
			break;
		case (PARAM_FLOATVAL):
			if (p->rw) {
				float v;
				cbData=sizeof(v);RegQueryValueEx(hKey,p->name,0,NULL,(LPBYTE)&v,&cbData);
				FVAL(*p)=v;
			}
			break;
		case (PARAM_BOOLVAL):
			{
				int v;
				cbData=sizeof(v);RegQueryValueEx(hKey,p->name,0,NULL,(LPBYTE)&v,&cbData);
				BVAL(*p)=v;
			}
			break;
		case (PARAM_LISTVAL):
		case (PARAM_STRVAL):
			{
				LONG lret;
				DWORD ll;
				ll = strlen("Length ") + strlen(p->name);
				keystr = new char[ll+1];
				if (keystr == NULL) continue;
				sprintf(keystr,"Length ");
				strcat(keystr,p->name);
				cbData=sizeof(ll);
				lret=RegQueryValueEx(hKey,keystr,0,NULL,(LPBYTE)&ll,&cbData);
				delete[] keystr;
				if (lret == ERROR_SUCCESS) {
					cbData=ll;
					keystr = new char[ll+1];
					if (keystr == NULL) continue;
					RegQueryValueEx(hKey,p->name,0,NULL,(LPBYTE)keystr,&cbData);
					keystr[ll]='\0';
					if (p->type == PARAM_LISTVAL) {
						set_list_param_value(p,keystr);
					} else {
						set_str_param_value(p,keystr);
					}
					delete[] keystr;
				}
			}
			break;
		}
	}
	RegCloseKey(hKey);
}
void RegSettings::WriteSection(PluginParameters *params)
{
	int i;
	DWORD disp;
	HKEY hKey;
	char *keystr;
	int l = strlen("Software\\Goom\\WMP9\\") + strlen(params->name);
	keystr = new char[l+1];
	if (keystr == NULL) return;
	sprintf(keystr,"Software\\Goom\\WMP9\\");
	strcat(keystr,params->name);
	LONG res = RegCreateKeyEx(HKEY_CURRENT_USER,keystr,0,NULL,0,KEY_WRITE,NULL,&hKey,&disp);
	delete[] keystr;
	if (res!=ERROR_SUCCESS) return;
	for (i = 0; i < params->nbParams; i++) {
		if (params->params[i] == 0) continue;
		PluginParam *p = params->params[i];
		switch(p->type) {
		case (PARAM_INTVAL):
			{
				int v;
				v=IVAL(*p);
				RegSetValueEx(hKey,p->name,0,REG_BINARY,(LPBYTE)&v,sizeof(v));
			}
			break;
		case (PARAM_FLOATVAL):
			if (p->rw) {
				float v;
				v=FVAL(*p);
				RegSetValueEx(hKey,p->name,0,REG_BINARY,(LPBYTE)&v,sizeof(v));
			}
			break;
		case (PARAM_BOOLVAL):
			{
				int v;
				v=BVAL(*p);
				RegSetValueEx(hKey,p->name,0,REG_BINARY,(LPBYTE)&v,sizeof(v));
			}
			break;
		case (PARAM_LISTVAL):
		case (PARAM_STRVAL):
			{
				LPCTSTR v;
				if (p->type == PARAM_LISTVAL) {
					v=LVAL(*p);
				} else {
					v=SVAL(*p);
				}
				disp = strlen("Length ") + strlen(p->name);
				keystr = new char[disp+1];
				if (keystr == NULL) continue;
				sprintf(keystr,"Length ");
				strcat(keystr,p->name);
				disp=strlen(v);
				RegSetValueEx(hKey,keystr,0,REG_BINARY,(LPBYTE)&disp,sizeof(disp));
				delete[] keystr;
				RegSetValueEx(hKey,p->name,0,REG_BINARY,(LPBYTE)v,disp);
			}
			break;
		}
	}
	RegCloseKey(hKey);
}

PluginParam *RegSettings::FindValue(LPCTSTR sect, LPCTSTR name)
{
	int i,j;
	for (i = 0; i < plug->nbParams; i++) {
		if (strcmp(plug->params[i].name,sect)) continue;
		for (j = 0; j < plug->params[i].nbParams; j++) {
			if (plug->params[i].params[j] == 0) continue;
			PluginParam *p = plug->params[i].params[j];
			if (!strcmp(name,p->name)) return p;
		}
	}
	return NULL;
}


RegSettings *regset = NULL;


CWmp9_goom::CWmp9_goom() :
m_hwndParent(NULL),
m_clrForeground(0x0000FF),
m_nPreset(0)
{
    lstrcpyn(m_szPluginText, _T("wmp9_goom"), sizeof(m_szPluginText) / sizeof(m_szPluginText[0]));
    m_dwAdviseCookie = 0;
	surface_width = 320;
	surface_height = 240;
	bFirstRender = true;
	songTitle=NULL;
	oldRect.left=0;
	oldRect.right=0;
	oldRect.top=0;
	oldRect.bottom=0;
	msg_tab[1]=readme();
	plug=NULL;
	OutputDebugString("GOOM Constructor Called\n");

}

/////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::~CWmp9_goom
// Destructor

CWmp9_goom::~CWmp9_goom()
{
	if (songTitle != NULL) delete[] songTitle;
	OutputDebugString("GOOM Destructor Called\n");
}

/////////////////////////////////////////////////////////////////////////////
// CWmp9_goom:::FinalConstruct
// Called when an effect is first loaded. Use this function to do one-time
// intializations that could fail (i.e. creating offscreen buffers) instead
// of doing this in the constructor, which cannot return an error.

HRESULT CWmp9_goom::FinalConstruct()
{
    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CWmp9_goom:::FinalRelease
// Called when an effect is unloaded. Use this function to free any
// resources allocated in FinalConstruct.

void CWmp9_goom::FinalRelease()
{
    ReleaseCore();
}

static short s1 = 128;
static short s2 = 256;
static gint16 data[2][512];

static char *check_message_update(TimedLevel *pLevels)
{
	int i;
	char *message = NULL;

	/*
	for (i=0;i<512;i++)
		if (data[0][i]>2) {
			if (encore_nul > ENCORE_NUL_LOCK)
				encore_nul = 0;
			break;
		}
		*/

	if (pLevels->state == 2 && encore_nul > ENCORE_NUL_LOCK) {
		encore_nul = 0;
		i = 0;
	} else {
		i = 512;
	}
	
	if ((i == 512) && (encore_nul == 0))
		encore_nul = ENCORE_NUL_LOCK + 100;

	if (encore_nul == ENCORE_NUL_LOCK) {
		message = msg_tab[msg_pos];
		msg_pos ++;
		msg_pos %= 3;
	}

	msg_rotate_ogl = 0;
	if (encore_nul <= ENCORE_NUL_LOCK) { // wait a while before starting
		if (pLevels->state != 2) { // only rotate if we're not playing
			if (encore_nul > (ENCORE_NUL_LOCK - encore_frame_ogl[msg_pos])) { // shorten delay to resume rotating
				msg_rotate_ogl = 1;
			}
		}
	}

	if (encore_nul > 0) {
		encore_nul --;
	}

	return message;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::Render
// Called when an effect should render itself to the screen.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::Render(TimedLevel *pLevels, HDC hdc, RECT *prc)
{
	if (thr != NULL) thr->Pause();

	if (bFirstRender) {
		bFirstRender=false;
		int cc;
		for (cc = 0; cc < sizeof(BITMAPINFOHEADER)+260*4; cc++)
			bitmapbuffer[cc] = 0;
		bitmap_header = (BITMAPINFO *)&bitmapbuffer;
		bitmap_header->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bitmap_header->bmiHeader.biPlanes = 1;
		bitmap_header->bmiHeader.biBitCount = 32;
		bitmap_header->bmiHeader.biCompression = BI_BITFIELDS;
		bitmap_header->bmiHeader.biWidth = GOOM_BITMAP_WIDTH;
		bitmap_header->bmiHeader.biHeight = -GOOM_BITMAP_HEIGHT;	// note well
		((unsigned long *)bitmap_header->bmiColors)[0] = 0x00FF0000;
		((unsigned long *)bitmap_header->bmiColors)[1] = 0x0000FF00;
		((unsigned long *)bitmap_header->bmiColors)[2] = 0x000000FF;
	}

	if (goom_width != GOOM_BITMAP_WIDTH || goom_height != GOOM_BITMAP_HEIGHT) {
		goom_set_resolution(GOOM_BITMAP_WIDTH, GOOM_BITMAP_HEIGHT,0);
		goom_width = GOOM_BITMAP_WIDTH;
		goom_height = GOOM_BITMAP_HEIGHT;
	}

	int i;

	for (i = 0; i < 512; i++) {
		data[0][i] = ((short)pLevels->waveform[0][i]^s1) * s2;
		data[1][i] = ((short)pLevels->waveform[1][i]^s1) * s2;
	}


	float fps;
	fps = framerate_tester_getvalue();
	if (!regset->showfps) fps = -1.0f;

	char *st = songTitle;
	if (!regset->showtitle) st = NULL;

	char *message = check_message_update(pLevels);

	if (err_message != NULL) {
		message = err_message;
	}

	renderplug=goom_get_plugin();
	unsigned int *buf = goom_update(data,0,fps,st,message);
	framerate_tester_newframe();

	err_message = NULL;

	if (st != NULL) {
		delete st;
		songTitle=NULL;
	}

	int offx, offy;
	offx = (GOOM_BITMAP_WIDTH - (prc->right - prc->left) )>>1;
	offy = (GOOM_BITMAP_HEIGHT - (prc->bottom - prc->top)  )>>1;
	if (offx < 0) offx=0;
	if (offy < 0) offy=0;
    StretchDIBits(hdc, prc->left, prc->top, prc->right-prc->left, prc->bottom-prc->top, offx, offy, GOOM_BITMAP_WIDTH-(offx<<1), 
              GOOM_BITMAP_HEIGHT-(offy<<1), buf, bitmap_header, DIB_RGB_COLORS, SRCCOPY);
    
    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::MediaInfo
// Everytime new media is loaded, this method is called to pass the
// number of channels (mono/stereo), the sample rate of the media, and the
// title of the media
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::MediaInfo(LONG lChannelCount, LONG lSampleRate, BSTR bstrTitle )
{
	if (songTitle != NULL) delete songTitle;
	songTitle = _com_util::ConvertBSTRToString(bstrTitle);
	if (thr != NULL) {
		thr->NewSong(songTitle);
		songTitle=NULL;
	}
    return S_OK;
}


//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::GetCapabilities
// Returns the capabilities of this effect. Flags that can be returned are:
//	EFFECT_CANGOFULLSCREEN		-- effect supports full-screen rendering
//	EFFECT_HASPROPERTYPAGE		-- effect supports a property page
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::GetCapabilities(DWORD * pdwCapabilities)
{
    if (NULL == pdwCapabilities)
    {
        return E_POINTER;
    }

    *pdwCapabilities = EFFECT_HASPROPERTYPAGE | EFFECT_CANGOFULLSCREEN;
    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::DisplayPropertyPage
// Invoked when a host wants to display the property page for the effect
//////////////////////////////////////////////////////////////////////////////

typedef struct {
	UINT dlg;
	RegSettings *reg;
	int wrt;
} PropSheetData;

static void IntMeterChanged(PluginParam *p)
{
	if (p->user_data != 0) {
		::SendNotifyMessage((HWND)p->user_data, UDM_SETPOS, 0L,(LPARAM)MAKELONG((short)IVAL(*p),0));
	}
}
static void FloatMeterChanged(PluginParam *p)
{
	if (p->user_data != 0) {
	int v;
	v=int(100.0f*(FVAL(*p)-FMIN(*p))/(FMAX(*p)-FMIN(*p)));
	if (!p->rw) {
		::SendNotifyMessage((HWND)p->user_data, PBM_SETPOS, (WPARAM)v, 0L);
	} else {
		::SendNotifyMessage((HWND)p->user_data, TBM_SETPOS, TRUE, v);
	}
	}
}
static void SetupMeter(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u)
{
  PluginParam *p;
  HWND htmp;
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		int nUpper,nLower,nPos;
		  p->user_data=htmp;
		if (p->type == PARAM_INTVAL) {
			nUpper=IMAX(*p);
			nLower=IMIN(*p);
			nPos=IVAL(*p);
		::SendMessage(htmp, UDM_SETRANGE32, (WPARAM) nLower, (LPARAM) nUpper);
		::SendMessage(htmp, UDM_SETPOS, 0L, (LPARAM)MAKELONG((short)nPos,0));
		  p->change_listener=IntMeterChanged;
		} else if (p->type == PARAM_FLOATVAL) {
			nUpper=100;
			nLower=0;
			nPos=int(100.0f*(FVAL(*p)-FMIN(*p))/(FMAX(*p)-FMIN(*p)));
			if (!p->rw) {
				::SendMessage(htmp, PBM_SETRANGE32, (WPARAM) nLower, (LPARAM) nUpper);
				::SendMessage(htmp, PBM_SETPOS, (WPARAM)nPos, 0L);
				p->change_listener=FloatMeterChanged;
			} else {
				::SendMessage(htmp, TBM_SETRANGEMIN, FALSE, nLower);
				::SendMessage(htmp, TBM_SETRANGEMAX, FALSE, nUpper);
				::SendMessage(htmp, TBM_SETPOS, TRUE, nPos);
			}
		}
	}
  }
}
static void RetrieveMeter(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u)
{
  PluginParam *p;
  HWND htmp;
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		  p->user_data=htmp;
		if (p->type == PARAM_INTVAL) {
		  p->change_listener=empty_fct;
		} else if (p->type == PARAM_FLOATVAL) {
			if (!p->rw) {
			} else {
				int v = ::SendMessage(htmp, TBM_GETPOS, 0, 0l);
				FVAL(*p)=FMIN(*p)+((float)v)/100.0f*(FMAX(*p)-FMIN(*p));
			}
			p->change_listener=empty_fct;
		}
	}
  }
}
static void KillMeter(RegSettings *r, LPCTSTR sect, LPCTSTR name)
{
  PluginParam *p;
  if ((p=r->FindValue(sect,name)) != NULL) {
	  p->change_listener=empty_fct;
	  p->user_data=0;
  }
}
static void SetupSpinner(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u,UINT uspin)
{
  PluginParam *p;
  HWND htmp;
  char tmpc[20];
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		sprintf(tmpc,"%d",IVAL(*p));
		SendMessage(htmp,WM_SETTEXT,0,(LPARAM)tmpc);
		HWND hspin = GetDlgItem(hwnd,uspin);
		::SendMessage(hspin,UDM_SETBUDDY,(WPARAM)htmp,0);
		::SendMessage(hspin,UDM_SETRANGE,0,MAKELONG(IMAX(*p),IMIN(*p)));
	  }
  }
}

static void RetrieveSpinner(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u,UINT uspin)
{
  PluginParam *p;
  HWND htmp;
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		char tmpc[20];
		ZeroMemory(tmpc,20);
		int v;
		SendMessage(htmp,WM_GETTEXT,9,(LPARAM)tmpc);
		if (sscanf(tmpc,"%d",&v) == 1) {
			if (v > IMAX(*p)) {
				v = IMAX(*p);
			} else if (v < IMIN(*p)) {
				v = IMIN(*p);
			}
			IVAL(*p)=v;
		}
	}
  }
}
static void SetupCheck(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u)
{
  PluginParam *p;
  HWND htmp;
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		  if (BVAL(*p) != 0) {
			  SendMessage(htmp,BM_SETCHECK,BST_CHECKED,0);
		  } else {
			  SendMessage(htmp,BM_SETCHECK,BST_UNCHECKED,0);
		  }
	}
  }
}
static void RetrieveCheck(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u)
{
  PluginParam *p;
  HWND htmp;
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		if (SendMessage(htmp,BM_GETCHECK,0,0) == BST_CHECKED) {
			BVAL(*p) = 1;
		} else {
			BVAL(*p) = 0;
		}
	}
  }
}
static void SetupEdit(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u)
{
  PluginParam *p;
  HWND htmp = NULL;
  LPCTSTR v = NULL;
  if (sect != NULL) {
	  if ((p=r->FindValue(sect,name)) != NULL) {
		if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
			v=SVAL(*p);
		}
	}
  } else {
	  htmp = GetDlgItem(hwnd,u);
	  v=name;
  }
  char *tmp_read = new char[strlen(v)*2];
  int i,j;
  for (i = 0,j=0; i < (int)strlen(v); i++,j++) {
	  if (v[i] == '\n') {
		  tmp_read[j] = '\r';
		  j++;
	  }
	  tmp_read[j]=v[i];
  }
  tmp_read[j]='\0';
  SendMessage(htmp,WM_SETTEXT,0,(LPARAM)tmp_read);
  delete[] tmp_read;

}
static void RetrieveEdit(RegSettings *r, HWND hwnd, LPCTSTR sect, LPCTSTR name, UINT u)
{
  PluginParam *p;
  HWND htmp = NULL;
  LPCTSTR v = NULL;
  if ((p=r->FindValue(sect,name)) != NULL) {
	if ((htmp = GetDlgItem(hwnd,u)) != NULL) {
		int nget=257;
		int nalloc=256;
		char *tmp_read = NULL;
		while (nget >= nalloc) {
			if (tmp_read != NULL) delete[] tmp_read;
			nalloc = nalloc * 2;
			tmp_read = new char[nalloc];
			if (tmp_read == NULL) return;
			ZeroMemory(tmp_read,nalloc);
			nget = SendMessage(htmp,WM_GETTEXT,(WPARAM)nalloc,(LPARAM)tmp_read) + 1;
		}
		char *w = new char[strlen(tmp_read)+2];
		if (w == NULL) {
			delete[] tmp_read;
			return;
		}
		int i,j=0;
		for (i = 0; i < (int)strlen(tmp_read); i++) {
			if (tmp_read[i] == '\r') continue;
			w[j]=tmp_read[i];
			j++;
		}
		w[j]='\0';
		set_str_param_value(p,w);
		delete[] w;
		delete[] tmp_read;
	}
  }

}

static BOOL APIENTRY PropDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	RegSettings *ptmpreg = NULL;
	PropSheetData *data;
	if (msg!=WM_INITDIALOG) {
		data = (PropSheetData*)GetWindowLong(hwnd,DWL_USER);
		if (data == NULL) return FALSE;
		ptmpreg = data->reg;
		if (ptmpreg==NULL) return FALSE;
	}
  switch (msg) 
  { case WM_INITDIALOG:
    { 
		PROPSHEETPAGE *psp = (PROPSHEETPAGE*)lParam;
		data = (PropSheetData*)(psp->lParam);
      ptmpreg = data->reg;
      SetWindowLong(hwnd,DWL_USER,(LONG)data);
	  if (data->dlg == IDD_GOOM_ABOUT) {
		  SetupEdit(ptmpreg,hwnd,NULL,
			  "What a GOOM!! v2\n\ncopyright 2000-2004, by J.C. Hoelt <jeko@free.fr>\n\nThis is my first visual plugins for XMMS, and I\nthink that it's the best I have ever done !\n\n---\n\nThis dialog will help you to configure goom.\nMany options here will seem strange to you,\nanyway, just try things and look what happen !\n\nEnjoy,\n\n\tJeko"
			  ,IDC_EDIT_ABOUT);
	  } else if (data->dlg == IDD_GOOM_PP) {
		  HWND htmp = GetDlgItem(hwnd,IDC_CHECK_FPS);
		  if (ptmpreg->showfps) {
			  SendMessage(htmp,BM_SETCHECK,BST_CHECKED,0);
		  } else {
			  SendMessage(htmp,BM_SETCHECK,BST_UNCHECKED,0);
		  }
		  htmp = GetDlgItem(hwnd,IDC_CHECK_TITLE);
		  if (ptmpreg->showtitle) {
			  SendMessage(htmp,BM_SETCHECK,BST_CHECKED,0);
		  } else {
			  SendMessage(htmp,BM_SETCHECK,BST_UNCHECKED,0);
		  }
		  htmp = GetDlgItem(hwnd,IDC_CHECK_GL);
		  if (ptmpreg->surface_gl) {
			  SendMessage(htmp,BM_SETCHECK,BST_CHECKED,0);
		  } else {
			  SendMessage(htmp,BM_SETCHECK,BST_UNCHECKED,0);
		  }
		  if (ptmpreg->zsval == -1.0f) {
			  ::CheckRadioButton(hwnd,IDC_RADIO_ZSM5,IDC_RADIO_ZSM1,IDC_RADIO_ZSM1);
		  } else if (ptmpreg->zsval == -2.0f) {
			  ::CheckRadioButton(hwnd,IDC_RADIO_ZSM5,IDC_RADIO_ZSM1,IDC_RADIO_ZSM3);
		  } else {
			  ::CheckRadioButton(hwnd,IDC_RADIO_ZSM5,IDC_RADIO_ZSM1,IDC_RADIO_ZSM5);
		  }
			HWND hlim = GetDlgItem(hwnd,IDC_COMBO_FPSLIM);
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"5");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"10");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"15");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"20");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"25");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"30");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"None");
			SendMessage(hlim,CB_SETCURSEL,(WPARAM)ptmpreg->fpslim,0);
	  } else if (data->dlg == IDD_GOOM_SOUND) {
		  SetupSpinner(ptmpreg,hwnd,"Sound","Big Goom Speed Limit",IDC_EDIT_BIG_GOOM_SL,IDC_SPIN_BIG_GOOM_SL);
		  SetupSpinner(ptmpreg,hwnd,"Sound","Big Goom Factor",IDC_EDIT_BIG_GOOM_FACT,IDC_SPIN_BIG_GOOM_FACT);
		  SetupMeter(ptmpreg,hwnd,"Sound","Sound Volume",IDC_PROGRESS_GOOM_SV);
		  SetupMeter(ptmpreg,hwnd,"Sound","Sound Acceleration",IDC_PROGRESS_GOOM_SA);
		  SetupMeter(ptmpreg,hwnd,"Sound","Sound Speed",IDC_PROGRESS_GOOM_SP);
		  SetupMeter(ptmpreg,hwnd,"Sound","Goom Limit",IDC_PROGRESS_GOOM_LM);
		  SetupMeter(ptmpreg,hwnd,"Sound","Goom Power",IDC_PROGRESS_GOOM_POW);
		  SetupMeter(ptmpreg,hwnd,"Sound","Goom Detection",IDC_PROGRESS_GOOM_DET);
		  SetupMeter(ptmpreg,hwnd,"Sound","Big Goom Detection",IDC_PROGRESS_BIGGOOM_DET);
	  } else if (data->dlg == IDD_GOOM_BRIGHT_FLASH) {
		  SetupMeter(ptmpreg,hwnd,"Bright Flash","Screen Brightness",IDC_SLIDER_SCREEN_BRIGHT);
		  SetupMeter(ptmpreg,hwnd,"Bright Flash","Flash Intensity",IDC_SLIDER_FLASH_INT);
		  SetupMeter(ptmpreg,hwnd,"Bright Flash","Factor",IDC_PROGRESS_FACTOR);
		  SetupEdit(ptmpreg,hwnd,"Bright Flash","Script",IDC_EDIT_SCRIPT);
		  SetupCheck(ptmpreg,hwnd,"Bright Flash","Compile",IDC_CHECK1);
	  } else if (data->dlg == IDD_GOOM_PARTICLE) {
		  SetupSpinner(ptmpreg,hwnd,"Particule System","FX Mode",IDC_EDIT_FX_MODE,IDC_SPIN_FX_MODE);
		  SetupMeter(ptmpreg,hwnd,"Particule System","FX Mode",IDC_SPIN_FX_MODE);
		  SetupSpinner(ptmpreg,hwnd,"Particule System","Max Number of Particules",IDC_EDIT_MAX_PART,IDC_SPIN_MAX_PART);
		  SetupSpinner(ptmpreg,hwnd,"Particule System","Fireworks Largest Bombs",IDC_EDIT_FIRE_LARGE,IDC_SPIN_FIRE_LARGE);
		  SetupSpinner(ptmpreg,hwnd,"Particule System","Fireworks Smallest Bombs",IDC_EDIT_FIRE_SMALL,IDC_SPIN_FIRE_SMALL);
		  SetupMeter(ptmpreg,hwnd,"Particule System","Number of Particules (% of Max)",IDC_PROGRESS_PART_PCT);
	  } else if (data->dlg == IDD_GOOM_TENTACLE) {
		  SetupCheck(ptmpreg,hwnd,"3D Tentacles","Enabled",IDC_CHECK1);
	  } else if (data->dlg == IDD_GOOM_ZOOM_FILTER) {
		  SetupCheck(ptmpreg,hwnd,"Zoom Filter","Enabled",IDC_CHECK1);
	  }
      return TRUE;
    }
    case WM_COMMAND:
    {
		/*
	WORD id = LOWORD(wParam);
      if (id==ID_EDIT)
      {
        return TRUE;
      }
	  */
      return FALSE;
    }
    case WM_NOTIFY:
    {
		int code=(((NMHDR FAR *) lParam)->code);
		if (code == PSN_APPLY && ptmpreg != NULL) {
			if (data->dlg == IDD_GOOM_PP) {
			  HWND htmp = GetDlgItem(hwnd,IDC_CHECK_FPS);
			  if (htmp != NULL) ptmpreg->showfps = (SendMessage(htmp,BM_GETCHECK,0,0) == BST_CHECKED);
			  htmp = GetDlgItem(hwnd,IDC_CHECK_TITLE);
			  if (htmp != NULL) ptmpreg->showtitle = (SendMessage(htmp,BM_GETCHECK,0,0) == BST_CHECKED);
			  htmp = GetDlgItem(hwnd,IDC_CHECK_GL);
			  if (htmp != NULL) ptmpreg->surface_gl = (SendMessage(htmp,BM_GETCHECK,0,0) == BST_CHECKED);
			  if (::IsDlgButtonChecked(hwnd,IDC_RADIO_ZSM1)) {
				  ptmpreg->zsval = -1.0f;
			  } else if (::IsDlgButtonChecked(hwnd,IDC_RADIO_ZSM3)) {
				  ptmpreg->zsval = -2.0f;
			  } else {
				  ptmpreg->zsval = -5.0f;
			  }
				zshift=ptmpreg->zsval;
				HWND hlim = GetDlgItem(hwnd,IDC_COMBO_FPSLIM);
				ptmpreg->fpslim=SendMessage(hlim,CB_GETCURSEL,0,0);
				data->wrt=1;
			} else if (data->dlg == IDD_GOOM_SOUND) {
				RetrieveSpinner(ptmpreg,hwnd,"Sound","Big Goom Speed Limit",IDC_EDIT_BIG_GOOM_SL,IDC_SPIN_BIG_GOOM_SL);
				RetrieveSpinner(ptmpreg,hwnd,"Sound","Big Goom Factor",IDC_EDIT_BIG_GOOM_FACT,IDC_SPIN_BIG_GOOM_FACT);
				data->wrt=1;
			} else if (data->dlg == IDD_GOOM_BRIGHT_FLASH) {
				RetrieveMeter(ptmpreg,hwnd,"Bright Flash","Screen Brightness",IDC_SLIDER_SCREEN_BRIGHT);
				RetrieveMeter(ptmpreg,hwnd,"Bright Flash","Flash Intensity",IDC_SLIDER_FLASH_INT);
				RetrieveEdit(ptmpreg,hwnd,"Bright Flash","Script",IDC_EDIT_SCRIPT);
				RetrieveCheck(ptmpreg,hwnd,"Bright Flash","Compile",IDC_CHECK1);
				data->wrt=1;
			} else if (data->dlg == IDD_GOOM_PARTICLE) {
				  RetrieveSpinner(ptmpreg,hwnd,"Particule System","Max Number of Particules",IDC_EDIT_MAX_PART,IDC_SPIN_MAX_PART);
				  RetrieveSpinner(ptmpreg,hwnd,"Particule System","Fireworks Largest Bombs",IDC_EDIT_FIRE_LARGE,IDC_SPIN_FIRE_LARGE);
				  RetrieveSpinner(ptmpreg,hwnd,"Particule System","Fireworks Smallest Bombs",IDC_EDIT_FIRE_SMALL,IDC_SPIN_FIRE_SMALL);
				data->wrt=1;
			} else if (data->dlg == IDD_GOOM_TENTACLE) {
				RetrieveCheck(ptmpreg,hwnd,"3D Tentacles","Enabled",IDC_CHECK1);
				data->wrt=1;
			} else if (data->dlg == IDD_GOOM_ZOOM_FILTER) {
				RetrieveCheck(ptmpreg,hwnd,"Zoom Filter","Enabled",IDC_CHECK1);
				data->wrt=1;
			}
		} 
      return TRUE;
    }
    case WM_DESTROY:
    {
		  KillMeter(ptmpreg,"Sound","Sound Volume");
		  KillMeter(ptmpreg,"Sound","Sound Acceleration");
		  KillMeter(ptmpreg,"Sound","Sound Speed");
		  KillMeter(ptmpreg,"Sound","Goom Limit");
		  KillMeter(ptmpreg,"Sound","Goom Power");
		  KillMeter(ptmpreg,"Sound","Goom Detection");
		  KillMeter(ptmpreg,"Sound","Big Goom Detection");
		  KillMeter(ptmpreg,"Particule System","Number of Particules (% of Max)");
		  KillMeter(ptmpreg,"Particule System","FX Mode");
		  KillMeter(ptmpreg,"Bright Flash","Screen Brightness");
		  KillMeter(ptmpreg,"Bright Flash","Flash Intensity");
		  KillMeter(ptmpreg,"Bright Flash","Factor");
		  OutputDebugString("Killing Meters\n");
      return TRUE;
    }
  }
  return FALSE;
}
static void AddPropSheet(PROPSHEETPAGE& psp, PropSheetData *psd, LPCTSTR title, UINT idd, RegSettings *reg)
{
  psp.dwSize = sizeof(PROPSHEETPAGE);
  psp.dwFlags = PSP_USETITLE;
  psp.hInstance = _Module.m_hInst;
  psp.pszTemplate = MAKEINTRESOURCE(idd);
  psp.pszIcon = 0;
  psp.pfnDlgProc = PropDlgProc;
  psp.pszTitle = title;
  psp.lParam=(LPARAM)psd;
  psp.pfnCallback = NULL;
  psd->dlg = idd;
  psd->reg = reg;
  psd->wrt = 0;
}
STDMETHODIMP CWmp9_goom::DisplayPropertyPage(HWND hwndOwner)
{
	PropSheetData psd[7];
 PROPSHEETPAGE psp[7];
  PROPSHEETHEADER psh;
	PluginInfo *propsheet_plug = NULL;
  if (renderplug != NULL) {
	  propsheet_plug = renderplug;
  } else if (plug != NULL) {
	  propsheet_plug = plug;
  } else {
	  goom_init(128,128,0);
	  propsheet_plug = goom_get_plugin();
  }
  RegSettings tmpreg(propsheet_plug);
  int i=0;
  AddPropSheet(psp[i],&psd[i],"About",IDD_GOOM_ABOUT,NULL); i++;
  AddPropSheet(psp[i],&psd[i],"Display",IDD_GOOM_PP,&tmpreg); i++;
  AddPropSheet(psp[i],&psd[i],"Sound",IDD_GOOM_SOUND,&tmpreg); i++;
  AddPropSheet(psp[i],&psd[i],"Bright Flash",IDD_GOOM_BRIGHT_FLASH,&tmpreg); i++;
  AddPropSheet(psp[i],&psd[i],"Particle System",IDD_GOOM_PARTICLE,&tmpreg); i++;
  AddPropSheet(psp[i],&psd[i],"3D Tentacles",IDD_GOOM_TENTACLE,&tmpreg); i++;
  AddPropSheet(psp[i],&psd[i],"Zoom Filter",IDD_GOOM_ZOOM_FILTER,&tmpreg); i++;
  psh.dwSize = sizeof(PROPSHEETHEADER);
  psh.dwFlags = PSH_PROPSHEETPAGE;
  psh.hwndParent = hwndOwner;
  psh.hInstance = psp[0].hInstance;
  psh.pszIcon = 0;
  psh.pszCaption = (LPSTR) "Goom! Visualization";
  psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
  psh.nStartPage = 0;
  psh.ppsp = (LPCPROPSHEETPAGE) &psp;
  psh.pfnCallback = NULL;
  PropertySheet(&psh);

  for (i = 0; i < (int)psh.nPages; i++) {
	 if (psd[i].wrt != 0) {
		 tmpreg.Write();
		  if (regset) {
			  regset->Read();
			  break;
		  }
	  }
  }
  if (propsheet_plug != plug && propsheet_plug != renderplug) {
	  goom_close();
  }

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::GetTitle
// Invoked when a host wants to obtain the title of the effect
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::GetTitle(BSTR* bstrTitle)
{
    USES_CONVERSION;

    if (NULL == bstrTitle)
    {
        return E_POINTER;
    }

    CComBSTR bstrTemp;
    bstrTemp.LoadString(IDS_EFFECTNAME); 
        
    if ((!bstrTemp) || (0 == bstrTemp.Length()))
    {
        return E_FAIL;
    }

    *bstrTitle = bstrTemp.Detach();

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::GetPresetTitle
// Invoked when a host wants to obtain the title of the given preset
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::GetPresetTitle(LONG nPreset, BSTR *bstrPresetTitle)
{
    USES_CONVERSION;

    if (NULL == bstrPresetTitle)
    {
        return E_POINTER;
    }

    if ((nPreset < 0) || (nPreset >= PRESET_COUNT))
    {
        return E_INVALIDARG;
    }

    CComBSTR bstrTemp;
    
    switch (nPreset)
    {
    case PRESET_320_240:
        bstrTemp.LoadString(IDS_320_240); 
        break;
    case PRESET_480_360:
        bstrTemp.LoadString(IDS_480_360); 
        break;
    case PRESET_640_480:
        bstrTemp.LoadString(IDS_640_480); 
        break;
    case PRESET_800_600:
        bstrTemp.LoadString(IDS_800_600); 
        break;
    }
    
    if ((!bstrTemp) || (0 == bstrTemp.Length()))
    {
        return E_FAIL;
    }

    *bstrPresetTitle = bstrTemp.Detach();

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::GetPresetCount
// Invoked when a host wants to obtain the number of supported presets
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::GetPresetCount(LONG *pnPresetCount)
{
    if (NULL == pnPresetCount)
    {
        return E_POINTER;
    }

    *pnPresetCount = PRESET_COUNT;

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::SetCurrentPreset
// Invoked when a host wants to change the index of the current preset
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::SetCurrentPreset(LONG nPreset)
{
    if ((nPreset < 0) || (nPreset >= PRESET_COUNT))
    {
        return E_INVALIDARG;
    }

    m_nPreset = nPreset;

    switch (nPreset)
    {
    case PRESET_320_240:
		surface_width=320;
		surface_height=240;
        break;
    case PRESET_480_360:
		surface_width=480;
		surface_height=360;
        break;
    case PRESET_640_480:
		surface_width=600;
		surface_height=480;
        break;
    case PRESET_800_600:
		surface_width=800;
		surface_height=600;
        break;
    }


    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::GetCurrentPreset
// Invoked when a host wants to obtain the index of the current preset
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::GetCurrentPreset(LONG *pnPreset)
{
    if (NULL == pnPreset)
    {
        return E_POINTER;
    }

    *pnPreset = m_nPreset;

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::SetCore
// Set WMP core interface
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::SetCore(IWMPCore * pCore)
{
    HRESULT hr = S_OK;

    // release any existing WMP core interfaces
    ReleaseCore();

    // If we get passed a NULL core, this  means
    // that the plugin is being shutdown.

    if (pCore == NULL)
    {
		goom_ref_cnt--;
		if (goom_ref_cnt == 0) {
			if (thr != NULL) {
				thr->Stop();
				delete thr;
				thr=NULL;
			}
			goom_close();
			framerate_tester_close();
			if (regset) delete regset;
			regset=NULL;
			if (renderplug == plug) renderplug=NULL;
			plug=NULL;
		}
        return S_OK;
    } else {
		if (goom_ref_cnt == 0) {
			goom_init(256,256,0);
			plug=goom_get_plugin();
			regset = new RegSettings(plug);
			if (regset->surface_gl) {
				goom_width = 256;
				goom_height = 256;
			} else {
				goom_set_resolution(surface_width,surface_height,0);
				goom_width = surface_width;
				goom_height = surface_height;
			}
			framerate_tester_init();
		}
		goom_ref_cnt++;
	}

    m_spCore = pCore;

    // connect up the event interface
    CComPtr<IConnectionPointContainer>  spConnectionContainer;

    hr = m_spCore->QueryInterface( &spConnectionContainer );

    if (SUCCEEDED(hr))
    {
        hr = spConnectionContainer->FindConnectionPoint( __uuidof(IWMPEvents), &m_spConnectionPoint );
    }

    if (SUCCEEDED(hr))
    {
        hr = m_spConnectionPoint->Advise( GetUnknown(), &m_dwAdviseCookie );

        if ((FAILED(hr)) || (0 == m_dwAdviseCookie))
        {
            m_spConnectionPoint = NULL;
        }
    }

    return hr;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::Create
// Invoked when the visualization should be initialized.
//
// If hwndParent != NULL, RenderWindowed() will be called and the visualization
// should draw into the window specified by hwndParent. This will be the
// behavior when the visualization is hosted in a window.
//
// If hwndParent == NULL, Render() will be called and the visualization
// should draw into the DC passed to Render(). This will be the behavior when
// the visualization is hosted windowless (like in a skin for example).
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::Create(HWND hwndParent)
{
	HWND oldHwnd = m_hwndParent;
    m_hwndParent = hwndParent;
	if (hwndParent != NULL) {
		if (thr != NULL) {
			thr->Stop();
			delete thr;
		} else {
			if (win_ok != 0) {
				if (win_gl) {
					ptc_gl_close();
				} else {
					ptc_close();
				}
				win_ok=0;
				win_wnd=NULL;
			}
		}
#ifdef _DEBUG
		char tmpstr[64];
		sprintf(tmpstr,"GOOM9::HWND=%08x,%08x\n",hwndParent,oldHwnd);
		OutputDebugString(tmpstr);
#endif
#if 1
		thr = new ThreadRender(m_hwndParent,_Module.m_hInst,surface_width,surface_height);
#else
		if (regset->surface_gl) {
			ptc_gl_set_hwnd(hwndParent);
			win_ok = ptc_gl_open("goom",256,256);
			zshift = regset->zsval;
		} else {
//			ptc_set_parent(m_hwndParent,_Module.m_hInst);
			ptc_set_hwnd(m_hwndParent);
			win_ok = ptc_open("goom",surface_width,surface_height);
		}
		win_width=surface_width;
		win_height=surface_height;
		win_gl = regset->surface_gl;
		HWND htmp = hwndParent;
		if (win_ok != 0) win_wnd = hwndParent;
#endif
	}

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::Destroy
// Invoked when the visualization should be released.
//
// Any resources allocated for rendering should be released.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::Destroy()
{
	if (m_hwndParent != NULL) {
		OutputDebugString("Goom9::DESTROY\n");
		if (thr != NULL) {
			thr->Stop();
			delete thr;
			thr=NULL;
		} else {
			if (win_ok != 0) {
				if (win_gl) {
					ptc_gl_close();
				} else {
					ptc_close();
				}
				win_ok=0;
				win_wnd=NULL;
			}
		}
	}

    m_hwndParent = NULL;

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::NotifyNewMedia
// Invoked when a new media stream begins playing.
//
// The visualization can inspect this object for properties (like name or artist)
// that might be interesting for visualization.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::NotifyNewMedia(IWMPMedia *pMedia)
{
    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::OnWindowMessage
// Window messages sent to the parent window.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::OnWindowMessage(UINT msg, WPARAM WParam, LPARAM LParam, LRESULT *plResultParam )
{
    // return S_OK only if the plugin has handled the window message
    // return S_FALSE to let the defWindowProc handle the message
	if (msg == WM_DESTROY) OutputDebugString("GOOM9::Got WM_DESTROY\n");
	if (msg == WM_CLOSE) OutputDebugString("GOOM9::Got WM_CLOSE\n");
	if (msg == WM_SIZE) {
		if (WParam == SIZE_MINIMIZED) OutputDebugString("GOOM9::Got Minimized\n");
		if (WParam == SIZE_RESTORED) OutputDebugString("GOOM9::Got Restored\n");
		if (WParam == SIZE_MAXIMIZED) OutputDebugString("GOOM9::Got Maximized\n");
	}
    return S_FALSE;
}


//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::RenderWindowed
// Called when an effect should render itself to the screen.
//
// The fRequiredRender flag specifies if an update is required, otherwise the
// update is optional. This allows visualizations that are fairly static (for example,
// album art visualizations) to only render when the parent window requires it,
// instead of n times a second for dynamic visualizations.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::RenderWindowed(TimedLevel *pLevels, BOOL fRequiredRender )
{
    // NULL parent window should not happen 
    if (NULL == m_hwndParent)
    {
        return E_UNEXPECTED;
    }
	renderplug=goom_get_plugin();
	if (thr != NULL) {
		if (thr->IsDone()) {
			delete thr;
			thr = new ThreadRender(m_hwndParent,_Module.m_hInst,surface_width,surface_height);
		}
		thr->NewData(pLevels,m_hwndParent,surface_width,surface_height);
		thr->Start();
		return S_OK;
	}
	int exp_w;
	int exp_h;


	if (regset->surface_gl) {
		exp_w = 256;
		exp_h = 256;
	} else {
		exp_w = surface_width;
		exp_h = surface_height;
	}
	
	if (win_width != surface_width || win_height != surface_height || win_gl != regset->surface_gl
		|| m_hwndParent != win_wnd) {
		if (!regset->surface_gl || !win_gl || win_wnd != m_hwndParent) {
			if (win_gl) {
				if (win_ok != 0) ptc_gl_close();
			} else {
				if (win_ok != 0) ptc_close();
			}
			Sleep(2);
			if (regset->surface_gl) {
				ptc_gl_set_hwnd(m_hwndParent);
				win_ok = ptc_gl_open("Goom",256,256);
				zshift = regset->zsval;
				win_width = 256;
				win_height = 256;
				if (win_ok == 0) {
					err_message = "Failed To Initialize OpenGL :(";
				} else {
					err_message = NULL;
				}
			} else {
//				ptc_set_parent(m_hwndParent,_Module.m_hInst);
				ptc_set_hwnd(m_hwndParent);
				win_ok = ptc_open("Goom",surface_width,surface_height);
				win_width = surface_width;
				win_height = surface_height;
				if (win_ok == 0) {
					err_message = "Failed To Initialize DirectDraw :(";
				} else {
					err_message = NULL;
				}
			}
		}
		win_gl = regset->surface_gl;
		if (win_ok != 0) win_wnd = m_hwndParent;
	}

	if (win_ok == 0) {
		HDC hdc = GetDC(m_hwndParent);
		if (hdc != NULL) {
			RECT rc;
			GetClientRect(m_hwndParent,&rc);
			Render(pLevels,hdc,&rc);
			ReleaseDC(m_hwndParent,hdc);
		}
		return S_OK;
	}

	if (goom_width != exp_w || goom_height != exp_h || win_gl != regset->surface_gl) {
		if (!regset->surface_gl || !win_gl) {
			if (regset->surface_gl) {
				goom_set_resolution(256,256,0);
				goom_width = 256;
				goom_height = 256;
			} else {
				goom_set_resolution(surface_width, surface_height,0);
				goom_width = surface_width;
				goom_height = surface_height;
			}
		} else if (goom_width != 256 || goom_height != 256) {
			goom_set_resolution(256,256,0);
			goom_width = 256;
			goom_height = 256;
		}
	}


	int i;

	for (i = 0; i < 512; i++) {
		data[0][i] = ((short)pLevels->waveform[0][i]^s1) * s2;
		data[1][i] = ((short)pLevels->waveform[1][i]^s1) * s2;
	}

	float fps;
	fps = framerate_tester_getvalue();
	if (!regset->showfps) fps = -1.0f;
	
	char *st = songTitle;
	if (!regset->showtitle) st = NULL;

	char *message = check_message_update(pLevels);

	unsigned int *buf = goom_update(data,0,fps,st,message);
	framerate_tester_newframe();

	if (st != NULL) {
		delete st;
		songTitle=NULL;
	}

	if (win_gl) {
		RECT cr;
		::GetClientRect(m_hwndParent,&cr);
		if ((cr.right - cr.left) != (oldRect.right - oldRect.left) || 
			(cr.bottom - cr.top) != (oldRect.bottom - oldRect.top)) {
			ReSizeGLScene(cr.right - cr.left,cr.bottom - cr.top);
			::CopyRect(&oldRect,&cr);
		}
		ptc_gl_update(buf);
	} else {
		ptc_update(buf);
	}

    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::ReleaseCore
// Release WMP core interfaces
//////////////////////////////////////////////////////////////////////////////
void CWmp9_goom::ReleaseCore()
{
    if (m_spConnectionPoint)
    {
        if (0 != m_dwAdviseCookie)
        {
            m_spConnectionPoint->Unadvise(m_dwAdviseCookie);
            m_dwAdviseCookie = 0;
        }
        m_spConnectionPoint = NULL;
    }

    if (m_spCore)
    {
        m_spCore = NULL;
    }
}

//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::get_foregroundColor
// Property get to retrieve the foregroundColor prop via the public interface.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::get_foregroundColor(BSTR *pVal)
{
	return ColorToWz( pVal, m_clrForeground);
}


//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::put_foregroundColor
// Property put to set the foregroundColor prop via the public interface.
//////////////////////////////////////////////////////////////////////////////
STDMETHODIMP CWmp9_goom::put_foregroundColor(BSTR newVal)
{
	return WzToColor(newVal, &m_clrForeground);
}


//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::WzToColor
// Helper function used to convert a string into a COLORREF.
//////////////////////////////////////////////////////////////////////////////
HRESULT CWmp9_goom::WzToColor(const WCHAR *pwszColor, COLORREF *pcrColor)
{ 
    if (NULL == pwszColor)
    {
        //NULL color string passed in
        return E_POINTER;
    }

    if (0 == lstrlenW(pwszColor))
    {
        //Empty color string passed in
        return E_INVALIDARG;
    }

    if (NULL == pcrColor)
    {
        //NULL output color DWORD passed in
        return E_POINTER;
    }
    
    if (lstrlenW(pwszColor) != 7)
    {
        //hex color string is not of the correct length
        return E_INVALIDARG;
    }

    DWORD dwRet = 0;
    for (int i = 1; i < 7; i++)
    {
        // shift dwRet by 4
        dwRet <<= 4;
        // and add in the value of this string

        if ((pwszColor[i] >= L'0') && (pwszColor[i] <= L'9'))
        {
            dwRet += pwszColor[i] - '0';
        }
        else if ((pwszColor[i] >= L'A') && (pwszColor[i] <= L'F'))
        {
            dwRet += 10 + (pwszColor[i] - L'A');
        }
        else if ((pwszColor[i] >= L'a') && (pwszColor[i] <= L'f'))
        {
            dwRet += 10 + (pwszColor[i] - L'a');
        }
        else
        {
           //Invalid hex digit in color string
            return E_INVALIDARG;
        }
    }

    *pcrColor = SwapBytes(dwRet);

    return S_OK;
} 


//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::ColorToWz
// Helper function used to convert a COLORREF to a BSTR.
//////////////////////////////////////////////////////////////////////////////
HRESULT CWmp9_goom::ColorToWz( BSTR* pbstrColor, COLORREF crColor)
{
    _ASSERT( NULL != pbstrColor );
    _ASSERT( (crColor & 0x00FFFFFF) == crColor );

    *pbstrColor = NULL;

    WCHAR wsz[8];
    HRESULT hr  = S_OK;

    wsprintfW( wsz, L"#%06X", SwapBytes(crColor) );
    
    *pbstrColor = ::SysAllocString( wsz );

    if (!pbstrColor)
    {
        hr = E_FAIL;
    }

    return hr;
}


//////////////////////////////////////////////////////////////////////////////
// CWmp9_goom::SwapBytes
// Used to convert between a DWORD and COLORREF.  Simply swaps the lowest 
// and 3rd order bytes.
//////////////////////////////////////////////////////////////////////////////
inline DWORD CWmp9_goom::SwapBytes(DWORD dwRet)
{
    return ((dwRet & 0x0000FF00) | ((dwRet & 0x00FF0000) >> 16) | ((dwRet & 0x000000FF) << 16));
}

