/******************************************************************************/
/* This file is originally written by:                                        */
/*                                                                            */
/*   Sigurd Enghoff                                                           */
/*   The Salk Institute, CNL                                                  */
/*   enghoff@salk.edu                                                         */
/*                                                                            */
/* And has been modified by Tak-Shing Chan:                                   */
/*                                                                            */
/*   - Assumed real is double and integer is int                              */
/*   - Renamed extended to ext for compatibility with BSD and Solaris         */
/*   - Incorporated F77_FUNC wrappers from autoconf                           */
/*   - Removed R250 stuffs                                                    */
/*                                                                            */
/******************************************************************************/

#ifndef ICA_H
#define ICA_H

#include "config.h"

/* If KURTOSIS_ESTIMATE is defined sub- and super-Gaussian distributions are  */
/* estimated using:                                                           */
/*    k = E{u^2}^2 / E{x^4} - 3                                               */
/* else:                                                                      */
/*    k = E{sech(u)^2} * E{u^2} - E{tanh(u) * u}                              */

#define KURTOSIS_ESTIMATE

#define MAX_WEIGHT             1e8
#define DEFAULT_STOP           0.000001
#define DEFAULT_ANNEALDEG      60
#define DEFAULT_ANNEALSTEP     0.90
#define DEFAULT_EXTANNEAL      0.98
#define DEFAULT_MAXSTEPS       512
#define DEFAULT_MOMENTUM       0.0

#define DEFAULT_BLOWUP         1000000000.0
#define DEFAULT_BLOWUP_FAC     0.8
#define DEFAULT_RESTART_FAC    0.9

#define MIN_LRATE              0.000001
#define MAX_LRATE              0.1
#define DEFAULT_LRATE(chans)   0.015/log((double)chans)

#define DEFAULT_BLOCK(length)  (int)sqrt((double)length/3.0)

/* Extended-ICA option: */
#define DEFAULT_EXTENDED       0
#define DEFAULT_EXTBLOCKS      1
#define DEFAULT_NSUB           1

#define DEFAULT_EXTMOMENTUM    0.5
#define MAX_PDFSIZE            6000
#define MIN_PDFSIZE            2000
#define SIGNCOUNT_THRESHOLD    25

#ifdef KURTOSIS_ESTIMATE
#define DEFAULT_SIGNSBIAS      0.02
#else
#define DEFAULT_SIGNSBIAS      0.0
#endif

#define SIGNCOUNT_STEP         2

#define DEFAULT_BIASFLAG       1

#define MIN(x,y) (((x) > (y)) ? (y) : (x))
#define DEGCONST               180.0/ICA_PI
#define ICA_PI                 3.14159265358979324

#define DEFAULT_PCAFLAG        0
#define DEFAULT_SPHEREFLAG     1
#define DEFAULT_POSACT         1
#define DEFAULT_VERBOSE        1

#define NWINDOW                5
#define FRAMEWINDOW            0
#define FRAMESTEP              1
#define EPOCHWINDOW            2
#define EPOCHSTEP              3
#define BASELINE               4

#define EOL 0x0A
/* Fixing the seed causes multiple runs of a given */
/* configuration to yield identical results */
/* #define FIX_SEED */

typedef struct {
    int    idx;
    double val;
} idxelm;

typedef struct {
    char *token;
    void *prev;
} key;

extern int ext, extblocks, pdfsize, nsub;
extern int verbose, block, maxsteps;

extern double lrate, annealstep, annealdeg, nochange, momentum;

extern void error(char*);

extern void zero(int, double*);
extern void eye(int, double*);
extern void rmmean(double*, int, int);
extern void syproj(double*, double*, int, int, double*);
extern void geproj(double*, double*, int, int, double*);
extern void pcaproj(double*, double*, int, int, int, double*);
extern void varsort(double*, double*, double*, double*, double*, int*, int, int, int);
extern void do_sphere(double*, int, int, double*);
extern void pca(double*, int, int, double*);
extern void posact(double*, double*, int, int, double*);
extern void runica(double*, double*, int, int, int, double*, int*);
extern double F77_FUNC(dsum,DSUM)(int*, double*, int*);
extern double F77_FUNC(ddot,DDOT)(int*, double*, int*, double*, int*);
extern int F77_FUNC(idamax,IDAMAX)(int*, double*, int*);
extern int F77_FUNC(ilaenv,ILAENV)(int*, char*, char*, int*, int*, int*, int*);
extern void F77_FUNC(dscal,DSCAL)(int*, double*, double*, int*);
extern void F77_FUNC(dcopy,DCOPY)(int*, double*, int*, double*, int*);
extern void F77_FUNC(dswap,DSWAP)(int*, double*, int*, double*, int*);
extern void F77_FUNC(daxpy,DAXPY)(int*, double*, double*, int*, double*, int*);
extern void F77_FUNC(dgemv,DGEMV)(char*, int*, int*, double*, double*, int*, double*, int*, double*, double*, int*);
extern void F77_FUNC(dgemm,DGEMM)(char*, char*, int*, int*, int*, double*, double*, int*, double*, int*, double*, double*, int*);
extern void F77_FUNC(dsymm,DSYMM)(char*, char*, int*, int*, double*, double*, int*, double*, int*, double*, double*, int*);
extern void F77_FUNC(dsyrk,DSYRK)(char*, char*, int*, int*, double*, double*, int*, double*, double*, int*);
extern void F77_FUNC(dsyev,DSYEV)(char*, char*, int*, double*, int*, double*, double*, int*, int*);
extern void F77_FUNC(dgesv,DGESV)(int*, int*, double*, int*, int*, double*, int*, int*);
extern void F77_FUNC(dgetri,DGETRI)(int*, double*, int*, int*, double*, int*, int*);
extern void F77_FUNC(dgetrf,DGETRF)(int*, int*, double*, int*, int*, int*);

#endif
