# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

### This file is not in a locales directory to prevent it from
### being translated as the feature is still in heavy development
### and strings are likely to change often.

-pioneer-brand-short-name = Pioneer
pioneer = { -pioneer-brand-short-name }
pioneer-document-title = Put your data to work for a better internet
pioneer-summary = { -pioneer-brand-short-name } puts your data to work to address some of today’s most pressing technology concerns, like misinformation, data privacy, and ethical AI. The data you agree to share with Mozilla (the makers of Firefox) helps create tools for better internet transparency and design products that give control back to the people who use them. As a { -pioneer-brand-short-name } participant, you’ll also have the option to contribute your data to studies sponsored by research institutions and other organizations.
pioneer-study-prompt = Join to enroll
pioneer-join-study = Join Study
pioneer-leave-study = Leave Study
pioneer-enrollment-button = Join { -pioneer-brand-short-name }
pioneer-unenrollment-button = Leave { -pioneer-brand-short-name }
pioneer-current-studies = Current Studies
pioneer-no-current-studies = No current studies, please check back later.
pioneer-end-study = End Study
pioneer-ended-study = Study Ended
pioneer-accept-participate = Accept and Participate
pioneer-accept-leave = Accept and Leave
pioneer-cancel = Cancel
pioneer-consent-notice = { -pioneer-brand-short-name } Privacy Notice
pioneer-consent-study-notice = { -pioneer-brand-short-name } Study Privacy Consent Notice
pioneer-leave = Leaving { -pioneer-brand-short-name }
pioneer-consent-study-title = Leaving Study
pioneer-consent-study-join = Accept and Join Study
pioneer-consent-study-leave = Accept and Leave Study

pioneer-program-consent-intro = When you enroll in { -pioneer-brand-short-name }, you are sharing personal information. Keeping that information safe is important to us and to the integrity of { -pioneer-brand-short-name }. Here is how we safeguard your data and protect your identity.

pioneer-program-study-intro = When you enroll in this study, you are sharing personal information. Keeping that information safe is important to us and to the integrity of { -pioneer-brand-short-name }. Here is how we safeguard your data and protect your identity.


pioneer-works-title = How it works:
pioneer-works-bullet-get-started-title = Get started.
pioneer-works-bullet-get-started-content = Select the { pioneer-enrollment-button } button, review and agree to our Privacy Notice, and answer a few (optional) demographic questions.  Note that { -pioneer-brand-short-name } is currently open to participants in the US who are 19 or older.
pioneer-works-bullet-enroll-title = Enroll in studies.
pioneer-works-bullet-enroll-content = Share your data with studies run by { -vendor-short-name } and our { -pioneer-brand-short-name } research partners. You’ll have the opportunity to learn about a study’s goals, the data it collects, and its research team before you enroll.
pioneer-works-bullet-control-title = Stay in control.
pioneer-works-bullet-control-content = The { -pioneer-brand-short-name } icon will appear on the { -brand-product-name } toolbar. Select the icon any time you want to return to this page to update your settings, enroll in a study, or leave a study or the { -pioneer-brand-short-name } program.

pioneer-your-data-title = Your data: why it matters and how we protect it
pioneer-your-data-summary = { -pioneer-brand-short-name } puts your data to work for a better internet. Our goal is to better understand topics like internet usage, online privacy, algorithmic bias, discrimination, and misinformation. This in turn can lead to new products that fundamentally change the tech landscape and hand more power and control back to users.

pioneer-your-data-bullet-know = You’ll know the information we plan to collect before we collect it. We publish our data collection documentation, so you can confirm this for yourself. Read each privacy notice for detailed information.
pioneer-your-data-bullet-lengths = We prioritize securing your data and protecting your privacy.
pioneer-your-data-bullet-leave = You can leave the { -pioneer-brand-short-name } program at any time, and we’ll stop collecting data when you do.
pioneer-your-data-learn-more = Learn more about <a data-l10n-name="privacy-policy">managing the data you share</a> with { -pioneer-brand-short-name }.

pioneer-us-only = Sorry, { -pioneer-brand-short-name } is currently only open to participants in the US.

pioneer-enroll-effective-date = Effective September 1, 2020
pioneer-enroll-summary = { -pioneer-brand-short-name } is an experimental initiative led by Mozilla to better understand how our users use and navigate the internet. { -pioneer-brand-short-name } is available to Firefox users in the United States who are 19 or older.
pioneer-enroll-demographic = When you join { -pioneer-brand-short-name }, we’ll ask you to provide optional demographic data. We’ll also collect basic technical and interaction data as long as you’re participating in { -pioneer-brand-short-name }. Once you’ve enrolled, you’ll have the opportunity to join available studies—each study will have a specific research purpose and unique privacy notice for you to review before you join it.
pioneer-enroll-privacy-notice = In this Privacy Notice, we detail what data the { -pioneer-brand-short-name } program collects and discloses, and why. Read each study’s privacy notice for information about how data is collected and handled in that particular study. We also adhere to the <a data-l10n-name="privacy-notice">Mozilla Privacy Policy</a> for how we receive, handle, and share information.
pioneer-enroll-data-disclosure = To see a full list of the data we collect, click <a data-l10n-name="privacy-policy">here</a>.
pioneer-enroll-what-we-collect = What Information We Collect:
pioneer-enroll-collect-demographic = <strong>Demographic data:</strong> We collect optional, self-reported demographic data from { -pioneer-brand-short-name } participants, including their age, gender, race/ethnicity, education level, household income, and zip code.
pioneer-enroll-technical-data = <strong>Technical data:</strong> We collect basic information about your device’s operating system. When Firefox sends data to us, your IP address is temporarily collected as part of our server logs.
pioneer-enroll-interaction-data = <strong>Interaction data:</strong> We collect data about your interactions with Firefox, like number and type of installed Firefox Add-ons and your active browsing session duration.
pioneer-enroll-location-data = <strong>Location data:</strong> We will use your IP address to approximate your country location, in addition to collecting your self-reported zip code (if you provide it).
pioneer-enroll-how-we-use = How We Use Your Information:
pioneer-enroll-r-and-d = We use the information we collect for for <strong>research and development</strong>, including:
pioneer-enroll-bullet-criteria = To determine which participants meet the criteria to be available to participate in particular research studies
pioneer-enroll-bullet-representative = To ensure our data sets are representative of the many users of Firefox
pioneer-enroll-bullet-improve-existing = To improve our existing products and services
pioneer-enroll-bullet-create = To create and develop new products
pioneer-enroll-who-we-disclose-to = Who We May Disclose Information To:
pioneer-enroll-who-we-disclose-bullet-gcp = <strong>Google Cloud Platform (GCP):</strong> We use GCP as our cloud-storage service. Mozilla has contracted with GCP requiring them to handle the data in ways that are approved by us.
pioneer-enroll-who-we-disclose-bullet-third-party = <strong>Third-party researchers:</strong> As part of being part of the { -pioneer-brand-short-name } program, we will offer you the ability to join studies. If necessary for the study, we may ask you to share all or some of the data collected under this Privacy Notice with the third party researcher(s) administering a study. Mozilla will contractually obligate the third party researchers to ensure that your data is handled in ways that are approved by us.
pioneer-enroll-who-we-disclose-bullet-public = <strong>General public:</strong> To advance our <a data-l10n-name="mozilla-manifesto">mission of being open</a>, we may release data sets to the general public. When we do so, we will aggregate the data and remove identifying information, so the data won’t reveal the behaviors or characteristics of individual users.
pioneer-enroll-data-management = Data Management:
pioneer-enroll-data-management-learn-more = You can learn more about managing your { -pioneer-brand-short-name } and individual study data <a data-l10n-name="privacy-policy">here</a>. If you have any other questions regarding our privacy practices, please contact us at <a data-l10n-name="compliance-email">compliance@mozilla.com</a>.
