# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = Здарылася памылка падчас злучэння з { $hostname }. { $errorMessage }

# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Код памылкі: { $error }

psmerr-ssl-disabled = Немагчыма бяспечна злучыцца, бо пратакол SSL забаронены.
psmerr-ssl2-disabled = Немагчыма бяспечна злучыцца, бо сайт карыстаецца састарэлай небяспечнай версіяй пратакола SSL.

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Вы атрымалі няспраўны сертыфікат.  Звяжыцеся, калі ласка, з адміністратарам сервера ці з э-паштовым карэспандэнтам і паведаміце ім наступныя звесткі:
    
    Ваш сертыфікат змяшчае серыйны нумар, аднолькавы з нумарам іншага сертыфіката, выдадзенага цэнтрам сертыфікацыі.  Атрымайце, калі ласка, новы сертыфікат, які змяшчае ўнікальны серыйны нумар.

ssl-error-export-only-server = Немагчыма бяспечна злучыцца. Пір не падтрымлівае высокаўзроўневае шыфраванне.
ssl-error-us-only-server = Немагчыма бяспечна злучыцца. Пір патрабуе высокаўзроўневае шыфраванне, якое не падтрымліваецца.
ssl-error-no-cypher-overlap = Немагчыма бяспечна злучыцца з пірам: няма агульнага алгарытму(-аў) шыфравання.
ssl-error-no-certificate = Немагчыма знайсці сертыфікат або ключ, патрэбныя для аўтэнтыфікацыі.
ssl-error-bad-certificate = Немагчыма бяспечна злучыцца з пірам: сертыфікат піра быў адхілены.
ssl-error-bad-client = Сервер атрымаў кепскія дадзеныя з кліента.
ssl-error-bad-server = Кліент атрымаў кепскія дадзеныя з сервера.
ssl-error-unsupported-certificate-type = Тып сертыфіката не падтрымліваецца.
ssl-error-unsupported-version = Версія пратакола бяспекі, якую ўжывае пір, не падтрымліваецца.
ssl-error-wrong-certificate = Не выйшла аўтэнтыфікаваць кліент: прыватны ключ у базе дадзеных ключоў не адпавядае публічнаму ключу ў базе дадзеных сертыфікатаў.
ssl-error-bad-cert-domain = Немагчыма бяспечныя злучыцца з пірам: запатрабаваная назва дамена не адпавядае сертыфікату сервера.
ssl-error-post-warning = Нераспазнаны код памылкі SSL.
ssl-error-ssl2-disabled = Пір падтрымлівае толькі 2-ю версію SSL, якая лакальна забаронена.
ssl-error-bad-mac-read = SSL атрымаў запіс з няправільным Кодам Аўтэнтыфікацыі Паведамлення.
ssl-error-bad-mac-alert = SSL-пір паведамляе пра няправільны Код Аўтэнтыфікацыі Паведамлення.
ssl-error-bad-cert-alert = SSL-пір не можа праверыць ваш сертыфікат.
ssl-error-revoked-cert-alert = SSL-пір адхіліў ваш сертыфікат як адкліканы.
ssl-error-expired-cert-alert = SSL-пір адхіліў ваш сертыфікат як састарэлы.
ssl-error-ssl-disabled = Немагчыма злучыцца: SSL забаронены.
ssl-error-fortezza-pqg = Немагчыма злучыцца: SSL-пір у іншым дамене FORTEZZA.
ssl-error-unknown-cipher-suite = Запатрабаваны невядомы набор шыфраў SSL.
ssl-error-no-ciphers-supported = Няма прысутных і дазволеных набораў шыфраў у гэтай праграме.
ssl-error-bad-block-padding = SSL атрымаў запіс з дрэннай падбіўкай блокаў.
ssl-error-rx-record-too-long = SSL атрымаў запіс, даўжыня якога перавышае найбольшую дазволеную.
ssl-error-tx-record-too-long = SSL спрабаваў даслаць запіс, даўжыня якога перавышае найбольшую дазволеную.
ssl-error-rx-malformed-hello-request = SSL атрымаў няскладнае рукапаціскальнае паведамленне Запыт Прывітання.
ssl-error-rx-malformed-client-hello = SSL атрымаў скажонае рукапаціскальнае паведамленне Прывітанне Карыстальніка.
ssl-error-rx-malformed-server-hello = SSL атрымаў скажонае рукапаціскальнае паведамленне Прывітанне Сервера.
ssl-error-rx-malformed-certificate = SSL атрымаў няскладнае рукапаціскальнае паведамленне Пасведчанне.
ssl-error-rx-malformed-server-key-exch = SSL атрымаў скажонае рукапаціскальнае паведамленне Абмен Ключом Сервера.
ssl-error-rx-malformed-cert-request = SSL атрымаў няскладнае рукапаціскальнае паведамленне Запыт Пасведчання.
ssl-error-rx-malformed-hello-done = SSL атрымаў скажонае рукапаціскальнае паведамленне Прывітанне Сервера Зроблена.
ssl-error-rx-malformed-cert-verify = SSL атрымаў скажонае рукапаціскальнае паведамленне Праверка Сертыфіката.
ssl-error-rx-malformed-client-key-exch = SSL атрымаў скажонае рукапаціскальнае паведамленне Абмен Ключом Карыстальніка.
ssl-error-rx-malformed-finished = SSL атрымаў няскладнае рукапаціскальнае паведамленне Скончана.
ssl-error-rx-malformed-change-cipher = SSL атрымаў няскладны запіс Вызначэнне Змены Шрыфту.
ssl-error-rx-malformed-alert = SSL атрымаў няскладны запіс Перасцярога.
ssl-error-rx-malformed-handshake = SSL атрымаў няскладны запіс Рукапацісканне.
ssl-error-rx-malformed-application-data = SSL атрымаў скажоны запіс Дадзеныя Праграмы.
ssl-error-rx-unexpected-hello-request = SSL атрымаў нечаканае рукапаціскальнае паведамленне Запыт Прывітання.
ssl-error-rx-unexpected-client-hello = SSL атрымаў нечаканае рукапаціскальнае паведамленне Прывітанне Карыстальніка.
ssl-error-rx-unexpected-server-hello = SSL атрымаў нечаканае рукапаціскальнае паведамленне Прывітанне Сервера.
ssl-error-rx-unexpected-certificate = SSL атрымаў нечаканае рукапаціскальнае паведамленне Сертыфікат.
ssl-error-rx-unexpected-server-key-exch = SSL атрымаў нечаканае рукапаціскальнае паведамленне Абмен Ключом Сервера.
ssl-error-rx-unexpected-cert-request = SSL атрымаў нечаканае рукапаціскальнае паведамленне Запыт Сертыфіката.
ssl-error-rx-unexpected-hello-done = SSL атрымаў нечаканае рукапаціскальнае паведамленне Прывітанне Сервера Зроблена.
ssl-error-rx-unexpected-cert-verify = SSL атрымаў нечаканае рукапаціскальнае паведамленне Праверка Сертыфіката.
ssl-error-rx-unexpected-client-key-exch = SSL атрымаў нечаканае рукапаціскальнае паведамленне Абмен Ключом Карыстальніка.
ssl-error-rx-unexpected-finished = SSL атрымаў нечаканае рукапаціскальнае паведамленне Скончана.
ssl-error-rx-unexpected-change-cipher = SSL атрымаў нечаканы запіс Вызначэнне Змены Шрыфту.
ssl-error-rx-unexpected-alert = SSL атрымаў нечаканы запіс Перасцярога.
ssl-error-rx-unexpected-handshake = SSL атрымаў нечаканы запіс Рукапацісканне.
ssl-error-rx-unexpected-application-data = SSL атрымаў нечаканы запіс Дадзеныя Праграмы.
ssl-error-rx-unknown-record-type = SSL атрымаў запіс з невядомым тыпам змесціва.
ssl-error-rx-unknown-handshake = SSL атрымаў рукапаціскальнае паведамленне невядомага тыпу.
ssl-error-rx-unknown-alert = SSL атрымаў перасцярожны запіс з невядомым апісаннем перасцярогі.
ssl-error-close-notify-alert = SSL-пір выдаліў гэтае злучэнне.
ssl-error-handshake-unexpected-alert = SSL-пір не чакаў рукапаціскальнае паведамленне, якое ён атрымаў.
ssl-error-decompression-failure-alert = SSL-пір не здольны паспяхова расціснуць атрыманы запіс SSL.
ssl-error-handshake-failure-alert = SSL-пір не здольны знайсці прымальную сукупнасць параметраў бяспекі.
ssl-error-illegal-parameter-alert = SSL-пір адхіліў рукапаціскальнае паведамленне з-за непрымальнага змесціва.
ssl-error-unsupported-cert-alert = SSL-пір не падтрымлівае тыпы пасведчанняў, якія ён атрымаў.
ssl-error-certificate-unknown-alert = SSL-пір мае нейкую нявызначаную праблему з атрыманым пасведчаннем.
ssl-error-generate-random-failure = SSL зазнаў няўдачу яго генератара выпадковых лікаў.
ssl-error-sign-hashes-failure = Немагчыма лічбава падпісаць дадзеныя, неабходныя для праверкі вашага сертыфіката.
ssl-error-extract-public-key-failure = SSL не здолеў выняць публічны ключ з сертыфіката піра.
ssl-error-server-key-exchange-failure = Нявызначаная няўдача падчас апрацоўкі SSL-рукапаціскання Абмен Ключом Сервера.
ssl-error-client-key-exchange-failure = Нявызначаная няўдача падчас апрацоўкі SSL-рукапаціскання Абмен Ключом Карыстальніка.
ssl-error-encryption-failure = Няўдача масавага алгарытму шыфравання дадзеных у вылучаным наборы шыфраў.
ssl-error-decryption-failure = Няўдача масавага алгарытму дэшыфравання дадзеных у вылучаным наборы шыфраў.
ssl-error-socket-write-failure = Няўдача спробы запісу тайнапісных дадзеных ў сокет, што ляжыць ніжэй.
ssl-error-md5-digest-failure = Няўдача функцыі digest MD5.
ssl-error-sha-digest-failure = Няўдача функцыі digest SHA-1.
ssl-error-mac-computation-failure = Няўдача вылічэння MAC.
ssl-error-sym-key-context-failure = Няўдача стварэння змесціва Сіметрычнага Ключа.
ssl-error-sym-key-unwrap-failure = Няўдача разгорткі сіметрычнага ключа ў паведамленні Абмен Ключом Карыстальніка.
ssl-error-pub-key-size-limit-exceeded = Сервер SSL спрабаваў ужыць публічны ключ хатняга вырабу з экспартным наборам шыфраў.
ssl-error-iv-param-failure = Код PKCS11 пацярпеў няўдачу пры перакладзе IV у параметр.
ssl-error-init-cipher-suite-failure = Няўдача ініцыялізацыі вылучанага збору шыфраў.
ssl-error-session-key-gen-failure = Карыстальнік пацярпеў няўдачу пры стварэнні сеансавых ключоў для сеансу SSL.
ssl-error-no-server-key-for-alg = У сервера няма ключоў для дадзенага алгарытму абмену ключамі.
ssl-error-token-insertion-removal = Лексема PKCS#11 была ўстаўлена або прынята пакуль дзеянне выконвалася.
ssl-error-token-slot-not-found = Немагчыма знайсці лексему PKCS#11, каб зрабіць патрэбнае дзеянне.
ssl-error-no-compression-overlap = Немагчыма мець зносіны з пірам бяспечна: няма агульнага алгарытму(-аў) сціскання.
ssl-error-handshake-not-completed = Немагчыма пачаць іншае рукапацісканне SSL, пакуль цяперашняе не скончана.
ssl-error-bad-handshake-hash-value = Атрыманы памылковыя хэш-значэнні рукапаціскання ад піра.
ssl-error-cert-kea-mismatch = Дадзены сертыфікат не можа выкарыстоўвацца ў выбраным алгарытме абмену ключамі.
ssl-error-no-trusted-ssl-client-ca = Няма цэнтраў сертыфікацыі, якія маюць давер для аўтарызацыі карыстальнікаў SSL.
ssl-error-session-not-found = Ідэнтыфікатар сеансу SSL не знойдзены ў сеансавым кэшы сервера.
ssl-error-decryption-failed-alert = Пір не здолеў расшыфраваць атрыманы запіс SSL.
ssl-error-record-overflow-alert = Пір атрымаў запіс SSL, памер якога большы за дазволены.
ssl-error-unknown-ca-alert = Пір не распазнаў ЦС, які выдаў ваша пасведчанне, і не давярае яму.
ssl-error-access-denied-alert = Пір атрымаў дапушчальнае пасведчанне, але забараніў доступ.
ssl-error-decode-error-alert = Пір не здолеў дэкадаваць паведамленне рукапаціскання SSL.
ssl-error-decrypt-error-alert = Пір паведамляе пра няўдачу праверкі подпісу або няўдачу абмену ключамі.
ssl-error-export-restriction-alert = Пір паведамляе, што перамовы не адпавядаюць прадпісанням экспарту.
ssl-error-protocol-version-alert = Пір скардзіцца, што версія пратакола не падтрымліваецца, ці што яна несумяшчальная.
ssl-error-insufficient-security-alert = Сервер патрабуе больш бяспечныя шыфры, чым тыя, што падтрымліваюцца кліентам.
ssl-error-internal-error-alert = Пір паведамляе, што зазнаў унутраную памылку.
ssl-error-user-canceled-alert = Рукапацісканне з пірам скасавана карыстальнікам.
ssl-error-no-renegotiation-alert = Пір не дазваляе пераўзгодніць параметры бяспекі SSL.
ssl-error-server-cache-not-configured = Кэш SSL сервера не наладжаны і не забаронены для гэтага сокета.
ssl-error-unsupported-extension-alert = SSL-пір не падтрымлівае запатрабаванае пашырэнне вітання TLS.
ssl-error-certificate-unobtainable-alert = SSL-пір не можа атрымаць ваш сертыфікат з дадзенага URL.
ssl-error-unrecognized-name-alert = SSL-пір не мае сертыфіката для запатрабаванай назвы DNS.
ssl-error-bad-cert-status-response-alert = SSL-пір не здольны атрымаць адказ OCSP з яго сертыфікатам.
ssl-error-bad-cert-hash-value-alert = SSL-пір паведаміў пра дрэннае хэш-значэнне сертыфіката.
ssl-error-rx-unexpected-new-session-ticket = SSL атрымаў нечаканае паведамленне рукапаціскання "Білет новага сеанса".
ssl-error-rx-malformed-new-session-ticket = SSL атрымаў скажонае паведамленне рукапаціскання "Білет новага сеанса".
ssl-error-decompression-failure = SSL атрымаў сціснуты запіс, які немагчыма расціснуць.
ssl-error-renegotiation-not-allowed = Пераўзгадненне ўмоваў не дазволена для гэтага сокета SSL.
ssl-error-unsafe-negotiation = Пір спрабаваў ужыць рукапацісканне састарэлага тыпу (магчыма ўразлівае).
ssl-error-rx-unexpected-uncompressed-record = SSL атрымаў нечаканы нясціснуты запіс.
ssl-error-weak-server-ephemeral-dh-key = SSL атрымаў слабы недаўгавечны ключ Diffie-Hellman у рукапаціскальным паведамленні Абмену Ключом з Серверам.
ssl-error-next-protocol-data-invalid = SSL атрымаў няспраўныя дадзеныя пашырэння NPN.
ssl-error-feature-not-supported-for-ssl2 = Магчымасць SSL не падтрымліваецца для злучэнняў SSL 2.0.
ssl-error-feature-not-supported-for-servers = Магчымасць SSL не падтрымліваецца для сервераў.
ssl-error-feature-not-supported-for-clients = Магчымасць SSL не падтрымліваецца для кліентаў.
ssl-error-invalid-version-range = Хібны дыяпазон версій SSL.
ssl-error-cipher-disallowed-for-version = SSL-пір выбраў набор шыфраў, забаронены для выбранай версіі пратакола.
ssl-error-rx-malformed-hello-verify-request = SSL атрымаў некарэктнае паведамленне поціску рук Hello Verify Request.
ssl-error-rx-unexpected-hello-verify-request = SSL атрымаў нечаканае паведамленне поціску рук Hello Verify Request.
ssl-error-feature-not-supported-for-version = Магчымасць SSL не падтрымліваецца для гэтай версіі пратаколу.
ssl-error-rx-unexpected-cert-status = SSL атрымаў нечаканае паведамленне поціску рук Статус Сертыфіката.
ssl-error-unsupported-hash-algorithm = TLS-пір выкарыстоўвае непадтрыманы алгарытм хэшавання.
ssl-error-digest-failure = Памылка функцыі digest.
ssl-error-incorrect-signature-algorithm = Некарэктны алгарытм подпісу ўказаны ў лічбава-падпісаным элеменце.
ssl-error-next-protocol-no-callback = Наступнае пашырэнне пратаколу перамоваў было ўключана, але зваротны выклік быў ачышчаны раней, чым трэба.
ssl-error-next-protocol-no-protocol = Сервер не падтрымлівае ніводзін з пратаколаў, якія кліент прапануе ў пашырэнні ALPN.
ssl-error-inappropriate-fallback-alert = Сервер адхіліў поціск рук, таму што кліент паніжаны да версіі TLS ніжэй, чым сервер падтрымлівае.
ssl-error-weak-server-cert-key = Сертыфікат сервера ўключае публічны ключ, які занадта слабы.
ssl-error-rx-short-dtls-read = Недастаткова месца для буферызацыі запісаў DTLS.
ssl-error-no-supported-signature-algorithm = Не наладжаны ні адзін падтрыманы алгарытм подпісу TLS.
ssl-error-unsupported-signature-algorithm = Пір выкарыстоўвае непадтрыманае спалучэнне алгарытмаў подпісу і хэшавання.
ssl-error-missing-extended-master-secret = Пір спрабаваў прадоўжыць без карэктнага пашырэння extended_master_secret.
ssl-error-unexpected-extended-master-secret = Пір спрабаваў прадоўжыць з нечаканым пашырэннем extended_master_secret.
sec-error-io = Здарылася памылка ўводу/вываду падчас бяспечнага апазнавання.
sec-error-library-failure = няўдача бібліятэкі бяспекі.
sec-error-bad-data = бібліятэка бяспекі: атрыманы кепскія дадзеныя.
sec-error-output-len = бібліятэка бяспекі: памылковая даўжыня вываду.
sec-error-input-len = бібліятэка бяспекі зазнала памылку з даўжынёй уводу.
sec-error-invalid-args = бібліятэка бяспекі: кепскія аргументы.
sec-error-invalid-algorithm = бібліятэка бяспекі: недапушчальны алгарытм.
sec-error-invalid-ava = бібліятэка бяспекі: недапушчальны AVA.
sec-error-invalid-time = Няправільна адфарматаваны радок часу.
sec-error-bad-der = бібліятэка бяспекі: няправільна адфарматаванае DER-закадаванае паведамленне.
sec-error-bad-signature = Сертыфікат піра мае няспраўны подпіс.
sec-error-expired-certificate = Сертыфікат піра састарэў.
sec-error-revoked-certificate = Сертыфікат піра адкліканы.
sec-error-unknown-issuer = Выдавец сертыфіката піра не распазнаны.
sec-error-bad-key = Публічны ключ піра няспраўны.
sec-error-bad-password = Уведзены няправільны пароль бяспекі.
sec-error-retry-password = Новы пароль уведзены няправільна. Паспрабуйце, калі ласка, зноў.
sec-error-no-nodelock = бібліятэка бяспекі: няма замыкання вузла.
sec-error-bad-database = бібліятэка бяспекі: дрэнная база дадзеных.
sec-error-no-memory = бібліятэка бяспекі: няўдачы вылучэння памяці.
sec-error-untrusted-issuer = Выдавец сертыфіката піра пазначаны карыстальнікам як выдавец, які не мае даверу.
sec-error-untrusted-cert = Сертыфікат піра пазначаны карыстальнікам як сертыфікат, які не мае даверу.
sec-error-duplicate-cert = Сертыфікат ужо ёсць у вашай базе дадзеных.
sec-error-duplicate-cert-name = Назва атрыманага сертыфіката супадае з іншай, якая ёсць у вашай базе дадзеных.
sec-error-adding-cert = Памылка дадання сертыфіката ў базу дадзеных.
sec-error-filing-key = Памылка перазапаўнення ключа для гэтага сертыфіката.
sec-error-no-key = Немагчыма адшукаць прыватны ключ у базе ключоў
sec-error-cert-valid = Гэты сертыфікат сапраўдны.
sec-error-cert-not-valid = Гэты сертыфікат несапраўдны.
sec-error-cert-no-response = Бібліятэка сертыфікатаў: няма адказу
sec-error-expired-issuer-certificate = Сертыфікат выдаўца гэтага сертыфіката састарэў. Праверце дату і час вашай сістэмы.
sec-error-crl-expired = САП для гэтага выдаўца сертыфіката састарэў. Абнавіце яго або праверце дату і час вашай сістэмы.
sec-error-crl-bad-signature = САП для гэтага выдаўца сертыфікатаў мае няспраўны подпіс.
sec-error-crl-invalid = Новы САП мае недапушчальны фармат.
sec-error-extension-value-invalid = Недапушчальнае значэнне пашырэння сертыфіката.
sec-error-extension-not-found = Пашырэнне сертыфіката не знойдзена.
sec-error-ca-cert-invalid = Няспраўны сертыфікат выдаўца.
sec-error-path-len-constraint-invalid = Дрэннае абмежаванне даўжыні шляху сертыфіката.
sec-error-cert-usages-invalid = Дрэннае поле, якое апісвае выкарыстанні сертыфіката.
sec-internal-only = **Толькі ўнутраны модуль**
sec-error-invalid-key = Ключ не падтрымлівае запатрабаванае дзеянне.
sec-error-unknown-critical-extension = Сертыфікат змяшчае невядомае крытычнае пашырэнне.
sec-error-old-crl = Новы САП не навейшы чым цяперашні.
sec-error-no-email-cert = Не зашыфраваны і не падпісаны: вы яшчэ не маеце сертыфіката эл.пошты.
sec-error-no-recipient-certs-query = Не зашыфраваны: вы не маеце сертыфікаты для кожнага атрымальніка.
sec-error-not-a-recipient = Немагчыма дэшыфраваць: ці вы не атрымальнік, ці няма адпаведнага сертыфіката і прыватнага ключа.
sec-error-pkcs7-keyalg-mismatch = Немагчыма дэшыфраваць: алгарытм шыфравання ключа не адпавядае вашаму сертыфікату.
sec-error-pkcs7-bad-signature = Няўдача праверкі подпісу: ці не знойдзены падпісальнік, ці занадта многа падпісальнікаў, ці дадзеныя непрыдатныя або пашкоджаныя.
sec-error-unsupported-keyalg = Алгарытм ключа ці невядомы, ці не падтрымліваецца.
sec-error-decryption-disallowed = Немагчыма дэшыфраваць: зашыфравана з дапамогаю забароненага алгарытму ці памеру ключа.
xp-sec-fortezza-bad-card = Картка Fortezza не была ініцыялізавана належным чынам. Выдаліце яе, калі ласка, і вярніце вашаму выдаўцу.
xp-sec-fortezza-no-card = Не знойдзены карткі Fortezza
xp-sec-fortezza-none-selected = Картка Fortezza не вылучана
xp-sec-fortezza-more-info = Вылучыце, калі ласка, асобу, каб атрымаць падрабязныя звесткі пра яе
xp-sec-fortezza-person-not-found = Асоба не знойдзена
xp-sec-fortezza-no-more-info = Няма больш звестак пра гэтую асобу
xp-sec-fortezza-bad-pin = Няспраўны ключ
xp-sec-fortezza-person-error = Немагчыма прадвызначыць асобы Fortezza.
sec-error-no-krl = Не знойдзены KRL для сертыфіката гэтага сайта.
sec-error-krl-expired = KRL для сертыфіката гэтага сайта састарэў.
sec-error-krl-bad-signature = KRL для сертыфіката гэтага сайта мае няспраўны подпіс.
sec-error-revoked-key = Ключ сертыфіката гэтага сайта быў адкліканы.
sec-error-krl-invalid = Новы KRL мае недапушчальны фармат.
sec-error-need-random = бібліятэка бяспекі: патрэбны выпадковыя дадзеныя.
sec-error-no-module = бібліятэка бяспекі: ніводзін модуль бяспекі не здольны выканаць запатрабаванае дзеянне.
sec-error-no-token = Картка або лексема бяспекі не існуе, патрабуе ініцыялізацыі, ці была выдалена.
sec-error-read-only = бібліятэка бяспекі: база дадзеных толькі для чытання.
sec-error-no-slot-selected = Не вылучаны слот або лексема.
sec-error-cert-nickname-collision = Сертыфікат з такой мянушкай ужо ёсць.
sec-error-key-nickname-collision = Ключ з такой мянушкаю ўжо існуе.
sec-error-safe-not-created = памылка падчас стварэння бяспечнага аб'екта
sec-error-baggage-not-created = памылка падчас стварэння паклажнага аб'екта
xp-java-remove-principal-error = Немагчыма выдаліць галаўнік
xp-java-delete-privilege-error = Немагчыма выдаліць прывілей
xp-java-cert-not-exists-error = Гэты галаўнік не мае сертыфіката
sec-error-bad-export-algorithm = Патрэбны алгарытм не дазволены.
sec-error-exporting-certificates = Памылка падчас спробы экспарту сертыфікатаў.
sec-error-importing-certificates = Памылка падчас спробы імпарту сертыфікатаў.
sec-error-pkcs12-decoding-pfx = Імпарт немагчымы. Памылка дэкадавання. Недапушчальны файл.
sec-error-pkcs12-invalid-mac = Імпарт немагчымы. Няспраўны MAC. Няправільны пароль або пашкоджаны файл.
sec-error-pkcs12-unsupported-mac-algorithm = Імпарт немагчымы. Алгарытм MAC не падтрымліваецца.
sec-error-pkcs12-unsupported-transport-mode = Імпарт немагчымы. Падтрымліваюцца толькі рэжымы цэльнасці пароля і прыватнасці.
sec-error-pkcs12-corrupt-pfx-structure = Імпарт немагчымы. Структура файла пашкоджана.
sec-error-pkcs12-unsupported-pbe-algorithm = Імпарт немагчымы. Алгарытм шыфравання не падтрымліваецца.
sec-error-pkcs12-unsupported-version = Імпарт немагчымы. Не падтрымліваецца версія файла.
sec-error-pkcs12-privacy-password-incorrect = Імпарт немагчымы. Няправільны пароль прыватнасці.
sec-error-pkcs12-cert-collision = Імпарт немагчымы. Такая мянушка ўжо ёсць базе дадзеных.
sec-error-user-cancelled = Карыстальнік націснуў Скасаваць.
sec-error-pkcs12-duplicate-data = Не імпартаваны, бо ўжо ў базе дадзеных.
sec-error-message-send-aborted = Паведамленне не даслана.
sec-error-inadequate-key-usage = Ужытак ключа сертыфіката неадпаведны для гэтага дзеяння.
sec-error-inadequate-cert-type = Тып сертыфіката не адобраны для праграмы.
sec-error-cert-addr-mismatch = Адрас у падпісным сертыфікаце не адпавядае адрасу ў загалоўках ліста.
sec-error-pkcs12-unable-to-import-key = Імпарт немагчымы. Памылка спробы імпарту прыватнага ключа.
sec-error-pkcs12-importing-cert-chain = Імпарт немагчымы. Памылка спробы імпарту ланцуга сертыфікатаў.
sec-error-pkcs12-unable-to-locate-object-by-name = Экспарт немагчымы. Немагчыма адшукаць сертыфікат па ключу або мянушцы.
sec-error-pkcs12-unable-to-export-key = Экспарт немагчымы. Немагчыма адшукаць і экспартаваць прыватны ключ.
sec-error-pkcs12-unable-to-write = Экспарт немагчымы. Немагчыма запісаць экспартны файл.
sec-error-pkcs12-unable-to-read = Імпарт немагчымы. Немагчыма прачытаць імпартны файл.
sec-error-pkcs12-key-database-not-initialized = Экспарт немагчымы. База дадзеных ключоў ці пашкоджана, ці выдалена.
sec-error-keygen-fail = Немагчыма стварыць пару прыватны/публічны ключ.
sec-error-invalid-password = Уведзены пароль няправільны. Увядзіце, калі ласка, іншы.
sec-error-retry-old-password = Стары пароль уведзены няправільна. Паспрабуйце, калі ласка, ізноў.
sec-error-bad-nickname = Мянушка сертыфіката ўжо выкарыстоўваецца.
sec-error-not-fortezza-issuer = Ланцуг FORTEZZA піра мае не-FORTEZZA сертыфікат.
sec-error-cannot-move-sensitive-key = Адчувальны ключ не можа быць перамешчаны ў слот, у якім ён патрабуецца.
sec-error-js-invalid-module-name = Недапушчальная назва модуля.
sec-error-js-invalid-dll = Недапушчальны шлях/назва-файла модуля.
sec-error-js-add-mod-failure = Немагчыма дадаць модуль
sec-error-js-del-mod-failure = Немагчыма выдаліць модуль
sec-error-old-krl = Новы KRL не навейшы за цяперашні.
sec-error-ckl-conflict = Новы CKL мае выдаўца, адрознага ад цяперашняга CKL.  Выдаліце цяперашні CKL.
sec-error-cert-not-in-name-space = Цэнтр Сертыфікацыі гэтага сертыфіката не мае дазволу выдаваць сертыфікаты з такой назвай.
sec-error-krl-not-yet-valid = Спіс адклікання ключоў для гэтага сертыфіката яшчэ несапраўдны.
sec-error-crl-not-yet-valid = Спіс адклікання сертыфікатаў для гэтага сертыфіката яшчэ несапраўдны.
sec-error-unknown-cert = Немагчыма знайсці запатрабаванае сертыфікат.
sec-error-unknown-signer = Немагчыма знайсці сертыфікат падпісальніка.
sec-error-cert-bad-access-location = Месцазнаходжанне сервера статусу сертыфікатаў мае няспраўны фармат.
sec-error-ocsp-unknown-response-type = Немагчыма дэкадаваць адказ OCSP; ён невядомага тыпу.
sec-error-ocsp-bad-http-response = Сервер OCSP вярнуў нечаканыя/няспраўныя дадзеныя HTTP.
sec-error-ocsp-malformed-request = Сервер OCSP выявіў, што запыт пашкоджаны ці дрэнна ўкладзены.
sec-error-ocsp-server-error = Сервер OCSP зазнаў унутраную памылку.
sec-error-ocsp-try-server-later = Сервер OCSP прапаноўвае паспрабаваць ізноў пазней.
sec-error-ocsp-request-needs-sig = Сервер OCSP патрабуе, каб гэты запыт меў подпіс.
sec-error-ocsp-unauthorized-request = Сервер OCSP адхіліў гэты запыт як недазволены.
sec-error-ocsp-unknown-response-status = Сервер OCSP вярнуў непазнавальны статус.
sec-error-ocsp-unknown-cert = Сервер OCSP не мае статуса пасведчання.
sec-error-ocsp-not-enabled = Вы мусіце дазволіць OCSP, каб выканаць гэтае дзеянне.
sec-error-ocsp-no-default-responder = Вы мусіце прызначыць прадвызначанага адказніка OCSP, каб выканаць гэтае дзеянне.
sec-error-ocsp-malformed-response = Адказ сервера OCSP ці пашкоджаны, ці дрэнна ўкладзены.
sec-error-ocsp-unauthorized-response = Падпісальнік адказу OCSP не ўпаўнаважаны даваць статус гэтага сертыфіката.
sec-error-ocsp-future-response = Адказ OCSP яшчэ не сапраўдны (змяшчае будучую дату).
sec-error-ocsp-old-response = Адказ OCSP змяшчае звесткі, якія па-за дапушчальнай датай.
sec-error-digest-not-found = Не знойдзены зборнік CMS ці PKCS #7 у падпісаным паведамленні.
sec-error-unsupported-message-type = Непатрымальны тып паведамлення CMS ці PKCS #7.
sec-error-module-stuck = Модуль PKCS #11 не можа быць выдалены, бо яшчэ ўжываецца.
sec-error-bad-template = Немагчыма дэкадаваць дадзеныя ASN.1. Вызначаны ўзор няспраўны.
sec-error-crl-not-found = Не знойдзены адпаведны САП.
sec-error-reused-issuer-and-serial = Вы спрабуеце імпартаваць сертыфікат з аднолькавым выдаўцом/нумарам з наяўным сертыфікатам, але гэта не той жа сертыфікат.
sec-error-busy = Немагчыма выключыць NSS. Аб'екты яшчэ выкарыстоўваюцца.
sec-error-extra-input = DER-закадаванае паведамленне змяшчала залішнія нескарыстаныя дадзеныя.
sec-error-unsupported-elliptic-curve = Непадтрымальная эліптычная крывая.
sec-error-unsupported-ec-point-form = Непадтрымальная форма кропкі эліптычнай крывой.
sec-error-unrecognized-oid = Непазнавальны ідэнтыфікатар аб'екта.
sec-error-ocsp-invalid-signing-cert = Няспраўны падпісальны сертыфікат OCSP у адказе OCSP.
sec-error-revoked-certificate-crl = Сертыфікат адкліканы спісам адкліканых сертыфікатаў выдаўца.
sec-error-revoked-certificate-ocsp = Адказчык выдаўца OCSP паведамляе, што сертыфікат адкліканы.
sec-error-crl-invalid-version = Спіс адкліканых сертыфікатаў выдаўца мае невядомы нумар версіі.
sec-error-crl-v1-critical-extension = Спіс адкліканых сертыфікатаў V1 выдаўца мае крытычнае пашырэнне.
sec-error-crl-unknown-critical-extension = Спіс адкліканых сертыфікатаў V2 выдаўца мае невядомае крытычнае пашырэнне.
sec-error-unknown-object-type = Зададзены невядомы тып аб'екта.
sec-error-incompatible-pkcs11 = Кіроўца PKCS #11 парушае спецыфікацыі несумяшчальным спосабам.
sec-error-no-event = Няма даступных новых гнездавых падзей у гэты час.
sec-error-crl-already-exists = САП ужо існуе.
sec-error-not-initialized = NSS не ініцыялізаваны.
sec-error-token-not-logged-in = Дзеянне пацярпела няўдачу, бо PKCS#11 токен не ўвайшоў.
sec-error-ocsp-responder-cert-invalid = Прызначаны адказчыку OCSP сертыфікат няспраўны.
sec-error-ocsp-bad-signature = Адказ OCSP мае недапушчальны подпіс.
sec-error-out-of-search-limits = Пошук пацвярджэння сертыфіката па-за лімітамі пошуку
sec-error-invalid-policy-mapping = Адлюстраванне палітыкі змяшчае "любая палітыка"
sec-error-policy-validation-failed = Ланцуг сертыфікатаў не праходзіць пацвярджэнне палітыкі
sec-error-unknown-aia-location-type = Невядомы тып месцазнаходжання ў пашырэнні AIA сертыфіката
sec-error-bad-http-response = Сервер вярнуў дрэнны адказ HTTP
sec-error-bad-ldap-response = Сервер вярнуў дрэнны адказ LDAP
sec-error-failed-to-encode-data = Няўдача кадавання дадзеных кадавальнікам ASN1
sec-error-bad-info-access-location = Дрэннае месцазнаходжанне доступу да звестак у пашырэнні сертыфіката
sec-error-libpkix-internal = Унутраная памылка libpkix падчас пацвярджэння сертыфіката.
sec-error-pkcs11-general-error = Модуль PKCS #11 вярнуў CKR_GENERAL_ERROR, якая паказвае, што мела месца непапраўная памылка.
sec-error-pkcs11-function-failed = Модуль PKCS #11 module вярнуў CKR_FUNCTION_FAILED, якая паказвае, што запатрабаваная функцыя не можа быць выканана. Спроба паўтарыць дзеянне можа мець поспех.
sec-error-pkcs11-device-error = Модуль PKCS #11 вярнуў CKR_DEVICE_ERROR, якая зазначае, што мела месца праблема з лексемай або слотам.
sec-error-bad-info-access-method = Невядомы метад доступу да звестак у пашырэнні сертыфіката.
sec-error-crl-import-failed = Памылка падчас імпарту САП.
sec-error-expired-password = Састарэлы пароль.
sec-error-locked-password = Замкнёны пароль.
sec-error-unknown-pkcs11-error = Невядомая памылка PKCS #11.
sec-error-bad-crl-dp-url = URL няспраўны або не падтрымліваецца ў назве пункта распаўсюджвання САП.
sec-error-cert-signature-algorithm-disabled = Сертыфікат падпісаны з дапамогай алгарытму, які забаронены, бо лічыцца небяспечным.
mozilla-pkix-error-key-pinning-failure = Сервер выкарыстоўвае замацаванне/пінінг ключоў (HPKP), але немагчыма стварыць ланцуг давераных сертыфікатаў, які б адпавядаў набору замацовак/пінаў. Парушэнні пінінгу не могуць быць перавызначаны.
mozilla-pkix-error-ca-cert-used-as-end-entity = Сервер выкарыстоўвае сертыфікат з асноўным пашырэннем ідэнтыфікацыі, пазначаючы яго як сертыфікацыйную ўстанову. Для правільна выдадзеных сертыфікатаў гэта не павінна мець месца.
mozilla-pkix-error-inadequate-key-size = Сервер прадстаўляе сертыфікат з памерам ключа, які занадта малы, каб усталяваць бяспечнае злучэнне.
mozilla-pkix-error-v1-cert-used-as-ca = Сертыфікат X.509 версіі 1, які не з'яўляецца якарам даверу, выкарыстаны для выдання сертыфіката сервера. Сертыфікаты X.509 версіі 1 пазначаны састарэлымі і не павінны выкарыстаўвацца для падпісання іншых сертыфікатаў.
mozilla-pkix-error-not-yet-valid-certificate = Сервер адправіў сертыфікат, які пакуль яшчэ не сапраўдны.
mozilla-pkix-error-not-yet-valid-issuer-certificate = Сертыфікат, які яшчэ не сапраўдны, быў выкарыстаны для выдання сертыфіката гэтага сервера.
mozilla-pkix-error-signature-algorithm-mismatch = Алгарытм подпісу ў полі подпісу сертыфіката не супадае за алгарытмам у яго полі signatureAlgorithm.
mozilla-pkix-error-ocsp-response-for-cert-missing = Водгук OCSP не ўтрымлівае статус сертыфіката, які правяраецца.
mozilla-pkix-error-validity-too-long = Сервер прадставіў сертыфікат, які дзейнічае вельмі доўга.
mozilla-pkix-error-required-tls-feature-missing = Абавязковая магчымасць TLS адсутнічае.
mozilla-pkix-error-invalid-integer-encoding = Сервер прадставіў сертыфікат, які ўтрымлівае недапушчальнае кадаванне цэлага ліку. Звычайныя прычыны ўключаюць адмоўныя парадкавыя нумары, адмоўны модуль RSA, і кадаванне даўжэй, чым трэба.
mozilla-pkix-error-empty-issuer-name = Сервер прадставіў сертыфікат з пустым адметным імем выдаўца.
mozilla-pkix-error-additional-policy-constraint-failed = Пры праверцы гэтага сертыфіката выяўлена парушэнне абмежавання дадатковай палітыкі.
mozilla-pkix-error-self-signed-cert = Сертыфікату нельга давяраць, бо ён самападпісаны.
