# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = Terjadi kesalahan ketika menyambungkan ke { $hostname }. { $errorMessage }

# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Kode kesalahan: { $error }

psmerr-ssl-disabled = Tidak dapat tersambung dengan aman karena protokol SSL telah dinonaktifkan.
psmerr-ssl2-disabled = Tidak dapat tersambung dengan aman karena situs menggunakan protokol SSL versi lama dan tidak aman.

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Anda telah menerima sertifikat yang tidak sah. Silakan hubungi administrator sistem atau kirim email kepada yang bersangkutan dan memberitahukan informasi berikut:
    
    Sertifikat Anda mengandung nomor seri yang sama dengan sertifikat lain yang dikeluarkan otoritas sertifikat. Mohon dibuat sertifikat baru yang memiliki nomor seri yang unik.

ssl-error-export-only-server = Gagal tersambung dengan aman. Pihak lain tidak mendukung enkripsi tingkat tinggi.
ssl-error-us-only-server = Gagal tersambung dengan aman. Pihak lain membutuhkan enkripsi tingkat tinggi yang tidak didukung.
ssl-error-no-cypher-overlap = Tidak tersambung dengan pihak lain dengan aman: tidak ada algoritma enkripsi yang dimiliki bersama.
ssl-error-no-certificate = Gagal menemukan sertifikat atau kunci yang dibutuhkan untuk autentikasi.
ssl-error-bad-certificate = Gagal tersambung dengan aman. Sertifikat pihak lain ditolak.
ssl-error-bad-client = Server menerima data jelek dari klien.
ssl-error-bad-server = Klien menerima data jelek dari server.
ssl-error-unsupported-certificate-type = Tipe sertifikat tidak didukung.
ssl-error-unsupported-version = Pihak lain menggunakan versi protokol keamanan yang tidak didukung.
ssl-error-wrong-certificate = Autentikasi klien gagal: kunci pribadi dalam basis data kunci tidak cocok dengan kunci publik dalam basis data sertifikat.
ssl-error-bad-cert-domain = Gagal tersambung dengan aman. nama domain yang diminta tidak cocok dengan sertifikat server.
ssl-error-post-warning = Kode galat SSL tidak dikenal.
ssl-error-ssl2-disabled = Pihak lain hanya mendukung SSL versi 2 yang dinonaktifkan secara lokal.
ssl-error-bad-mac-read = SSL menerima data pesan yang mengandung Kode Autentikasi Pesan yang salah.
ssl-error-bad-mac-alert = Pihak SSL lainnya melaporkan kesalahan Kode Autentikasi Pesan.
ssl-error-bad-cert-alert = Pihak SSL tidak dapat memverifikasi sertifikat Anda.
ssl-error-revoked-cert-alert = Pihak SSL menolak sertifikat Anda karena telah dicabut.
ssl-error-expired-cert-alert = Pihak SSL menolak sertifikat Anda karena telah kedaluwarsa.
ssl-error-ssl-disabled = Tidak tersambung: SSL dinonaktifkan.
ssl-error-fortezza-pqg = Tidak tersambung: pihak lain SSL ber-domain FORTEZZA.
ssl-error-unknown-cipher-suite = Salah satu SSL cipher suite yang tidak dikenali telah diminta.
ssl-error-no-ciphers-supported = Tidak ada cipher suite yang tersedia dan diaktifkan di program ini.
ssl-error-bad-block-padding = SSL menerima bagian pesan dengan penambahan blok yang jelek.
ssl-error-rx-record-too-long = SSL menerima bagian pesan yang panjangnya melebihi yang dibolehkan.
ssl-error-tx-record-too-long = SSL mencoba mengirim bagian pesan yang panjangnya melebihi yang dibolehkan.
ssl-error-rx-malformed-hello-request = SSL menerima pesan handshake Hello Request dalam format yang salah.
ssl-error-rx-malformed-client-hello = SSL menerima pesan handshake Client Hello dalam format yang salah.
ssl-error-rx-malformed-server-hello = SSL menerima pesan handshake Server Hello dalam format yang salah.
ssl-error-rx-malformed-certificate = SSL menerima pesan handshake Certificate dalam format yang salah.
ssl-error-rx-malformed-server-key-exch = SSL menerima pesan handshake Server Key Exchange dalam format yang salah.
ssl-error-rx-malformed-cert-request = SSL menerima pesan handshake Certificate Request dalam format yang salah.
ssl-error-rx-malformed-hello-done = SSL menerima pesan handshake Server Hello Done dalam format yang salah.
ssl-error-rx-malformed-cert-verify = SSL menerima pesan handshake Certificate Verify dalam format yang salah.
ssl-error-rx-malformed-client-key-exch = SSL menerima pesan handshake Client Key Exchange dalam format yang salah.
ssl-error-rx-malformed-finished = SSL menerima pesan handshake Finished dalam format yang salah.
ssl-error-rx-malformed-change-cipher = SSL menerima data Change Cipher Spec dalam format yang salah.
ssl-error-rx-malformed-alert = SSL menerima data Alert dalam format yang salah.
ssl-error-rx-malformed-handshake = SSL menerima data Handshake dalam format yang salah.
ssl-error-rx-malformed-application-data = SSL menerima data Application Data dalam format yang salah.
ssl-error-rx-unexpected-hello-request = SSL menerima pesan handshake Hello Request yang tidak diharapkan.
ssl-error-rx-unexpected-client-hello = SSL menerima pesan handshake Client Hello yang tidak diharapkan.
ssl-error-rx-unexpected-server-hello = SSL menerima pesan handshake Server Hello yang tidak diharapkan.
ssl-error-rx-unexpected-certificate = SSL menerima pesan handshake Certificate yang tidak diharapkan.
ssl-error-rx-unexpected-server-key-exch = SSL menerima pesan handshake Server Key Exchange yang tidak diharapkan.
ssl-error-rx-unexpected-cert-request = SSL menerima pesan handshake Certificate Request yang tidak diharapkan.
ssl-error-rx-unexpected-hello-done = SSL menerima pesan handshake Server Hello Done yang tidak diharapkan.
ssl-error-rx-unexpected-cert-verify = SSL menerima pesan handshake Certificate Verify yang tidak diharapkan.
ssl-error-rx-unexpected-client-key-exch = SSL menerima pesan handshake Client Key Exchange yang tidak diharapkan.
ssl-error-rx-unexpected-finished = SSL menerima pesan handshake Finished yang tidak diharapkan.
ssl-error-rx-unexpected-change-cipher = SSL menerima data Change Cipher Spec yang tidak diharapkan.
ssl-error-rx-unexpected-alert = SSL menerima data Alert yang tidak diharapkan.
ssl-error-rx-unexpected-handshake = SSL menerima data Handshake yang tidak diharapkan.
ssl-error-rx-unexpected-application-data = SSL menerima data Application Data yang tidak diharapkan.
ssl-error-rx-unknown-record-type = SSL menerima data dengan jenis isi yang tidak dikenali.
ssl-error-rx-unknown-handshake = SSL menerima pesan handshake dengan jenis pesan yang tidak dikenali.
ssl-error-rx-unknown-alert = SSL menerima data alert dengan deskripsi alert yang tidak dikenali.
ssl-error-close-notify-alert = Pihak lain telah menutup sambungan ini.
ssl-error-handshake-unexpected-alert = Pihak lain tidak mengharapkan pesan handshake yang telah diterima.
ssl-error-decompression-failure-alert = Pihak lain gagal mendekompresi data SSL yang telah diterima.
ssl-error-handshake-failure-alert = Pihak lain gagal menegosiasikan sekelompok parameter keamanan yang dapat diterima.
ssl-error-illegal-parameter-alert = Pihak lain menolak pesan handshake untuk isi yang tidak dikenali.
ssl-error-unsupported-cert-alert = Pihak lain tidak mendukung jenis sertifikat yang telah diterima.
ssl-error-certificate-unknown-alert = Pihak lain memiliki masalah yang tidak dikenali untuk sertifikat yang telah diterima.
ssl-error-generate-random-failure = SSL mengalami kegagalan pada generator bilangan acak.
ssl-error-sign-hashes-failure = Gagal menandatangani data secara dijital yang dibutuhkan untuk memverifikasi sertifikat Anda.
ssl-error-extract-public-key-failure = SSL gagal mengekstrak kunci publik dari sertifikat pihak lain.
ssl-error-server-key-exchange-failure = Kegagalan yang tidak dikenali saat memproses handshake SSL Client Key Exchange.
ssl-error-client-key-exchange-failure = Kegagalan yang tidak dikenali saat memproses handshake SSL Client Key Exchange.
ssl-error-encryption-failure = Algoritma enkripsi data bulk gagal pada cipher suite yang dipilih.
ssl-error-decryption-failure = Algoritma dekripsi data bulk gagal pada cipher suite yang dipilih.
ssl-error-socket-write-failure = Percobaan menulis data terenkripsi pada socket gagal.
ssl-error-md5-digest-failure = Fungsi MD5 digest gagal.
ssl-error-sha-digest-failure = Fungsi SHA-1 digest gagal.
ssl-error-mac-computation-failure = Perhitungan MAC gagal.
ssl-error-sym-key-context-failure = Gagal membuat konteks Symmetric Key.
ssl-error-sym-key-unwrap-failure = Gagal membuka kunci Symmetric pada pesan Client Key Exchange.
ssl-error-pub-key-size-limit-exceeded = Server SSL mencoba menggunakan kunci publik tingkat-domestik dengan suite cipher.
ssl-error-iv-param-failure = Kode PKCS11 gagal menerjemahkan sebuah IV menjadi sebuah param.
ssl-error-init-cipher-suite-failure = Gagal menginisialisasi cipher suite terpilih.
ssl-error-session-key-gen-failure = Klien gagal membuat kunci sesi untuk sesi SSL.
ssl-error-no-server-key-for-alg = Server tidak memiliki kunci untuk algoritma pertukaran kunci yang dicoba.
ssl-error-token-insertion-removal = Token PKCS#11 telah disisipkan atau dibuang ketika proses sedang berjalan.
ssl-error-token-slot-not-found = Tidak ada token PKCS#11 yang ditemukan untuk operasi yang dibutuhkan.
ssl-error-no-compression-overlap = Tidak dapat tersambung dengan aman dengan pihak lain: tidak ada algoritma kompresi yang sama.
ssl-error-handshake-not-completed = Tidak dapat memulai handshake SSL yang lain hingga handshake yang sedang berjalan selesai.
ssl-error-bad-handshake-hash-value = Diterima hash handshake yang salah dari pihak lainnya.
ssl-error-cert-kea-mismatch = Sertifikat yang disediakan tidak dapat digunakan untuk algoritma pertukaran kunci yang dipilih.
ssl-error-no-trusted-ssl-client-ca = Tidak ada otoritas sertifikat yang dipercaya untuk autentikasi klien SSL.
ssl-error-session-not-found = ID sesi klien SSL tidak ditemukan pada tembolok sesi di server.
ssl-error-decryption-failed-alert = Pihak lain gagal mendekripsi data SSL yang diterima.
ssl-error-record-overflow-alert = Pihak lain menerima data SSL yang panjangnya melebihi yang diizinkan.
ssl-error-unknown-ca-alert = Pihak lain tidak mengenali dan mempercayai CA yang mengeluarkan sertifikat Anda.
ssl-error-access-denied-alert = Pihak lain menerima sertifikat yang sah, tapi akses ditolak.
ssl-error-decode-error-alert = Pihak lain tidak dapat mendekode pesan handshake SSL.
ssl-error-decrypt-error-alert = Pihak lain melaporkan kegagalan verifikasi tanda tangan atau pertukaran kunci.
ssl-error-export-restriction-alert = Pihak lain melaporkan negosiasi tidak sesuai dengan peraturan ekspor.
ssl-error-protocol-version-alert = Pihak lain melaporkan versi protokol yang tidak kompatibel atau tidak didukung.
ssl-error-insufficient-security-alert = Server membutuhkan cipher yang lebih aman dari yang didukung klien.
ssl-error-internal-error-alert = Pihak lain melaporkan telah terjadi kesalahan internal.
ssl-error-user-canceled-alert = Pihak lain membatalkan handshake.
ssl-error-no-renegotiation-alert = Pihak lain tidak mengizinkan negosiasi ulang untuk parameter keamanan SSL.
ssl-error-server-cache-not-configured = Tembolok server SSL tidak diatur dan tidak dinonaktifkan untuk socket ini.
ssl-error-unsupported-extension-alert = Pihak SSL lain tidak mendukung ekstensi hello TLS yang diminta.
ssl-error-certificate-unobtainable-alert = Pihak SSL lain tidak dapat mendapatkan sertifikat Anda dari URL yang disediakan.
ssl-error-unrecognized-name-alert = Pihak SSL lain tidak memiliki sertifikat untuk nama DNS yang diminta.
ssl-error-bad-cert-status-response-alert = Pihak SSL lain gagal mendapatkan jawaban OCSP untuk sertifikat ini.
ssl-error-bad-cert-hash-value-alert = Pihak SSL lain melaporkan nilai hash sertifikat yang salah.
ssl-error-rx-unexpected-new-session-ticket = SSL menerima pesan handshake Tiket Sesi Baru yang tidak diharapkan.
ssl-error-rx-malformed-new-session-ticket = SSL menerima pesan handshake Tiket Sesi Baru yang bentuknya salah.
ssl-error-decompression-failure = SSL menerima record terkompresi yang seharusnya tidak terkompresi.
ssl-error-renegotiation-not-allowed = Renegosiasi tidak diizinkan pada soket SSL ini.
ssl-error-unsafe-negotiation = Pihak lain mencoba menggunakan handshake gaya lama (mengandung kerawanan potensial).
ssl-error-rx-unexpected-uncompressed-record = SSL menerima record tak terkompresi yang tidak diharapkan.
ssl-error-weak-server-ephemeral-dh-key = SSL menerima kunci Diffie-Hellman efemeral pada pesan handshake Server Key Exchange.
ssl-error-next-protocol-data-invalid = SSL menerima data ekstensi NPN yang tidak valid.
ssl-error-feature-not-supported-for-ssl2 = Fitur SSL tidak didukung pada sambungan SSL 2.0.
ssl-error-feature-not-supported-for-servers = Fitur SSL tidak didukung server.
ssl-error-feature-not-supported-for-clients = Fitur SSL tidak didukung klien.
ssl-error-invalid-version-range = Rentang versi SSL tidak valid.
ssl-error-cipher-disallowed-for-version = Pihak lain SSL memilih cipher suite yang tidak diizinkan untuk versi protokol yang dipilih.
ssl-error-rx-malformed-hello-verify-request = SSL menerima pesan handshake Hello Verify Request yang salah.
ssl-error-rx-unexpected-hello-verify-request = SSL menerima pesan handshake Hello Verify Request yang tidak diharapkan.
ssl-error-feature-not-supported-for-version = SSL feature not supported for the protocol version.
ssl-error-rx-unexpected-cert-status = SSL menerima pesan handshake Certificate Status yang tidak diharapkan.
ssl-error-unsupported-hash-algorithm = Algoritme hash yang tidak didukung yang digunakan oleh pihak lain TLS.
ssl-error-digest-failure = Fungsi digest gagal.
ssl-error-incorrect-signature-algorithm = Algoritme tanda tangan yang salah yang ditentukan pada elemen yang ditandatangani digital.
ssl-error-next-protocol-no-callback = Ekstensi negosiasi protokol berikutnya tidak diaktifkan, tetapi pemanggilan kembali telah dibersihkan sebelum dibutuhkan.
ssl-error-next-protocol-no-protocol = Server mendukung tidak satu pun protokol yang diajukan klien pada ekstensi ALPN.
ssl-error-inappropriate-fallback-alert = Server menilah handshake karena klien menurunkan ke versi TLS yang lebih rendah dari yang didukung server.
ssl-error-weak-server-cert-key = Sertifikat server yang disertakan pada kunci publik yang tingkatnya terlalu lemah.
ssl-error-rx-short-dtls-read = Tidak cukup ruang dalam buffer untuk perekaman DTLS.
ssl-error-no-supported-signature-algorithm = Tidak ada penanda algoritma TLS didukung yang sudah diatur.
ssl-error-unsupported-signature-algorithm = Pihak lain menggunakan kombinasi penanda dan algoritma hash yang tidak didukung.
ssl-error-missing-extended-master-secret = Pihak lain mencoba untuk melanjutkan tanpa ekstensi extended_master_secret yang benar.
ssl-error-unexpected-extended-master-secret = Pihak lain mencoba untuk melanjutkan ekstensi extended_master_secret yang tidak diharapkan.
sec-error-io = Kesalahan Input/Output terjadi saat otorisasi keamanan.
sec-error-library-failure = kegagalan pustaka keamanan.
sec-error-bad-data = pustaka keamanan: menerima data salah.
sec-error-output-len = pustaka keamanan: kesalahan panjang output.
sec-error-input-len = pustaka keamanan mengalami kesalahan panjang input.
sec-error-invalid-args = pustaka keamanan: argumen tidak sah.
sec-error-invalid-algorithm = pustaka keamanan: algoritma tidak sah.
sec-error-invalid-ava = pustaka keamanan: AVA tidak sah.
sec-error-invalid-time = Format teks waktu tidak benar.
sec-error-bad-der = pustaka keamanan: format pesan DER terenkode salah.
sec-error-bad-signature = Tandatangan sertifikat pihak lain tidak sah.
sec-error-expired-certificate = Sertifikat pihak lain kedaluwarsa.
sec-error-revoked-certificate = Sertifikat pihak lain telah dicabut.
sec-error-unknown-issuer = Penerbit Sertifikat pihak lain tidak dikenali.
sec-error-bad-key = Kunci publik pihak lain tidak sah.
sec-error-bad-password = Sandi keamanan yang dimasukkan salah.
sec-error-retry-password = Salah memasukkan sandi yang baru. Silakan coba lagi.
sec-error-no-nodelock = pustaka keamanan: tidak ada nodelock.
sec-error-bad-database = pustaka keamanan: basis data salah.
sec-error-no-memory = pustaka keamanan: kegagalan alokasi memori.
sec-error-untrusted-issuer = Penerbit sertifikat pihak lain telah ditandai tidak dipercaya oleh pengguna.
sec-error-untrusted-cert = Sertifikat pihak lain telah ditandai tidak dipercaya oleh pengguna.
sec-error-duplicate-cert = Sertifikat sudah ada dalam basis data Anda.
sec-error-duplicate-cert-name = Nama sertifikat yang diunduh sama dengan yang sudah ada dalam basis data.
sec-error-adding-cert = Kesalahan saat menambahkan sertifikat ke basis data.
sec-error-filing-key = Kesalahan menyimpan kunci untuk sertifikat ini.
sec-error-no-key = Kunci pribadi untuk sertifikat ini tidak ditemukan dalam basis data.
sec-error-cert-valid = Sertifikat ini sah.
sec-error-cert-not-valid = Sertifikat ini tidak sah.
sec-error-cert-no-response = Pustaka Sertifikat: Tidak ada jawaban.
sec-error-expired-issuer-certificate = Sertifikat penerbit yang mengeluarkan sertifikat telah kedaluwarsa. Silakan periksa waktu dan tanggal sistem.
sec-error-crl-expired = CRL untuk penerbit sertifikat telah kedaluwarsa. Perbarui CRLnya atau periksa tanggal dan waktu sistem Anda.
sec-error-crl-bad-signature = CRL untuk penerbit sertifikat mempunyai tanda tangan yang tidak sah.
sec-error-crl-invalid = Format CRL yang baru salah.
sec-error-extension-value-invalid = Nilai ekstensi sertifikat tidak sah.
sec-error-extension-not-found = Ekstensi sertifikat tidak ditemukan.
sec-error-ca-cert-invalid = Sertifikat penerbit tidak sah.
sec-error-path-len-constraint-invalid = Kendala panjang path sertifikat tidak sah.
sec-error-cert-usages-invalid = Penggunaan field sertifikat tidak sah.
sec-internal-only = **modul INTERNAL saja**
sec-error-invalid-key = Kunci tidak mendukung operasi yang diminta.
sec-error-unknown-critical-extension = Sertifikat mengandung ekstensi penting yang tidak dikenali.
sec-error-old-crl = CRL baru tidak lebih baru dari yang ada sekarang.
sec-error-no-email-cert = Tidak dienkripsi atau ditandatangani: Anda belum memiliki sertifikat email.
sec-error-no-recipient-certs-query = Tidak dienkripsi: Anda tidak memiliki sertifikat untuk tiap-tiap penerima.
sec-error-not-a-recipient = Tidak bisa mendekripsi: Anda bukan penerima atau sertifikat dan kunci pribadi yang sesuai tidak ditemukan.
sec-error-pkcs7-keyalg-mismatch = Tidak bisa mendekripsi: algoritma enkripsi kunci tidak sesuai dengan sertifikat Anda.
sec-error-pkcs7-bad-signature = Verifikasi tanda tangan gagal: tidak ada penandatangan ditemukan, terlalu banyak penandatangan ditemukan, atau data yang salah.
sec-error-unsupported-keyalg = Algoritma kunci yang tidak dikenali atau didukung.
sec-error-decryption-disallowed = Tidak dapat mendekripsi: enkripsi menggunakan algoritma atau ukuran kunci yang tidak diizinkan.
xp-sec-fortezza-bad-card = Kartu Fortezza tidak diinisialisasi dengan benar. Silakan copot dan kembalikan kepada penerbit Anda.
xp-sec-fortezza-no-card = Tidak ada kartu Fortezza yang dapat ditemukan
xp-sec-fortezza-none-selected = Tidak ada kartu Fortezza yang dipilih
xp-sec-fortezza-more-info = Silakan pilih personalitas untuk informasi lebih lanjut tentang
xp-sec-fortezza-person-not-found = Personalitas tidak ditemukan
xp-sec-fortezza-no-more-info = Tidak ada informasi lebih lanjut tentang Personalitas tersebut
xp-sec-fortezza-bad-pin = Pin Tidak Sah
xp-sec-fortezza-person-error = Tidak dapat menginisialisasi personalitas Fortezza.
sec-error-no-krl = Tidak ada KRL untuk sertifikat situs ini yang bisa ditemukan.
sec-error-krl-expired = KRL untuk sertifikat situs ini telah kedaluwarsa.
sec-error-krl-bad-signature = KRL untuk sertifikat situs ini mempunyai tanda tangan yang tidak sah.
sec-error-revoked-key = Kunci untuk sertifikat situs ini telah dicabut.
sec-error-krl-invalid = Format KRL yang baru salah.
sec-error-need-random = pustaka keamanan: dibutuhkan data acak.
sec-error-no-module = pustaka keamanan: tidak ada modul keamanan yang mampu menjalankan operasi yang diminta.
sec-error-no-token = Kartu atau token keamanan tidak ada, perlu diinisialisasi, atau telah dicopot.
sec-error-read-only = pustaka keamanan: basis data baca-saja.
sec-error-no-slot-selected = Tidak ada slot atau token terpilih.
sec-error-cert-nickname-collision = Sertifikat dengan nama alias/nick sudah ada.
sec-error-key-nickname-collision = Kunci dengan nama nick yang sama telah ada.
sec-error-safe-not-created = kesalahan saat membuat objek yang aman
sec-error-baggage-not-created = kesalahan saat membuat objek bawaan
xp-java-remove-principal-error = Tidak dapat membuang prinsipal
xp-java-delete-privilege-error = Tidak dapat menghapus privilege
xp-java-cert-not-exists-error = Prinsipal berikut tidak memiliki sertifikat
sec-error-bad-export-algorithm = Algoritma yang dibutuhkan tidak diizinkan.
sec-error-exporting-certificates = Kesalahan saat mencoba mengekspor sertifikat.
sec-error-importing-certificates = Kesalahan saat mencoba mengimpor sertifikat.
sec-error-pkcs12-decoding-pfx = Gagal mengimpor. Kesalahan mendekode. Berkas tidak sah.
sec-error-pkcs12-invalid-mac = Gagal mengimpor. MAC tidak valid. Sandi salah atau berkas terkorupsi.
sec-error-pkcs12-unsupported-mac-algorithm = Gagal mengimpor. Algoritma MAC tidak didukung.
sec-error-pkcs12-unsupported-transport-mode = Gagal mengimpor. Hanya mode integritas sandi dan privasi yang didukung.
sec-error-pkcs12-corrupt-pfx-structure = Gagal mengimpor. Struktur berkas terkorupsi.
sec-error-pkcs12-unsupported-pbe-algorithm = Gagal mengimpor. Algoritma enkripsi tidak didukung.
sec-error-pkcs12-unsupported-version = Gagal mengimpor. Versi berkas tidak didukung.
sec-error-pkcs12-privacy-password-incorrect = Gagal mengimpor. Sandi pribadi salah.
sec-error-pkcs12-cert-collision = Gagal mengimpor. Nama nick yang sama telah ada dalam basis data.
sec-error-user-cancelled = Pengguna menekan batal.
sec-error-pkcs12-duplicate-data = Tidak diimpor, sudah ada di basis data.
sec-error-message-send-aborted = Pesan tidak dikirim.
sec-error-inadequate-key-usage = Penggunaan kunci sertifikat tidak sesuai untuk operasi yang akan dilaksanakan.
sec-error-inadequate-cert-type = Jenis sertifikat tidak disetujui untuk aplikasi.
sec-error-cert-addr-mismatch = Alamat pada sertifikat penandatangan tidak sesuai dengan alamat pada header pesan.
sec-error-pkcs12-unable-to-import-key = Gagal mengimpor. Kesalahan saat mencoba mengimpor kunci pribadi.
sec-error-pkcs12-importing-cert-chain = Gagal mengimpor. Kesalahan saat mencoba mengimpor rantai sertifikat.
sec-error-pkcs12-unable-to-locate-object-by-name = Gagal mengekspor. Gagal menemukan sertifikat atau kunci berdasarkan nama nick.
sec-error-pkcs12-unable-to-export-key = Gagal mengekspor. Kunci Pribadi tidak bisa ditemukan dan diekspor.
sec-error-pkcs12-unable-to-write = Gagal mengekspor. Gagal menulis pada berkas untuk ekspor.
sec-error-pkcs12-unable-to-read = Gagal mengimpor. Gagal membaca berkas untuk diimpor.
sec-error-pkcs12-key-database-not-initialized = Gagal mengekspor. Basis data kunci terkorupsi atau terhapus.
sec-error-keygen-fail = Gagal membuat pasangan kunci publik/pribadi.
sec-error-invalid-password = Sandi yang dimasukkan tidak sah. Silakan ganti dengan yang lain.
sec-error-retry-old-password = Sandi lama yang dimasukkan salah. Silakan coba lagi.
sec-error-bad-nickname = Nama nick sertifikat sudah digunakan.
sec-error-not-fortezza-issuer = Rantai pihak FORTEZZA mempunyai Sertifikat Non-FORTEZZA.
sec-error-cannot-move-sensitive-key = Kunci penting tidak dapat dipindah ke slot yang dibutuhkan.
sec-error-js-invalid-module-name = Nama modul tidak sah.
sec-error-js-invalid-dll = Path modul/nama berkas tidak sah.
sec-error-js-add-mod-failure = Gagal menambah modul
sec-error-js-del-mod-failure = Gagal menghapus modul.
sec-error-old-krl = KRL baru tidak lebih baru dari yang ada sekarang.
sec-error-ckl-conflict = CKL baru mempunyai penerbit yang berbeda dari CKL yang sekarang. Hapus CKL yang sekarang.
sec-error-cert-not-in-name-space = Otoritas Sertifikat untuk sertifikat ini tidak diizinkan untuk mengeluarkan sertifikat dengan nama berikut.
sec-error-krl-not-yet-valid = Daftar pencabutan kunci untuk sertifikat ini masih belum sah.
sec-error-crl-not-yet-valid = Daftar pencabutan sertifikat untuk sertifikat ini masih belum sah.
sec-error-unknown-cert = Sertifikat yang diminta tidak ditemukan.
sec-error-unknown-signer = Sertifikat milik penandatangan tidak ditemukan.
sec-error-cert-bad-access-location = Format lokasi untuk server status sertifikat tidak sah.
sec-error-ocsp-unknown-response-type = Jawaban OCSP tidak bisa didekode sepenuhnya, tipenya tidak dikenali.
sec-error-ocsp-bad-http-response = Server OCSP mengembalikan data HTTP yang tidak diharapkan/tidak sah.
sec-error-ocsp-malformed-request = Server OCSP menemukan bahwa permintaan terkorupsi atau formatnya salah.
sec-error-ocsp-server-error = Server OCSP mengalami kesalahan internal.
sec-error-ocsp-try-server-later = Server OCSP menyarankan mencoba lagi nanti.
sec-error-ocsp-request-needs-sig = Server OCSP membutuhkan tanda tangan untuk permintaan ini.
sec-error-ocsp-unauthorized-request = Server OCSP menolak permintaan ini karena tidak diotorisasi.
sec-error-ocsp-unknown-response-status = Server OCSP mengembalikan status yang tidak dikenali.
sec-error-ocsp-unknown-cert = Server OCSP tidak memiliki status untuk sertifikat ini.
sec-error-ocsp-not-enabled = Anda harus mengaktifkan OCSP sebelum melakukan tindakan berikut.
sec-error-ocsp-no-default-responder = Anda harus mengatur penjawab OCSP baku sebelum melakukan tindakan berikut.
sec-error-ocsp-malformed-response = Jawaban dari server OCSP terkorupsi atau formatnya salah.
sec-error-ocsp-unauthorized-response = Penandatangan jawaban OCSP tidak mempunyai otorisasi untuk memberikan status sertifikat ini.
sec-error-ocsp-future-response = Jawaban OCSP masih tidak valid karena mengandung tanggal di masa datang.
sec-error-ocsp-old-response = Jawaban OCSP mengandung informasi yang kedaluwarsa.
sec-error-digest-not-found = Digest CMS atau PKCS #7 tidak ditemukan pada pesan yang ditandatangani.
sec-error-unsupported-message-type = Jenis pesan CMS atau PKCS #7 tidak didukung.
sec-error-module-stuck = Modul PCKS #11 tidak dapat dihapus karena masih digunakan.
sec-error-bad-template = Tidak dapat mendekode data ASN.1. Template yang ditentukan tidak sah.
sec-error-crl-not-found = Tidak ada CRL yang cocok yang ditemukan.
sec-error-reused-issuer-and-serial = Anda mencoba mengimpor sertifikat dengan penerbit/nomor seri yang sama dengan sertifikat tersebut, tapi tidak pada sertifikat yang sama.
sec-error-busy = NSS tidak dapat dinonaktifkan. Objek masih digunakan.
sec-error-extra-input = Pesan terenkode-DER mengandung data ekstra yang tidak digunakan.
sec-error-unsupported-elliptic-curve = Kurva eliptis tidak didukung.
sec-error-unsupported-ec-point-form = Bentuk titik kurva eliptis tidak didukung.
sec-error-unrecognized-oid = Identitas Objek tidak dikenali.
sec-error-ocsp-invalid-signing-cert = Sertifikat penandatangan OCSP yang tidak sah pada jawaban OCSP.
sec-error-revoked-certificate-crl = Sertifikat dicabut dari daftar pencabutan sertifikat penerbit.
sec-error-revoked-certificate-ocsp = Jawaban OCSP penerbit melaporkan sertifikat telah dicabut.
sec-error-crl-invalid-version = Daftar Pencabutan Sertifikat Penerbit mengandung nomor versi yang tidak dikenali.
sec-error-crl-v1-critical-extension = Daftar Pencabutan Sertifikat Penerbit V1 memiliki ekstensi penting.
sec-error-crl-unknown-critical-extension = Daftar Pencabutan Sertifikat Penerbit V2 memiliki ekstensi penting yang tidak dikenali.
sec-error-unknown-object-type = Jenis objek yang tidak dikenali telah ditentukan.
sec-error-incompatible-pkcs11 = Driver PKCS #11 melanggar spesifikasi dengan cara yang tidak kompatibel.
sec-error-no-event = Tidak ada slot event baru yang tersedia saat ini.
sec-error-crl-already-exists = CRL sudah ada.
sec-error-not-initialized = NSS belum diinisialisasi.
sec-error-token-not-logged-in = Operasi gagal karena token PKCS#11 tidak log-masuk.
sec-error-ocsp-responder-cert-invalid = Sertifikat penjawab OCSP yang diatur tidak sah.
sec-error-ocsp-bad-signature = Jawaban OCSP memiliki tanda tangan yang tidak sah.
sec-error-out-of-search-limits = Pencarian validasi sertifikat melebihi batas pencarian
sec-error-invalid-policy-mapping = Pemetaan kebijakan berisi anypolicy
sec-error-policy-validation-failed = Rangkaian sertifikat menggagalkan validasi kebijakan
sec-error-unknown-aia-location-type = Jenis lokasi yang tidak dikenal pada ekstensi AIA sertifikat
sec-error-bad-http-response = Server mengembalikan balasan HTTP yang salah
sec-error-bad-ldap-response = Server mengembalikan balasan LDAP yang salah
sec-error-failed-to-encode-data = Gagal mengenkode data dengan pengenkode ASN1
sec-error-bad-info-access-location = Lokasi akses informasi yang salah pada ekstensi sertifikat
sec-error-libpkix-internal = Kesalahan internal libpkix terjadi saat validasi sertifikat.
sec-error-pkcs11-general-error = Sebuah modul PKCS #11 mengembalikan CKR_GENERAL_ERROR yang menandakan kesalahan yang tidak bisa diperbaiki telah terjadi.
sec-error-pkcs11-function-failed = Sebuah modul PKCS #11 mengembalikan CKR_FUNCTION_FAILED yang menandakan fungsi yang diminta tidak dapat dilakukan. Percobaan operasi yang sama selanjutnya mungkin sukses.
sec-error-pkcs11-device-error = Sebuah modul PKCS #11 mengembalikan CKR_DEVICE_ERROR yang menandakan telah terjadi masalah dengan token atau slot.
sec-error-bad-info-access-method = Metode akses informasi yang tidak dikenal pada ekstensi sertifkat.
sec-error-crl-import-failed = Kesalahan ketika mencoba mengimpor CRL.
sec-error-expired-password = Sandi kedaluwarsa.
sec-error-locked-password = Sandi terkunci.
sec-error-unknown-pkcs11-error = Galat PKCS #11 tidak dikenal.
sec-error-bad-crl-dp-url = URL tidak valid atau tidak didukung pada nama titik distribusi KRL.
sec-error-cert-signature-algorithm-disabled = Sertifikat ditandatangani dengan algoritma tandatangan yang dinonaktifkan karena tidak aman.
mozilla-pkix-error-key-pinning-failure = Server menggunakan key pinning (HPKP) tetapi tidak ada rantai sertifikat dipercaya yang dapat dibangun yang sesuai dengan pinset. Pelanggaran key pinning tidak dapat ditimpa.
mozilla-pkix-error-ca-cert-used-as-end-entity = Server menggunakan sertifikat dengan ekstensi kendala dasar yang mengidentifikasi sebagai otoritas sertifikat. Hal ini salah untuk sertifikat yang diterbitkan dengan benar.
mozilla-pkix-error-inadequate-key-size = Server menggunakan sertifikat dengan ukuran kunci yang terlalu kecil untuk membuat sambungan aman.
mozilla-pkix-error-v1-cert-used-as-ca = Sebuah sertifikat X.509 versi 1 yang bukan merupakan jangkar kepercayaan telah digunakan untuk menerbitkan sertifikat server. Sertifikat X.509 versi 1 sudah usang dan seharusnya tidak digunakan untuk menandatangani sertifikat lainnya.
mozilla-pkix-error-not-yet-valid-certificate = Server memberikan sertifikat yang masih belum valid.
mozilla-pkix-error-not-yet-valid-issuer-certificate = Sertifikat yang belum valid telah digunakan untuk menerbitkan sertifikat server.
mozilla-pkix-error-signature-algorithm-mismatch = Algoritme tanda tangan pada bidang tanda tangan sertifikat tidak cocok dengan algoritme yang ditentukan pada bidang algoritme tanda tangan.
mozilla-pkix-error-ocsp-response-for-cert-missing = Balasan OCSP tidak menyertakan status untuk sertifikat yang sedang diverifikasi.
mozilla-pkix-error-validity-too-long = Server memberikan sertifikat yang valid dalam jangka waktu yang sangat lama.
mozilla-pkix-error-required-tls-feature-missing = Fitur TLS yang dibutuhkan tidak ada.
mozilla-pkix-error-invalid-integer-encoding = Server menggunakan sertifikat yang mengandung pengodean integer yang salah. Alasan umum termasuk nomor serial negatif, moduli RSA negatif, dan pengodean yang lebih lama dari yang diperlukan.
mozilla-pkix-error-empty-issuer-name = Server menggunakan sertifikat dengan nama penerbit dibedakan yang kosong.
mozilla-pkix-error-additional-policy-constraint-failed = Batasan kebijakan tambahan gagal ketika memvalidasi sertifikat ini.
mozilla-pkix-error-self-signed-cert = Sertifikat ini tidak dipercayai karena ditandatangani sendiri.
