# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = An error occurred during a connection to { $hostname }. { $errorMessage }
# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Error code: { $error }
psmerr-ssl-disabled = Can’t connect securely because the SSL protocol has been disabled.
psmerr-ssl2-disabled = Can’t connect securely because the site uses an older, insecure version of the SSL protocol.
# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    You have received an invalid certificate.  Please contact the server administrator or email correspondent and give them the following information:
    
    Your certificate contains the same serial number as another certificate issued by the certificate authority.  Please get a new certificate containing a unique serial number.
ssl-error-export-only-server = Hindi makapag-communicate nang ligtas. Hindi suportado ng peer ang high-grade encryption.
ssl-error-us-only-server = Hindi makapag-communicate nang ligtas. Nangangailangan ang peer ng high-grade encryption, na hindi suportado ngayon.
ssl-error-no-cypher-overlap = Cannot communicate securely with peer: no common encryption algorithm(s).
ssl-error-no-certificate = Walang kakayahang makita ang katibayan o kinakailangang susi para sa katunayan.
ssl-error-bad-certificate = Hindi maka-communicate ng secure sa peer: peers ng sertipiko ay tinanggihan.
ssl-error-bad-client = Nakakita ang server ng maling data galing client.
ssl-error-bad-server = Ang kliyente ay nakaranas ng hindi magandang data na galing sa server.
ssl-error-unsupported-certificate-type = Hindi suportado ang uri ng certificate.
ssl-error-unsupported-version = Peer ang paggamit ng hindi suportadong bersyon ng seguridad na protocol.
ssl-error-wrong-certificate = Client authentication ay nabigo: pribadong key sa key database ay hindi tumutugma sa public key sa sertipiko ng database.
ssl-error-bad-cert-domain = Hindi makakapag-usap ng secure sa peer: Ang hiniling na domain name ay hindi tumutugma sa sertipiko ng server.
ssl-error-post-warning = Hindi makilalang SSL error code.
ssl-error-ssl2-disabled = Sumusuporta lang ang peer ng SSL bersyon 2, na naka-disable locally.
ssl-error-bad-mac-read = nakatangap ang SSL ng record na may maling Message Authentication Code.
ssl-error-bad-mac-alert = Nag-uulat ang SSL peer ng maling Message Authentication Code.
ssl-error-bad-cert-alert = Hindi ma-verify ng SSL peer ang iyong certificate
ssl-error-revoked-cert-alert = Tinanggihan ng SSL peer ang iyong certificate bilang walang-bisa.
ssl-error-expired-cert-alert = Tinanggihan ng SSL peer ang iyong certificate bilang expired na.
ssl-error-ssl-disabled = Hindi makakonekta: SSL ay sarado.
ssl-error-fortezza-pqg = Hindi makakonekta: SSL peer ay nasa isa pang domain FORTEZZA.
ssl-error-unknown-cipher-suite = May di-kilalang SSL cipher suite na hiningi.
ssl-error-no-ciphers-supported = Walang ibang mga cipher suite na natagpuan at naka-enable sa program na ito.
ssl-error-bad-block-padding = Ang SSL ay nakatanggap ng record na may bad block padding.
ssl-error-rx-record-too-long = Ang SSL ay nakatanggap ng record na lumampas sa pinakamahabang pwedeng sukat.
ssl-error-tx-record-too-long = Ang SSL ay nagtangkang magpadala ng record na lumampas sa pinakamahabang pwedeng sukat.
ssl-error-rx-malformed-hello-request = Ang SSL ay nakatanggap ng malformed Hello Request handshake message.
ssl-error-rx-malformed-client-hello = Ang SSL ay nakatanggap ng malformed Client Hello handshake message.
ssl-error-rx-malformed-server-hello = Ang SSL ay nakatanggap ng malformed Server Hello handshake message.
ssl-error-rx-malformed-certificate = Ang SSL ay nakatanggap ng malformed Certificate handshake message.
ssl-error-rx-malformed-server-key-exch = Ang SSL ay nakatanggap ng malformed Server Key Exchange handshake message.
ssl-error-rx-malformed-cert-request = Ang SSL ay nakatanggap ng malformed Certificate Request handshake message.
ssl-error-rx-malformed-hello-done = Ang SSL ay nakatanggap ng malformed Server Hello Done handshake message.
ssl-error-rx-malformed-cert-verify = Ang SSL ay nakatanggap ng malformed Certificate Verify handshake message.
ssl-error-rx-malformed-client-key-exch = Ang SSL ay nakatanggap ng malformed Client Key Exchange handshake message.
ssl-error-rx-malformed-finished = Ang SSL ay nakatanggap ng malformed Finished handshake message.
ssl-error-rx-malformed-change-cipher = Ang SSL ay nakatanggap ng malformed Change Cipher Spec record.
ssl-error-rx-malformed-alert = Ang SSL ay nakatanggap ng malformed Alert record.
ssl-error-rx-malformed-handshake = Ang SSL ay nakatanggap ng malformed Handshake record.
ssl-error-rx-malformed-application-data = Ang SSL ay nakatanggap ng malformed Application Data record.
ssl-error-rx-unexpected-hello-request = Ang SSL ay nakatanggap ng di-inaasahang Hello Request handshake message.
ssl-error-rx-unexpected-client-hello = Ang SSL ay nakatanggap ng di-inaasahang Client Hello handshake message.
ssl-error-rx-unexpected-server-hello = Ang SSL ay nakatanggap ng di-inaasahang Server Hello handshake message.
ssl-error-rx-unexpected-certificate = Ang SSL ay nakatanggap ng di-inaasahang Certificate handshake message.
ssl-error-rx-unexpected-server-key-exch = Ang SSL ay nakatanggap ng di-inaasahang Server Key Exchange handshake message.
ssl-error-rx-unexpected-cert-request = Ang SSL ay nakatanggap ng di-inaasahang Certificate Request handshake message.
ssl-error-rx-unexpected-hello-done = Ang SSL ay nakatanggap ng di-inaasahang Server Hello Done handshake message.
ssl-error-rx-unexpected-cert-verify = Ang SSL ay nakatanggap ng di-inaasahang Certificate Verify handshake message.
ssl-error-rx-unexpected-client-key-exch = Ang SSL ay nakatanggap ng di-inaasahang Client Key Exchange handshake message.
ssl-error-rx-unexpected-finished = Ang SSL ay nakatanggap ng di-inaasahang Finished handshake message.
ssl-error-rx-unexpected-change-cipher = Ang SSL ay nakatanggap ng di-inaasahang Change Cipher Spec record.
ssl-error-rx-unexpected-alert = Ang SSL ay nakatanggap ng di-inaasahang Alert record.
ssl-error-rx-unexpected-handshake = Ang SSL ay nakatanggap ng di-inaasahang Handshake record.
ssl-error-rx-unexpected-application-data = Ang SSL ay nakatanggap ng di-inaasahang Application Data record.
ssl-error-rx-unknown-record-type = Ang SSL ay nakatanggap ng record na may di-kilalang content type.
ssl-error-rx-unknown-handshake = Ang SSL ay nakatanggap ng handshake message na may di-kilalang content type.
ssl-error-rx-unknown-alert = Ang SSL ay nakatanggap ng alert record na may di-kilalang alert description.
ssl-error-close-notify-alert = Isinara na ng SSL peer ang koneksiyong ito.
ssl-error-handshake-unexpected-alert = Hindi inaasahan ng SSL peer ang natanggap nitong handshake message.
ssl-error-decompression-failure-alert = Ang SSL peer ay bigong makapag-decompress ng natanggap na SSL record.
ssl-error-handshake-failure-alert = Ang SSL peer ay bigong makapag-negotiate ng katanggap-tanggap na pangkat ng mga security parameter.
ssl-error-illegal-parameter-alert = Ang SSL peer ay tumanggi sa handshake message dahil sa di-katanggap-tanggap na content.
ssl-error-unsupported-cert-alert = Hindi sinusuportahan ng SSL peer ang mga certificate na may uring natanggap.
ssl-error-certificate-unknown-alert = Nagkaroon ng di-nabanggit na issue ang SSL peer sa certificate na natanggap.
ssl-error-generate-random-failure = Ang SSL ay nakaranas ng problema sa random number generator nito.
ssl-error-sign-hashes-failure = Hindi kayang ma-digitally sign ang data na kailangan para mapatunayan ang iyong certificate.
ssl-error-extract-public-key-failure = Hindi ma-extract ng SSL ang public key mula sa peer certificate.
ssl-error-server-key-exchange-failure = May di-nabanggit na pagkabigo habang pina-process ang SSL Server Key Exchange handshake.
ssl-error-client-key-exchange-failure = May di-nabanggit na pagkabigo habang pina-process ang SSL Client Key Exchange handshake.
ssl-error-encryption-failure = Nabigo ang bulk data encryption algorithm sa napiling cipher suite.
ssl-error-decryption-failure = Nabigo ang bulk data decryption algorithm sa napiling cipher suite.
ssl-error-socket-write-failure = Nabigo ang tangkang magsulat ng encrypted data sa underlying socket.
ssl-error-md5-digest-failure = Nabigo ang MD5 digest function.
ssl-error-sha-digest-failure = Nabigo ang SHA-1 digest function.
ssl-error-mac-computation-failure = Nabigo ang MAC computation.
ssl-error-sym-key-context-failure = Bigong makagawa ng Symmetric Key context.
ssl-error-sym-key-unwrap-failure = Bigong ma-unwrap ang Symmetric Key sa Client Key Exchange message.
ssl-error-pub-key-size-limit-exceeded = Ang SSL Server ay nagtangkang gumamit ng domestic-grade public key na may export cipher suite.
ssl-error-iv-param-failure = Bigong makapag-translate ang PKCS11 code ng IV sa param.
ssl-error-init-cipher-suite-failure = Bigong mag-initialize ng napiling cipher suite.
ssl-error-session-key-gen-failure = Bigo ang client na makapag-generate ng mga session key para sa SSL session.
ssl-error-no-server-key-for-alg = Walang key ang server para sa tinangkang key exchange algorithm.
ssl-error-token-insertion-removal = May PKCS#11 token na ipinasok o tinanggal habang tumatakbo ang operasyon.
ssl-error-token-slot-not-found = Walang natagpuang PKCS#11 token para gawin ang kinakailangang operasyon.
ssl-error-no-compression-overlap = Hindi makapag-communicate nang ligtas sa peer; walang common compression algorithm(s).
ssl-error-handshake-not-completed = Hindi maaaring simulan ang isa pang SSL handshake hangga't hindi kumpleto ang kasalukuyang handshake.
ssl-error-bad-handshake-hash-value = Nakatanggap ng mga maling handshake hash value mula sa peer.
ssl-error-cert-kea-mismatch = Ang binigay na certificate ay hindi maaaring gamitin sa napiling key exchange algorithm.
ssl-error-no-trusted-ssl-client-ca = Walang certificate authority na pinagkakatiwalaan para sa SSL client authentication.
ssl-error-session-not-found = Hindi natagpuan ang SSL session ID ng client sa session cache ng server.
ssl-error-decryption-failed-alert = Hindi ma-decrypt ng peer ang natanggap na SSL record.
ssl-error-record-overflow-alert = Ang peer ay nakatanggap ng SSL record na mas mahaba kaysa sa pinapahintulutan.
ssl-error-unknown-ca-alert = Hindi kinikilala at pinagkakatiwalaan ng peer ang CA na naglathala ng iyong certificate.
ssl-error-access-denied-alert = Nakatanggap ang peer ng wastong certificate, ngunit hindi pinayagan ang pag-access.
ssl-error-decode-error-alert = Ang peer ay hindi makapag-decode ng SSL handshake message.
ssl-error-decrypt-error-alert = Ang peer ay nag-uulat ng pagkabigo sa signature verification o key exchange.
ssl-error-export-restriction-alert = Ang peer ay nag-uulat ng negotiation na di-alinsunod sa mga export regulation.
ssl-error-protocol-version-alert = Ang peer ay nag-uulat ng salungat o di-suportadong protocol version.
ssl-error-insufficient-security-alert = Ang server ay nangangailangan ng mga cipher na mas ligtas pa kaysa sa sinusuportahan ng client.
ssl-error-internal-error-alert = Ang peer ay nag-uulat na ito'y nakaranas ng internal error.
ssl-error-user-canceled-alert = Kinansela ng peer user ang handshake.
ssl-error-no-renegotiation-alert = Ang peer ay hindi nagpapahintulot ng renegotiation ng mga SSL security parameter.
ssl-error-server-cache-not-configured = Ang SSL server cache ay hindi naka-configure at hindi naka-disable para sa socket na ito.
ssl-error-unsupported-extension-alert = Ang SSL peer ay hindi suportado ang hininging TLS hello extension.
ssl-error-certificate-unobtainable-alert = Hindi kayang makuha ng SSL peer ang iyong certificate mula sa naibigay na URL.
ssl-error-unrecognized-name-alert = Walang certificate ang SSL peer para sa hininging DNS name.
ssl-error-bad-cert-status-response-alert = Bigong makakuha ang SSL peer ng OCSP response para sa certificate nito.
ssl-error-bad-cert-hash-value-alert = Nag-ulat ang SSL peer ng bad certificate hash value.
ssl-error-rx-unexpected-new-session-ticket = Ang SSL ay nakatanggap ng di-inaasahang New Session Ticket handshake message.
ssl-error-rx-malformed-new-session-ticket = Ang SSL ay nakatanggap ng malformed New Session Ticket handshake message.
ssl-error-decompression-failure = Ang SSL ay nakatanggap ng compressed record na hindi kayang ma-decompress.
ssl-error-renegotiation-not-allowed = Hindi pinapayagan ang renegotiation sa SSL socket na ito.
ssl-error-unsafe-negotiation = Ang peer ay nagtangkang gumawa ng old style (maaaring mahinang) handshake.
ssl-error-rx-unexpected-uncompressed-record = Ang SSL ay nakatanggap ng di-inaasahang uncompressed record.
ssl-error-weak-server-ephemeral-dh-key = Ang SSL ay nakatanggap ng weak ephemeral Diffie-Hellman key sa Server Key Exchange handshake message.
ssl-error-next-protocol-data-invalid = Ang SSL ay nakatanggap ng di-wastong NPN extension data.
ssl-error-feature-not-supported-for-ssl2 = Ang SSL feature ay hindi suportado para sa mga SSL 2.0 connection.
ssl-error-feature-not-supported-for-servers = Ang SSL feature ay hindi suportado para sa mga server.
ssl-error-feature-not-supported-for-clients = Ang SSL feature ay hindi suportado para sa mga client.
ssl-error-invalid-version-range = Ang SSL version range ay mali.
ssl-error-cipher-disallowed-for-version = Pumili ang SSL peer ng cipher suite na ipinagbawal para sa napiling protocol version.
ssl-error-rx-malformed-hello-verify-request = Ang SSL ay nakatanggap ng malformed Hello Verify Request handshake message.
ssl-error-rx-unexpected-hello-verify-request = Ang SSL ay nakatanggap ng di-inaasahang Hello Verify Request handshake message.
ssl-error-feature-not-supported-for-version = Ang SSL feature ay hindi suportado para sa bersyon ng protocol.
ssl-error-rx-unexpected-cert-status = Ang SSL ay nakatanggap ng di-inaasahang Certificate Status handshake message.
ssl-error-unsupported-hash-algorithm = Di-suportadong hash algorithm na ginamit ng TLS peer.
ssl-error-digest-failure = Nabigo ang digest function.
ssl-error-incorrect-signature-algorithm = Maling signature algorithm nabanggit sa isang digitally-signed na element.
ssl-error-next-protocol-no-callback = Naka-enable ang susunod na protocol negotiation extension, pero na-clear ang callback bago kailanganin.
ssl-error-next-protocol-no-protocol = Ang server ay hindi sumusuporta sa mga protocol na ina-advertise ng client sa ALPN extension.
ssl-error-inappropriate-fallback-alert = Ang server ay tumanggi sa handshake dahil ang client ay nag-downgrade sa mas mababang bersyon ng TLS kaysa sa sinusuportahan ng server.
ssl-error-weak-server-cert-key = Ang server certificate ay nagsama ng public key na masyadong mahina.
ssl-error-rx-short-dtls-read = Walang sapat na lugar sa buffer para sa DTLS record.
ssl-error-no-supported-signature-algorithm = Walang suportadong TLS signature algorithm ang naka-configure.
ssl-error-unsupported-signature-algorithm = Ang peer ay gumamit ng di-suportadong kombinasyon ng signature at hash algorithm.
ssl-error-missing-extended-master-secret = Sinubukan ng peer na magpatuloy nang walang tamang extended_master_secret extension.
ssl-error-unexpected-extended-master-secret = Sinubukan ng peer na magpatuloy na may di-inaasahang extended_master_secret extension.
sec-error-io = May naganap na I/O error habang may security authorization.
sec-error-library-failure = security library failure.
sec-error-bad-data = security library: nakatanggap ng bad data.
sec-error-output-len = security library: output length error.
sec-error-input-len = ang security library ay nakaranas ng input length error.
sec-error-invalid-args = security library: invalid arguments.
sec-error-invalid-algorithm = security library: invalid algorithm.
sec-error-invalid-ava = Librarya ng Seguridad: Maling AVA.
sec-error-invalid-time = Maling pagkaka-format ng oras.
sec-error-bad-der = security library: maling pagkaka-format ng DER-encoded message.
sec-error-bad-signature = Ang certificate ng peer ay may invalid signature.
sec-error-expired-certificate = Nag-expire na ang Peer Certificate.
sec-error-revoked-certificate = Pinawalang-bisa na ang Peer Certificate.
sec-error-unknown-issuer = Ang Certificate issuer ng Peer ay hindi kinikilala.
sec-error-bad-key = Hindi wasto ang public key ng peer.
sec-error-bad-password = Hindi tama ang security password.
sec-error-retry-password = Nagpasok ng maling password. Subukan uli.
sec-error-no-nodelock = security library: no nodelock.
sec-error-bad-database = security library: bad database.
sec-error-no-memory = security library: memory allocation failure.
sec-error-untrusted-issuer = Ang certificate issuer ng peer ay minarkahan bilang di-pinagkakatiwalaan ng user.
sec-error-untrusted-cert = Ang certificate ng peer ay minarkahan bilang di-pinagkakatiwalaan ng user.
sec-error-duplicate-cert = Ang sertipiko ay mayroon na sa iyong database.
sec-error-duplicate-cert-name = May ka-doble na sa database ang pangalan sa na-download na certificate.
sec-error-adding-cert = Nagkaroon ng error sa pagdaragdag ng sertipiko sa database.
sec-error-filing-key = Nagkaroon ng error sa pag-refile ng key sa certificate na ito.
sec-error-no-key = Ang private key para sa certificate na ito ay hindi matagpuan sa key database
sec-error-cert-valid = Ang sertipiko ay may-bisa.
sec-error-cert-not-valid = Hindi wasto ang certificate na ito.
sec-error-cert-no-response = Cert Library: Walang Response
sec-error-expired-issuer-certificate = Nag-expire na ang certificate ng certificate issuer. Tingnan ang petsa at oras ng sistema mo.
sec-error-crl-expired = Nag-expire na ang CRL para sa issuer ng certificate. Baguhin ito o tingnan ang petsa at oras ng sistema mo.
sec-error-crl-bad-signature = Hindi wasto ang signature ng CRL para sa issuer ng certificate.
sec-error-crl-invalid = Ang bagong CRL ay may maling format.
sec-error-extension-value-invalid = Di-wasto ang certificate extension value.
sec-error-extension-not-found = Hindi nakita ang extension ng certificate.
sec-error-ca-cert-invalid = Di-wasto ang issuer certificate.
sec-error-path-len-constraint-invalid = Ang certificate path length constraint ay invalid.
sec-error-cert-usages-invalid = Ang certificate usages field ay invalid.
sec-internal-only = **Internal ONLY module**
sec-error-invalid-key = Ang key ay hindi sumusuporta sa hininging operasyon.
sec-error-unknown-critical-extension = Ang certificate ay naglalaman ng di-kilalang kritikal na extension.
sec-error-old-crl = Ang bagong CRL ay hindi mas bago kaysa sa kasalukuyang CRL.
sec-error-no-email-cert = Hindi nakakripta o napirma: wala pa kayo ang sertipikong pang-email.
sec-error-no-recipient-certs-query = Hindi nakakripta: wala kayo ang mga sertipiko para sa bawat isang tatanggap.
sec-error-not-a-recipient = Hindi makapag-decrypt: hindi ka recipient, o walang mahanap na nagtutugmang certificate at private key.
sec-error-pkcs7-keyalg-mismatch = Hindi mabuksan ang pagkokodigo: hindi tugma ang algoritmong pagsasakripta ng susi sa sertipiko ninyo.
sec-error-pkcs7-bad-signature = Bigo ang signature verification: walang natagpuang signer, masyadong maraming signer, o di-wasto o sirang data.
sec-error-unsupported-keyalg = Di-suportado o di-kilalang key algorithm.
sec-error-decryption-disallowed = Hindi maaaring i-decrypt: naka-encrypt gamit ang isang ipinagbabawal na algorithm o key size.
xp-sec-fortezza-bad-card = Ang Fortezza card ay hindi maayos na na-initialize. Mangyaring alisin ito at ibalik ito sa iyong issuer.
xp-sec-fortezza-no-card = Walang Natagpuang mga Fortezza card
xp-sec-fortezza-none-selected = Walang napiling Fortezza card
xp-sec-fortezza-more-info = Mangyaring pumili ng personalidad para makakuha ng karagdagang impormasyon sa
xp-sec-fortezza-person-not-found = Personality not found
xp-sec-fortezza-no-more-info = No more information on that Personality
xp-sec-fortezza-bad-pin = Di-wastong Pin
xp-sec-fortezza-person-error = Hindi makapag-initialize ng mga Fortezza personality.
sec-error-no-krl = Walang natagpuang KRL para sa certificate ng site na ito.
sec-error-krl-expired = Ang KRL para sa certificate ng site na ito ay nag-expire na.
sec-error-krl-bad-signature = Ang KRL para sa certificate ng site na ito ay may invalid signature.
sec-error-revoked-key = Ang key para sa mga sertipiko sa site na ito ay binawi na.
sec-error-krl-invalid = Ang bagong KRL ay may di-wastong format.
sec-error-need-random = security library: need random data.
sec-error-no-module = security library: walang security module na makakagawa ng hininging operasyon.
sec-error-no-token = Walang security card o token, kailangang i-initialize, o tinanggal na.
sec-error-read-only = security library: read-only database.
sec-error-no-slot-selected = Walang slot o token na pinili.
sec-error-cert-nickname-collision = Mayroon nang natagpuang certificate na may kaparehong nickname.
sec-error-key-nickname-collision = Mayroon nang natagpuang key na may kaparehong nickname.
sec-error-safe-not-created = nagkaroon ng error habang gumagawa ng safe object
sec-error-baggage-not-created = nagkaroon ng error habang gumagawa ng baggage object
xp-java-remove-principal-error = Hindi kayang tanggalin ang principal
xp-java-delete-privilege-error = Hindi kayang burahin ang privilege
xp-java-cert-not-exists-error = Ang principal na ito ay walang certificate
sec-error-bad-export-algorithm = Hindi pinapayagan ang kinakailangang algorithm.
sec-error-exporting-certificates = May error sa tangkang pag-export ng mga certificate.
sec-error-importing-certificates = May error sa tangkang pag-import ng mga certificate.
sec-error-pkcs12-decoding-pfx = Hindi makapag-import. Decoding error. Di-wasto ang file.
sec-error-pkcs12-invalid-mac = Hindi makapag-import. Di-wastong MAC. Maling password o sirang file.
sec-error-pkcs12-unsupported-mac-algorithm = Hindi makapag-import. Hindi suportado ang MAC algorithm.
sec-error-pkcs12-unsupported-transport-mode = Hindi makapag-import. Tanging password integrity at mga privacy mode lang ang suportado.
sec-error-pkcs12-corrupt-pfx-structure = Hindi makapag-import. Sira ang file structure.
sec-error-pkcs12-unsupported-pbe-algorithm = Hindi makapag-import. Hindi suportado ang encryption algorithm.
sec-error-pkcs12-unsupported-version = Hindi makapag-import. Hindi suportado ang file version.
sec-error-pkcs12-privacy-password-incorrect = Hindi makapag-import. Maling privacy password.
sec-error-pkcs12-cert-collision = Hindi makapag-import. May kaparehong nickname na sa database.
sec-error-user-cancelled = Pinindot ng user ang cancel.
sec-error-pkcs12-duplicate-data = Hindi na-import dahil nasa database na.
sec-error-message-send-aborted = Hindi naipadala ang mensahe.
sec-error-inadequate-key-usage = Ang paggamit ng certificate key ay di-sapat para sa tinatangkang operasyon.
sec-error-inadequate-cert-type = Ang certificate type ay hindi aprubado para sa application.
sec-error-cert-addr-mismatch = Ang address sa pag-sign ng certificate ay hindi tumutugma sa address sa mga message header.
sec-error-pkcs12-unable-to-import-key = Hindi makapag-import. May error sa pagtatangkang mag-import ng private key.
sec-error-pkcs12-importing-cert-chain = Hindi makapag-import. May error sa pagtatangkang mag-import ng certificate chain.
sec-error-pkcs12-unable-to-locate-object-by-name = Hindi makapag-export. Hindi makahanap ng certificate o key sa pamamagitan ng nickname.
sec-error-pkcs12-unable-to-export-key = Hindi makapag-export. Hindi matagpuan at ma-export ang Private Key.
sec-error-pkcs12-unable-to-write = Hindi makapag-export. Hindi makapagsulat sa export file.
sec-error-pkcs12-unable-to-read = Hindi makapag-import. Hindi makapagbasa ng import file.
sec-error-pkcs12-key-database-not-initialized = Hindi makapag-export. Sira o burado na ang key database.
sec-error-keygen-fail = Hindi makapag-generate ng public/private key pair.
sec-error-invalid-password = Hindi wasto ang naipasok na password. Mangyaring pumili ng iba pa.
sec-error-retry-old-password = Mali ang naipasok na lumang password. Subukan uli.
sec-error-bad-nickname = Gamit na ang certificate nickname.
sec-error-not-fortezza-issuer = Ang peer FORTEZZA chain ay may non-FORTEZZA Certificate.
sec-error-cannot-move-sensitive-key = May sensitive key na hindi pwedeng ilipat sa slot kung saan ito kinakailangan.
sec-error-js-invalid-module-name = Di-wastong module name.
sec-error-js-invalid-dll = Di-wastong module path/filename
sec-error-js-add-mod-failure = Hindi makapagdagdag ng module
sec-error-js-del-mod-failure = Hindi makapagbura ng module
sec-error-old-krl = Ang bagong KRL ay hindi mas bago kaysa sa kasalukuyan.
sec-error-ckl-conflict = Ang bagong CKL ay may ibang issuer kaysa sa kasalukuyang CKL. Burahin ang kasalukuyang CKL.
sec-error-cert-not-in-name-space = Ang Certifying Authority para sa certificate na ito ay hindi pinahihintulutang mag-isyu ng isang certificate na may ganitong pangalan.
sec-error-krl-not-yet-valid = Ang listahan ng key revocation para sa certificate na ito ay hindi pa wasto.
sec-error-crl-not-yet-valid = Ang listahan ng certificate revocation para sa certificate na ito ay hindi pa wasto.
sec-error-unknown-cert = Hindi matagpuan ang hininging certificate.
sec-error-unknown-signer = Ang signer's certificate ay hindi mahanap.
sec-error-cert-bad-access-location = Ang lokasyon ng certificate status server ay may di-wastong format.
sec-error-ocsp-unknown-response-type = Ang OCSP response ay hindi lubusang ma-decode; hindi kilala ang uri nito.
sec-error-ocsp-bad-http-response = Ang OCSP server ay nagbalik ng di-inaasahan/di-wastong HTTP data.
sec-error-ocsp-malformed-request = Nakita ng OCSP server na ang request ay sira o hindi tama ang pagkakagawa.
sec-error-ocsp-server-error = Ang OCSP server ay nakaranas ng internal error.
sec-error-ocsp-try-server-later = Ang OCSP server ay nagmumungkahing subukan uli mamaya.
sec-error-ocsp-request-needs-sig = Ang OCSP server ay nangangailangan ng signature sa request na ito.
sec-error-ocsp-unauthorized-request = Ang OCSP server ay tumanggi sa request bilang ito ay unauthorized.
sec-error-ocsp-unknown-response-status = Ang OCSP server ay nagbalik ng di-kilalang status.
sec-error-ocsp-unknown-cert = Ang OCSP server ay walang status para sa certificate.
sec-error-ocsp-not-enabled = Kailangan mong paganahin ang OCSP bago gawin ang operasyon na ito.
sec-error-ocsp-no-default-responder = Kailangan mo munang itakda ang OCSP default responder bago gawin ang operasyong ito.
sec-error-ocsp-malformed-response = Ang tugon mula sa server ng ​​OCSP ay napinsala o hindi wastong nabuo.
sec-error-ocsp-unauthorized-response = Ang signer ng OSCP response ay hindi awtorisadong magbigay ng status para sa certificate na ito.
sec-error-ocsp-future-response = Ang OCSP response ay hindi pa wasto (naglalaman ng petsa sa hinaharap).
sec-error-ocsp-old-response = Ang OCSP response ay naglalaman ng impormasyong lipas na.
sec-error-digest-not-found = Ang CMS o PKCS #7 Digest ay hindi natagpuan sa signed message.
sec-error-unsupported-message-type = Ang CMS o PKCS #7 Message type ay hindi suportado.
sec-error-module-stuck = Ang PKCS #11 module ay hindi pa maaaring tanggalin dahil ito ay ginagamit pa.
sec-error-bad-template = Hindi ma-decode ng ASN.1 data. Tinukoy na template ay hindi wasto.
sec-error-crl-not-found = Walang katugma na CRL.
sec-error-reused-issuer-and-serial = Tinatangka mong mag-import ng cert sa parehong issuer / serial bilang isang umiiral na cert, ngunit iyon ay hindi ang parehong cert.
sec-error-busy = Hindi maaaring mag-shutdown ang NSS. Ginagamit pa ang mga object.
sec-error-extra-input = Naglaman ng sobrang di-nagamit na data ang DER-encoded message.
sec-error-unsupported-elliptic-curve = Hindi suportadong elliptic curve.
sec-error-unsupported-ec-point-form = Hindi suportadong elliptic curve point form.
sec-error-unrecognized-oid = Unrecognized Object Identifier.
sec-error-ocsp-invalid-signing-cert = Di-wastong OCSP signing certificate sa OCSP response.
sec-error-revoked-certificate-crl = Binawi na ang certificate sa certificate revocation list ng issuer.
sec-error-revoked-certificate-ocsp = Iniulat ng OCSP responder ng issuer na pinawalang-bisa na ang certificate.
sec-error-crl-invalid-version = Issuer's Certificate Revocation na listahan ay may isang hindi kilalang bilang na bersyon.
sec-error-crl-v1-critical-extension = Issuer's V1 Certificate Revocation na listahan ay may isang kritikal extension.
sec-error-crl-unknown-critical-extension = Issuer’s V2 Certificate Revocation List has an unknown critical extension.
sec-error-unknown-object-type = Nabanggit ang di-kilalang object type.
sec-error-incompatible-pkcs11 = Nilabag ng PKCS #11 driver ang spec sa salungat na paraan.
sec-error-no-event = Walang mga bagong slot event na magagamit sa mga oras na ito.
sec-error-crl-already-exists = Mayroon nang CRL.
sec-error-not-initialized = Hindi naka-initialize ang NSS.
sec-error-token-not-logged-in = Bigo ang operasyon dahil ang PKCS#11 token ay hindi naka-login.
sec-error-ocsp-responder-cert-invalid = Ang naka-configure na OCSP responder certificate ay hindi wasto.
sec-error-ocsp-bad-signature = Ang OCSP response ay may invalid signature.
sec-error-out-of-search-limits = Ang cert validation search ay lampas na sa mga search limit
sec-error-invalid-policy-mapping = Ang policy mapping ay naglalaman ng anypolicy
sec-error-policy-validation-failed = Bigo sa policy validation ang cert chain
sec-error-unknown-aia-location-type = Di-kilalang location type sa cert AIA extension
sec-error-bad-http-response = Ang server ay nagbalik ng di-wastong HTTP response
sec-error-bad-ldap-response = Ang server ay nagbalik ng maling LDAP response
sec-error-failed-to-encode-data = Bigong makapag-encode ng data na may ASN1 encoder
sec-error-bad-info-access-location = Maling information access location sa cert extension
sec-error-libpkix-internal = Libpkix internal error occured during cert validation.
sec-error-pkcs11-general-error = Ang isang PKCS #11 module ay nagbalik ng CKR_GENERAL_ERROR, na nagsasabing may naganap na unrecoverable error.
sec-error-pkcs11-function-failed = Ang isang PKCS #11 module ay nagbalik ng CKR_FUNCTION_FAILED, na nagsasabing ang hininging function ay hindi maaaring gawin. Maaaring mapagana kapag inulit uli ang operasyon.
sec-error-pkcs11-device-error = Ang isang PKCS #11 module ay nagbalik ng CKR_DEVICE_ERROR, na nagsasabing may problemang naganap sa token o slot.
sec-error-bad-info-access-method = May di-kilalang information access method sa certificate extension.
sec-error-crl-import-failed = Nagkaproblema nang magtangkang mag-import ng CRL.
sec-error-expired-password = Paso na ang password.
sec-error-locked-password = Ang password ay naka-lock.
sec-error-unknown-pkcs11-error = Di-kilalang PKCS #11 error.
sec-error-bad-crl-dp-url = Di-wasto o di-suportadong URL sa CRL distribution point name.
sec-error-cert-signature-algorithm-disabled = Naka-sign ang certificate gamit ang isang signature algorithm na naka-disable dahil hindi ito ligtas.
mozilla-pkix-error-key-pinning-failure = Ang server ay gumagamit ng key pinning (HPKP) pero walang pinagkakatiwalaang certificate chain na maaaring buuing tumutugma sa pinset. Hindi pwedeng ma-override ang mga key pinning violation.
mozilla-pkix-error-ca-cert-used-as-end-entity = Ang server ay gumagamit ng certificate na may basic constraints extension na nagtutukoy dito bilang isang certificate authority. Hindi dapat ito ang kaso para sa isang certificate na may maayos na pagkakalathala.
mozilla-pkix-error-inadequate-key-size = Ang server ay nagprisinta ng certificate na may key size na masyadong maliit para makapagtatag ng ligtas na koneksyon.
mozilla-pkix-error-v1-cert-used-as-ca = May isang X.509 bersyon 1 na certificate na hindi trust anchor na ginamit para makapaglathala ng server certificate. Ang mga X.509 bersyon 1 na certificate ay deprecated na at hindi dapat gamitin para mag-sign ng ibang mga certificate.
mozilla-pkix-error-not-yet-valid-certificate = Ang server ay nagprisinta ng certificate na hindi pa valid.
mozilla-pkix-error-not-yet-valid-issuer-certificate = May isang certificate na hindi pa valid ay ginamit para maglathala ng server certificate.
mozilla-pkix-error-signature-algorithm-mismatch = Ang signature algorithm sa signature field ng certificate ay hindi tumutugma sa algorithm ng signatureAlgorithm field nito.
mozilla-pkix-error-ocsp-response-for-cert-missing = Ang OCSP response ay hindi nagsasama ng status para sa certificate na vine-verify.
mozilla-pkix-error-validity-too-long = Ang server ay nagprisinta ng certificate na valid sa masyadong mahabang panahon.
mozilla-pkix-error-required-tls-feature-missing = May kinakailangan na TLS feature na nawawala.
mozilla-pkix-error-invalid-integer-encoding = Ang server ay nagprisinta ng certificate na naglalaman ng di-wastong encoding ng isang integer. Ang mga karaniwang sanhi ay kagaya ng mga negative serial number, negative RSA moduli, at mga encoding na mas mahaba kaysa sa kinakailangan.
mozilla-pkix-error-empty-issuer-name = Ang server ay nagprisinta ng certificate na may bakanteng issuer distinguished name.
mozilla-pkix-error-additional-policy-constraint-failed = May karagdagang policy constraint na nabigo habang vina-validate ang certificate na ito.
mozilla-pkix-error-self-signed-cert = Ang certificate ay hindi pinagkakatiwalaan dahil ito ay self-signed.
