cert-error-intro = { $hostname } utiliza um certificado de segurança inválido.
cert-error-mitm-intro = Os websites provam a sua identidade via certificados, que são emitidos por autoridades certificadoras.
cert-error-mitm-mozilla = O { -brand-short-name } é apoiado pela, sem fins lucrativos, Mozilla, que administra um armazenamento completamente aberto de autoridade certificadora (CA). O armazenamento CA ajuda a assegura que as autoridades certificadoras estão a seguir as melhores práticas para segurança de utilizadores.
cert-error-mitm-connection = O { -brand-short-name } utiliza o armazenamento CA da Mozilla para verificar que uma ligação é segura, em vez dos certificados fornecidos pelo sistema operativo do utilizador. Por isso, se um programa antivírus ou rede estão a intercetar uma ligação com um certificado de segurança emitido por uma CA que não está no armazenamento CA da Mozilla, a ligação é considerada insegura.
cert-error-trust-unknown-issuer-intro = Alguém pode estar a tentar fazer-se passar pelo site e você não deve continuar.
cert-error-trust-unknown-issuer = Os websites provam a sua identidade via certificados. O { -brand-short-name } não confia em { $hostname } porque o seu emissor de certificados é desconhecido, o certificado é auto-assinado, ou o servidor não está a enviar os certificados intermediários corretos.
cert-error-trust-cert-invalid = O certificado não é de confiança porque foi emitido por uma AC inválida.
cert-error-trust-untrusted-issuer = O certificado não é de confiança porque o certificado do emissor não é de confiança.
cert-error-trust-signature-algorithm-disabled = O certificado não é de confiança porque foi assinado com um algoritmo que foi desativado por não ser seguro.
cert-error-trust-expired-issuer = O certificado não é de confiança porque o certificado do emissor expirou.
cert-error-trust-self-signed = O certificado não é de confiança porque é auto-assinado.
cert-error-trust-symantec = Certificados emitidos por GeoTrust, RapidSSL, Symantec, Thawte, e VeriSign não são mais considerados seguros porque estas autoridades de certificados não seguiram práticas de segurança no passado.
cert-error-trust-certificate-transparency = O { -brand-short-name } não confia em { $hostname } porque este não conseguiu demonstrar que cumpre os requisitos de transparência do certificado público.
cert-error-untrusted-default = O certificado não vem de uma fonte confiável.
cert-error-domain-mismatch = Os websites provam a sua identidade via certificados. O { -brand-short-name } não confia neste site porque este utiliza um certificado que não é válido para { $hostname }.
cert-error-domain-mismatch-single = Os websites provam a sua identidade via certificados. O { -brand-short-name } não confia neste site porque este utiliza um certificado que não é válido para { $hostname }. O certificado só é válido para <a data-l10n-name="domain-mismatch-link">{ $alt-name }</a>.
cert-error-domain-mismatch-single-nolink = Os websites provam a sua identidade via certificados. O { -brand-short-name } não confia neste site porque este utiliza um certificado que não é válido para { $hostname }. O certificado só é válido para { $alt-name }.
cert-error-domain-mismatch-multiple = Os websites provam a sua identidade via certificados. O { -brand-short-name } não confia neste site porque este utiliza um certificado que não é válido para { $hostname }. O certificado apenas é válido para os seguintes nomes: { $subject-alt-names }
cert-error-expired-now = Os websites provam a sua identidade via certificados, que são válidos para um período definido de tempo. O certificado para { $hostname } expirou em { $not-after-local-time }.
cert-error-not-yet-valid-now = Os websites provam a sua identidade via certificados, que são válidos para um período definido de tempo. O certificado para { $hostname } não irá ser válido até { $not-before-local-time }.
cert-error-code-prefix = Código de erro: { $error }
cert-error-code-prefix-link = Código de erro: <a data-l10n-name="error-code-link">{ $error }</a>
cert-error-ssl-connection-error = Ocorreu um erro durante a ligação a { $hostname }. { $errorMessage }
cert-error-symantec-distrust-description = Os websites provam a sua identidade via certificados, que são emitidos por autoridades certificadoras. A maioria dos navegadores não irão mais confiar em certificados emitidos por GeoTrust, RapidSSL, Symantec, e VeriSign. { $hostname } utiliza um certificado de uma destas autoridades e por isso a identidade do website não pode ser provada.
cert-error-symantec-distrust-admin = Pode notificar o administrador do website acerca deste problema.
cert-error-old-tls-version = Este site poderá não suportar o protocolo TLS 1.2, que é a versão mínima suportada pelo { -brand-short-name }.
cert-error-details-hsts-label = Segurança rigorosa de transporte HTTP (HSTS): { $hasHSTS }
cert-error-details-key-pinning-label = HTTP Public Key Pinning: { $hasHPKP }
cert-error-details-cert-chain-label = Cadeia de certificados:
csp-xfo-blocked-long-desc = Para proteger a sua segurança, { $hostname } não permitirá que o { -brand-short-name } apresente a página se a mesma for incorporada noutro site. Para ver esta página, deve abrir a mesma numa nova janela.
connectionFailure-title = Ligação não estabelecida
deniedPortAccess-title = Este endereço é restrito
dnsNotFound-title = Hum. Estamos a ter problemas em encontrar esse site.
internet-connection-offline-title = Parece que há um problema com a sua ligação à Internet.
fileNotFound-title = Ficheiro não encontrado
fileAccessDenied-title = O acesso ao ficheiro foi negado
generic-title = Oops.
captivePortal-title = Iniciar sessão na rede
malformedURI-title = Hmm. Esse endereço não parece bem.
netInterrupt-title = A ligação foi interrompida
notCached-title = Documento expirado
netOffline-title = Modo offline
contentEncodingError-title = Erro de codificação de conteúdo
unsafeContentType-title = Tipo de ficheiro inseguro
netReset-title = A ligação foi reposta
netTimeout-title = A ligação expirou
httpErrorPage-title = Parece que existe um problema com este site
serverError-title = Parece que existe um problema com este site
unknownProtocolFound-title = O endereço não foi compreendido
proxyConnectFailure-title = O servidor proxy está a recusar ligações
proxyResolveFailure-title = Servidor proxy não encontrado
redirectLoop-title = A página não está a redirecionar corretamente
unknownSocketType-title = Resposta inesperada do servidor
nssFailure2-title = A ligação segura falhou
csp-xfo-error-title = O { -brand-short-name } não pode abrir esta página
corruptedContentError-title = Conteúdo corrompido
sslv3Used-title = Não é possível ligar com segurança
inadequateSecurityError-title = A sua ligação não é segura
blockedByPolicy-title = Página bloqueada
clockSkewError-title = O relógio do seu computador está errado
networkProtocolError-title = Erro de protocolo de rede
nssBadCert-title = Aviso: Potencial risco de segurança à frente
nssBadCert-sts-title = Não se ligou: potencial problema de segurança
certerror-mitm-title = Software está a impedir o { -brand-short-name } de se ligar em segurança a este site
fp-certerror-page-title = Aviso: risco de segurança
fp-certerror-body-title = Tenha cuidado. Algo não parece bem.
fp-certerror-why-site-dangerous = O que faz o site parecer perigoso?
fp-certerror-what-can-you-do = O que pode fazer relativamente a isto?
fp-certerror-advanced-title = Avançadas
fp-certerror-advanced-button = Avançadas
fp-certerror-hide-advanced-button = Ocultar avançadas
fp-certerror-override-exception-button = Continuar para { $hostname } (arriscado)
fp-certerror-intro = O { -brand-short-name } detetou um problema de segurança potencialmente grave com <strong>{ $hostname }</strong>. Alguém que se faz passar pelo site pode tentar roubar coisas como informações de cartão de crédito, palavras-passe ou e-mails.
fp-certerror-expired-into = O { -brand-short-name } detetou um problema de segurança com <strong>{ $hostname }</strong>. Ou o site não está configurado corretamente ou o relógio do seu dispositivo está definido para uma data/hora errada.
fp-certerror-view-certificate-link = Ver o certificado do site
fp-certerror-return-to-previous-page-recommended-button = Retroceder (recomendado)
fp-certerror-bad-domain-why-dangerous-body = O site está configurado para permitir apenas ligações seguras, mas há um problema com o certificado do site. É possível que um autor malicioso esteja a tentar fazer-se passar pelo site. Os sites utilizam certificados emitidos por uma autoridade certificadora para mostrar que são realmente quem dizem ser. O { -brand-short-name } não confia neste site porque o seu certificado não é válido para { $hostname }. O certificado só é válido para: { $validHosts }.
fp-certerror-bad-domain-what-can-you-do-body = Provavelmente nada, já que é provável que exista um problema com o próprio site. Os sites utilizam certificados emitidos por uma autoridade certificadora para mostrar que são realmente quem dizem ser. Mas se estiver numa rede empresarial, a sua equipa de apoio poderá ter mais informações. Se está a utilizar um software antivírus, tente procurar por possíveis conflitos ou problemas conhecidos.
fp-certerror-unknown-issuer-why-dangerous-body = Há um problema com o certificado do site. É possível que um autor malicioso esteja a tentar fazer-se passar pelo site. Os sites utilizam certificados emitidos por uma autoridade certificadora para mostrar que são realmente quem dizem ser. O { -brand-short-name } não confia neste site porque não podemos dizer quem emitiu o certificado, ou o mesmo é auto-assinado ou o site não está a enviar certificados intermédios nos quais confiamos.
fp-certerror-unknown-issuer-what-can-you-do-body = Provavelmente nada, já que é provável que exista um problema com o próprio site. Mas se estiver numa rede empresarial, a sua equipa de apoio poderá ter mais informações. Se está a utilizar um software antivírus, pode ser necessário configurar o mesmo para funcionar com o { -brand-short-name }.
fp-certerror-self-signed-why-dangerous-body = Porque há um problema com o certificado do site. Os sites utilizam certificados emitidos por uma autoridade certificadora para mostrar que são realmente quem dizem ser. O certificado deste site é auto-assinado. Não foi emitido por uma autoridade certificadora reconhecida - por isso, e por predefinição, não confiamos no mesmo.
fp-certerror-self-signed-what-can-you-do-body = Não muito. É provável que seja um problema com o site.
fp-certerror-self-signed-important-note = NOTA IMPORTANTE: se está a tentar visitar este site numa intranet empresarial, a sua equipa de TI poderá utilizar certificados auto-assinados. Esta poderá ajudar a verificar a sua autenticidade.
fp-certerror-expired-why-dangerous-body = Os sites utilizam certificados emitidos por uma autoridade certificadora para mostrar que são realmente quem dizem ser. O { -brand-short-name } não confia neste site porque parece que o certificado expirou a { DATETIME($date, month: "numeric", day: "numeric", year: "numeric") }.
fp-certerror-not-yet-valid-why-dangerous-body = Os sites utilizam certificados emitidos por uma autoridade certificadora para mostrar que são realmente quem dizem ser. O { -brand-short-name } não confia neste site porque este parece que o certificado não será válido até { DATETIME($date, month: "numeric", day: "numeric", year: "numeric") }.
fp-certerror-expired-what-can-you-do-body = O relógio do seu dispositivo está definido para { DATETIME($date, month: "numeric", day: "numeric", year: "numeric") }. Se isto estiver correto, o problema de segurança provavelmente está no próprio site. Se estiver errado, pode alterar o mesmo nas definições de sistema do seu dispositivo.
fp-cert-error-code = Código de erro: { $error }
fp-datetime = { DATETIME($datetime, month: "short", year: "numeric", day: "numeric") } { DATETIME($datetime, timeStyle: "long") }
fp-learn-more-about-secure-connection-failures = Saber mais sobre falhas de ligação segura
fp-learn-more-about-cert-issues = Saber mais sobre este tipo de problemas com certificados
fp-learn-more-about-time-related-errors = Saber mais sobre a resolução de problemas de erros relacionados com a data e hora
