# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

tabbrowser-empty-tab-title = Uusi välilehti
tabbrowser-empty-private-tab-title = Uusi yksityinen välilehti
tabbrowser-menuitem-close-tab =
    .label = Sulje välilehti
tabbrowser-menuitem-close =
    .label = Sulje
# Displayed as a tooltip on container tabs
# Variables:
#   $title (String): the title of the current tab.
#   $containerName (String): the name of the current container.
tabbrowser-container-tab-title = { $title } — { $containerName }
# This text serves as an on-screen tooltip as well as an accessible name for
# the "X" button that is shown on the active tab or, when multiple tabs are
# selected, to all their "X" buttons.
# Variables:
#   $tabCount (Number): The number of tabs that will be closed.
tabbrowser-close-tabs-button =
    .tooltiptext =
        { $tabCount ->
            [one] Sulje välilehti
           *[other] Sulje { $tabCount } välilehteä
        }
# Variables:
#   $tabCount (Number): The number of tabs that will be closed.
tabbrowser-close-tabs-tooltip =
    .label =
        { $tabCount ->
            [one] Sulje välilehti
           *[other] Sulje { $tabCount } välilehteä
        }

## Tooltips for tab audio control
## Variables:
##   $tabCount (Number): The number of tabs that will be affected.

# Variables:
#   $shortcut (String): The keyboard shortcut for "Mute tab".
tabbrowser-mute-tab-audio-tooltip =
    .label =
        { $tabCount ->
            [one] Vaimenna välilehti ({ $shortcut })
           *[other] Vaimenna { $tabCount } välilehteä ({ $shortcut })
        }
# Variables:
#   $shortcut (String): The keyboard shortcut for "Unmute tab".
tabbrowser-unmute-tab-audio-tooltip =
    .label =
        { $tabCount ->
            [one] Palauta ääni välilehteen ({ $shortcut })
           *[other] Palauta ääni { $tabCount } välilehteen ({ $shortcut })
        }
tabbrowser-mute-tab-audio-background-tooltip =
    .label =
        { $tabCount ->
            [one] Vaimenna välilehti
           *[other] Vaimenna { $tabCount } välilehteä
        }
tabbrowser-unmute-tab-audio-background-tooltip =
    .label =
        { $tabCount ->
            [one] Palauta ääni välilehteen
           *[other] Palauta ääni { $tabCount } välilehteen
        }
tabbrowser-unblock-tab-audio-tooltip =
    .label =
        { $tabCount ->
            [one] Toista välilehden äänet
           *[other] Toista { $tabCount } välilehden äänet
        }

## Confirmation dialog when closing a window with more than one tab open,
## or when quitting when only one window is open.

# The singular form is not considered since this string is used only for multiple tabs.
# Variables:
#   $tabCount (Number): The number of tabs that will be closed.
tabbrowser-confirm-close-tabs-title = Suljetaanko { $tabCount } välilehteä?
tabbrowser-confirm-close-tabs-button = Sulje välilehdet
tabbrowser-ask-close-tabs-checkbox = Kysy ennen useiden välilehtien sulkemista
tabbrowser-confirm-close-tabs-checkbox = Vahvista ennen kuin useat välilehdet suljetaan

## Confirmation dialog when quitting using the menu and multiple windows are open.

# The forms for 0 or 1 items are not considered since this string is used only for
# multiple windows.
# Variables:
#   $windowCount (Number): The number of windows that will be closed.
tabbrowser-confirm-close-windows-title = Suljetaanko { $windowCount } ikkunaa?
tabbrowser-confirm-close-windows-button =
    { PLATFORM() ->
        [windows] Sulje ja poistu
       *[other] Sulje ja lopeta
    }

## Confirmation dialog when quitting using the keyboard shortcut (Ctrl/Cmd+Q)
## Windows does not show a prompt on quit when using the keyboard shortcut by default.

tabbrowser-confirm-close-tabs-with-key-title = Suljetaanko ikkuna ja lopetetaanko { -brand-short-name }?
tabbrowser-confirm-close-tabs-with-key-button = Lopeta { -brand-short-name }
# Variables:
#   $quitKey (String): the text of the keyboard shortcut for quitting.
tabbrowser-ask-close-tabs-with-key-checkbox = Kysy ennen pikanäppäimellä { $quitKey } lopettamista
# Variables:
#   $quitKey (String): the text of the keyboard shortcut for quitting.
tabbrowser-confirm-close-tabs-with-key-checkbox = Vahvista ennen pikanäppäimellä { $quitKey } lopettamista

## Confirmation dialog when quitting using the keyboard shortcut (Ctrl/Cmd+Q)
## and browser.warnOnQuitShortcut is true.

tabbrowser-confirm-close-warn-shortcut-title = Lopetetaanko { -brand-short-name } vai suljetaanko nykyinen välilehti?
tabbrowser-confirm-close-windows-warn-shortcut-button =
    { PLATFORM() ->
        [windows] Lopeta { -brand-short-name }
       *[other] Lopeta { -brand-short-name }
    }
tabbrowser-confirm-close-tab-only-button = Sulje avoin välilehti

## Confirmation dialog when opening multiple tabs simultaneously

tabbrowser-confirm-open-multiple-tabs-title = Vahvista avaaminen
# Variables:
#   $tabCount (Number): The number of tabs that will be opened.
tabbrowser-confirm-open-multiple-tabs-message =
    { $tabCount ->
       *[other] Yrität avata { $tabCount } välilehteä samanaikaisesti. { -brand-short-name }in toiminta voi hidastua välilehtien latautumisen ajaksi. Avataanko välilehdet?
    }
tabbrowser-confirm-open-multiple-tabs-button = Avaa välilehdet
tabbrowser-confirm-open-multiple-tabs-checkbox = Varoita, kun usean välilehden avaaminen voi hidastaa { -brand-short-name }in toimintaa

## Confirmation dialog for enabling caret browsing

tabbrowser-confirm-caretbrowsing-title = Selaus kohdistimella
tabbrowser-confirm-caretbrowsing-message = F7-näppäimellä voit ottaa käyttöön tai poistaa käytöstä selauksen kohdistimella. Tämän toiminnon ollessa päällä verkkosivulla on liikuteltava kohdistin, jonka avulla voit näppäimistöllä valita tekstiä sivulta. Selataanko kohdistimella?
tabbrowser-confirm-caretbrowsing-checkbox = Älä näytä tätä ikkunaa uudestaan.

## Confirmation dialog for closing all duplicate tabs

tabbrowser-confirm-close-duplicate-tabs-title = Huomio
tabbrowser-confirm-close-duplicate-tabs-text = Pidämme viimeisen aktiivisen välilehden avoinna
tabbrowser-confirm-close-all-duplicate-tabs-title = Suljetaanko välilehtien kaksoiskappaleet?
tabbrowser-confirm-close-all-duplicate-tabs-text =
    Välilehtien kaksoiskappaleet suljetaan tässä ikkunassa. Viimeinen aktiivinen
    välilehti jää auki.
tabbrowser-confirm-close-all-duplicate-tabs-button-closetabs = Sulje välilehdet

##

# Variables:
#   $domain (String): URL of the page that is trying to steal focus.
tabbrowser-allow-dialogs-to-get-focus =
    .label = Salli, että tällaiset ilmoitukset sivustolta { $domain } vievät sinut heidän välilehteen
tabbrowser-customizemode-tab-title = Muokkaa { -brand-short-name }-selainta

## Context menu buttons, of which only one will be visible at a time

tabbrowser-context-mute-tab =
    .label = Vaimenna välilehti
    .accesskey = V
tabbrowser-context-unmute-tab =
    .label = Palauta ääni
    .accesskey = ä
# The accesskey should match the accesskey for tabbrowser-context-mute-tab
tabbrowser-context-mute-selected-tabs =
    .label = Vaimenna välilehdet
    .accesskey = V
# The accesskey should match the accesskey for tabbrowser-context-unmute-tab
tabbrowser-context-unmute-selected-tabs =
    .label = Palauta ääni välilehtiin
    .accesskey = ä
# This string is used as an additional tooltip and accessibility description for tabs playing audio
tabbrowser-tab-audio-playing-description = Toistaa ääntä

## Ctrl-Tab dialog

# Variables:
#   $tabCount (Number): The number of tabs in the current browser window. It will always be 2 at least.
tabbrowser-ctrl-tab-list-all-tabs =
    .label = Näytä kaikki { $tabCount } välilehteä

## Tab manager menu buttons

tabbrowser-manager-mute-tab =
    .tooltiptext = Vaimenna välilehti
tabbrowser-manager-unmute-tab =
    .tooltiptext = Palauta ääni
tabbrowser-manager-close-tab =
    .tooltiptext = Sulje välilehti

## Tab Groups

tab-group-editor-title-create = Luo välilehtiryhmä
tab-group-editor-title-edit = Hallinnoi välilehtiryhmää
tab-group-editor-name-label = Nimi
tab-group-editor-name-field =
    .placeholder = Esimerkki: Ostokset
tab-group-editor-cancel =
    .label = Peruuta
    .accesskey = P
tab-context-unnamed-group =
    .label = Nimetön ryhmä

## Variables:
##  $tabCount (Number): the number of tabs that are affected by the action.

tab-context-move-tab-to-new-group =
    .label =
        { $tabCount ->
            [1] Lisää välilehti uuteen ryhmään
            [one] Lisää välilehti uuteen ryhmään
           *[other] Lisää välilehdet uuteen ryhmään
        }
    .accesskey = u
tab-context-move-tab-to-group =
    .label =
        { $tabCount ->
            [1] Lisää välilehti ryhmään
            [one] Lisää välilehti ryhmään
           *[other] Lisää välilehdet ryhmään
        }
    .accesskey = ä
tab-group-editor-action-new-tab =
    .label = Uusi välilehti ryhmässä
tab-group-editor-action-new-window =
    .label = Siirrä ryhmä uuteen ikkunaan
tab-group-editor-action-save =
    .label = Tallenna ja sulje ryhmä
tab-group-editor-action-ungroup =
    .label = Pura välilehtien ryhmittely
tab-group-editor-action-delete =
    .label = Poista ryhmä
tab-group-editor-done =
    .label = Valmis
    .accessKey = V
tab-context-reopen-tab-group =
    .label = Avaa välilehtiryhmä uudelleen
# Variables:
#  $groupCount (Number): the number of tab groups that are affected by the action.
tab-context-ungroup-tab =
    .label =
        { $groupCount ->
            [1] Poista ryhmästä
            [one] Poista ryhmästä
           *[other] Poista ryhmistä
        }
    .accesskey = r
