# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## The Enterprise Policies feature is aimed at system administrators
## who want to deploy these settings across several Firefox installations
## all at once. This is traditionally done through the Windows Group Policy
## feature, but the system also supports other forms of deployment.
## These are short descriptions for individual policies, to be displayed
## in the documentation section in about:policies.

policy-3rdparty = ᱱᱤᱛᱤ ᱠᱚ ᱥᱮᱴ ᱢᱮ ᱡᱟᱦᱟᱸ ᱫᱚ chrome.storage.managed ᱛᱮ WebExtensions ᱟᱫᱮᱨ ᱫᱟᱲᱮᱭᱟᱜᱼᱟᱭ ᱾
policy-AllowedDomainsForApps = Google ᱠᱟᱹᱢᱤ ᱴᱚᱴᱷᱟ ᱨᱮ ᱥᱮᱱᱚᱜ ᱞᱟᱹᱜᱤᱫ ᱦᱮᱸᱥᱮᱨᱤᱭᱟᱹ ᱢᱮᱱᱟᱜ ᱰᱳᱢᱮᱱ ᱠᱚ ᱵᱟᱛᱟᱣ ᱢᱮ ᱾
policy-AppAutoUpdate = ᱟᱡᱛᱮ ᱮᱯᱞᱤᱠᱮᱥᱚᱱ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱮᱢ ᱟᱨᱵᱟᱝ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-AppUpdatePin = { -brand-short-name } ᱵᱤᱥᱮᱥ ᱵᱷᱚᱨᱥᱚᱱ ᱠᱷᱚᱱ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱠᱷᱚᱱ ᱟᱠᱮᱴ ᱢᱮ ᱾
policy-AppUpdateURL = ᱠᱚᱥᱴᱚᱢ ᱮᱯ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ URL ᱥᱮᱴ ᱢᱮ ᱾
policy-Authentication = ᱱᱚᱶᱟ ᱥᱚᱦᱚᱫ ᱮᱢᱮᱫ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱞᱟᱹᱜᱤᱫ ᱤᱱᱴᱤᱜᱽᱨᱮᱴᱮᱰ ᱚᱛᱷᱮᱱᱴᱤᱠᱮᱥᱚᱱ ᱥᱮᱴ ᱢᱮ ᱾
policy-AutoLaunchProtocolsFromOrigins = ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱵᱤᱱ ᱫᱮᱠᱷᱟᱣ ᱠᱟᱛᱮ ᱞᱤᱥᱴᱤ ᱟᱠᱟᱱ ᱢᱩᱞ ᱡᱟᱭᱜᱟ ᱠᱷᱚᱱ ᱵᱮᱵᱷᱟᱨ ᱫᱟᱲᱮᱭᱟᱜ ᱵᱟᱦᱨᱮ ᱯᱨᱚᱴᱚᱠᱚᱞ ᱨᱮᱱᱟᱜ ᱢᱤᱫ ᱞᱤᱥᱴᱤ ᱵᱟᱛᱟᱣ ᱢᱮ ᱾
policy-BackgroundAppUpdate2 = ᱵᱮᱠᱜᱽᱨᱟᱣᱱᱰ ᱦᱟᱹᱞᱤᱭᱟᱹᱠᱤᱭᱟᱹ ᱮᱢ ᱢᱮ ᱟᱨᱵᱟᱝ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-BlockAboutAddons = ᱮᱰᱼᱚᱱᱥ ᱢᱚᱱᱮᱡᱟᱨ ᱛᱮ ᱟᱫᱮᱨ ᱟᱠᱚᱴ ᱢᱮ (about:addons) ᱾
policy-BlockAboutConfig = about:config ᱥᱟᱦᱴᱟ ᱛᱮ ᱟᱫᱮᱨ ᱟᱠᱚᱴ ᱢᱮ ᱾
policy-BlockAboutProfiles = about:profiles ᱥᱟᱦᱴᱟ ᱛᱮ ᱟᱫᱮᱨ ᱟᱠᱚᱴ ᱢᱮ ᱾
policy-BlockAboutSupport = about:support ᱥᱟᱦᱴᱟ ᱛᱮ ᱟᱫᱮᱨ ᱟᱠᱚᱴ ᱢᱮ ᱾
policy-Bookmarks = ᱯᱩᱛᱷᱤᱪᱤᱱᱦᱟᱹ ᱦᱟᱹᱛᱤᱭᱟᱨᱵᱟᱨ, ᱯᱩᱛᱷᱤᱪᱤᱱᱦᱟᱹ ᱢᱮᱱᱩ ᱥᱮ ᱚᱱᱟ ᱢᱩᱫᱨᱮ ᱢᱤᱫᱴᱟᱝ ᱯᱚᱴᱚᱢ ᱵᱷᱤᱛᱤᱨ ᱨᱮ ᱯᱩᱛᱷᱤᱪᱤᱱᱦᱟᱹ ᱵᱮᱱᱟᱣ ᱢᱮ ᱾
policy-CaptivePortal = ᱠᱮᱯᱴᱤᱵᱷ ᱯᱚᱨᱴᱟᱞ ᱜᱚᱲᱚ ᱫᱚ ᱮᱢ ᱟᱨ ᱵᱟᱝ ᱵᱚᱸᱫ ᱪᱷᱚᱭ ᱢᱮ ᱾
policy-CertificatesDescription = ᱯᱚᱨᱢᱟᱱ ᱥᱟᱠᱟᱢ ᱥᱮᱞᱮᱫ ᱢᱮ ᱟᱨ ᱵᱟᱝ ᱢᱟᱲᱟᱝ ᱠᱷᱚᱱ ᱢᱮᱱᱟᱜ ᱠᱟᱱ ᱵᱮᱵᱷᱟᱨ ᱢᱮ ᱾
policy-Cookies = ᱠᱩᱠᱤ ᱥᱮᱴ ᱞᱟᱹᱜᱤᱫ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱠᱚ ᱢᱟᱱᱟ ᱥᱮ ᱮᱢ ᱪᱷᱚᱭᱟ ᱾
# Containers in this context is referring to container tabs in Firefox.
policy-Containers = ᱠᱚᱱᱴᱮᱱᱚᱨ ᱛᱮ ᱱᱤᱛᱤ ᱵᱟᱵᱚᱛ ᱡᱤᱱᱤᱥ ᱫᱚᱦᱚᱭᱟ ᱾
policy-DisabledCiphers = ᱮᱞᱮᱠᱷ ᱵᱚᱱᱫᱚᱭ ᱢᱮ ᱾
policy-DefaultDownloadDirectory = ᱢᱩᱞ ᱰᱟᱣᱱᱞᱚᱰ ᱜᱩᱫᱟᱢ ᱥᱮᱴ ᱢᱮ ᱾
policy-DisableAppUpdate = ᱵᱽᱨᱟᱣᱡᱚᱨ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱠᱷᱚᱱ ᱢᱟᱱᱟᱭ ᱢᱮ ᱾
policy-DisableBuiltinPDFViewer = PDF.js ᱵᱚᱸᱫᱚᱭ ᱢᱮ, { -brand-short-name } ᱨᱮ PDF ᱫᱮᱠᱷᱟᱣᱤᱭᱟᱹ ᱛᱮᱭᱟᱨ ᱢᱮᱱᱟᱜᱼᱟ ᱾
policy-DisableDefaultBrowserAgent = ᱢᱩᱞ ᱵᱽᱨᱟᱣᱡᱚᱨ ᱫᱚ ᱡᱟᱦᱟᱸ ᱠᱟᱹᱢᱤ ᱤᱫᱤ ᱢᱟᱲᱟᱝ ᱠᱷᱚᱱ ᱟᱠᱚᱴ ᱢᱮ ᱾ ᱠᱷᱟᱹᱞᱤ ᱣᱤᱱᱰᱚ ᱞᱟᱹᱜᱤᱫ ᱜᱮᱪ ᱜᱮ; ᱮᱴᱟᱜ ᱯᱞᱟᱴᱯᱷᱚᱨᱢ ᱨᱮ ᱫᱚ ᱮᱡᱮᱱᱴ ᱵᱟᱠᱚ ᱛᱟᱦᱮᱸᱱᱟ ᱾
policy-DisableDeveloperTools = ᱰᱮᱵᱷᱞᱚᱯᱚᱨ ᱦᱟᱹᱛᱤᱭᱟᱨ ᱨᱮ ᱟᱫᱮᱨ ᱟᱠᱚᱴ ᱢᱮ ᱾
policy-DisableFeedbackCommands = ᱜᱚᱲᱚ ᱢᱮᱱᱩ ᱠᱷᱚᱱ ᱯᱷᱤᱰᱵᱮᱠ ᱵᱷᱮᱡᱟ ᱞᱟᱹᱜᱤᱫ ᱛᱮ ᱟᱫᱮᱥ ᱵᱚᱸᱫ ᱢᱮ  (ᱯᱷᱤᱰᱵᱮᱠ ᱯᱟᱨᱥᱚᱞ ᱟᱨ ᱮᱲᱮ ᱥᱟᱭᱤᱴ ᱠᱷᱚᱵᱚᱨ ᱢᱮ) ᱾
policy-DisableFirefoxAccounts = { -fxaccount-brand-name } ᱡᱩᱲᱟᱹᱣ ᱠᱟᱹᱢᱤᱦᱚᱨᱟ ᱵᱚᱸᱫᱚᱭ ᱢᱮ, ᱥᱤᱝᱠ ᱥᱟᱶᱛᱮ ᱾
# Firefox Screenshots is the name of the feature, and should not be translated.
policy-DisableFirefoxScreenshots = Firefox ᱥᱠᱨᱤᱱᱥᱚᱴ ᱯᱷᱤᱪᱚᱨ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DisableFirefoxStudies = { -brand-short-name } ᱫᱚ ᱯᱟᱲᱦᱟᱣ ᱠᱚ ᱵᱚᱸᱫ ᱪᱷᱚᱭ ᱢᱮ ᱾
policy-DisableForgetButton = ᱦᱤᱲᱤᱧ ᱵᱩᱛᱟᱹᱢ ᱨᱮ ᱟᱫᱮᱨ ᱟᱠᱚᱴ ᱢᱮ ᱾
policy-DisableFormHistory = ᱥᱮᱸᱫᱽᱨᱟ ᱟᱨ ᱯᱷᱚᱨᱢ ᱦᱤᱛᱟᱹᱞ ᱩᱭᱦᱟᱹᱨ ᱟᱞᱚᱫᱚᱦᱚᱭᱟᱢ ᱾
policy-DisablePrimaryPasswordCreation = ᱡᱩᱫᱤ ᱥᱟᱹᱨᱤ ᱠᱷᱟᱱ, ᱢᱤᱫᱴᱟᱝ ᱢᱩᱞ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫᱽ ᱫᱚ ᱛᱮᱭᱟᱨ ᱵᱟᱭ ᱜᱟᱱᱚᱜᱼᱟ ᱾
policy-DisablePasswordReveal = ᱥᱟᱺᱪᱟᱣ ᱠᱟᱱ ᱵᱚᱞᱚ ᱦᱚᱨ ᱨᱮ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫ ᱠᱚ ᱟᱞᱚ ᱫᱮᱠᱷᱟᱣ ᱪᱷᱚᱭᱟ ᱾
policy-DisablePocket2 = { -pocket-brand-name } ᱨᱮ ᱣᱮᱵᱽᱥᱟᱦᱴᱟᱠᱚ ᱥᱟᱺᱪᱟᱣ ᱞᱟᱹᱜᱤᱫ ᱯᱷᱤᱪᱚᱨ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DisablePrivateBrowsing = ᱯᱨᱟᱭᱣᱮᱴ ᱵᱽᱨᱟᱣᱡᱤᱝ ᱵᱚᱱᱫ ᱠᱟᱜ ᱢᱮ ᱾
policy-DisableProfileImport = ᱮᱴᱟᱜ ᱵᱽᱨᱟᱣᱡᱚᱨ ᱠᱷᱚᱱ ᱰᱟᱴᱟ ᱟᱹᱜᱩ ᱞᱟᱹᱜᱤᱫ ᱛᱮ ᱢᱮᱱᱩ ᱠᱚᱢᱟᱱᱰ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DisableProfileRefresh = about:support ᱥᱟᱦᱴᱟ ᱨᱮ ᱱᱟᱶᱟ { -brand-short-name } ᱟᱹᱨᱩ ᱵᱩᱛᱟᱹᱢ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DisableSafeMode = ᱯᱷᱤᱪᱚᱨ ᱵᱚᱸᱫ ᱞᱟᱹᱜᱤᱫ ᱨᱩᱠᱷᱤᱭᱟᱹ ᱢᱳᱰ ᱨᱮ ᱫᱩᱦᱲᱟᱹ ᱮᱛᱦᱚᱵ ᱢᱮ ᱾ ᱵᱟᱲᱟᱭ ᱢᱮ : ᱨᱩᱠᱷᱤᱭᱟᱹ ᱢᱳᱰ ᱨᱮ ᱵᱮᱵᱷᱟᱨᱚᱜ Shift ᱪᱟᱹᱵᱤ ᱫᱚ ᱣᱤᱱᱰᱚ ᱨᱮ ᱫᱳᱞ ᱱᱤᱛᱤ ᱵᱮᱵᱷᱟᱨ ᱟᱛᱮᱫ ᱵᱚᱸᱫ ᱜᱟᱱᱚᱜᱼᱟ ᱾
policy-DisableSecurityBypass = ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱨᱩᱠᱷᱤᱭᱟᱹ ᱦᱩᱥᱤᱩᱭᱟᱹᱨ ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱟᱞᱚ ᱯᱚᱨᱚᱢ ᱠᱷᱚᱱ ᱟᱠᱚᱴ ᱢᱮ ᱾
policy-DisableSetAsDesktopBackground = ᱪᱤᱛᱟᱹᱨ ᱞᱟᱹᱜᱤᱫ ᱰᱮᱥᱠᱴᱚᱯ ᱵᱮᱠᱜᱽᱨᱟᱣᱱᱰ ᱞᱮᱠᱷᱟ ᱥᱮᱛ ᱢᱮᱱᱩ ᱟᱫᱮᱨ ᱫᱚ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DisableSystemAddonUpdate = ᱵᱽᱨᱟᱣᱡᱚᱨ ᱫᱚ ᱥᱤᱥᱴᱚᱢ ᱮᱰ-ᱚᱱᱥ ᱵᱚᱦᱟᱞ ᱟᱨ ᱦᱟᱹᱞᱤᱭᱟᱠ ᱞᱟᱹᱜᱤᱫ ᱟᱠᱚᱴᱮᱢ ᱾
policy-DisableTelemetry = ᱴᱮᱞᱤᱢᱮᱴᱨᱤ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DisableThirdPartyModuleBlocking = ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱫᱚ ᱛᱮᱥᱟᱨᱼᱯᱟᱴᱤ ᱢᱳᱰᱭᱩᱞ ᱠᱚ ᱟᱠᱚᱴᱮᱢ ᱡᱟᱦᱟᱸ ᱫᱚ { -brand-short-name } ᱞᱟᱦᱟᱱᱛᱤ ᱨᱮ ᱵᱚᱞᱚᱱ ᱟ ᱾
policy-DisplayBookmarksToolbar = ᱢᱩᱞ ᱞᱮᱠᱷᱟᱛᱮ ᱵᱩᱠᱢᱟᱨᱠ ᱦᱟᱹᱛᱤᱭᱟᱨ ᱵᱟᱨ ᱫᱮᱠᱷᱟᱣ ᱢᱮ ᱾
policy-DisplayMenuBar = ᱢᱩᱞ ᱞᱮᱠᱷᱟᱛᱮ ᱢᱮᱱᱩᱵᱟᱨ ᱫᱮᱠᱷᱟᱣ ᱢᱮ ᱾
policy-DNSOverHTTPS = HTTPS ᱪᱮᱛᱟᱱ ᱨᱮ DNS ᱥᱮᱴ ᱢᱮ ᱾
policy-DontCheckDefaultBrowser = ᱮᱛᱦᱚᱵ ᱨᱮ ᱢᱩᱞ ᱵᱽᱨᱟᱣᱡᱚᱨ ᱪᱤᱱᱦᱟᱹ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-DownloadDirectory = ᱰᱟᱣᱱᱞᱚᱰ ᱡᱟᱭᱜᱟ ᱫᱚ ᱥᱮᱴ ᱟᱨ ᱠᱩᱞᱩᱯ ᱠᱟᱜ ᱢᱮ ᱾
# “lock” means that the user won’t be able to change this setting
policy-EnableTrackingProtection = ᱡᱤᱱᱤᱥ ᱵᱞᱚᱠᱤᱝ ᱫᱚ ᱮᱢ ᱥᱮ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱟᱨ ᱢᱚᱱᱮ ᱛᱮ ᱠᱩᱞᱩᱯ ᱢᱮ ᱾
# “lock” means that the user won’t be able to change this setting
policy-EncryptedMediaExtensions = ᱮᱱᱠᱨᱤᱯᱴᱮᱰ ᱢᱤᱰᱤᱭᱟ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱫᱚ ᱮᱢ ᱥᱮ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱟᱨ ᱢᱚᱱᱮ ᱛᱮ ᱠᱩᱞᱩᱯ ᱢᱮ ᱾
policy-ExemptDomainFileTypePairsFromFileTypeDownloadWarnings = ᱰᱚᱢᱮᱱ ᱨᱮ ᱜᱚᱴᱟᱵᱩᱴᱟᱹ ᱯᱷᱟᱭᱤᱞ ᱞᱮᱠᱟᱱ ᱞᱟᱹᱜᱤᱫ ᱯᱷᱟᱭᱤᱞ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱪᱮᱛᱟᱱ ᱴᱮᱦᱟᱴ ᱠᱟᱛᱮ ᱥᱟᱨᱵᱷᱟᱨ ᱫᱚ ᱵᱮᱼᱥᱮᱵᱽ ᱢᱮ ᱾
# A “locked” extension can’t be disabled or removed by the user. This policy
# takes 3 keys (“Install”, ”Uninstall”, ”Locked”), you can either keep them in
# English or translate them as verbs.
policy-Extensions = ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱠᱚ ᱵᱚᱦᱟᱞ, ᱚᱪᱚᱜ ᱥᱮ ᱠᱩᱞᱩᱯ ᱠᱟᱜ ᱢᱮ ᱾ ᱵᱚᱦᱟᱞ ᱚᱯᱥᱮᱱ ᱫᱚ URLs ᱥᱮ ᱦᱚᱨ ᱯᱟᱨᱟᱢᱤᱴᱚᱨ ᱞᱮᱠᱷᱟ ᱤᱫᱤᱭᱟᱭ ᱾ ᱚᱪᱚᱜᱽ ᱟᱨ ᱠᱩᱞᱩᱯ ᱚᱯᱥᱚᱱ ᱫᱚ ᱮᱠᱥᱴᱮᱱᱥᱚᱱ IDs ᱤᱫᱤᱭᱟᱭ ᱾
policy-ExtensionSettings = ᱮᱠᱥᱴᱮᱱᱥᱚᱱ ᱵᱚᱦᱚᱞᱟᱜ ᱡᱷᱚᱛᱚ ᱫᱚᱥᱟᱹ ᱛᱮ ᱢᱮᱱᱮᱡᱽ ᱢᱮ ᱾
policy-ExtensionUpdate = ᱟᱡᱛᱮ ᱮᱯᱞᱤᱠᱮᱥᱚᱱ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱮᱢ ᱟᱨᱵᱟᱝ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-FirefoxHome2 = { -firefox-home-brand-name } ᱥᱟᱹᱛ ᱢᱮ ᱾
policy-GoToIntranetSiteForSingleWordEntryInAddressBar = ᱢᱤᱫᱴᱟᱝ ᱟᱹᱲᱟᱹ ᱴᱷᱤᱠᱬᱟᱹ ᱵᱟᱨ ᱨᱮ ᱟᱫᱮᱨ ᱡᱷᱚᱜ ᱥᱮᱸᱫᱽᱨᱟ ᱵᱟᱝ ᱠᱟᱛᱮ ᱰᱟᱭᱨᱮᱠᱴ ᱤᱱᱴᱨᱟᱱᱮᱴ ᱥᱟᱭᱤᱴ ᱪᱮᱛᱟᱱ ᱨᱮ ᱡᱩᱨ ᱮᱢ ᱢᱮ ᱾
policy-Handlers = ᱢᱩᱞ ᱮᱯᱞᱤᱠᱮᱥᱚᱱ ᱦᱮᱱᱰᱞᱚᱨᱥ ᱠᱚ ᱥᱮᱴ ᱢᱮ ᱾
policy-HardwareAcceleration = ᱡᱩᱫᱤ ᱠᱷᱟᱹᱞᱤ ᱛᱟᱦᱮᱸᱱ ᱠᱷᱟᱱ, ᱦᱟᱰᱣᱮᱨ ᱮᱠᱥᱮᱞᱮᱨᱮᱥᱚᱱ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
# “lock” means that the user won’t be able to change this setting
policy-Homepage = ᱥᱮᱴ ᱢᱮ ᱟᱨ ᱢᱚᱱᱮ ᱛᱮ ᱚᱲᱟᱜᱥᱟᱦᱴᱟ ᱠᱩᱞᱩᱯ ᱢᱮ ᱾
policy-InstallAddonsPermission = ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱮᱰ-ᱚᱱᱠᱚ ᱵᱚᱦᱟᱞ ᱪᱷᱚᱣᱟ ᱠᱚᱢ ᱾
policy-LegacyProfiles = ᱢᱤᱫᱴᱟᱝ ᱯᱷᱤᱪᱚᱨ ᱡᱟᱦᱟᱸ ᱫᱚ ᱢᱤᱫᱴᱟᱝ ᱢᱚᱦᱚᱨ ᱡᱷᱚᱛᱚ ᱵᱚᱦᱟᱞ ᱡᱷᱚᱜ ᱡᱩᱨᱛᱮᱭᱟᱨᱟᱭ ᱵᱚᱸᱫ ᱠᱟᱜ ᱢᱮ ᱾

## Do not translate "SameSite", it's the name of a cookie attribute.

policy-LegacySameSiteCookieBehaviorEnabled = ᱢᱩᱞ ᱛᱮᱜᱮᱥᱤ SameSite ᱠᱩᱠᱤ ᱵᱚᱨᱛᱟᱵ ᱥᱟᱡᱟᱣ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱾
policy-LegacySameSiteCookieBehaviorEnabledForDomainList = ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱱᱤᱨᱫᱷᱟᱨᱤᱛ ᱥᱟᱭᱤᱴ ᱨᱮ ᱠᱩᱠᱤᱡᱽ ᱞᱟᱹᱜᱤᱫ ᱞᱮᱜᱮᱥᱤ SameSite ᱵᱚᱨᱛᱟᱵ ᱨᱩᱣᱟᱹᱲ ᱟᱹᱜᱩᱭᱢᱮ ᱾

##

policy-LocalFileLinks = ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱱᱤᱨᱫᱷᱟᱨᱤᱛ ᱥᱟᱭᱤᱴ ᱨᱮ ᱞᱚᱠᱚᱞ ᱨᱮᱫᱽᱠᱚᱨᱮ ᱞᱤᱝᱠ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱾
policy-ManagedBookmarks = ᱢᱤᱫᱴᱟᱝ ᱪᱟᱪᱞᱟᱣᱤᱭᱟᱹ ᱢᱮᱱᱮᱡᱽ ᱠᱟᱫ ᱵᱩᱠᱢᱟᱨᱠ ᱨᱮᱭᱟᱜ ᱞᱤᱥᱴᱤ ᱥᱮᱴ ᱢᱮ ᱡᱟᱦᱟᱸ ᱫᱚ ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱵᱟᱭ ᱵᱚᱫᱚᱞ ᱫᱟᱲᱮᱭᱟᱜᱼᱟᱭ ᱾
policy-ManualAppUpdateOnly = ᱠᱷᱟᱹᱞᱤ ᱛᱤᱛᱮᱭᱟᱜ ᱞᱮᱠᱷᱟ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱟᱨ ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱫᱚ ᱟᱞᱚᱢ ᱤᱛᱞᱟᱹ ᱟᱭᱟ ᱾
policy-PrimaryPassword = ᱢᱤᱫᱴᱟᱝ ᱢᱩᱞ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫᱽ ᱵᱮᱵᱷᱟᱨ ᱟᱛᱮᱫ ᱫᱚᱨᱠᱟᱨ ᱥᱮ ᱢᱟᱱᱟ ᱾
policy-NetworkPrediction = ᱱᱮᱴᱣᱟᱨᱠ ᱵᱷᱚᱵᱤᱥᱭᱚᱣᱟᱬᱤ ᱮᱢ ᱥᱮ ᱵᱚᱸᱫᱚᱭ ᱢᱮ (DNS ᱢᱟᱲᱟᱝ ᱠᱷᱚᱱ ᱟᱹᱛᱩᱨ) ᱾
policy-NewTabPage = ᱱᱟᱣᱟ ᱴᱮᱵᱽ ᱥᱟᱦᱴᱟ ᱮᱢ ᱢᱮ ᱟᱨᱵᱟᱝ ᱵᱚᱫᱚᱞ ᱢᱮ ᱾
policy-NoDefaultBookmarks = ᱢᱩᱞ ᱯᱩᱛᱷᱤᱪᱤᱱᱦᱟᱹ ᱵᱚᱱᱰᱚᱞ ᱛᱮᱭᱟᱨ { -brand-short-name } ᱥᱟᱞᱟᱜ ᱵᱚᱸᱫᱚᱭ ᱢᱮ, ᱟᱨ ᱥᱢᱟᱨᱴ ᱯᱩᱛᱷᱤᱪᱤᱱᱦᱟᱹ (ᱡᱟᱹᱥᱛᱤ ᱪᱟᱞᱟᱣ ᱠᱟᱱ, ᱱᱮᱛᱟᱨᱟᱜ ᱴᱮᱜᱽᱠᱚ) ᱾ ᱠᱷᱟᱴᱚ ᱚᱞ : ᱱᱚᱶᱟ ᱱᱤᱛᱤ ᱫᱚ ᱩᱱ ᱡᱷᱚᱜ ᱵᱮᱵᱷᱟᱨᱚᱜᱼᱟ ᱛᱤᱧ ᱡᱷᱚᱜ ᱢᱚᱦᱚᱨ ᱨᱮᱭᱟᱜ ᱯᱩᱭᱞᱩ ᱫᱷᱟᱣ ᱪᱟᱹᱞᱩ ᱠᱚᱜᱼᱟ ᱾
policy-OfferToSaveLogins = { -brand-short-name } ᱫᱚ ᱥᱟᱸᱪᱟᱣ ᱠᱟᱱ ᱵᱚᱞᱚ ᱟᱨ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫ ᱠᱚ ᱩᱭᱦᱟᱹᱨ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱡᱩᱨ ᱛᱮ ᱥᱟᱡᱟᱣ ᱨᱮ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱾ ᱵᱟᱨᱭᱟ ᱥᱟᱹᱨᱤ ᱟᱨ ᱠᱷᱟᱹᱞᱤ ᱢᱟᱱ ᱞᱟᱹᱠᱛᱤ ᱠᱟᱱᱟ ᱾
policy-OfferToSaveLoginsDefault = { -brand-short-name } ᱫᱚ ᱥᱟᱺᱪᱟᱣ ᱠᱟᱱ ᱵᱚᱞᱚ ᱟᱨ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫ ᱠᱚ ᱩᱭᱦᱟᱹᱨ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱢᱩᱞ ᱢᱟᱱ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱾ ᱵᱟᱨᱭᱟ ᱥᱟᱹᱨᱤ ᱟᱨ ᱠᱷᱟᱹᱞᱤ ᱢᱟᱱ ᱞᱟᱹᱠᱛᱤ ᱠᱟᱱᱟ ᱾
policy-OverrideFirstRunPage = ᱯᱩᱭᱞᱩ ᱥᱟᱦᱴᱟ ᱫᱟᱹᱲ ᱪᱷᱚ ᱚᱣᱚᱨᱨᱟᱭᱤᱰ ᱢᱮ ᱾ ᱯᱩᱭᱞᱩ ᱥᱟᱦᱴᱟ ᱵᱚᱸᱫᱪᱷᱚ ᱥᱟᱱᱟᱢ ᱠᱷᱟᱱ ᱱᱚᱶᱟ ᱱᱤᱛᱤ ᱥᱟᱯᱷᱟ ᱨᱮ ᱥᱮᱴ ᱠᱟᱜ ᱢᱮ ᱾
policy-OverridePostUpdatePage = “ᱪᱮᱫ ᱱᱟᱶᱟ ᱢᱮᱱᱟᱜᱼᱟ” ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱯᱚᱥᱴ ᱠᱟᱛᱮ ᱥᱟᱦᱴᱟ ᱫᱟᱹᱲ ᱪᱷᱚ ᱚᱣᱚᱨᱨᱟᱭᱤᱰ ᱢᱮ ᱾ ᱯᱚᱥᱴ ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱥᱟᱦᱴᱟ ᱵᱚᱸᱫᱪᱷᱚ ᱥᱟᱱᱟᱢ ᱠᱷᱟᱱ ᱱᱚᱶᱟ ᱱᱤᱛᱤ ᱥᱟᱯᱷᱟ ᱨᱮ ᱥᱮᱴ ᱠᱟᱜ ᱢᱮ ᱾
policy-PasswordManagerEnabled = ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫᱽ ᱢᱮᱱᱮᱡᱚᱨ ᱨᱮ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫᱽ ᱥᱟᱺᱪᱟᱣ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱾
policy-PasswordManagerExceptions = { -brand-short-name } ᱫᱚ ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱥᱟᱭᱤᱴ ᱠᱚ ᱞᱟᱹᱜᱤᱫ ᱫᱟᱱᱟᱝ ᱥᱟᱵᱟᱫᱽ ᱥᱟᱺᱪᱟᱣ ᱠᱷᱚᱱ ᱢᱟᱱᱟ ᱟᱭ ᱢᱮ ᱾
# PDF.js and PDF should not be translated
policy-PDFjs = PDF.js ᱵᱚᱸᱫᱚᱭ ᱥᱮ ᱥᱮᱴ ᱢᱮ, { -brand-short-name } ᱨᱮ PDF ᱫᱮᱠᱷᱟᱣᱤᱭᱟᱹ ᱛᱮᱭᱟᱨ ᱢᱮᱱᱟᱜᱼᱟ ᱾
policy-Permissions2 = ᱠᱮᱢᱮᱨᱟ, ᱢᱟᱭᱠᱨᱚᱯᱷᱚᱱ, ᱡᱟᱭᱜᱟ, ᱠᱷᱚᱵᱚᱨ ᱟᱨ ᱚᱴᱚᱯᱞᱮ ᱞᱟᱹᱜᱤᱫ ᱪᱷᱟᱰᱠᱚ ᱥᱮᱴ ᱢᱮ ᱾
policy-PictureInPicture = ᱪᱤᱛᱟᱹᱨᱼᱨᱮᱼᱪᱤᱛᱟᱹᱨ ᱮᱢ ᱥᱮ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
policy-PopupBlocking = ᱢᱩᱞ ᱞᱮᱠᱟᱛᱮ ᱴᱟᱴᱠᱟ ᱚᱰᱚᱠ ᱫᱮᱠᱷᱟᱣ ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱣᱮᱵᱽᱥᱟᱭᱤᱴᱠᱚ ᱞᱟᱹᱜᱤᱫ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ ᱾
policy-Preferences = ᱠᱩᱥᱤᱭᱟᱜ ᱢᱤᱫ ᱥᱚᱵᱥᱮᱴ ᱥᱟᱹᱜᱤᱫ ᱮᱞ ᱥᱮᱴ ᱥᱮ ᱠᱩᱞᱩᱯ ᱠᱟᱜ ᱢᱮ ᱾
policy-PromptForDownloadLocation = ᱰᱟᱣᱱᱞᱚᱰ ᱡᱷᱚᱜ ᱚᱠᱟᱨᱮ ᱨᱮᱫᱽ ᱥᱟᱺᱪᱟᱣᱜᱼᱟ ᱠᱩᱠᱞᱤ ᱢᱮ ᱾
policy-Proxy = ᱯᱨᱚᱠᱥᱤ ᱥᱟᱡᱟᱣᱠᱚ ᱥᱮᱴ ᱢᱮ ᱾
policy-RequestedLocales = ᱠᱩᱥᱤᱭᱟᱜ ᱦᱤᱥᱟᱹᱵᱛᱮ ᱮᱯᱞᱤᱠᱮᱥᱚᱱ ᱞᱟᱹᱜᱤᱫ ᱱᱮᱦᱚᱨ ᱠᱟᱱ ᱯᱟᱹᱨᱥᱤ ᱨᱮᱭᱟᱜ ᱞᱤᱥᱴᱤ ᱥᱮᱴ ᱢᱮ ᱾
policy-SanitizeOnShutdown2 = ᱥᱚᱴᱰᱟᱣᱱ ᱡᱷᱚᱜ ᱯᱟᱱᱛᱮ ᱚᱲᱟᱜ ᱢᱮᱴᱟᱣ ᱢᱮ ᱾
policy-SearchBar = ᱥᱮᱸᱫᱽᱨᱟᱵᱚᱨ ᱨᱮᱭᱟᱜ ᱢᱩᱞ ᱡᱟᱭᱜᱟ ᱥᱮᱴ ᱢᱮ ᱾ ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱫᱚ ᱢᱤᱛ ᱦᱚᱸ ᱢᱚᱱᱮ ᱛᱮ ᱵᱚᱫᱚᱞ ᱫᱟᱲᱮᱭᱟᱜᱼᱟᱭ ᱾
policy-SearchEngines = ᱥᱮᱸᱫᱽᱨᱟᱭ ᱤᱧᱡᱤᱱ ᱥᱟᱡᱟᱣᱠᱚ ᱥᱮᱴ ᱢᱮ ᱾ ᱱᱚᱶᱟ ᱱᱤᱛᱤ ᱫᱚ ᱠᱷᱟᱹᱞᱤ ᱮᱠᱥᱴᱮᱱᱰᱮᱰ ᱥᱚᱯᱚᱴ ᱨᱤᱞᱤᱡᱽ (ESR) ᱵᱷᱚᱨᱥᱚᱱ ᱨᱮ ᱢᱮᱱᱟᱜ ᱠᱟᱫᱟ ᱾
policy-SearchSuggestEnabled = ᱥᱮᱸᱫᱽᱨᱟ ᱵᱟᱛᱟᱣ ᱫᱚ ᱮᱢ ᱥᱮ ᱵᱚᱸᱫᱚᱭ ᱢᱮ ᱾
# For more information, see https://wikipedia.org/wiki/PKCS_11
policy-SecurityDevices2 = PKCS #11 ᱢᱳᱰᱭᱩᱞᱥᱠᱚ ᱥᱮᱞᱮᱫ ᱥᱮ ᱢᱮᱴᱟᱣ ᱢᱮ ᱾
policy-ShowHomeButton = ᱦᱟᱹᱛᱤᱭᱟᱨ ᱵᱟᱨ ᱨᱮ ᱚᱲᱟᱜ ᱵᱩᱛᱟᱹᱢ ᱫᱮᱠᱷᱟᱣ ᱢᱮ ᱾
policy-SSLVersionMax = ᱡᱷᱚᱛᱚ ᱠᱷᱚᱱ ᱰᱷᱮᱨ SSL ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱥᱮᱴ ᱢᱮ ᱾
policy-SSLVersionMin = ᱡᱷᱚᱛᱚ ᱠᱷᱚᱱ ᱠᱚᱢ SSL ᱦᱟᱹᱞᱤᱭᱟᱹᱠ ᱥᱮᱴ ᱢᱮ ᱾
policy-StartDownloadsInTempDirectory = ᱢᱤᱫᱴᱟᱝ ᱞᱚᱠᱟᱞ, ᱚᱥᱛᱷᱟᱭ ᱡᱟᱭᱜᱟ ᱨᱮ ᱮᱛᱦᱚᱵ ᱞᱟᱹᱜᱤᱫ ᱰᱟᱣᱱᱞᱚᱰᱠᱚᱨᱮ ᱡᱩᱨ ᱮᱢ ᱢᱮ, ᱢᱩᱞ ᱰᱟᱣᱱᱞᱚᱰ ᱡᱟᱭᱜᱟ ᱨᱮ ᱵᱟᱝ ᱠᱟᱛᱮ ᱾
policy-SupportMenu = ᱜᱚᱲᱚ ᱢᱮᱱᱩ ᱛᱮ ᱠᱚᱥᱴᱚᱢ ᱥᱚᱦᱚᱫ ᱢᱮᱱᱩ ᱡᱤᱱᱤᱥ ᱥᱮᱞᱮᱫ ᱢᱮ ᱾
policy-UserMessaging = ᱛᱤᱞᱟᱹᱜ ᱜᱟᱱ ᱠᱷᱚᱵᱚᱨ ᱫᱚ ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱟᱞᱚᱢ ᱫᱮᱠᱷᱟᱣ ᱟᱭᱟ ᱾
policy-UseSystemPrintDialog = ᱥᱤᱥᱴᱚᱢ ᱪᱷᱟᱯᱟ ᱰᱷᱟᱶᱨᱟ ᱵᱮᱵᱷᱟᱨ ᱠᱟᱛᱮ ᱪᱷᱟᱯᱟᱭ ᱢᱮ
# “format” refers to the format used for the value of this policy.
policy-WebsiteFilter = ᱪᱟᱞᱟᱣ ᱠᱷᱚᱱ ᱢᱟᱱᱟ ᱨᱮᱭᱟᱜ ᱣᱮᱵᱽᱥᱟᱭᱤᱴ ᱟᱠᱚᱴ ᱪᱷᱚᱭ ᱢᱮ ᱾ ᱯᱷᱚᱨᱢᱟᱴ ᱨᱮ ᱰᱷᱮᱨ ᱵᱟᱲᱟᱭ ᱞᱟᱹᱜᱤᱫ ᱫᱚᱞᱤᱞᱤᱭᱟᱹ ᱧᱮᱞ ᱢᱮ ᱾
policy-Windows10SSO = Microsoft, ᱠᱟᱹᱢᱤ ᱟᱨ ᱟᱥᱲᱟ ᱮᱠᱟᱣᱩᱱᱴ ᱞᱟᱹᱜᱤᱫ Windows ᱢᱤᱫ ᱡᱮᱠᱷᱟ ᱥᱩᱦᱤ ᱮᱢ ᱞᱟᱹᱜᱤᱫ ᱦᱮᱸᱥᱮᱨᱤᱭᱟᱹᱭ ᱢᱮ ᱾
