# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Generative AI (GenAI) Settings section

genai-settings-chat-description = Voegt de chatbot van uw keuze toe aan de zijbalk, voor snelle toegang terwijl u surft. <a data-l10n-name="connect">Feedback delen</a>
genai-settings-chat-choose = Kies een chatbot
genai-settings-chat-choose-one-menuitem =
    .label = Kies er een
genai-settings-chat-links = Wanneer u een chatbot kiest, gaat u akkoord met de gebruiksvoorwaarden en het privacybeleid van de provider.
genai-settings-chat-chatgpt-links = Door ChatGPT te kiezen, gaat u akkoord met de <a data-l10n-name="link1">Gebruiksvoorwaarden</a> en het <a data-l10n-name="link2">Privacybeleid</a> van OpenAI.
genai-settings-chat-claude-links = Door Anthropic Claude te kiezen, gaat u akkoord met de <a data-l10n-name="link1">Servicevoorwaarden voor consumenten</a>, het <a data-l10n-name="link2">gebruiksbeleid</a> en het <a data-l10n-name="link3">Privacybeleid</a> van Anthropic.
genai-settings-chat-copilot-links = Door Copilot te kiezen, gaat u akkoord met de <a data-l10n-name="link1">Voorwaarden van Copilot AI Experiences</a> en de <a data-l10n-name="link2">Privacyverklaring van Microsoft</a>.
genai-settings-chat-gemini-links = Door Google Gemini te kiezen, gaat u akkoord met de <a data-l10n-name="link1">Servicevoorwaarden van Google</a>, het <a data-l10n-name="link2">beleid voor verboden gebruik van generatieve AI</a > en de <a data-l10n-name="link3">Privacyverklaring van Gemini Apps</a>.
genai-settings-chat-huggingchat-links = Door HuggingChat te kiezen, gaat u akkoord met de <a data-l10n-name="link1">Privacyverklaring van HuggingChat</a> en het <a data-l10n-name="link2">Privacybeleid van Hugging Face</a>.
genai-settings-chat-lechat-links = Door Le Chat Mistral te kiezen, gaat u akkoord met de <a data-l10n-name="link1">Servicevoorwaarden</a> en het <a data-l10n-name="link2">Privacybeleid</a> van Mistral AI.
genai-settings-chat-localhost-links = Breng uw eigen privé lokale chatbot mee, zoals <a data-l10n-name="link1">llamafile</a> van de Innovation-groep van { -vendor-short-name }.
genai-settings-chat-shortcuts =
    .description = Toont een snelkoppeling naar prompts wanneer u tekst selecteert. { -brand-short-name } verzendt de tekst, paginatitel en prompt naar de chatbot.
    .label = Toont prompts bij tekstselectie

## Chatbot prompts
## Prompts are plain language ‘instructions’ sent to a chatbot.
## These prompts have been made concise and direct in English because some chatbot providers
## have character restrictions and being direct reduces the chance for misinterpretation.
## When localizing, please be concise and direct, but not at the expense of losing meaning.

# Prompt purpose: help users understand what a selection covers at a glance
genai-prompts-summarize =
    .label = Samenvatten
    .value = Vat de selectie samen in exacte en beschrijvende woorden. Gebruik kopteksten en opsommingslijsten in de samenvatting, om deze scanbaar te maken. Behoud de betekenis en feitelijke juistheid.
# Prompt purpose: make a selection easier to read
genai-prompts-simplify =
    .label = Taal vereenvoudigen
    .value = Herschrijf de selectie in korte zinnen en eenvoudige woorden. Behoud de betekenis en feitelijke juistheid.
# Prompt purpose: test understanding of selection in an interactive way
genai-prompts-quiz =
    .label = Mij testen
    .value = Test mij over deze selectie. Stel me een uiteenlopende soort vragen, bijvoorbeeld meerkeuze, waar of niet waar en kort antwoord. Wacht op mijn antwoord voordat wordt doorgegaan naar de volgende vraag.
# Prompt purpose: helps users understand words, phrases, concepts
genai-prompts-explain =
    .label = Dit uitleggen
    .value = Leg de belangrijkste concepten in deze selectie uit in eenvoudige woorden. Gebruik ook voorbeelden.
# This prompt is added to the beginning of selection prompts sent to a chatbot.
# $tabTitle (string) - title of the webpage
# $selection (string) - selected text
genai-prompt-prefix-selection = Ik ben op pagina ‘{ $tabTitle }’ met ‘{ $selection }’ geselecteerd.

## Chatbot menu shortcuts

genai-menu-ask-generic =
    .label = AI-chatbot vragen
# $provider (string) - name of the provider
genai-menu-ask-provider =
    .label = { $provider } vragen
genai-input-ask-generic =
    .placeholder = AI-chatbot vragen…
# $provider (string) - name of the provider
genai-input-ask-provider =
    .placeholder = { $provider } vragen…
