# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

# Variables:
# $hostname (String) - Hostname of the website with SSL error.
# $errorMessage (String) - Error message corresponding to the type of error we are experiencing.
ssl-connection-error = Produciuse un erro durante unha conexión con { $hostname }. { $errorMessage }
# Variables:
# $error (string) - NSS error code string that specifies type of cert error. e.g. unknown issuer, invalid cert, etc.
cert-error-code-prefix = Código de erro: { $error }
psmerr-ssl-disabled = Non é posíbel conectarse de modo seguro porque se desactivou o protocolo SSL.
psmerr-ssl2-disabled = Non é posíbel conectarse de modo seguro porque o sitio utiliza unha versión máis antiga e insegura do protocolo SSL.
# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    Recibiu un certificado non válido. Contacte co administrador do servidor ou co correo electrónico correspondente e fornézalles a seguinte información:
    
    O seu certificado contén o mesmo número de serie que o outro certificado emitido pola autoridade certificadora. Obteña un certificado que conteña un único número de serie.
ssl-error-export-only-server = Non foi posíbel comunicar de modo seguro. O elemento do mesmo nivel non é compatíbel cunha codificación de grao alto.
ssl-error-us-only-server = Non foi posíbel comunicar de modo seguro. O elemento do mesmo nivel require unha codificación de grao alto que non é compatíbel.
ssl-error-no-cypher-overlap = Non é posíbel comunicar de modo seguro cun elemento do mesmo nivel: Non hai algoritmos de codificación común.
ssl-error-no-certificate = Non foi posíbel localizar o certificado ou chave necesaria para a autenticación.
ssl-error-bad-certificate = Non foi posíbel comunicar de modo seguro cun elemento do mesmo nivel: O certificado do elemento do mesmo nivel foi rexeitado.
ssl-error-bad-client = O servidor atopou datos incorrectos do cliente.
ssl-error-bad-server = O cliente atopou datos incorrectos do servidor.
ssl-error-unsupported-certificate-type = Tipo de certificado non compatíbel.
ssl-error-unsupported-version = Elemento do mesmo nivel usando unha versión de protocolo de seguranza incompatíbel.
ssl-error-wrong-certificate = Erro na autenticación do cliente: A chave privada da base de datos de chaves non coincide coa chave pública da base de datos de certificados.
ssl-error-bad-cert-domain = Non foi posíbel comunicar de modo seguro cun elemento do mesmo nivel: O nome do dominio requirido non coincide co certificado do servidor.
ssl-error-post-warning = Código do erro SSL non recoñecido.
ssl-error-ssl2-disabled = O elemento do mesmo nivel só é compatíbel coa versión 2 de SSL, que está localmente desactivada.
ssl-error-bad-mac-read = SSL recibiu un rexistro cun código de autenticación da mensaxe incorrecto.
ssl-error-bad-mac-alert = O elemento do mesmo nivel de SSL informa dun código incorrecto de autenticación da mensaxe.
ssl-error-bad-cert-alert = O elemento do mesmo nivel de SSL non pode verificar o seu certificado.
ssl-error-revoked-cert-alert = O elemento do mesmo nivel de SSL rexeitou o seu certificado como revogado.
ssl-error-expired-cert-alert = O elemento do mesmo nivel  de SSL rexeitou o seu certificado como caducado.
ssl-error-ssl-disabled = Non é posíbel conectar: SSL está desactivado.
ssl-error-fortezza-pqg = Non é posíbel conectar: O elemento do mesmo nivel de SSL está noutro dominio de FORTEZZA.
ssl-error-unknown-cipher-suite = Solicitouse un paquete de codificación de SSL descoñecido.
ssl-error-no-ciphers-supported = Non hai paquetes de codificación que estean presentes e activados neste programa.
ssl-error-bad-block-padding = SSL recibiu un rexistro cun enchemento de bloque incorrecto.
ssl-error-rx-record-too-long = SSL recibiu un rexistro que execedía a lonxitude máxima permitida.
ssl-error-tx-record-too-long = SSL tentou enviar un rexistro que exedía a lonxitude máxima permitida.
ssl-error-rx-malformed-hello-request = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación.
ssl-error-rx-malformed-client-hello = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación co cliente.
ssl-error-rx-malformed-server-hello = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación co servidor.
ssl-error-rx-malformed-certificate = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación co certificado.
ssl-error-rx-malformed-server-key-exch = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación co intercambio de chave do servidor.
ssl-error-rx-malformed-cert-request = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación coa solicitude de certificado.
ssl-error-rx-malformed-hello-done = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación realizado co servidor.
ssl-error-rx-malformed-cert-verify = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación coa verificación do certificado.
ssl-error-rx-malformed-client-key-exch = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación co intercambio de chave de cliente.
ssl-error-rx-malformed-finished = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación concluído.
ssl-error-rx-malformed-change-cipher = SSL recibiu un rexistro incorrecto de Change Cipher Spec.
ssl-error-rx-malformed-alert = SSL recibiu un rexistro incorrecto de alerta.
ssl-error-rx-malformed-handshake = SSL recibiu un rexistro incorrecto de estabelecemento de comunicación.
ssl-error-rx-malformed-application-data = SSL recibiu un rexistro incorrecto de datos do aplicativo.
ssl-error-rx-unexpected-hello-request = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación.
ssl-error-rx-unexpected-client-hello = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación co cliente.
ssl-error-rx-unexpected-server-hello = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación co servidor.
ssl-error-rx-unexpected-certificate = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación co certificado.
ssl-error-rx-unexpected-server-key-exch = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación co intercambio de chave do servidor.
ssl-error-rx-unexpected-cert-request = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación coa solicitude de certificado.
ssl-error-rx-unexpected-hello-done = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación co servidor.
ssl-error-rx-unexpected-cert-verify = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación coa verificación do certificado.
ssl-error-rx-unexpected-client-key-exch = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación co intercambio de chave do cliente.
ssl-error-rx-unexpected-finished = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación finalizado.
ssl-error-rx-unexpected-change-cipher = SSL recibiu un rexistro inesperado de Change Cipher Spec.
ssl-error-rx-unexpected-alert = SSL recibiu un rexistro inesperado de alerta.
ssl-error-rx-unexpected-handshake = SSL recibiu un rexistro inesperado de estabelecemento de comunicación.
ssl-error-rx-unexpected-application-data = SSL recibiu un rexistro inesperado de datos do aplicativo.
ssl-error-rx-unknown-record-type = SSL recibiu un rexistro cun tipo de contido descoñecido.
ssl-error-rx-unknown-handshake = SSL recibiu unha mensaxe de estabelecemento de comunicación cun tipo de mensaxe descoñecido.
ssl-error-rx-unknown-alert = SSL recibiu un rexistro de alerta cunha descrición de alerta descoñecida.
ssl-error-close-notify-alert = O elemento do mesmo nivel de SSL pechou esta conexión.
ssl-error-handshake-unexpected-alert = O elemento do mesmo nivel de SSL non estaba á espera de recibir unha mensaxe de estabelecemento de comunicación.
ssl-error-decompression-failure-alert = O elemento do mesmo nivel de SSL non conseguiu descomprimir correctamente o rexistro  SSL recibido.
ssl-error-handshake-failure-alert = O elemento do mesmo nivel de SSL non conseguiu negociar un conxunto de parámetros de seguranza aceptábel.
ssl-error-illegal-parameter-alert = O elemento do mesmo nivel de SSL rexeitou unha mensaxe de  estabelecemento de comunicación co contido inaceptábel.
ssl-error-unsupported-cert-alert = O elemento do mesmo nivel de SSL non é compatíbel cos certificados do tipo recibido.
ssl-error-certificate-unknown-alert = O elemento do mesmo nivel de SSL tiña algún problema inespecífico co certificado recibido.
ssl-error-generate-random-failure = SSL experimentou un erro do seu xerador numérico aleatorio
ssl-error-sign-hashes-failure = Non foi posíbel asinar dixitalmente os datos requiridos para verificar o seu certificado.
ssl-error-extract-public-key-failure = SSL non conseguiu extraer a chave pública do certificado do elemento do mesmo nivel.
ssl-error-server-key-exchange-failure = Erro non especificado ao procesar o estabelecemento de comunicación do intercambio de chave do servidor de SSL.
ssl-error-client-key-exchange-failure = Erro non especificado ao procesar a mensaxe de estabelecemento de comunicación do intercambio de chave de cliente de SSL.
ssl-error-encryption-failure = Erro do algoritmo de codificación masiva de datos no paquete de codificación seleccionado.
ssl-error-decryption-failure = Erro do algoritmo de codificación masiva de datos no paquete de codificación seleccionado.
ssl-error-socket-write-failure = Erro na tentativa de escribir datos codificados para o socket subxacente.
ssl-error-md5-digest-failure = Erro da función de resumo de MD5.
ssl-error-sha-digest-failure = Erro da función de resumo de SHA-1.
ssl-error-mac-computation-failure = Erro de cálculo de MAC.
ssl-error-sym-key-context-failure = Erro ao crear o contexto de chave simétrica.
ssl-error-sym-key-unwrap-failure = Erro ao abrir a chave simétrica na mensaxe de intercambio de chave do cliente.
ssl-error-pub-key-size-limit-exceeded = Tentativa do servidor de SSL para utilizar a chave pública de grao doméstico co paquete de codificación de exportación.
ssl-error-iv-param-failure = Erro do código PKCS11 para traducir IV nun parámetro.
ssl-error-init-cipher-suite-failure = Erro ao iniciar o paquete de codificación seleccionado.
ssl-error-session-key-gen-failure = Erro do cliente ao xerar chaves de sesión da sesión SSL.
ssl-error-no-server-key-for-alg = O servidor non ten chave para o algoritmo de intercambio de chave tentado.
ssl-error-token-insertion-removal = A chave electrónica PKCS#11 inseriuse ou eliminouse mentres a operación estaba en proceso.
ssl-error-token-slot-not-found = Non foi posíbel atopar ningunha chave electrónica PKCS#11 para realizar a operación requirida.
ssl-error-no-compression-overlap = Non é posíbel comunicar de modo seguro co elemento do mesmo nivel: Non hai algoritmos de compresión comúns.
ssl-error-handshake-not-completed = Non é posíbel iniciar outro estabelecemento de comunicación de SSL ata que remate o estabelecemento de comunicación actual.
ssl-error-bad-handshake-hash-value = Recibíronse valores hash de estabelecemento de comunicación incorrectos a partir do elemento do mesmo nivel.
ssl-error-cert-kea-mismatch = Non é posíbel utilizar o certificado fornecido co algoritmo de intercambio de chave seleccionado.
ssl-error-no-trusted-ssl-client-ca = Non hai ningunha entidade de acreditación de confianza para a autenticación de cliente de SSL.
ssl-error-session-not-found = Non se atopou o ID da sesión SSL de cliente na caché da sesión do servidor.
ssl-error-decryption-failed-alert = O elemento do mesmo nivel non conseguiu descifrar un rexistro de SSL recibido.
ssl-error-record-overflow-alert = O elemento do mesmo nivel recibiu un rexistro de SSL que era máis longo do permitido.
ssl-error-unknown-ca-alert = O elemento do mesmo nivel non recoñece nin confía na AC que emitiu o seu certificado.
ssl-error-access-denied-alert = O elemento do mesmo nivel recibiu un certificado válido, mais negouse o acceso.
ssl-error-decode-error-alert = O elemento do mesmo nivel non conseguiu descodificar unha mensaxe de estabelecemento de comunicación de SSL.
ssl-error-decrypt-error-alert = O elemento do mesmo nivel informa dun erro de verificación de sinatura ou de intercambio de chave.
ssl-error-export-restriction-alert = O elemento do mesmo nivel informa dunha negociación en disconformidade coas regulacións de exportación.
ssl-error-protocol-version-alert = O elemento do mesmo nivel informa dunha versión de protocolo non admitida ou incompatíbel.
ssl-error-insufficient-security-alert = O servidor require códigos máis seguros que aqueles compatíbeis co cliente.
ssl-error-internal-error-alert = O elemento do mesmo nivel informa de que isto experimentou un erro interno.
ssl-error-user-canceled-alert = O usuario do elemento do mesmo nivel cancelou o estabelemento de comunicación.
ssl-error-no-renegotiation-alert = O elemento do mesmo nivel non permite a renegociación dos parámetros de seguranza de SSL.
ssl-error-server-cache-not-configured = Caché do servidor SSL non configurada nin desactivada para este socket.
ssl-error-unsupported-extension-alert = O elemento do mesmo nivel de SSL non é compatíbel coa extensión de saúdo TLS requirida.
ssl-error-certificate-unobtainable-alert = O elemento do mesmo nivel de SSL non conseguiu obter o seu certificado a partir do URL fornecido.
ssl-error-unrecognized-name-alert = O elemento do mesmo nivel de SSL non ten certificado para o nome DNS requirido.
ssl-error-bad-cert-status-response-alert = O elemento do mesmo nivel de SSL non conseguiu obter unha resposta  OCSP para os seus certificados.
ssl-error-bad-cert-hash-value-alert = O elemento do mesmo nivel de SSL informou dun valor hash de certificado incorrecto.
ssl-error-rx-unexpected-new-session-ticket = SSL recibiu unha mensaxe inesperada de negociación de novo ticket de sesión.
ssl-error-rx-malformed-new-session-ticket = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación de novo ticket de sesión.
ssl-error-decompression-failure = SSL recibiu un rexistro comprimido que non foi posíbel descomprimir.
ssl-error-renegotiation-not-allowed = Non se permite a renegociación neste sócket SSL.
ssl-error-unsafe-negotiation = O elemento do mesmo nivel intentou un estabelecemento de comunicación ao estilo antigo (potencialmente vulnerábel).
ssl-error-rx-unexpected-uncompressed-record = SSL recibiu un rexistro inesperado sen comprimir.
ssl-error-weak-server-ephemeral-dh-key = SSL recibiu unha chave Diffie-Hellman efémera débil na mensaxe de estabelecemento de comunicación co intercambio de chave do servidor.
ssl-error-next-protocol-data-invalid = SSL recibiu datos da extensión NPN incorrectos.
ssl-error-feature-not-supported-for-ssl2 = Non se admite a característica SSL nas conexións SSL 2.0.
ssl-error-feature-not-supported-for-servers = Non se admite a característica SSL nos servidores.
ssl-error-feature-not-supported-for-clients = Non se admite a característica SSL nos clientes.
ssl-error-invalid-version-range = O intervalo de versións SSL é incorrecto.
ssl-error-cipher-disallowed-for-version = O par SSL seleccionou un paquete de cifrado non permitido na versión do protocolo escollida.
ssl-error-rx-malformed-hello-verify-request = SSL recibiu unha mensaxe incorrecta de estabelecemento de comunicación de tipo «Hello Verify Request»
ssl-error-rx-unexpected-hello-verify-request = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación de tipo «Hello Verify Request»
ssl-error-feature-not-supported-for-version = Non se admite a característica SSL nesta versión do protocolo.
ssl-error-rx-unexpected-cert-status = SSL recibiu unha mensaxe inesperada de estabelecemento de comunicación de tipo «Certificate Status»
ssl-error-unsupported-hash-algorithm = Non se admite o algoritmo hash usado polo para TLS.
ssl-error-digest-failure = Erro da función de resumo.
ssl-error-incorrect-signature-algorithm = Algoritmo de sinatura incorrecto especificado nun elemento asinado dixitalmente.
ssl-error-next-protocol-no-callback = Activouse a extensión «next protocol negotiation», pero a chamada de retorno borrouse antes de que se usara.
ssl-error-next-protocol-no-protocol = O servidor non admite ningún dos protocolos anunciados polo cliente na extensión ALPN.
ssl-error-inappropriate-fallback-alert = O servidor rexeitou o estabelecemento de comunicación porque o cliente agora usa a versión TLS máis baixa que admite o servidor.
ssl-error-weak-server-cert-key = O certificado de servidor incluía unha chave pública que era demasiado débil.
ssl-error-rx-short-dtls-read = Non hai suficiente espazo no búfer para o rexistro DTLS.
ssl-error-no-supported-signature-algorithm = Configurouse un algoritmo de sinatura TLS non compatíbel.
ssl-error-unsupported-signature-algorithm = O par usou unha combinación non admitida de sinatura e algoritmo hash.
ssl-error-missing-extended-master-secret = O par tentou continuar sen unha extensión extended_master_secret correcta.
ssl-error-unexpected-extended-master-secret = O par tentou continuar cunha extensión extended_master_secret inesperada.
sec-error-io = Produciuse un erro E/S durante a autorización de seguranza.
sec-error-library-failure = erro da biblioteca de seguranza.
sec-error-bad-data = biblioteca de seguranza: recibíronse datos incorrectos.
sec-error-output-len = biblioteca de seguranza: erro de lonxitude de saída.
sec-error-input-len = a biblioteca de seguranza experimentou un erro de lonxitude de entrada.
sec-error-invalid-args = biblioteca de seguranza: argumentos non válidos.
sec-error-invalid-algorithm = biblioteca de seguranza: algoritmo non válido.
sec-error-invalid-ava = biblioteca de seguranza: AVA non válido.
sec-error-invalid-time = Cadea de tempo formatada incorrectamente.
sec-error-bad-der = biblioteca de seguranza: mensaxe DER codificada formatada incorrectamente.
sec-error-bad-signature = O certificado do elemento do mesmo nivel ten unha sinatura válida.
sec-error-expired-certificate = O certificado do elemento do mesmo nivel caducou.
sec-error-revoked-certificate = O certificado do elemento do mesmo nivel foi revogado.
sec-error-unknown-issuer = O emisor do certificado do elemento do mesmo nivel non é recoñecido.
sec-error-bad-key = A chave pública do elemento do mesmo nivel non é válida.
sec-error-bad-password = O contrasinal de seguranza introducido non é correcto.
sec-error-retry-password = Novo contrasinal introducido incorrectamente. Tente de novo.
sec-error-no-nodelock = biblioteca de seguranza: sen nodelock.
sec-error-bad-database = biblioteca de seguranza: base de datos incorrecta.
sec-error-no-memory = biblioteca de seguranza: erro de atribución de memoria.
sec-error-untrusted-issuer = O emisor do certificado do elemento do mesmo nivel foi marcado como non fiábel polo usuario.
sec-error-untrusted-cert = O certificado do elemento do mesmo nivel foi marcado como non fiábel polo usuario.
sec-error-duplicate-cert = O certificado xa existe na súa base de datos.
sec-error-duplicate-cert-name = O nome do certificado descargado duplica un xa existente na súa base de datos.
sec-error-adding-cert = Erro ao engadir o certificado á base de datos.
sec-error-filing-key = Erro ao encher de novo a chave deste certificado.
sec-error-no-key = A chave privada deste certificado non se pode atopar na base de datos da chave
sec-error-cert-valid = Este certificado é válido.
sec-error-cert-not-valid = Este certificado non é válido.
sec-error-cert-no-response = Bilioteca Cert: Sen resposta
sec-error-expired-issuer-certificate = O certificado do emisor do certificado caducou. Comprobe a data e hora do sistema.
sec-error-crl-expired = A CRL do emisor de certificados caducou. Actualice ou comprobe a hora e data do seu sistema.
sec-error-crl-bad-signature = A CRL do emisor de certificados ten unha sinatura non válida.
sec-error-crl-invalid = A nova CRL ten un formato incorrecto.
sec-error-extension-value-invalid = O valor da extensión do certificado non é válido.
sec-error-extension-not-found = Non se atopou a extensión do certificado.
sec-error-ca-cert-invalid = O certificado do emisor non é válido.
sec-error-path-len-constraint-invalid = A restrición de lonxitude da ruta do certificado non é válida.
sec-error-cert-usages-invalid = O campo de usos do certificado non é válido.
sec-internal-only = **Módulo ONLY interno**
sec-error-invalid-key = A chave non é compatíbel coa operación requirida.
sec-error-unknown-critical-extension = O certificado contén unha extensión crítica descoñecida.
sec-error-old-crl = A nova CRL non é posterior ao actual.
sec-error-no-email-cert = Non codificado nin asinado: Aínda non ten un certificado de correo electrónico.
sec-error-no-recipient-certs-query = Non codificado: Non ten certificados para cada un dos destinatarios.
sec-error-not-a-recipient = Non é posíbel descifrar: Non é un destinatario ou non se atoparon a chave privada e o certificado coincidente.
sec-error-pkcs7-keyalg-mismatch = Non é posíbel descifrar: O algoritmo de codificación da chave non coincide co seu certificado.
sec-error-pkcs7-bad-signature = Erro de verificación da sinatura: Ou non se atopou asinante, ou atopáronse demasiados asinantes, ou datos danados ou incorrectos.
sec-error-unsupported-keyalg = Algoritmo de chave descoñecido ou incompatíbel.
sec-error-decryption-disallowed = Non é posíbel descifrar: Cifrado usando un algoritmo ou tamaño de chave non permitido.
xp-sec-fortezza-bad-card = A tarxeta Fortezza non se iniciou correctamente. Retírea e devólvaa ao seu emisor.
xp-sec-fortezza-no-card = Non se atoparon tarxetas Fortezza
xp-sec-fortezza-none-selected = Non se seleccionou ningunha tarxeta Fortezza
xp-sec-fortezza-more-info = Seleccione unha personalidade para obter máis información en
xp-sec-fortezza-person-not-found = Non se atopou ningunha personalidade
xp-sec-fortezza-no-more-info = Non máis información sobre esta personalidade
xp-sec-fortezza-bad-pin = Pin non válido
xp-sec-fortezza-person-error = Non foi posíbel iniciar as personalidades de Fortezza.
sec-error-no-krl = Non se atopou ningún KRL deste certificado de sitio.
sec-error-krl-expired = Caducou o KRL deste certificado de sitio.
sec-error-krl-bad-signature = O KRL deste certificado de sitio ten unha sinatura non válida.
sec-error-revoked-key = Revogouse a chave deste certificado de sitio.
sec-error-krl-invalid = O novo KRL ten un formato non válido.
sec-error-need-random = biblioteca de seguranza: datos aleatorios necesarios.
sec-error-no-module = biblioteca de seguranza: ningún módulo de seguranza pode executar a operación requirida.
sec-error-no-token = Ou o cartón de seguranza ou chave electrónica non existe, ou necesita ser iniciado ou foi eliminado.
sec-error-read-only = biblioteca de seguranza: base de datos só de lectura.
sec-error-no-slot-selected = Non se seleccionou ningunha rañura nin chave electrónica.
sec-error-cert-nickname-collision = Xa hai un certificado co mesmo alcume.
sec-error-key-nickname-collision = Xa hai unha chave co mesmo alcume.
sec-error-safe-not-created = erro ao crear o obxecto seguro
sec-error-baggage-not-created = erro ao crear o obxecto de equipaxe
xp-java-remove-principal-error = Non foi posíbel eliminar o principal
xp-java-delete-privilege-error = Non foi posíbel eliminar o privilexio
xp-java-cert-not-exists-error = Este principal non ten un certificado
sec-error-bad-export-algorithm = O algoritmo requirido non está permitido.
sec-error-exporting-certificates = Erro ao tentar exportar certificados.
sec-error-importing-certificates = Erro ao tentar importar certificados.
sec-error-pkcs12-decoding-pfx = Non foi posíbel importar. Erro de descodificación. Ficheiro non válido.
sec-error-pkcs12-invalid-mac = Non foi posíbel importar. MAC non válida. Contrasinal incorrecto ou ficheiro danado.
sec-error-pkcs12-unsupported-mac-algorithm = Non é posíbel importar. Algoritmo MAC non compatíbel.
sec-error-pkcs12-unsupported-transport-mode = Non foi posíbel importar. Só son compatíbeis os modos de privacidade e a integridade do contrasinal.
sec-error-pkcs12-corrupt-pfx-structure = Non foi posíbel importar. A estrutura do ficheiro está danada.
sec-error-pkcs12-unsupported-pbe-algorithm = Non foi posíbel importar. Algoritmo de codificación non compatíbel.
sec-error-pkcs12-unsupported-version = Non foi posíbel importar. Versión do ficheiro non compatíbel.
sec-error-pkcs12-privacy-password-incorrect = Non foi posíbel importar. Contrasinal de privacidade incorrecto.
sec-error-pkcs12-cert-collision = Non foi posíbel importar. Ese mesmo alcume xa existe na base de datos.
sec-error-user-cancelled = O usuario premeu Cancelar.
sec-error-pkcs12-duplicate-data = Non importado, xa está na base de datos.
sec-error-message-send-aborted = Mensaxe non enviada.
sec-error-inadequate-key-usage = Uso inadecuado da chave de certificado para a operación tentada.
sec-error-inadequate-cert-type = Tipo de certificado non aprobado para o aplicativo.
sec-error-cert-addr-mismatch = O enderezo do certificado de sinatura non coincide co enderezo das cabeceiras da mensaxe.
sec-error-pkcs12-unable-to-import-key = Non foi posíbel importar. Erro ao tentar importar a chave de privacidade.
sec-error-pkcs12-importing-cert-chain = Non foi posíbel importar. Erro ao tentar importar unha serie de certificados.
sec-error-pkcs12-unable-to-locate-object-by-name = Non foi posíbel exportar. Non foi posíbel localizar o certificado ou a chave polo alcume.
sec-error-pkcs12-unable-to-export-key = Non foi posíbel exportar. Non foi posíbel localizar nin exportar a chave privada.
sec-error-pkcs12-unable-to-write = Non foi posíbel exportar.  Non foi posíbel editar o ficheiro de exportación.
sec-error-pkcs12-unable-to-read = Non foi posíbel importar. Non foi posíbel ler o ficheiro de importación.
sec-error-pkcs12-key-database-not-initialized = Non foi posíbel exportar. Base de datos da chave danada ou eliminada.
sec-error-keygen-fail = Non foi posíbel xerar o par de chaves público/privado.
sec-error-invalid-password = O contrasinal introducido non é válido. Seleccione un diferente.
sec-error-retry-old-password = O contrasinal antigo introduciuse incorrectamente. Tente de novo.
sec-error-bad-nickname = O alcume do certificado xa está a ser utilizado.
sec-error-not-fortezza-issuer = A serie de FORTEZZA do elemento do mesmo nivel ten un certificado non FORTEZZA.
sec-error-cannot-move-sensitive-key = Non é posíbel mover unha chave importante para a rañura onde esta é necesaria.
sec-error-js-invalid-module-name = Nome do módulo incorrecto.
sec-error-js-invalid-dll = Nome do ficheiro/ruta do módulo non válido
sec-error-js-add-mod-failure = Non foi posíbel engadir o módulo
sec-error-js-del-mod-failure = Non foi posíbel eliminar o módulo
sec-error-old-krl = O novo KRL non é posterior ao actual.
sec-error-ckl-conflict = O novo CKL ten un emisor diferente ao CKL actual. Elimine o CKL actual.
sec-error-cert-not-in-name-space = A entidade de acreditación deste certificado non ten permitido emitir un certificado con este nome.
sec-error-krl-not-yet-valid = A lista de revogación desta chave aínda non é válida.
sec-error-crl-not-yet-valid = A lista de revogación deste certificado aínda non é válida.
sec-error-unknown-cert = Non foi posíbel atopar o certificado requirido.
sec-error-unknown-signer = Non foi posíbel atopar o certificado do asinante.
sec-error-cert-bad-access-location = A localización do servidor do estado do certificado ten un formato non válido.
sec-error-ocsp-unknown-response-type = Non é posíbel descodificar completamente a resposta de OCSP; esta é dun tipo descoñecido.
sec-error-ocsp-bad-http-response = O servidor de OCSP devolveu datos HTTP incorrectos ou inesperados.
sec-error-ocsp-malformed-request = O servidor de OCSP atopou a solicitude danada ou formada incorrectamente.
sec-error-ocsp-server-error = O servidor de OCSP experimentou un erro interno.
sec-error-ocsp-try-server-later = O servidor de OCSP suxire tentar de novo máis tarde.
sec-error-ocsp-request-needs-sig = O servidor de OCSP require unha sinatura nesta solicitude.
sec-error-ocsp-unauthorized-request = O servidor de OCSP rexeitou esta solicitude como non autorizada.
sec-error-ocsp-unknown-response-status = O servidor de OCSP devolveu un estado irrecoñecíbel.
sec-error-ocsp-unknown-cert = O servidor de OCSP non ten estado para o certificado.
sec-error-ocsp-not-enabled = Active OCSP antes de executar esta operación.
sec-error-ocsp-no-default-responder = Defina o dispositivo de resposta predefinido de OCSP antes de executar esta operación.
sec-error-ocsp-malformed-response = A resposta do servidor de OCSP estaba danada ou incorrectamente formada.
sec-error-ocsp-unauthorized-response = O asinante da resposta de OCSP non está autorizado para dar o estado da este certificado.
sec-error-ocsp-future-response = A resposta de OCSP aínda non é válida (contén unha data no futuro).
sec-error-ocsp-old-response = A resposta de OCSP contén información fóra de data.
sec-error-digest-not-found = Non se atopou o resumo de CMS ou PKCS #7 na mensaxe asinada.
sec-error-unsupported-message-type = O tipo de mensaxe de CMS ou PKCS #7 non é compatíbel.
sec-error-module-stuck = Non foi posíbel eliminar o módulo de PKCS #11 porque continúa a ser utilizado.
sec-error-bad-template = Non foi posíbel descodificar os datos ASN.1. O modelo especificado non era válido.
sec-error-crl-not-found = Non se atopou ningún CRL coincidente.
sec-error-reused-issuer-and-serial = Está a tentar importar un certificado coa mesma serie/emisor que un certificado existente, mais ese non é o mesmo certificado.
sec-error-busy = Non foi posíbel pechar NSS. Os obxectos aínda están a ser utilizados.
sec-error-extra-input = A mensaxe DER codificada contén datos adicionais sen utilizar.
sec-error-unsupported-elliptic-curve = Curva elíptica non compatíbel.
sec-error-unsupported-ec-point-form = Formulario de punto de curva elíptica non compatíbel.
sec-error-unrecognized-oid = Identificador de obxecto non recoñecido.
sec-error-ocsp-invalid-signing-cert = Certificado de sinatura de OCSP non válido na resposta de OCSP.
sec-error-revoked-certificate-crl = Revogouse o certificado na lista de revogación de certificados do emisor.
sec-error-revoked-certificate-ocsp = O dispositivo de resposta de OCSP do emisor informa de que o certificado está revogado.
sec-error-crl-invalid-version = A lista de revogación de certificados do emisor ten un número de versión descoñecido.
sec-error-crl-v1-critical-extension = A lista de revogación de certificados V1 do emisor ten unha extensión crítica.
sec-error-crl-unknown-critical-extension = A lista de revogación do certificados V2 do emisor ten unha extensión crítica descoñecida.
sec-error-unknown-object-type = Tipo de obxecto descoñecido especificado.
sec-error-incompatible-pkcs11 = O controlador de PKCS #11 infrinxe a especificación dun modo incompatíbel.
sec-error-no-event = Neste momento, non hai ningún evento novo dispoñible.
sec-error-crl-already-exists = CRL xa existe.
sec-error-not-initialized = NSS non está iniciado.
sec-error-token-not-logged-in = A operación fallou porque a chave electrónica de PKCS#11 non está rexistrada.
sec-error-ocsp-responder-cert-invalid = O certificado do dispositivo de reposta de OCSP configurado non é válido.
sec-error-ocsp-bad-signature = A resposta de OCSP ten unha sinatura inválida.
sec-error-out-of-search-limits = A busca da validación do certificado está fora dos límites da mesma
sec-error-invalid-policy-mapping = O mapeo de políticas contén anypolicy
sec-error-policy-validation-failed = A cadea de certificados non cumpre a validación de políticas
sec-error-unknown-aia-location-type = Tipo de localización descoñecida na extensión AIA do certificado
sec-error-bad-http-response = O servidor devolveu unha resposta HTTP incorrecta
sec-error-bad-ldap-response = O servidor devolveu unha resposta LDAP incorrecta
sec-error-failed-to-encode-data = Produciuse un fallo ao codificar os datos co codificador ASN1
sec-error-bad-info-access-location = Localización de acceso da información incorrecta na extensión do certificado
sec-error-libpkix-internal = Produciuse un erro interno libpkix durante a validación do certificado.
sec-error-pkcs11-general-error = Un módulo PKCS #11 devolveu CKR_GENERAL_ERROR, indicando que se produciu un erro irrecuperábel.
sec-error-pkcs11-function-failed = Un módulo PKCS #11 devolveu CKR_FUNCTION_FAILED, indicando que non foi posíbel executar a función solicitada. Tentar de novo a mesma operación podería ter éxito.
sec-error-pkcs11-device-error = Un módulo PKCS #11 devolveu CKR_DEVICE_ERROR, indicando que se produciu un problema co token ou slot.
sec-error-bad-info-access-method = Método de acceso á información descoñecido na extensión do certificado.
sec-error-crl-import-failed = Produciuse un erro ao tentar importar un CRL.
sec-error-expired-password = O contrasinal caducou.
sec-error-locked-password = O contrasinal está protexido.
sec-error-unknown-pkcs11-error = Erro PKCS #11 descoñecido.
sec-error-bad-crl-dp-url = URL incorrecto ou incompatíbel no nome do punto de distribución de CRL.
sec-error-cert-signature-algorithm-disabled = Firmouse o certificado usando un algoritmo de asinamento que está desactivado porque non é seguro.
mozilla-pkix-error-key-pinning-failure = O servidor usa o mecanismo de «key pinning» (HPKP) pero non foi posíbel construír unha cadea de certificados de confianza que coincida co pinset. Non é posíbel sobrescribir as violacións de «key pinning».
mozilla-pkix-error-ca-cert-used-as-end-entity = O servidor usa un certificado cunha extensión das restricións básicas que o identifica como unha entidade de acreditación. Este non debería ser o caso para un certificado emitido correctamente.
mozilla-pkix-error-inadequate-key-size = O servidor presentou un certificado cun tamaño de chave que é demasiado pequeno para estabelecer unha conexión segura.
mozilla-pkix-error-v1-cert-used-as-ca = Para emitir o certificado do servidor usouse un certificado X.509 versión 1 que non é de confianza. Os certificados X.509 versión 1 están desfasados e non deberían usarse para firmar outros certificados.
mozilla-pkix-error-not-yet-valid-certificate = O servidor presentou un certificado que aínda non é válido.
mozilla-pkix-error-not-yet-valid-issuer-certificate = Usouse un certificado que aínda non é válido para emitir o certificado do servidor.
mozilla-pkix-error-signature-algorithm-mismatch = O algoritmo de sinatura no campo da sinatura do certificado non coincide co algoritmo no campo signatureAlgorithm.
mozilla-pkix-error-ocsp-response-for-cert-missing = A resposta OCSP non inclúe un estado para o certificado en fase de verificación.
mozilla-pkix-error-validity-too-long = O servidor presentou un certificado cunha validez demasiado longa.
mozilla-pkix-error-required-tls-feature-missing = Falta unha característica TLS requirida.
mozilla-pkix-error-invalid-integer-encoding = O servidor presentou un certificado que contén unha codificación non válida dun enteiro. As causas máis habituais inclúen números de serie negativos, módulos RSA negativos e codificacións que son máis longas do necesario.
mozilla-pkix-error-empty-issuer-name = O servidor presentou un certificado cun nome distintivo de emisor baleiro.
mozilla-pkix-error-additional-policy-constraint-failed = Unha restrición de política adicional fallou ao validar este certificado.
mozilla-pkix-error-self-signed-cert = O certificado non é fiábel porque está autoasinado.
