# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Menu item that sends a tab to all synced devices.
account-send-to-all-devices = Sūtīt uz visām ierīcēm

## Variables:
##   $email (String): = Email address of user's Firefox Account.

account-reconnect = Pieslēgties { $email }
account-verify = Pārbaudīt { $email }

## Displayed in the Send Tab/Page/Link to Device context menu when right clicking a tab, a page or a link.

account-send-to-all-devices-titlecase = Sūtīt uz visām ierīcēm

## Displayed in the Send Tabs context menu when right clicking a tab, a page or a link
## and the account has only 1 device connected.

# Redirects to a marketing page.
account-send-tab-to-device-singledevice-status = Nav pieslēgtu ierīču
# Redirects to a marketing page.
account-send-tab-to-device-singledevice-learnmore = Uzziniet vairāk par cilņu sūtīšanu…
# Redirects to an FxAccounts page that tells to you to connect another device.
account-send-tab-to-device-connectdevice = Savienot citu ierīci…

## Displayed in the Send Tabs context menu when right clicking a tab, a page or a link
## and the Sync account is unverified. Redirects to the Sync preferences page.

account-send-tab-to-device-verify-status = Konts nav pārbaudīts
account-send-tab-to-device-verify = Pārbaudiet savu kontu…

## These strings are used in a notification shown when a new device joins the Firefox account.


## These strings are used in a notification shown when we're opening
## a single tab another device sent us to display.
## The body for this notification is the URL of the received tab.

account-single-tab-arriving-title = Cilne saņemta
# Variables:
#   $deviceName (String): the device name.
account-single-tab-arriving-from-device-title = Cilne no { $deviceName }
# Used when a tab from a remote device arrives but the URL must be truncated.
# Should display the URL with an indication that it's been truncated.
# Variables:
#   $url (String): the portion of the URL that remains after truncation.
account-single-tab-arriving-truncated-url = { $url }…

## These strings are used in a notification shown when we're opening
## multiple tabs another device or devices sent us to display.
## Variables:
##   $tabCount (Number): the number of tabs received

account-multiple-tabs-arriving-title = Cilnes saņemtas
# Variables:
#   $deviceName (String): the device name.
account-multiple-tabs-arriving-from-single-device =
    { $tabCount ->
        [zero] { $tabCount } cilnes ieradušās no { $deviceName }
        [one] { $tabCount } cilne ieradusies no { $deviceName }
       *[other] { $tabCount } cilnes ieradušās no { $deviceName }
    }
account-multiple-tabs-arriving-from-multiple-devices =
    { $tabCount ->
        [zero] { $tabCount } cilnes ieradušās no savienotajām ierīcēm
        [one] { $tabCount } cilne ieradusies no savienotajām ierīcēm
       *[other] { $tabCount } cilnes ieradušās no savienotajām ierīcēm
    }
# This version is used when we don't know any device names.
account-multiple-tabs-arriving-from-unknown-device =
    { $tabCount ->
        [zero] { $tabCount } cilnes ieradušās
        [one] { $tabCount } cilne ieradusies
       *[other] { $tabCount } cilnes ieradušās
    }
