// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

// this function deletes a file if it exists
function deleteThisFile(dirKey, file)
{
  var fFileToDelete;

  fFileToDelete = getFolder(dirKey, file);
  logComment("File to delete: " + fFileToDelete);
  if(File.isFile(fFileToDelete))
  {
    File.remove(fFileToDelete);
    return(true);
  }
  else
    return(false);
}

// this function deletes a folder if it exists
function deleteThisFolder(dirKey, folder, recursiveDelete)
{
  var fToDelete;

  if(typeof recursiveDelete == "undefined")
    recursiveDelete = true;

  fToDelete = getFolder(dirKey, folder);
  logComment("folder to delete: " + fToDelete);
  if(File.isDirectory(fToDelete))
  {
    File.dirRemove(fToDelete, recursiveDelete);
    return(true);
  }
  else
    return(false);
}

// OS type detection
// which platform?
function getPlatform()
{
  var platformStr;
  var platformNode;

  if('platform' in Install)
  {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else
  {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

function removeOldFiles() {
  deleteThisFile("Program", "chrome/US.jar");
  deleteThisFile("Program", "chrome/en-win.jar");
  deleteThisFile("Program", "chrome/help.jar");
  deleteThisFile("Program", "chrome/chrome.rdf");
  deleteThisFile("Program", "chrome/installed-chrome.txt");
  deleteThisFile("Program", "chrome/app-chrome.manifest");
  deleteThisFolder("Program", "chrome/overlayinfo");
  deleteThisFile("Program", "chrome/m3ffxtbr.manifest");
  deleteThisFile("Program", "chrome/m3ffxtbr.jar");
  deleteThisFile("Program", "defaults/pref/all.js");
  deleteThisFile("Program", "defaults/pref/security-prefs.js");
  deleteThisFile("Program", "defaults/pref/winpref.js");
  deleteThisFile("Program", "defaults/pref/xpinstall.js");
  deleteThisFile("Program", "defaults/pref/bug307259.js");
  deleteThisFile("Program", "defaults/pref/bug259708.js");
  deleteThisFile("Program", "defaults/profile/extensions/{972ce4c6-7e08-4474-a285-3208198ce6fd}/install.rdf");
  deleteThisFolder("Program", "defaults/profile/extensions/{972ce4c6-7e08-4474-a285-3208198ce6fd}");
  deleteThisFile("Program", "defaults/profile/extensions/Extensions.rdf");
  deleteThisFile("Program", "defaults/profile/extensions/installed-extensions.txt");
  deleteThisFolder("Program", "defaults/profile/extensions");
  deleteThisFolder("Program", "defaults/profile/US");
  deleteThisFile("Program", "extensions/{641d8d09-7dda-4850-8228-ac0ab65e2ac9}/install.rdf");
  deleteThisFolder("Program", "extensions/{641d8d09-7dda-4850-8228-ac0ab65e2ac9}");
  deleteThisFile("Program", "searchplugins/dictionary.src");
  deleteThisFile("Program", "searchplugins/dictionary.png");
  deleteThisFile("Program", "searchplugins/tr-tdk.src");
  deleteThisFile("Program", "searchplugins/tr-tdk.png");
  deleteThisFolder("Program", "searchplugins");
  deleteThisFile("Program", "components/component.reg");
  deleteThisFile("Program", "components/compreg.dat");
  deleteThisFile("Program", "components/xpti.dat");
  deleteThisFile("Program", "components/xptitemp.dat");
  deleteThisFile("Program", "components/nsBackgroundUpdateService.js");
  deleteThisFile("Program", "components/autocomplete.xpt");
  deleteThisFile("Program", "zlib.dll");
  deleteThisFile("Program", "components/BrandRes.dll");
  deleteThisFile("Program", "components/fullsoft.dll");
  deleteThisFile("Program", "components/master.ini");
  deleteThisFile("Program", "components/qfaservices.dll");
  deleteThisFile("Program", "components/qfaservices.xpt");
  deleteThisFile("Program", "components/talkback-l10n.ini");
  deleteThisFile("Program", "components/talkback.cnt");
  deleteThisFile("Program", "components/talkback.exe");
  deleteThisFile("Program", "components/talkback.hlp");
  deleteThisFile("Program", "components/libqfaservices.so");
  deleteThisFile("Program", "components/talkback/master.ini");
  deleteThisFile("Program", "components/talkback/talkback");
  deleteThisFile("Program", "components/talkback/talkback.so");
  deleteThisFile("Program", "components/talkback/XTalkback.ad");
  deleteThisFile("Program", "extensions/reporter@mozilla.org/install.rdf");
  deleteThisFile("Program", "extensions/reporter@mozilla.org/chrome.manifest");
  deleteThisFile("Program", "extensions/reporter@mozilla.org/chrome/reporter.jar");
  deleteThisFile("Program", "extensions/reporter@mozilla.org/defaults/preferences/reporter.js");
  deleteThisFile("Program", "uninstall/UninstallFirefox.exe");
  deleteThisFile("Program", "uninstall/UninstallDeerPark.exe");
}
function copyFlashXPT()
{
  /*
   * Check if Netscape Navigator (pre 6.0) is installed and if the
   * flash player is installed in Netscape's plugin folder. If it is,
   * try to copy the flashplayer.xpt file into our plugins folder to
   * make ensure that flash is scriptable if we're using it from
   * Netscape's plugins folder.
   */

  var winreg = getWinRegistry();

  winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
  var subkey = "Software\\Netscape\\Netscape Navigator";
  var nsver = winreg.getValueString(subkey, "CurrentVersion");

  if (!nsver)
    return;

  subkey += "\\" + nsver + "\\Main";

  var navPluginsDir = winreg.getValueString(subkey, "Plugins Directory");

  if (!navPluginsDir)
    return;

  var navFlashXPT = getFolder("file:///", navPluginsDir + "\\flashplayer.xpt");

  if (!File.exists(navFlashXPT))
    return;

  var target = getFolder("file:///", fProgram + "\\plugins\\flashplayer.xpt");

  // Copy the file flashplayer.xpt from Netscape's plugin directory to
  // Firefox's plugin directory.
  File.copy(navFlashXPT, target);

  logComment("Copied Flash xpt file from '" + navFlashXPT + "' to '" + target +
             "'");
}

function copyQuickTimeXPT()
{
  /*
   * Check if QuickTime is installed and copy
   * nsIQTScriptablePlugin.xpt from its plugins directory into our
   * plugins directory. If we don't do this, QuickTime will load in
   * Firefox, but it won't be scriptable.
   */

  var winreg = getWinRegistry();

  winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
  var subkey = "Software\\Apple Computer, Inc.\\QuickTime";
  var qtdir = winreg.getValueString(subkey, "InstallDir");

  if (!qtdir)
    return;

  var qtXPT = getFolder("file:///",
                        qtdir + "\\Plugins\\nsIQTScriptablePlugin.xpt");

  if (!File.exists(qtXPT))
    return;

  var target = getFolder("file:///",
                         fProgram + "\\plugins\\nsIQTScriptablePlugin.xpt");

  // Copy the file nsIQTScriptablePlugin.xpt from the QuickTime
  // installation directory to Firefox's plugin directory.
  File.copy(qtXPT, target);

  logComment("Copied QuickTime xpt file from '" + qtXPT + "' to '" + target +
             "'");
}

// main
var srDest;
var err;
var err2;
var fProgram;
var fWindowsSystem;
var fileComponentRegStr;
var fileComponentReg;
var fileToRegister;
var args;

args = new String(Install.arguments);
logComment("args: " + args);

srDest = 2505;
err    = initInstall("Mozilla Firefox", "Firefox", "1.5.0.9pre"); 
logComment("initInstall: " + err);

fProgram  = getFolder("Program");
fWindowsSystem = getFolder("Win System");
logComment("fProgram: " + fProgram);

if(verifyDiskSpace(fProgram, srDest))
{
  setPackageFolder(fProgram);

  removeOldFiles();
  err = addDirectory("",
                     "1.5.0.9pre",
                     "bin",              // dir name in jar to extract 
                     fProgram,           // Where to put this file (Returned from GetFolder) 
                     "",                 // subdir name to create relative to fProgram
                     true);              // Force Flag 
  logComment("addDirectory() of Program returned: " + err);

  // check return value
  if( err == SUCCESS )
  {
    fileToRegister = getFolder(fProgram, "AccessibleMarshal.dll");
    err2           = File.windowsRegisterServer(fileToRegister);
    logComment("windowsRegisterServer() returned: " + err2);

    // we don't want to fail on errors for the above two
    resetError();

    // Create the uninstall folder. 
    err = File.dirCreate(getFolder("Program", "uninstall"));
    logComment("dirCreate() of Program/uninstall returned: " + err);

    copyFlashXPT();
    copyQuickTimeXPT();
    
    /* Log files that are created after the installer is done, so they can be uninstalled */
    logComment("Installing: "    + fProgram + ".autoreg");
    logComment("Installing: "    + fProgram + "Xpcs Registry.dat");
    logComment("Installing: "    + fProgram + "xpcom.log");
    logComment("Create Folder: " + fProgram + "components");
    logComment("Installing: "    + fProgram + "components\\xpti.dat");
    logComment("Installing: "    + fProgram + "components\\xptitemp.dat");
    logComment("Installing: "    + fProgram + "components\\compreg.dat");
    logComment("Create Folder: " + fProgram + "components\\Netscape");
    logComment("Create Folder: " + fProgram + "components\\Netscape\\MozillaTrunk");
    logComment("Installing: "    + fProgram + "components\\Netscape\\MozillaTrunk\\manifest.ini");
    logComment("Installing: "    + fProgram + "components\\Netscape\\MozillaTrunk\\permdata.box");
    logComment("Installing: "    + fProgram + "components\\Netscape\\MozillaTrunk\\Talkback.ini");
    logComment("Create Folder: " + fProgram + "chrome");
    logComment("Create Folder: " + fProgram + "uninstall");
    logComment("Installing: "    + fProgram + "active-update.xml");
    logComment("Installing: "    + fProgram + "updates.xml");
    logComment("Installing: "    + fProgram + "last-update.log");
    logComment("Create Folder: " + fProgram + "updates");

    err = getLastError();
    if (err == SUCCESS)
    {
      err = performInstall();
      logComment("performInstall() returned: " + err);
      if (! ('buildID' in Install))
      {
        logComment("Running Pre-Mozilla 0.9.1");
        initInstall("Post-install Cleanup Utility", "Browser/xpicleanup", "1.5.0.9pre");
        cleanupUtility = getFolder(fProgram, "xpicleanup.exe");
        err = File.execute(cleanupUtility);
        logComment("execute() returned: " + err);
        err = performInstall();
      }
    }
    else
      cancelInstall(err);
  }
  else
    cancelInstall(err);
}
else
  cancelInstall(INSUFFICIENT_DISK_SPACE);


// end main
