// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

// this function deletes a file if it exists
function deleteThisFile(dirKey, file)
{
  var fFileToDelete;

  fFileToDelete = getFolder(dirKey, file);
  logComment("File to delete: " + fFileToDelete);
  if(File.isFile(fFileToDelete))
  {
    File.remove(fFileToDelete);
    return(true);
  }
  else
    return(false);
}

// this function deletes a folder if it exists
function deleteThisFolder(dirKey, folder, recursiveDelete)
{
  var fToDelete;

  if(typeof recursiveDelete == "undefined")
    recursiveDelete = true;

  fToDelete = getFolder(dirKey, folder);
  logComment("folder to delete: " + fToDelete);
  if(File.isDirectory(fToDelete))
  {
    File.dirRemove(fToDelete, recursiveDelete);
    return(true);
  }
  else
    return(false);
}

// OS type detection
// which platform?
function getPlatform()
{
  var platformStr;
  var platformNode;

  if('platform' in Install)
  {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else
  {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

function upgradeCleanup()
{
  // Get rid of Chrome directory cruft.
  deleteThisFolder("Chrome",      "classic");
  deleteThisFolder("Chrome",      "comm");
  deleteThisFolder("Chrome",      "en-mac");
  deleteThisFile("Chrome",        "en-mac.jar");
  deleteThisFolder("Chrome",      "en-unix");
  deleteThisFile("Chrome",        "en-unix.jar");
  deleteThisFolder("Chrome",      "en-US");
  deleteThisFolder("Chrome",      "en-win");
  deleteThisFile("Chrome",        "en-win.jar");
  deleteThisFolder("Chrome",      "US");
  deleteThisFile("Chrome",        "help.jar");

  deleteThisFile("Chrome",        "chrome.rdf");
  deleteThisFile("Chrome",        "installed-chrome.txt");
  deleteThisFile("Chrome",        "app-chrome.manifest");
  deleteThisFolder("Chrome",      "overlayinfo");

  // Remove defunct components and type libraries
  deleteThisFile("Components",    "typeaheadfind.xpt");
  deleteThisFile("Components",    "chrome.xpt");
  deleteThisFile("Components",    "ipcd.xpt");
  deleteThisFile("Components",    "nsUpdateNotifier.js");
  deleteThisFile("Components",    "nsBackgroundUpdateService.js");
  deleteThisFile("Components",    "p3p.xpt");
  deleteThisFile("Components",    "prefmigr.xpt");
  deleteThisFile("Components",    "profilesharingsetup.xpt");
  deleteThisFile("Components",    "related.xpt");
  deleteThisFile("Components",    "ucnative.xpt");
  deleteThisFile("Components",    "util.xpt");
  deleteThisFile("Components",    "compreg.dat");
  deleteThisFile("Components",    "xpti.dat");

  // Remove non-linked xpt files for rev'd interfaces; this prevents a
  // conflict if you had previously installed a zip build in the app directory.
  deleteThisFile("Components",    "autocomplete.xpt");
  
  // Remove defunct defaults files. 
  deleteThisFile("Program",	      "defaults/pref/all.js");
  deleteThisFile("Program",	      "defaults/pref/editor.js");
  deleteThisFile("Program",	      "defaults/pref/mailnews.js");
  deleteThisFile("Program",	      "defaults/pref/non-shared.txt");
  deleteThisFile("Program",	      "defaults/pref/security-prefs.js");
  deleteThisFile("Program",	      "defaults/pref/unix.js");
  deleteThisFile("Program",	      "defaults/pref/xpinstall.js");
  deleteThisFile("Program",	      "defaults/pref/bug307259.js");
  deleteThisFile("Program",	      "defaults/profile/panels.rdf");
  deleteThisFolder("Program",	    "defaults/profile/US");
  
  // Delete dictionary.com search plugin  
  deleteThisFile("Program",     "searchplugins/dictionary.src");
  deleteThisFile("Program",     "searchplugins/dictionary.png");

  // These files are related to app patches and will interfere with the 
  // UA/app version strings if we do not remove them. 
  deleteThisFile("Program",	    "defaults/pref/bug259708.js");
  
  // Remove defunct miscellany
  deleteThisFolder("Program",     "ipc");
  deleteThisFile("Program",       "mangle");
  deleteThisFile("Program",       "mozipcd");
  deleteThisFile("Program",       "regchrome");
  deleteThisFile("Program",       "regxpcom");
  deleteThisFile("Program",       "shlibsign");
}

var srDest = 1;

var err = initInstall("Mozilla Firefox", "Browser", "1.5.0.2"); 
logComment("initInstall: " + err);

var communicatorFolder = getFolder("Program");
logComment("communicatorFolder: " + communicatorFolder);

if (verifyDiskSpace(communicatorFolder, srDest))
{
    // Call upgradeCleanup() before addDirectory() in case we accidentaly
    // delete files that we happen to be also installing.  This way, if we do,
    // it will just get reinstalled.  This is for safety measure.
    upgradeCleanup();
    err = addDirectory("Program",
                       "1.5.0.2",
                       "bin",              // jar source folder
                       communicatorFolder, // target folder
                       "",                 // target subdir 
                       true );             // force flag 

    logComment("addDirectory() returned: " + err);

    // create the plugins folder next to mozilla 
    var pluginsFolder = getFolder("Plugins");
    var ignoreErr = dirCreate(pluginsFolder);
    logComment("dirCreate() returned: " + ignoreErr);

    if (err==SUCCESS)
    {
	    err = performInstall(); 
	    logComment("performInstall() returned: " + err);
        if (! ('buildID' in Install))
        {
          logComment("Running Pre-Mozilla 0.9.1");
          initInstall("Post-install Cleanup Utility", "Browser/xpicleanup", "1.5.0.2");
          cleanupUtility = getFolder(communicatorFolder, "xpicleanup");
          err = File.execute(cleanupUtility);
          logComment("execute() returned: " + err);
          err = performInstall();
        }
    }
    else
    {
	    cancelInstall(err);
	    logComment("cancelInstall() due to error: " + err);
    }
}
else
    cancelInstall(INSUFFICIENT_DISK_SPACE);
