// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

// this function deletes a file if it exists
function deleteThisFile(dirKey, file)
{
  var fFileToDelete;

  fFileToDelete = getFolder(dirKey, file);
  logComment("File to delete: " + fFileToDelete);
  if(File.isFile(fFileToDelete))
  {
    File.remove(fFileToDelete);
    return(true);
  }
  else
    return(false);
}

// this function deletes a folder if it exists
function deleteThisFolder(dirKey, folder, recursiveDelete)
{
  var fToDelete;

  if(typeof recursiveDelete == "undefined")
    recursiveDelete = true;

  fToDelete = getFolder(dirKey, folder);
  logComment("folder to delete: " + fToDelete);
  if(File.isDirectory(fToDelete))
  {
    File.dirRemove(fToDelete, recursiveDelete);
    return(true);
  }
  else
    return(false);
}

// OS type detection
// which platform?
function getPlatform()
{
  var platformStr;
  var platformNode;

  if('platform' in Install)
  {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else
  {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

function registerProgramFolderKey(winreg, fFolderPath)
{
  var subkey;
  var err;
  var szCurrentMozillaVersion;

  /* set the Program Folder Path in the Mozilla key in the Windows Registry */
  winreg.createKey("SOFTWARE\\Mozilla","");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox";
  winreg.createKey(subkey,"");
  err     = winreg.setValueString(subkey, "CurrentVersion", "1.0.5 (en-US)");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla";
  szCurrentMozillaVersion = winreg.getValueString(subkey, "CurrentVersion");
  logComment("szCurrentMozillaVersion: " + szCurrentMozillaVersion);

  if((szCurrentMozillaVersion == "") || (szCurrentMozillaVersion == null))
  {
    // A Mozilla\CurrentVersion key must be set so that Java can work. 
    // (bug 229627)
    subkey  = "SOFTWARE\\Mozilla\\Mozilla";
    winreg.createKey(subkey,"");
    err     = winreg.setValueString(subkey, "CurrentVersion", "1.7.9");
  }

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)";
  winreg.createKey(subkey,"");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)\\Main";
  winreg.createKey(subkey,"");
  err     = winreg.setValueString(subkey, "Program Folder Path", fFolderPath);
}

function createShortcuts() 
{
  var subkey;
  var valname;
  var szStartMenuPrograms;
  var szStartMenu;
  var szFolderDesktop;
  var szFolderQuickLaunch;
  var szFolderAppData;
  var winreg;
  var fTemp;
  var fProgram;
  var fDefShortcuts;
  var fileExe;
  var scExeDesc;
  var scFolderName;
  var fFolderDesktop;
  var fFolderPrograms;
  var fFolderProgramsStr;
  var fFolderQuickLaunch;
  var is_winnt;
  var szCurrentVersion;
  var folderQuickLaunchExists;

  winreg               = getWinRegistry();
  fProgram             = getFolder("Program");
  fDefShortcuts        = getFolder("Program","defaults/shortcuts");
  fTemp                = fProgram + "firefox.exe";
  fileExe              = getFolder("file:///", fTemp);
  scExeDesc            = "Mozilla Firefox";
  scFolderName         = "Mozilla Firefox";
  scSafeModeDesc       = "Mozilla Firefox (Safe Mode)";
  scSafeModeParam      = "-safe-mode";

  if (winreg) {
    // determine if the script is running under NT or not
    winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
    subkey              = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    szCurrentVersion    = winreg.getValueString(subkey, "CurrentVersion");
    logComment("szCurrentVersion: " + szCurrentVersion);
    is_winnt = szCurrentVersion != "";
    logComment("is_winnt value: " + is_winnt);

    // Locate the various folders we're about to install shortcuts into.     
    if(!is_winnt || restrictedAccess) {
      winreg.setRootKey(winreg.HKEY_CURRENT_USER);
      subkey              = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
      szStartMenuPrograms = winreg.getValueString(subkey, "Programs");
      szStartMenu         = winreg.getValueString(subkey, "Start Menu");
      szFolderDesktop     = winreg.getValueString(subkey, "Desktop");
	  }
    else {
      winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
      subkey              = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
      szStartMenuPrograms = winreg.getValueString(subkey, "Common Programs");
      szStartMenu         = winreg.getValueString(subkey, "Common Start Menu");
      szFolderDesktop     = winreg.getValueString(subkey, "Common Desktop");
    }

    // Locate the Start Menu Programs Folder
    winreg.setRootKey(winreg.HKEY_CURRENT_USER);
    subkey              = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)\\Main";
    fFolderProgramsStr  = winreg.getValueString(subkey, "Program Folder Path");
    fFolderPrograms = getFolder("file:///", fFolderProgramsStr || szStartMenuPrograms);

    // Locate the Desktop Folder
    winreg.setRootKey(winreg.HKEY_CURRENT_USER);
    fFolderDesktop = getFolder("file:///", szFolderDesktop);

    // Locate the Quick Launch folder
    winreg.setRootKey(winreg.HKEY_CURRENT_USER);
    subkey              = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    szFolderAppData     = winreg.getValueString(subkey, "AppData");
    szFolderQuickLaunch = szFolderAppData + "\\Microsoft\\Internet Explorer\\Quick Launch";
    fFolderQuickLaunch  = getFolder("file:///", szFolderQuickLaunch);
    folderQuickLaunchExists = File.isDirectory(fFolderQuickLaunch);
    if(!folderQuickLaunchExists) {
      subkey                  = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\GrpConv\\MapGroups";
      szFolderQuickLaunch     = winreg.getValueString(subkey, "Quick Launch");
      folderQuickLaunchExists = File.isDirectory(fFolderPrograms);
      if(folderQuickLaunchExists)
        fFolderQuickLaunch = getFolder("file:///", szFolderQuickLaunch);
    }
    logComment("folderQuickLaunchExists: " + folderQuickLaunchExists);

    logComment("Folder StartMenuPrograms: " + szStartMenuPrograms);
    logComment("Folder StartMenu        : " + szStartMenu);
    logComment("Folder FolderDesktop    : " + szFolderDesktop);
    logComment("Folder FolderQuickLaunch: " + szFolderQuickLaunch);
    logComment("fileExe                 : " + fileExe);
    logComment("fFolderPrograms         : " + fFolderPrograms);
    logComment("scExeDesc               : " + scExeDesc);
    logComment("fProgram                : " + fProgram);

    // Explicitly create the fFolderPrograms even though the windowsShortcut 
    // function creates the folder. This is so that the folder creation gets 
    // logged for uninstall to remove it.
    if(winreg.getValueNumber(subkey, "Create Start Menu Shortcut") != 0 && !File.exists(fFolderPrograms))
      File.dirCreate(fFolderPrograms);
    if(winreg.getValueNumber(subkey, "Create Start Menu Shortcut") != 0 && !File.exists(fDefShortcuts))
      File.dirCreate(fDefShortcuts);

    // Create the Shortcuts
    winreg.setRootKey(winreg.HKEY_CURRENT_USER);
    subkey              = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)\\Main";
    if (winreg.getValueNumber(subkey, "Create Desktop Shortcut") != 0)
      File.windowsShortcut(fileExe, fFolderDesktop, scExeDesc, fProgram, "", fileExe, 0);
    if (winreg.getValueNumber(subkey, "Create Start Menu Shortcut") != 0) {
      File.windowsShortcut(fileExe, fFolderPrograms, scExeDesc, fProgram, "", fileExe, 0);
      File.windowsShortcut(fileExe, fFolderPrograms,  scSafeModeDesc, fProgram, scSafeModeParam,  fileExe, 0);
    }
    if (winreg.getValueNumber(subkey, "Create Quick Launch Shortcut") != 0 && folderQuickLaunchExists)
      File.windowsShortcut(fileExe, fFolderQuickLaunch, scExeDesc, fProgram,  "", fileExe, 0);
    // Always create the default shortcuts. 
    File.windowsShortcut(fileExe, fDefShortcuts,    scExeDesc,      fProgram, "",               fileExe, 0);
    File.windowsShortcut(fileExe, fDefShortcuts,    scSafeModeDesc, fProgram, scSafeModeParam,  fileExe, 0);

    if(!restrictedAccess) {
      winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
      registerProgramFolderKey(winreg, fFolderPrograms);

      // This is so that Windows Media Player works with us      
      var subkey = "SOFTWARE\\Microsoft\\MediaPlayer\\ShimInclusionList\\firefox.exe";
      winreg.createKey(subkey, "");
    }

    winreg.setRootKey(winreg.HKEY_CURRENT_USER);
    registerProgramFolderKey(winreg, fFolderPrograms);
  }
  else
    logComment("winreg is null");
}

function IsWinnt()
{
  /* Determines if the script is running under NT or not.
   *
   */
  var winreg = getWinRegistry();
  var subkey;
  var szCurrentVersion;

  winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
  subkey              = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
  szCurrentVersion    = winreg.getValueString(subkey, "CurrentVersion");
  logComment("szCurrentVersion: " + szCurrentVersion);
  
  return szCurrentVersion != "";
}

function registerMainKeys(winreg)
{
  var subkey;  //the name of the subkey you are poking around in
  var data;
  var err;

  winreg.createKey("SOFTWARE\\Mozilla","");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox";
  winreg.createKey(subkey,"");
  err     = winreg.setValueString(subkey, "CurrentVersion", "1.0.5 (en-US)");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)";
  winreg.createKey(subkey,"");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)\\Main";
  winreg.createKey(subkey,"");

  err     = winreg.setValueString(subkey, "Install Directory", fProgram);

  // The following keys are required to be created to supply information
  // about the location of the Gecko Embedded Client to 3rd party apps.
  // "SOFTWARE\\Mozilla" must not be localized!
  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox 1.0.5";
  winreg.createKey(subkey,"");
  err     = winreg.setValueString(subkey, "GeckoVer", "1.0.1");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox 1.0.5\\Extensions";
  winreg.createKey(subkey,"");
  err     = winreg.setValueString(subkey, "Components", fProgram + "Components");
  err     = winreg.setValueString(subkey, "Plugins", fProgram + "Plugins");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox 1.0.5\\bin";
  winreg.createKey(subkey,"");
  err     = winreg.setValueString(subkey, "PathToExe", fProgram + "firefox.exe");

  subkey  = "SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)\\Main";
  err     = winreg.setValueString(subkey, "PathToExe", fProgram + "firefox.exe");

  // Register as a windows XP internet browser
  if( IsWinnt() )
  {
    subkey = "Software\\Clients\\StartMenuInternet\\firefox.exe";
    winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);

    winreg.createKey(subkey, "");
    winreg.createKey(subkey + "\\DefaultIcon", "");
    winreg.createKey(subkey + "\\shell", "");
    winreg.createKey(subkey + "\\shell\\open", "");
    winreg.createKey(subkey + "\\shell\\open\\command", "");
    winreg.createKey(subkey + "\\InstallInfo", "");
    winreg.setValueString(subkey, "", "Mozilla Firefox");

    // path does not need to be quoted per MS doc
    data = fProgram + "firefox.exe,0";
    winreg.setValueString(subkey + "\\DefaultIcon", "", data);

    data = "\"" + fProgram + "firefox.exe\"";
    winreg.setValueString(subkey + "\\shell\\open\\command", "", data);

    data = "\"" + fProgram + "uninstall\\UninstallFirefox.exe\" /ua \"1.0.5 (en-US)\" /hs browser";
    winreg.setValueString(subkey + "\\InstallInfo", "HideIconsCommand", data);

    winreg.setValueNumber(subkey + "\\InstallInfo", "IconsVisible", 1);

    data = "\"" + fProgram + "firefox.exe\" -silent -nosplash -setDefaultBrowser ";
    winreg.setValueString(subkey + "\\InstallInfo", "ReinstallCommand", data);

    data = "\"" + fProgram + "uninstall\\UninstallFirefox.exe\" /ua \"1.0.5 (en-US)\" /ss browser";
    winreg.setValueString(subkey + "\\InstallInfo", "ShowIconsCommand", data);
  }
}

function updateWinReg()
{
  //Notes:
  // can't use a double backslash before subkey - Windows already puts it in.
  // subkeys have to exist before values can be put in.
  var winreg = getWinRegistry();
  var subkey;  //the name of the subkey you are poking around in
  var err;
  var ikwDefined;

  if(winreg != null) 
  {
    /* This will check to see if the user has restricted access or not.
     * It checks to see if HKEY_LOCALMACHINE\SOFTWARE is writable.  If
     * it is, then access is not restricted.  This is only used to
     * determine which Desktop, Programs, and Start Menu folders
     * are to used: common or per user
     */
    restrictedAccess = false;
    ikwDefined = typeof(winreg.isKeyWritable);
    logComment("winreg.isKeyWritable(): " + ikwDefined);
    if(ikwDefined == "function")
    {
      winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
      if(!winreg.isKeyWritable("SOFTWARE"))
        restrictedAccess = true;
    }

    logComment("restrictedAccess value: " + restrictedAccess);
    if(!restrictedAccess)
    {
      winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
      registerMainKeys(winreg);

      // set the App Paths key here
      subkey  = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\firefox.exe";
      winreg.createKey(subkey,"");
      err     = winreg.setValueString(subkey, "", fProgram + "firefox.exe");
      err     = winreg.setValueString(subkey, "Path", fProgram);

      // XPInstall content type mappings. 
      subkey = "SOFTWARE\\Classes\\MIME\\Database\\Content Type\\application/x-xpinstall;app=firefox"
      winreg.createKey(subkey, "");
      winreg.setValueString(subkey, "Extension", ".xpi");
    }

    winreg.setRootKey(winreg.HKEY_CURRENT_USER);
    registerMainKeys(winreg);
  }
}

function upgradeCleanup()
{
  // Remove Chrome directory cruft
  deleteThisFile("Chrome",      "US.jar");
  deleteThisFile("Chrome",      "en-win.jar");
  // Remove chrome and overlay registries, to remove bogus dependencies
  // on any of the above files which may cause the app not to start. 
  // XXXben Erk. This will effectively disable all global extensions...
  //        we need to come up with a way to preserve global extensions 
  //        across app versions...
  deleteThisFile("Chrome",      "chrome.rdf");
  deleteThisFolder("Chrome",    "overlayinfo");

  // Remove defunct components 
  deleteThisFile("Components",  "compreg.dat");
  deleteThisFile("Components",  "xpti.dat");
  deleteThisFile("Components",  "nsBackgroundUpdateService.js");

  // Remove defunct defaults files. 
  deleteThisFile("Program",	    "defaults/pref/all.js");
  deleteThisFile("Program",     "defaults/pref/security-prefs.js");
  deleteThisFile("Program",     "defaults/pref/winpref.js");
  deleteThisFile("Program",     "defaults/pref/xpinstall.js");
  deleteThisFolder("Program",   "defaults/profile/US");
  
  // These files are related to app patches and will interfere with the 
  // UA/app version strings if we do not remove them. 
  deleteThisFile("Program",	    "defaults/pref/bug259708.js");
  
  // Remove non-linked xpt files for rev'd interfaces; this prevents a
  // conflict if you had previously installed a zip build in the app directory.
  deleteThisFile("Components",  "autocomplete.xpt");

  // Now clean up Uninstall entries that may be laying around in the
  // registry for older versions of the software that we're overwriting/
  // upgrading...
  var wr = getWinRegistry();
  wr.setRootKey(wr.HKEY_LOCAL_MACHINE);
  var i = 0; 
  const uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
  do {
    var key = wr.enumKeys(uninstallKey, i++);
    if (!key)
      break;
    key = uninstallKey + "\\" + key;
    
    // For us to remove the entry from the ARP uninstall list, the install 
    // folder paths must *match* and the display version strings must *NOT
    // MATCH* - i.e. we don't want to remove the entry we just created for
    // this version.
    var itemInstallFolder = wr.getValueString(key, "InstallLocation");
    var thisInstallFolder = wr.getValueString("SOFTWARE\\Mozilla\\Mozilla Firefox\\1.0.5 (en-US)\\Main", 
                                              "Install Directory");
    var itemInstallFolderShortName = File.windowsGetShortName(getFolder("file:///", itemInstallFolder));
    var thisInstallFolderShortName = File.windowsGetShortName(getFolder("file:///", thisInstallFolder));
    
    var itemDisplayVersion = wr.getValueString(key, "DisplayVersion");
    var thisDisplayVersion = "1.0.5 (en-US)";

    // It is possible that a user might have installed several products into
    // the same directory that have the same "DisplayVersion" (e.g. "1.0")... 
    // in this case we don't want to trash the Uninstall info for the others
    // so we have to be sure to make sure Comment matches... we use Comment
    // instead of DisplayName since DisplayName varies from version to version
    // as it contains the version number, and this instance of javascript is
    // crippled so as not to contain any useful string parsing.
    var itemComment = wr.getValueString(key, "Comment");
    var thisComment = "Mozilla Firefox";

    if ((itemComment == thisComment || itemComment == "The Browser, Reloaded.") && 
        itemInstallFolderShortName == thisInstallFolderShortName &&
        thisDisplayVersion != itemDisplayVersion && 
        wr.isKeyWritable(key)) {
      wr.deleteKey(key);
      logComment("Removing obsolete uninstall key with upgrade: " + key);
    }
  }
  while (true);
}

function copyFlashXPT()
{
  /*
   * Check if Netscape Navigator (pre 6.0) is installed and if the
   * flash player is installed in Netscape's plugin folder. If it is,
   * try to copy the flashplayer.xpt file into our plugins folder to
   * make ensure that flash is scriptable if we're using it from
   * Netscape's plugins folder.
   */

  var winreg = getWinRegistry();

  winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
  var subkey = "Software\\Netscape\\Netscape Navigator";
  var nsver = winreg.getValueString(subkey, "CurrentVersion");

  if (!nsver)
    return;

  subkey += "\\" + nsver + "\\Main";

  var navPluginsDir = winreg.getValueString(subkey, "Plugins Directory");

  if (!navPluginsDir)
    return;

  var navFlashXPT = getFolder("file:///", navPluginsDir + "\\flashplayer.xpt");

  if (!File.exists(navFlashXPT))
    return;

  var target = getFolder("file:///", fProgram + "\\plugins\\flashplayer.xpt");

  // Copy the file flashplayer.xpt from Netscape's plugin directory to
  // Firefox's plugin directory.
  File.copy(navFlashXPT, target);

  logComment("Copied Flash xpt file from '" + navFlashXPT + "' to '" + target +
             "'");
}

function copyQuickTimeXPT()
{
  /*
   * Check if QuickTime is installed and copy
   * nsIQTScriptablePlugin.xpt from its plugins directory into our
   * plugins directory. If we don't do this, QuickTime will load in
   * Firefox, but it won't be scriptable.
   */

  var winreg = getWinRegistry();

  winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE);
  var subkey = "Software\\Apple Computer, Inc.\\QuickTime";
  var qtdir = winreg.getValueString(subkey, "InstallDir");

  if (!qtdir)
    return;

  var qtXPT = getFolder("file:///",
                        qtdir + "\\Plugins\\nsIQTScriptablePlugin.xpt");

  if (!File.exists(qtXPT))
    return;

  var target = getFolder("file:///",
                         fProgram + "\\plugins\\nsIQTScriptablePlugin.xpt");

  // Copy the file nsIQTScriptablePlugin.xpt from the QuickTime
  // installation directory to Firefox's plugin directory.
  File.copy(qtXPT, target);

  logComment("Copied QuickTime xpt file from '" + qtXPT + "' to '" + target +
             "'");
}

// main
var srDest;
var err;
var err2;
var fProgram;
var fWindowsSystem;
var fileComponentRegStr;
var fileComponentReg;
var restrictedAccess;
var fileToRegister;
var args;
var gGreLocal = false;

args = new String(Install.arguments);
logComment("args: " + args);

// If -gGreLocal is passed in, then we need to *not* cleanup GRE files if they
// exist in the browser dir.
// The default is to delete any GRE files because we default GRE will be global.
if(args == "-greLocal")
  gGreLocal = true;

srDest = 2255;
err    = initInstall("Mozilla Firefox", "Firefox", "1.0.5"); 
logComment("initInstall: " + err);

fProgram  = getFolder("Program");
fWindowsSystem = getFolder("Win System");
logComment("fProgram: " + fProgram);

if(verifyDiskSpace(fProgram, srDest))
{
  setPackageFolder(fProgram);

  upgradeCleanup();
  err = addDirectory("",
                     "1.0.5",
                     "bin",              // dir name in jar to extract 
                     fProgram,           // Where to put this file (Returned from GetFolder) 
                     "",                 // subdir name to create relative to fProgram
                     true);              // Force Flag 
  logComment("addDirectory() of Program returned: " + err);

  // check return value
  if( err == SUCCESS )
  {
    fileToRegister = getFolder(fProgram, "AccessibleMarshal.dll");
    err2           = File.windowsRegisterServer(fileToRegister);
    logComment("windowsRegisterServer() returned: " + err2);
    updateWinReg();  // Finish registering above marshalling dll's

    createShortcuts();

    // we don't want to fail on errors for the above two
    resetError();

    // register chrome
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "browser.jar"), "content/browser/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome", "classic.jar"), "skin/classic/browser/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "browser.jar"), "content/browser-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "browser.jar"), "content/browser-platform/");

    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "toolkit.jar"), "content/passwordmgr/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "toolkit.jar"), "content/mozapps/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome", "classic.jar"), "skin/classic/mozapps/");
    
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/autoconfig/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/necko/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/cookie/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/wallet/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/xbl-marquee/");

    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","toolkit.jar"),"content/global/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","toolkit.jar"),"content/global-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","toolkit.jar"),"content/global-platform/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome","classic.jar"),"skin/classic/global/");

    // XXXben Stuff that will become obsolete
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/navigator/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/navigator-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/navigator-platform/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome","classic.jar"),"skin/classic/navigator/");

    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/communicator/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/communicator-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome","comm.jar"),"content/communicator-platform/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome","classic.jar"),"skin/classic/communicator/");

    // Create the uninstall folder. 
    err = File.dirCreate(getFolder("Program", "uninstall"));
    logComment("dirCreate() of Program/uninstall returned: " + err);

    // We need to register the psm chrome files.
    // We're checking to see if they exist first in case
    // they were not built and packaged up.
    var pki = getFolder("Chrome", "pippki.jar");
    if(File.exists(pki)) 
      registerChrome(CONTENT | DELAYED_CHROME, pki, "content/pippki/");

    var nss = getFolder("Chrome", "pipnss.jar");
    if(File.exists(nss)) 
      registerChrome(CONTENT | DELAYED_CHROME, nss, "content/pipnss/");

    copyFlashXPT();
    copyQuickTimeXPT();
    
    /* Log files that are created after the installer is done, so they can be uninstalled */
    logComment("Installing: "    + fProgram + ".autoreg");
    logComment("Installing: "    + fProgram + "Xpcs Registry.dat");
    logComment("Installing: "    + fProgram + "xpcom.log");
    logComment("Create Folder: " + fProgram + "components");
    logComment("Installing: "    + fProgram + "components\\xpti.dat");
    logComment("Installing: "    + fProgram + "components\\xptitemp.dat");
    logComment("Installing: "    + fProgram + "components\\compreg.dat");
    logComment("Create Folder: " + fProgram + "components\\Netscape");
    logComment("Create Folder: " + fProgram + "components\\Netscape\\MozillaTrunk");
    logComment("Installing: "    + fProgram + "components\\Netscape\\MozillaTrunk\\manifest.ini");
    logComment("Installing: "    + fProgram + "components\\Netscape\\MozillaTrunk\\permdata.box");
    logComment("Installing: "    + fProgram + "components\\Netscape\\MozillaTrunk\\Talkback.ini");
    logComment("Create Folder: " + fProgram + "chrome");
    logComment("Installing: "    + fProgram + "chrome\\installed-chrome.txt");
    logComment("Installing: "    + fProgram + "chrome\\chrome.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\cookie");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\cookie\\content");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\cookie\\content\\overlays.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\inspector");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\inspector\\content");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\inspector\\content\\overlays.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\communicator");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\communicator\\content");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\communicator\\content\\overlays.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\editor");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\editor\\content");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\editor\\content\\overlays.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\messenger");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\messenger\\content");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\messenger\\content\\overlays.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\navigator");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\navigator\\content");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\navigator\\content\\overlays.rdf");
    logComment("Create Folder: " + fProgram + "chrome\\overlayinfo\\navigator\\skin");
    logComment("Installing: "    + fProgram + "chrome\\overlayinfo\\navigator\\skin\\stylesheets.rdf");
    logComment("Create Folder: " + fProgram + "uninstall");

    err = getLastError();
    if (err == SUCCESS)
    {
      err = performInstall();
      logComment("performInstall() returned: " + err);
      if (File.exists(getFolder(fProgram, "xpicleanup.dat")))
      {
        logComment("incomplete install, manually launch cleanup utility");
        initInstall("Post-install Cleanup Utility", "Browser/xpicleanup", "1.0.5");
        cleanupUtility = getFolder(fProgram, "xpicleanup.exe");
        err = File.execute(cleanupUtility);
        logComment("execute() returned: " + err);
        err = performInstall();
      }
    }
    else
      cancelInstall(err);
  }
  else
    cancelInstall(err);
}
else
  cancelInstall(INSUFFICIENT_DISK_SPACE);


// end main
