// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

// this function deletes a file if it exists
function deleteThisFile(dirKey, file)
{
  var fFileToDelete;

  fFileToDelete = getFolder(dirKey, file);
  logComment("File to delete: " + fFileToDelete);
  if(File.isFile(fFileToDelete))
  {
    File.remove(fFileToDelete);
    return(true);
  }
  else
    return(false);
}

// this function deletes a folder if it exists
function deleteThisFolder(dirKey, folder, recursiveDelete)
{
  var fToDelete;

  if(typeof recursiveDelete == "undefined")
    recursiveDelete = true;

  fToDelete = getFolder(dirKey, folder);
  logComment("folder to delete: " + fToDelete);
  if(File.isDirectory(fToDelete))
  {
    File.dirRemove(fToDelete, recursiveDelete);
    return(true);
  }
  else
    return(false);
}

// OS type detection
// which platform?
function getPlatform()
{
  var platformStr;
  var platformNode;

  if('platform' in Install)
  {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else
  {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

var err = initInstall("Developer Tools", "Developer Tools", "1.0"); 
logComment("initInstall: " + err);

// JavaScript Debugger
// addFile("Venkman Service",
//        "bin/components/venkman-service.js",
//        getFolder("Components"),
//        "");

// addFile("Venkman Chrome",
//        "bin/chrome/venkman.jar",   // jar source folder 
//        getFolder("Chrome"),        // target folder
//        "");                        // target subdir 

// registerChrome(PACKAGE | DELAYED_CHROME, getFolder("Chrome","venkman.jar"), "content/venkman/");
// registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome","venkman.jar"), "skin/modern/venkman/");
// registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome","venkman.jar"), "locale/en-US/venkman/");

// DOM Inspector
var fProgram = getFolder("Program");
logComment("fProgram: " + fProgram);

err = addDirectory("", "1.0", "bin", fProgram, "", true);
logComment("addDirectory: " + err);

addFile("Inspector Command Line Handler",
        "bin/components/inspector-cmdline.js",
        getFolder("Components"),
        "");

var jarFolder = getFolder("Chrome", "inspector.jar");
registerChrome(PACKAGE | DELAYED_CHROME, jarFolder, "content/inspector/");
registerChrome(SKIN | DELAYED_CHROME, jarFolder, "skin/classic/inspector/");
registerChrome(LOCALE | DELAYED_CHROME, jarFolder, "locale/en-US/inspector/");

err = getLastError();
if (err==SUCCESS)
    performInstall(); 
else
    cancelInstall(err);
